<?php
///////////////////////////////////////////////////////////////////////////////
//	cltextureAction.class.php
//
//	OpenSimのDBを更新する．
//
//		v2.0
//		OpenSim
//			passwordSaltが''の場合はランダムに生成して，passwordHashもそれに合わせる．
//
//
//                                   Created by Fumi.Iseki
//

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimClTextureForm.class.php');



class  cltextureAction extends Abstruct_Action
{
	var $action_url;
	var	$cleared = false;



	function  cltextureAction($controller) 
	{
		$this->mActionForm = & new Xoopensim_ClTextureForm();
		if (!$this->mActionForm->isAdmin) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _AM_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->action_url = CMS_MODULE_URL.'/admin/index.php?action=cltexture';
	}



	function  execute()
	{
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->prepare();
			$this->mActionForm->fetch();
			$this->mActionForm->validate();

			if (!$this->mActionForm->hasError()) {
				$quest = $this->mActionForm->get('quest');
				if ($quest=='yes') {
					$cachedir = CMS_MODULE_PATH.'/helper/texture_cache';
					$command  = "cd $cachedir && /bin/sh cache_clear.sh";
					exec($command);
					$this->cleared = true;
				}
			}
		}
	}



	function  executeView($render) 
	{
		$root = & XCube_Root::getSingleton();
		$grid_name  = $root->mContext->mModuleConfig['grid_name'];
		$admin_menu = $root->mContext->mModule->getAdminMenu();

		$render->setTemplateName(CMS_MODULE_PATH.'/templates/xoopensim_cltexture.html');

		$render->setAttribute('admin_menu', $admin_menu);
		$render->setAttribute('grid_name',	$grid_name);
		$render->setAttribute('cleared',    $this->cleared);
		$render->setAttribute('action_url', $this->action_url);
		$render->setAttribute('actionForm', $this->mActionForm);
	}
}

?>
