<?php
///////////////////////////////////////////////////////////////////////////////
//	convertdbAction.class.php
//
//	OpenSimのDBを変換する．
//
//		v2.0
//		OpenSim
//			passwordSaltが''の場合はランダムに生成して，passwordHashもそれに合わせる．
//
//
//                                   Created by Fumi.Iseki
//

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimConvertdbForm.class.php');



class  convertdbAction extends Abstruct_Action
{
	var $action_url;
	var	$dbconverted = false;



	function  convertdbAction($controller) 
	{
		$this->mActionForm = & new Xoopensim_ConvertdbForm();
		if (!$this->mActionForm->isAdmin) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _AM_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->action_url = CMS_MODULE_URL.'/admin/index.php?action=convertdb';
	}



	function  execute()
	{
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->prepare();
			$this->mActionForm->fetch();
			$this->mActionForm->validate();

			if (!$this->mActionForm->hasError()) {
				$quest = $this->mActionForm->get('quest');
				if ($quest=='yes') {
					$ret = opensim_check_db();
					if (!$ret['grid_status']) {
						$this->mActionForm->addErrorMessage(_MD_XPNSM_DB_CONNECT_ERROR);
						return;
					}
					//Convert DB
					//opensim_supply_passwordSalt();
					opensim_succession_data(env_get_config('home_region'));
					opensim_recreate_presence();
					$profs = opensim_get_avatars_profiles_from_users();
					if ($profs!=null) xoopensim_set_profiles_from_users($profs, false);	// not over write
					$this->dbconverted = true;
				}
			}
		}
	}



	function  executeView($render) 
	{
		$root = & XCube_Root::getSingleton();
		$grid_name  = $root->mContext->mModuleConfig['grid_name'];
		$admin_menu = $root->mContext->mModule->getAdminMenu();

		$render->setTemplateName(CMS_MODULE_PATH.'/templates/xoopensim_convertdb.html');

		$render->setAttribute('admin_menu', $admin_menu);
		$render->setAttribute('grid_name',	$grid_name);
		$render->setAttribute('dbconverted',$this->dbconverted);
		$render->setAttribute('action_url', $this->action_url);
		$render->setAttribute('actionForm', $this->mActionForm);
	}
}

?>
