<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimCreateForm.class.php');


class  createAction extends Abstruct_Action
{
	var $mController;
	var $mActionForm;

	var $handler      = null;
	var $regionNames  = array();
	var $actvLastName = 0;

	var $isAdmin    = false;
	var $action_url = '';
    var $userid     = 0;		// owner id of this process
	var $created_avatar = false;

	var $avatars_num = 0;
	var $max_avatars = 0;
	var $isAvatarMax = false;

	// Xoops DB
	var $UUID	   = '';
	var $nx_UUID   = '';
	var $uid       = 0;			// owner id of avatar
	var $firstname = '';
	var $lastname  = '';
	var $passwd    = '';
	var $hmregion  = '';
	var $ownername = '';		// owner name of avatar



	function  createAction($controller) 
	{
		$this->mController = $controller;

		$root = & XCube_Root::getSingleton();
		if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		// for HTTPS
		$use_https = $root->mContext->mModuleConfig['use_https'];
		if ($use_https) {
			$https_url = $root->mContext->mModuleConfig['https_url'];
			if ($https_url!='') {
				$module_url = $https_url.'/'.CMS_DIR_NAME;
			}
			else $module_url = preg_replace('/^http:/', 'https:', XOOPS_MODULE_URL).'/'.CMS_DIR_NAME;
		}
		else $module_url = CMS_MODULE_URL;


		$this->action_url	= $module_url.'/?action=create';
		$this->mActionForm	= & new Xoopensim_CreateForm();
		$this->isAdmin		= $this->mActionForm->isAdmin;
		$this->userid		= $this->mActionForm->uid;
		$this->actvLastName	= $this->mActionForm->actvLastName;

		$this->avatars_num = xoopensim_get_avatars_num($this->userid);
		$this->max_avatars = $controller->mRoot->mContext->mModuleConfig['max_own_avatars'];
		if (!$this->isAdmin and $this->max_avatars>=0 and $this->avatars_num>=$this->max_avatars) $this->isAvatarMax = true;

		// Number of Avatars Check
		if ($this->isAvatarMax) {
			$controller->executeRedirect(CMS_MODULE_URL, 3, _MD_XPNSM_OVER_MAX_AVATARS." ($this->avatars_num >= $this->max_avatars)");
		}
	}



	function  execute()
	{
		// Region Name
		$this->regionNames = opensim_get_regions_names('ORDER BY regionName ASC');

		// Form
		$this->mActionForm->prepare();
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->fetch();
			$this->mActionForm->validate();
		}
		$this->mActionForm->load();

		$this->handler = & xoops_getmodulehandler('usersdb');
		if ($this->isAdmin) {
			do {
				$uuid = make_random_guid();
				$modobj = $this->handler->get($uuid);
			} while ($modobj!=null);
			$this->nx_UUID = $uuid;
		}

		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->firstname = $this->mActionForm->get('firstname');
			$this->lastname  = $this->mActionForm->get('lastname');
			$this->passwd	 = $this->mActionForm->get('passwd');
			$this->hmregion  = $this->mActionForm->get('hmregion');
			if($this->isAdmin) {
				$this->ownername= $this->mActionForm->get('ownername');
				$this->UUID		= $this->mActionForm->get('UUID');
			}
			if ($this->ownername=='') $this->ownername = $this->mActionForm->uname;

			if (!$this->mActionForm->hasError()) {
				$this->created_avatar = $this->createAvatar();
			}
		}
		else {
			$this->hmregion  = $this->mController->mRoot->mContext->mModuleConfig['home_region'];
			$this->UUID      = $this->nx_UUID;
			$this->ownername = $this->mActionForm->uname;
		}
	}



	function  executeView($render) 
	{
		$context = & XCube_Root::getSingleton()->mContext;

		$render->setTemplateName('xoopensim_create.html');
		$grid_name = $context->mModuleConfig['grid_name'];

		$render->setAttribute('grid_name',		$grid_name);
		$render->setAttribute('action_url', 	$this->action_url);
		$render->setAttribute('isAdmin',		$this->isAdmin);

		$render->setAttribute('actvLastName', 	$this->actvLastName);
		$render->setAttribute('lastNames',  	$this->mActionForm->lastNames);
		$render->setAttribute('regionNames', 	$this->regionNames);
		$render->setAttribute('created_avatar',	$this->created_avatar);
		$render->setAttribute('actionForm', 	$this->mActionForm);

		$render->setAttribute('firstname', 		$this->firstname);
		$render->setAttribute('lastname', 		$this->lastname);
		$render->setAttribute('passwd', 		$this->passwd);
		$render->setAttribute('hmregion', 		$this->hmregion);
		$render->setAttribute('ownername',		$this->ownername);
		$render->setAttribute('nx_UUID',      	$this->nx_UUID);
		$render->setAttribute('UUID', 		  	$this->UUID);

		$render->setAttribute('isDisclaimer',	$context->mModuleConfig['activate_disclaimer']);
		$render->setAttribute('disclaimer',		$context->mModuleConfig['disclaimer_content']);

		// 
		$render->setAttribute('pv_ownername', $this->ownername);
		if ($this->created_avatar) {
			$render->setAttribute('pv_firstname', '');
			$render->setAttribute('pv_lastname',  '');
		}
		else {
			$render->setAttribute('pv_firstname', $this->firstname);
			$render->setAttribute('pv_lastname',  $this->lastname);
		}
	}



	function createAvatar()
	{
		//$context = & XCube_Root::getSingleton()->mContext;
		//$userAssetURI	  = $context->mModuleConfig['asset_uri'];
		//$userInventoryURI = $context->mModuleConfig['inventory_uri'];

		// User Check
		$criteria  = & new CriteriaCompo();
		$criteria->add(new Criteria('firstname', $this->firstname));
		$criteria->add(new Criteria('lastname',  $this->lastname));

		$modobj = & $this->handler->getObjects($criteria);
		if ($modobj!=null) {
			$this->mActionForm->addErrorMessage(_MD_XPNSM_ALREADY_NAME_ERROR);
			return false;
		}

		// Create UUID
		if (!$this->isAdmin or !isGUID($this->UUID)) {
			do {
				$uuid = make_random_guid();
				$modobj = $this->handler->get($uuid);
			} while ($modobj!=null);
			$this->UUID = $uuid;
		}

		// OpenSim DB
		$rslt = opensim_create_avatar($this->UUID, $this->firstname, $this->lastname, $this->passwd, $this->hmregion);
		if (!$rslt) {
			$this->mActionForm->addErrorMessage(_MD_XPNSM_OPNSM_CREATE_ERROR);
			return false;
		}

		// User ID of Xoops Cube
		if ($this->isAdmin) {
			if ($this->ownername!='') {
				$this->uid = get_userid_by_name($this->ownername);
			}
			else $this->uid = '0';
		}
		else $this->uid = $this->userid;


		// Xoopensim DB
		$new_user['UUID']      = $this->UUID;
		$new_user['uid']	   = $this->uid;
		$new_user['firstname'] = $this->firstname;
		$new_user['lastname']  = $this->lastname;
		$new_user['hmregion']  = $this->hmregion;
		$new_user['time']      = time();
		$new_user['state']     = AVATAR_STATE_SYNCDB;

		//$ret = xoopensim_insrt_userstable($modHandler, $new_user);
		$ret = xoopensim_insert_userstable($new_user);
		if (!$ret) $this->mActionForm->addErrorMessage(_MD_XPNSM_XOOPS_CREATE_ERROR);

		return $ret;
	}

}

?>
