<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimDeleteForm.class.php');



class  deleteAction extends Abstruct_Action
{
	var $mController;
	var $mActionForm;

	var $isAdmin    = false;
	var $action_url = '';
	var $cancel_url = '';
	var $return_url = '';
	var $userid	    = 0;		// owner of this process

	var $deleted_avatar = false;
	var $cancel_action  = 'avatars';
	var $return_action  = 'avatars';

	// Xoops DB
	var $avatar    = null;
	var $UUID	   = '';
	var $uid 	   = 0;			// owner of avatar
	var $firstname = '';
	var $lastname  = '';
	var $hmregion  = '';
	var $state     = -1;
	var $ownername = '';


	function  deleteAction($controller) 
	{
		$this->mController = $controller;

		$root = & XCube_Root::getSingleton();
		if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->mActionForm 	= & new Xoopensim_DeleteForm();
		$this->isAdmin	   	= $this->mActionForm->isAdmin;
		$this->userid 	   	= $this->mActionForm->uid;
		$this->action_url  	= CMS_MODULE_URL.'/?action=delete';
		$this->cancel_url  	= CMS_MODULE_URL.'/?action='.$this->cancel_action;
		$this->return_url	= CMS_MODULE_URL.'/?action='.$this->return_action;


		// get UUID from POST
		$uuid = $root->mContext->mRequest->getRequest('uuid');
		if (!isGUID($uuid)) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_BAD_UUID);
		}
		$this->UUID = $uuid;

		// get uid from Xoops DB
		$usersdbHandler = & xoops_getmodulehandler('usersdb');
		$avatardata = & $usersdbHandler->get($uuid);
		if ($avatardata==null) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_NOT_EXIST_UUID);
		}
		$this->uid = $avatardata->get('uid');

		if (!$this->isAdmin and $this->userid!=$this->uid) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->state = (int)$avatardata->get('state');
		if (!($this->state&AVATAR_STATE_INACTIVE)) {
			$controller->executeRedirect($this->return_url, 3, _MD_XPNSM_ACTIVE_AVATAR);
		}

		// get User Info from Xoops DB
		$this->avatar = $avatardata;
		$this->ownername = get_username_by_id($this->uid);
	}



	function  execute()
	{
		// Form
		$this->mActionForm->prepare();
		if (xoops_getenv('REQUEST_METHOD')=='POST') {
			$this->mActionForm->fetch();
			$this->mActionForm->validate();
		}
		$this->mActionForm->load();

		$this->firstname = $this->avatar->get('firstname');
		$this->lastname  = $this->avatar->get('lastname');
		$this->hmregion	 = $this->avatar->get('hmregion');

		if (xoops_getenv('REQUEST_METHOD')=='POST' and  !$this->mActionForm->hasError()) {
			$del = $this->mActionForm->get('submit_delete');
			if ($del!='') {
				// delete avatar
				$this->deleted_avatar = $this->deleteAvatar();
			}
			else {
				$this->mController->executeRedirect($this->cancel_url, 2, _MD_XPNSM_AVATAR_DLT_CNCLD_TTL);
			}
		}
	}



	function  executeView($render) 
	{
		$render->setTemplateName('xoopensim_delete.html');

		$grid_name = $this->mController->mRoot->mContext->mModuleConfig['grid_name'];
		$showPostForm = !$this->deleted_avatar or $this->mActionForm->hasError();

		$render->setAttribute('grid_name',		$grid_name);
		$render->setAttribute('showPostForm',   $showPostForm);

		$render->setAttribute('return_action', 	$this->return_action);
		$render->setAttribute('return_url', 	$this->return_url);
		$render->setAttribute('action_url', 	$this->action_url);
		$render->setAttribute('actionForm', 	$this->mActionForm);
		$render->setAttribute('deleted_avatar',	$this->deleted_avatar);
		$render->setAttribute('isAdmin',		$this->isAdmin);
		$render->setAttribute('UUID', 			$this->UUID);
		$render->setAttribute('firstname', 		$this->firstname);
		$render->setAttribute('lastname', 		$this->lastname);
		$render->setAttribute('hmregion', 		$this->hmregion);
		$render->setAttribute('state',	 		$this->state);
		$render->setAttribute('ownername', 		$this->ownername);
	}



	function deleteAvatar()
	{
		if (!isGUID($this->UUID)) return false;

		// Xoops DB
		$delete_user['UUID']  = $this->UUID;
		$delete_user['state'] = $this->state;

		$ret = xoopensim_delete_userstable($delete_user);
		if (!$ret) {
			$this->mActionForm->addErrorMessage(_MD_XPNSM_XOOPS_DELETE_ERROR);
			return false;
		}

		xoopensim_delete_banneddb($this->UUID);
		xoopensim_delete_groupdb($this->UUID, false);
		xoopensim_delete_profiles($this->UUID);

		// OpenSim
		$ret = opensim_delete_avatar($this->UUID);
		if (!$ret) $this->mActionForm->addErrorMessage(_MD_XPNSM_OPNSM_DELETE_ERROR);

		return $ret;
	}

}

?>
