<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');




class  eventsAction extends Abstruct_Action
{
	var $mController;

	var $isAdmin = false;
	var $isGuest = true;
	var $userid  = 0;

	var $action_url;
	var $module_url;
	var $make_event_url;
	var $edit_event_url;
	var $del_event_url;

	var $pstart;
	var $plimit;
	var $Cpstart = 0;
	var $Cplimit = 25;

	var $number;
	var $sitemax;
	var $sitestart;

	var $icon 	 = array();
	var $pnum 	 = array();
	var $db_data = array();



	function  eventsAction($controller) 
	{
		$this->mController = $controller;
		$root = $controller->mRoot;

		$this->isGuest = $root->mContext->mUser->isInRole('Site.GuestUser');
		if ($this->isGuest) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->isAdmin = isXoopensimAdmin($root);
		$this->userid  = $root->mContext->mXoopsUser->get('uid');
		$this->pstart  = $root->mContext->mRequest->getRequest('pstart');
		$this->plimit  = $root->mContext->mRequest->getRequest('plimit');
		if ($this->pstart!='' and !preg_match('/^[0-9]+$/', $this->pstart)) $this->pstart = '';
		if ($this->plimit!='' and !preg_match('/^[0-9]+$/', $this->plimit)) $this->plimit = '';
		if ($this->pstart=='') $this->pstart = $this->Cpstart;
		if ($this->plimit=='') $this->plimit = $this->Cplimit;

		$action = 'index.php?action=events';
		$this->action_url 	  = CMS_MODULE_URL.'/'.$action;
		$this->make_event_url = CMS_MODULE_URL.'/index.php?action=edit_event';
		$this->edit_event_url = CMS_MODULE_URL.'/index.php?action=edit_event&amp;eventid=';
		$this->del_event_url  = CMS_MODULE_URL.'/index.php?action=del_event&amp;eventid=';

		return true;
	}



	function  execute()
	{
		if ($this->isAdmin) {
			$this->number = xoopensim_get_events_num(0, OPENSIM_PG_ONLY);
		}
		else {
			$this->number = xoopensim_get_events_num($this->userid, OPENSIM_PG_ONLY);
		}

		$this->sitemax   = ceil ($this->number/$this->plimit);
		$this->sitestart = round($this->pstart/$this->plimit, 0) + 1;
		if ($this->sitemax==0) $this->sitemax = 1; 

		// back more and back one
		if (0==$this->pstart) {
			$this->icon[0] = 'off';
			$this->pnum[0] = 0;
		}
		else {
			$this->icon[0] = 'on';
			$this->pnum[0] = $this->pstart - $this->plimit;
			if ($this->pnum[0]<0) $this->pnum[0] = 0;
		}

		// forward one
		if ($this->number <= ($this->pstart + $this->plimit)) {
			$this->icon[1] = 'off'; 
			$this->pnum[1] = 0; 
		}
		else {
			$this->icon[1] = 'on'; 
			$this->pnum[1] = $this->pstart + $this->plimit;
		}

		// forward more
		if (0 > ($this->number - $this->plimit)) {
			$this->icon[2] = 'off';
			$this->pnum[2] = 0;
		}
		else {
			$this->icon[2] = 'on';
			$this->pnum[2] = $this->number - $this->plimit;
		}

		$this->icon[3] = $this->icon[4] = $this->icon[5] = $this->icon[6] = 'icon_limit_off';
		if ($this->plimit != 10)  $this->icon[3] = 'icon_limit_10_on'; 
		if ($this->plimit != 25)  $this->icon[4] = 'icon_limit_25_on';
		if ($this->plimit != 50)  $this->icon[5] = 'icon_limit_50_on';
		if ($this->plimit != 100) $this->icon[6] = 'icon_limit_100_on';


		//
		if ($this->isAdmin) {
			$events = xoopensim_get_events(0, $this->pstart, $this->plimit, OPENSIM_PG_ONLY);
		}
		else {
			$events = xoopensim_get_events($this->userid, $this->pstart, $this->plimit, OPENSIM_PG_ONLY);
		}

		$colum = 0;
		foreach($events as $event) {
			if (!OPENSIM_PG_ONLY or $event['eventflags']==0) {
				$this->db_data[$colum] = $event;
				$this->db_data[$colum]['num']  = $colum;
				$this->db_data[$colum]['time'] = date(DATE_FORMAT, $event['dateUTC']);

				$avatar_name = opensim_get_avatar_name($event['creatoruuid']);
				$this->db_data[$colum]['creator'] = $avatar_name['fullname'];
				$avatar_name = opensim_get_avatar_name($event['owneruuid']);
				$this->db_data[$colum]['owner'] = $avatar_name['fullname'];

				if ($event['eventflags']==0) {
					$this->db_data[$colum]['type'] = "title='PG Event' src=./images/events/pink_star.gif";
				}
        	    else {
					$this->db_data[$colum]['type'] = "title='Mature Event' src=./images/events/blue_star.gif";
				}
				$colum++;
			}
		}
	}




	function  executeView($render) 
	{
		global $Categories;

		$grid_name = $this->mController->mRoot->mContext->mModuleConfig['grid_name'];
		//$content   = $this->mController->mRoot->mContext->mModuleConfig['regions_content'];

		$render->setTemplateName('xoopensim_events.html');

		$render->setAttribute('grid_name',  	$grid_name);
		//$render->setAttribute('content',   	$content);
		$render->setAttribute('isAdmin',   		$this->isAdmin);
		$render->setAttribute('isGuest',   		$this->isGuest);
		$render->setAttribute('userid',   		$this->userid);

		$render->setAttribute('db_data',   		$this->db_data);
		$render->setAttribute('module_url', 	CMS_MODULE_URL);
		$render->setAttribute('action_url',		$this->action_url);
		$render->setAttribute('make_event_url', $this->make_event_url);
		$render->setAttribute('edit_event_url', $this->edit_event_url);
		$render->setAttribute('del_event_url',  $this->del_event_url);
		$render->setAttribute('use_utc_time',	USE_UTC_TIME);
		$render->setAttribute('Categories',		$Categories);

		$render->setAttribute('icon',      		$this->icon);
		$render->setAttribute('sitestart', 		$this->sitestart);
		$render->setAttribute('sitemax',   		$this->sitemax);

		$render->setAttribute('pstart',    		$this->pstart);
		$render->setAttribute('plimit',   		$this->plimit);
		$render->setAttribute('pnum',      		$this->pnum);
		$render->setAttribute('number',    		$this->number);
	}
}

?>
