<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');



class  regionsAction extends Abstruct_Action
{
	var $mController;

	var $icon 	 = array();
	var $pnum 	 = array();
	var $db_data = array();

	var $action;
	var $action_url;
	var $stats_url;

	var $isAdmin = false;
	var $isGuest = true;
	var $db_ver  = '';

	var $Cpstart = 0;
	var $Cplimit = 25;
	var $order   = '';
	var $pstart;
	var $plimit;
	var $number;
	var $sitemax;
	var $sitestart;
	var $sql_condition = '';


	function  regionsAction($controller) 
	{
		$this->mController = $controller;
		$root  = $controller->mRoot;

		$this->isAdmin = isXoopensimAdmin($root);
		$this->isGuest = $root->mContext->mUser->isInRole('Site.GuestUser');

		$this->order = $root->mContext->mRequest->getRequest('order');
		if ($this->order!='' and !preg_match('/^[a-z]+$/', $this->order)) $this->order = '';

		$this->db_ver = opensim_get_db_version(); 

		$sql_order = '';
		if ($this->order=='name')       $sql_order = ' ORDER BY regionName ASC';
		elseif ($this->order=='x') 		$sql_order = ' ORDER BY locX ASC';
		elseif ($this->order=='y') 		$sql_order = ' ORDER BY locY ASC';
		elseif ($this->order=='ip')		$sql_order = ' ORDER BY serverIP ASC';
		elseif ($this->order=='estid') 	$sql_order = ' ORDER BY estate_map.EstateID ASC';
		elseif ($this->order=='owner') {
			if ($this->db_ver=='0.6') 	$sql_order = ' ORDER BY username, lastname ASC';
			else					  	$sql_order = ' ORDER BY FirstName,LastName ASC';
		}

		$this->pstart  = $root->mContext->mRequest->getRequest('pstart');
		$this->plimit  = $root->mContext->mRequest->getRequest('plimit');
		if ($this->pstart!='' and !preg_match('/^[0-9]+$/', $this->pstart)) $this->pstart = '';
		if ($this->plimit!='' and !preg_match('/^[0-9]+$/', $this->plimit)) $this->plimit = '';
		if ($this->pstart=='') $this->pstart = $this->Cpstart;
		if ($this->plimit=='') $this->plimit = $this->Cplimit;

		// SQL Condition
		$sql_limit = "LIMIT $this->pstart, $this->plimit";
		$this->sql_condition = " $sql_order $sql_limit";

		$this->action = 'index.php?action=regions';
		$this->action_url = CMS_MODULE_URL.'/'.$this->action;
		$this->stats_url  = CMS_MODULE_URL.'/index.php?action=stats';

		return true;
	}



	function  execute()
	{
		$this->number    = opensim_get_regions_num();
		$this->sitemax   = ceil ($this->number/$this->plimit);
		$this->sitestart = round($this->pstart/$this->plimit, 0) + 1;
		if ($this->sitemax==0) $this->sitemax = 1; 

		// back more and back one
		if (0==$this->pstart) {
			$this->icon[0] = 'off';
			$this->pnum[0] = 0;
		}
		else {
			$this->icon[0] = 'on';
			$this->pnum[0] = $this->pstart - $this->plimit;
			if ($this->pnum[0]<0) $this->pnum[0] = 0;
		}

		// forward one
		if ($this->number <= ($this->pstart + $this->plimit)) {
			$this->icon[1] = 'off'; 
			$this->pnum[1] = 0; 
		}
		else {
			$this->icon[1] = 'on'; 
			$this->pnum[1] = $this->pstart + $this->plimit;
		}

		// forward more
		if (0 > ($this->number - $this->plimit)) {
			$this->icon[2] = 'off';
			$this->pnum[2] = 0;
		}
		else {
			$this->icon[2] = 'on';
			$this->pnum[2] = $this->number - $this->plimit;
		}

		$this->icon[3] = $this->icon[4] = $this->icon[5] = $this->icon[6] = 'icon_limit_off';
		if ($this->plimit != 10)  $this->icon[3] = 'icon_limit_10_on'; 
		if ($this->plimit != 25)  $this->icon[4] = 'icon_limit_25_on';
		if ($this->plimit != 50)  $this->icon[5] = 'icon_limit_50_on';
		if ($this->plimit != 100) $this->icon[6] = 'icon_limit_100_on';


		$voice_mode[0] = _MD_XPNSM_VOICE_INACTIVE_CHNL;
		$voice_mode[1] = _MD_XPNSM_VOICE_PRIVATE_CHNL;
		$voice_mode[2] = _MD_XPNSM_VOICE_PERCEL_CHNL;


		// auto synchro
		xoopensim_synchro_opensimdb();

		//
		$regions = opensim_get_regions_infos($this->sql_condition);
		$colum = 0;
		foreach($regions as $region) {
			$this->db_data[$colum] = $region;
			$this->db_data[$colum]['num']   = $colum;
			$this->db_data[$colum]['locX']  = $this->db_data[$colum]['locX']/256;
			$this->db_data[$colum]['locY']  = $this->db_data[$colum]['locY']/256;
			$vcmode = opensim_get_voice_mode($region['UUID']);
			$this->db_data[$colum]['voice'] = $voice_mode[$vcmode];

			$this->db_data[$colum]['uuid']    = str_replace('-', '',  $region['UUID']);
			$this->db_data[$colum]['ow_uuid'] = str_replace('-', '',  $region['owner_uuid']);
			$this->db_data[$colum]['ip_name'] = str_replace('.', 'X', $region['serverIP']);
			$colum++;
		}

	}




	function  executeView($render) 
	{
		$grid_name = $this->mController->mRoot->mContext->mModuleConfig['grid_name'];
		$content   = $this->mController->mRoot->mContext->mModuleConfig['regions_content'];

		$render->setTemplateName('xoopensim_regions.html');

		$render->setAttribute('grid_name',  $grid_name);
		$render->setAttribute('content',   	$content);
		$render->setAttribute('isAdmin',   	$this->isAdmin);
		$render->setAttribute('isGuest',   	$this->isGuest);

		$render->setAttribute('db_data',   	$this->db_data);
		$render->setAttribute('module_url', CMS_MODULE_URL);
		$render->setAttribute('action',    	$this->action);
		$render->setAttribute('action_url',	$this->action_url);
		$render->setAttribute('stats_url',	$this->stats_url);

		$render->setAttribute('icon',      	$this->icon);
		$render->setAttribute('sitestart', 	$this->sitestart);
		$render->setAttribute('sitemax',   	$this->sitemax);

		$render->setAttribute('pstart',    	$this->pstart);
		$render->setAttribute('plimit',   	$this->plimit);
		$render->setAttribute('pnum',      	$this->pnum);
		$render->setAttribute('number',    	$this->number);
		$render->setAttribute('order',    	$this->order);
	}
}

?>
