<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/AbstructAction.class.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimStatsForm.class.php');




class  statsAction extends Abstruct_Action
{
	var $mController;
	var $mActionForm;

	var $isAdmin = false;
	var $isGuest = true;
	var $userid  = 0;
	var $url     = '';


	function  statsAction($controller) 
	{
		$this->mController = $controller;
		$root = $controller->mRoot;

		$this->isGuest = $root->mContext->mUser->isInRole('Site.GuestUser');
		if ($this->isGuest) {
			$controller->executeRedirect(CMS_MODULE_URL, 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}

		$this->mActionForm = & new Xoopensim_StatsForm();
		$this->isAdmin	   = $this->mActionForm->isAdmin;
		$this->userid	   = $this->mActionForm->uid;

		if (!$this->isAdmin) {
			$controller->executeRedirect(CMS_MODULE_URL.'/?action=regions', 2, _MD_XPNSM_ACCESS_FORBIDDEN);
		}
	}



	function  execute()
	{
		$this->mActionForm->prepare();
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		$this->mActionForm->load();
		
		if ($this->mActionForm->hasError()) {
			$this->mController->executeRedirect(CMS_MODULE_URL.'/?action=regions', 3, $this->mActionForm->getErrorMessages());
		}

		$this->url = 'http://'.$this->mActionForm->get('ip').':9000/SStats/';
	}



	function  executeView($render) 
	{
		$render->setTemplateName('xoopensim_object.html');

		$render->setAttribute('grid_name',  $this->mController->mRoot->mContext->mModuleConfig['grid_name']);
		$render->setAttribute('page_title', _MD_XPNSM_REGION_STATS);
		$render->setAttribute('object_url', $this->url);
	}

}

?>
