<?php

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimActionForm.class.php');


class Xoopensim_CreateForm extends Xoopensim_ActionForm
{
	var $isAdmin = false;
	var $actvLastName = 0;
	var $lastNames  = array();

	var $uid   = 0;
	var $uname = '';



	function Xoopensim_CreateForm()
	{
		parent::Xoopensim_ActionForm();

		$root = & XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->uid   = $root->mContext->mXoopsUser->get('uid');
			$this->uname = $root->mContext->mXoopsUser->get('uname');
		}
		$this->isAdmin = isXoopensimAdmin($root);

		// Last Name   
		$this->actvLastName = $root->mContext->mModuleConfig['activate_lastname'];
		if ($this->actvLastName=='1') {
			$modHandler = & xoops_getmodulehandler('lastnamesdb');
			$criteria   = & new CriteriaCompo();
			$criteria->add(new Criteria('state', '1'));		// active
			$criteria->addSort('lastname');
			$modobj = & $modHandler->getObjects($criteria);
			foreach ($modobj as $mod) {
				$this->lastNames[] = $mod->get('lastname');
			}
		}
	}



	function getTokenName()
	{
		return 'module.xoopensim.CreateAction.TOKEN';
	}



	function prepare()
	{
		$this->mFormProperties['firstname'] 	= & new XCube_StringProperty('firstname');
		$this->mFormProperties['lastname']  	= & new XCube_StringProperty('lastname');
		$this->mFormProperties['passwd']    	= & new XCube_StringProperty('passwd');
		$this->mFormProperties['confirm_pass']	= & new XCube_StringProperty('confirm_pass');
		$this->mFormProperties['hmregion']  	= & new XCube_StringProperty('hmregion');
		$this->mFormProperties['ownername']  	= & new XCube_StringProperty('ownername');
		$this->mFormProperties['UUID']  		= & new XCube_StringProperty('UUID');
		$this->mFormProperties['agree']  		= & new XCube_StringProperty('agree');

		$this->mFieldProperties['firstname'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['firstname']->setDependsByArray(array('required', 'maxlength', 'minlength'));
		$this->mFieldProperties['firstname']->addMessage('required',  _MD_XPNSM_FIRSTNAME_REQUIRED);
		$this->mFieldProperties['firstname']->addMessage('maxlength', _MD_XPNSM_FIRSTNAME_MAXLENGTH, '24');
		$this->mFieldProperties['firstname']->addMessage('minlength', _MD_XPNSM_FIRSTNAME_MINLENGTH, '3');
		$this->mFieldProperties['firstname']->addVar('maxlength', '24');
		$this->mFieldProperties['firstname']->addVar('minlength', '3');

		$this->mFieldProperties['lastname'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['lastname']->setDependsByArray(array('required', 'maxlength', 'minlength'));
		$this->mFieldProperties['lastname']->addMessage('required',  _MD_XPNSM_LASTNAME_REQUIRED);
		$this->mFieldProperties['lastname']->addMessage('maxlength', _MD_XPNSM_LASTNAME_MAXLENGTH, '24');
		$this->mFieldProperties['lastname']->addMessage('minlength', _MD_XPNSM_LASTNAME_MINLENGTH, '3');
		$this->mFieldProperties['lastname']->addVar('maxlength', '24');
		$this->mFieldProperties['lastname']->addVar('minlength', '3');

		$this->mFieldProperties['passwd'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['passwd']->setDependsByArray(array('required', 'maxlength', 'minlength'));
		$this->mFieldProperties['passwd']->addMessage('required',  _MD_XPNSM_PASSWD_REQUIRED);
		$this->mFieldProperties['passwd']->addMessage('maxlength', _MD_XPNSM_PASSWD_MAXLENGTH, 24);
		$this->mFieldProperties['passwd']->addMessage('minlength', _MD_XPNSM_PASSWD_MINLENGTH, 8);
		$this->mFieldProperties['passwd']->addVar('maxlength', '24');
		$this->mFieldProperties['passwd']->addVar('minlength', '8');

		$this->mFieldProperties['confirm_pass'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['hmregion'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['ownername'] 	= & new XCube_FieldProperty($this);
		$this->mFieldProperties['UUID'] 		= & new XCube_FieldProperty($this);
		$this->mFieldProperties['agree'] 		= & new XCube_FieldProperty($this);
	}



	function validateUUID()
	{
		$str = $this->get('UUID');
		if ($str!='' and $str!=null and !isGUID($str)) {
			$this->addErrorMessage(_MD_XPNSM_BAD_UUID.': '.htmlspecialchars($str).' ('._MD_XPNSM_UUID.')');
			$this->set('UUID', htmlspecialchars($str));
		}
	}



	function validateFirstname()
	{
		$str = $this->get('firstname');
		$ret = isAlphabetNumeric($str);
		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.': '.htmlspecialchars($str).' ('._MD_XPNSM_FIRSTNAME.')');
			$this->set('firstname', htmlspecialchars($str));
		}
	}



	function validateLastname()
	{
		$str = $this->get('lastname');
		$ret = isAlphabetNumeric($str);

		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_LASTNAME.')');
			$this->set('lastname', htmlspecialchars($str));
		}

		if ($this->actvLastName=='1') {
			if ($str!='') {
				foreach($this->lastNames as $lname) {
					if ($lname==$str) return;
				}
			}
			$this->addErrorMessage(_MD_XPNSM_INVALID_LASTNAME.': '.htmlspecialchars($str));
			$this->set('lastname', htmlspecialchars($str));
		}
	}



	function validateHmregion()
	{
		$str = $this->get('hmregion');
		$rep = preg_replace('/[ _-]/', '', $str);
		$ret = isAlphabetNumeric($rep);

		if (!$ret) {
			$this->set('hmregion', htmlspecialchars($str));
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_HOME_REGION.'['.$rep.'])');
			$this->addErrorMessage(_MD_XPNSM_OR_DB_NOTCONNECT);
		}
	}



	function validateOwnername()
	{
		$str = $this->get('ownername');
		if ($str!='') {
			$rep = preg_replace('/[ _-]/', '', $str);
			$ret = isAlphabetNumeric($rep);

			if (!$ret) {
				$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_OWNER_NAME_ERROR.')');
				$this->set('ownername', htmlspecialchars($str));
			}
			elseif ($this->isAdmin) {
				$uid = get_userid_by_name($str);
				if ($uid==0) {
					$this->addErrorMessage(_MD_XPNSM_NOUSER_FOUND.': '.htmlspecialchars($str).' ('._MD_XPNSM_OWNER_NAME_ERROR.')');
					$this->set('ownername', $this->uname);
				}
			}
		}
	}



	function validateAgree()
	{
		$str = $this->get('agree');

		if ($str!='agree') {
			$this->addErrorMessage(_MD_XPNSM_NEED_AGREE_DISCLAIMER.' ('._MD_XPNSM_DISCLAIMER.' '.$str.')');
		}
	}



	function validatePasswd()
	{
		$pass = $this->get('passwd');
		$ret  = isAlphabetNumeric($pass);
		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_PASSWORD.')');
			$pass = '';
		}
		$this->set('passwd', $pass);

		$conf = $this->get('confirm_pass');
		$ret  = isAlphabetNumeric($conf);
		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_CONFIRM_PASS.')');
			$conf = '';
		}
		$this->set('confirm_pass', $conf);
	
		if ($conf!=$pass) {
			$this->addErrorMessage(_MD_XPNSM_PASSWD_MISMATCH);
		}
	}



	function load()
	{
		$ownername = $this->get('ownername');
		if ($ownername=='' or !$this->isAdmin) {
			$this->set('ownername', $this->uname);
		}

		$region = $this->get('hmregion');
		if ($region=='') {
			$root = & XCube_Root::getSingleton();
			$hmregion = $root->mContext->mModuleConfig['home_region'];

			if ($hmregion!='') $this->set('hmregion', $hmregion);
		}
	}

}

?>
