<?php

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimActionForm.class.php');


class Xoopensim_EditForm extends Xoopensim_ActionForm
{
	var $isAdmin = false;
	var $uid   = 0;
	var $uname = '';


	function Xoopensim_EditForm()
	{
		parent::Xoopensim_ActionForm();

		$root = & XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->uid   = $root->mContext->mXoopsUser->get('uid');
			$this->uname = $root->mContext->mXoopsUser->get('uname');
		}
		$this->isAdmin = isXoopensimAdmin($root);
	}



	function getTokenName()
	{
		return 'module.xoopensim.EditAction.TOKEN';
	}



	function prepare()
	{
		$this->mFormProperties['passwd']    	= & new XCube_StringProperty('passwd');
		$this->mFormProperties['confirm_pass']	= & new XCube_StringProperty('confirm_pass');
		$this->mFormProperties['hmregion']  	= & new XCube_StringProperty('hmregion');
		$this->mFormProperties['ownername']		= & new XCube_StringProperty('ownername');
		$this->mFormProperties['state']  		= & new XCube_IntProperty('state');
		$this->mFormProperties['nomanage'] 		= & new XCube_StringProperty('nomanage');
		$this->mFormProperties['submit_update'] = & new XCube_StringProperty('submit_update');
		$this->mFormProperties['submit_delete'] = & new XCube_StringProperty('submit_delete');

		$this->mFieldProperties['passwd'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['passwd']->setDependsByArray(array('maxlength', 'minlength'));
		$this->mFieldProperties['passwd']->addMessage('maxlength', _MD_XPNSM_PASSWD_MAXLENGTH, 20);
		$this->mFieldProperties['passwd']->addMessage('minlength', _MD_XPNSM_PASSWD_MINLENGTH, 8);
		$this->mFieldProperties['passwd']->addVar('maxlength', '20');
		$this->mFieldProperties['passwd']->addVar('minlength', '8');

		$this->mFieldProperties['state'] = & new XCube_FieldProperty($this);
		//$this->mFieldProperties['state']->setDependsByArray(array('max', 'min'));
		//$this->mFieldProperties['state']->addMessage('min', _MD_XPNSM_STATE_MIN, 0);
		//$this->mFieldProperties['state']->addMessage('max', _MD_XPNSM_STATE_MAX, 5);
		//$this->mFieldProperties['state']->addVar('min', '0');
		//$this->mFieldProperties['state']->addVar('max', '5');

		$this->mFieldProperties['hmregion']  	 = & new XCube_FieldProperty($this);
		$this->mFieldProperties['ownername'] 	 = & new XCube_FieldProperty($this);
		$this->mFieldProperties['confirm_pass']  = & new XCube_FieldProperty($this);
		$this->mFieldProperties['nomanage'] 	 = & new XCube_FieldProperty($this);
		$this->mFieldProperties['submit_update'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['submit_delete'] = & new XCube_FieldProperty($this);
	}



	function validateHmregion()
	{
		$str = $this->get('hmregion');
		$rep = preg_replace('/[ _-]/', '', $str);

		$ret = isAlphabetNumeric($rep);
		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_START_REGION.')');
			$this->set('hmregion', htmlspecialchars($str));
		}
	}



	function validateOwnername()
	{
		$str = $this->get('ownername');
		$rep = preg_replace('/[ _-]/', '', $str);

		if ($rep!='') {
			$ret = isAlphabetNumeric($rep);
			if (!$ret) {
				$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_OWNER_NAME_ERROR.')');
				$this->set('ownername', htmlspecialchars($str));
			}
			elseif ($str!='') {
				$uid = get_userid_by_name($str);
				if ($uid==0) {
					$this->addErrorMessage(_MD_XPNSM_NOUSER_FOUND.': '.htmlspecialchars($str).' ('._MD_XPNSM_OWNER_NAME_ERROR.')');
					$this->set('ownername', $this->uname);
				}
			}
		}
	}



	function validatePasswd()
	{
		$pass = $this->get('passwd');
		if ($pass!='') {
			$ret  = isAlphabetNumeric($pass);
			if (!$ret) {
				$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_PASSWORD.')');
				$pass = '';
			}
		}
		$this->set('passwd', $pass);

		$conf = $this->get('confirm_pass');
		if ($conf!='') {
			$ret  = isAlphabetNumeric($conf);
			if (!$ret) {
				$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_CONFIRM_PASS.')');
				$conf = '';
			}
		}
		$this->set('confirm_pass', $conf);
	
		if ($conf!=$pass) {
			$this->addErrorMessage(_MD_XPNSM_PASSWD_MISMATCH);
		}
	}



	function load()
	{
		if (!$this->isAdmin) {
			$this->set('ownername', $this->uname);
		}
	}

}

?>
