<?php

require_once(CMS_MODULE_PATH.'/include/xoopensim.func.php');
require_once(CMS_MODULE_PATH.'/class/xoopensimActionForm.class.php');


class Xoopensim_OwnerForm extends Xoopensim_ActionForm
{
	var $isAdmin = false;
	var $uid   = 0;
	var $uname = '';


	function Xoopensim_OwnerForm()
	{
		parent::Xoopensim_ActionForm();

		$root = & XCube_Root::getSingleton();
		if (is_object($root->mContext->mXoopsUser)) {
			$this->uid   = $root->mContext->mXoopsUser->get('uid');
			$this->uname = $root->mContext->mXoopsUser->get('uname');
		}
		$this->isAdmin = isXoopensimAdmin($root);
	}



	function getTokenName()
	{
		return 'module.xoopensim.OwnerAction.TOKEN';
	}



	function prepare()
	{
		$this->mFormProperties ['passwd'] = & new XCube_StringProperty('passwd');
		$this->mFormProperties ['userid'] = & new XCube_StringProperty('userid');
		$this->mFieldProperties['passwd'] = & new XCube_FieldProperty($this);
		$this->mFieldProperties['userid'] = & new XCube_FieldProperty($this);
	}



	function validatePasswd()
	{
		$pass = $this->get('passwd');
		$ret  = isAlphabetNumeric($pass);
		if (!$ret) {
			$this->addErrorMessage(_MD_XPNSM_ALPHABET_NUMERIC.' ('._MD_XPNSM_PASSWORD.')');
			$this->set('passwd', $pass);
		}
	}



	function load()
	{
	}

}

?>
