<?php
/////////////////////////////////////////////////////////////////////////////
// Region θ̾ɽ롥
//
// usage... http://xxx/yyy/zzz/sim.php?region=3a9379b7-1821-4b04-ab97-e38df166bac1
//

require_once(realpath(dirname(__FILE__).'/../../../mainfile.php'));
require_once(realpath(dirname(__FILE__).'/../include/env_interface.php'));


$root = & XCube_Root::getSingleton();

if ($root->mContext->mUser->isInRole('Site.GuestUser')) {
	exit('<h4>guest user is not allowed to access this page!!</h4>');
}
$isAdmin = isXoopensimAdmin($root);

$region = $root->mContext->mRequest->getRequest('region');
if (!isGUID($region)) exit("<h4>bad region uuid!! ($region)</h4>");

$grid_name  = $root->mContext->mModuleConfig['grid_name'];
$action_url = CMS_MODULE_URL.'/helper/sim.php';


//////////////
$col = 0;
$users = opensim_get_avatars_infos();
foreach($users as $user) {
	$avatars[$col]['name'] = $user['firstname'].' '.$user['lastname'];
	$avatars[$col]['uuid'] = $user['UUID'];
	$col++;
}
$avatars_num = $col;


$vcmode = '';
$rginfo = '';

if ($isAdmin and xoops_getenv('REQUEST_METHOD')=='POST') {
	//
	$rgnadmin = $root->mContext->mRequest->getRequest('rgnadmin');
	if (!isGUID($rgnadmin)) {	// owner name
		$rgnuuid = opensim_get_avatar_uuid($rgnadmin);
		if (!isGUID($rgnuuid)) {
			exit("<h4>unknown avatar name!! ($rgnadmin)</h4>");
		}
		$rgnadmin = $rgnuuid;
	}

	$rginfo = opensim_get_region_info($region);
	if ($rginfo!=null and $rginfo['owner_uuid']!=$rgnadmin) {
		$ret = opensim_set_estate_owner($region, $rgnadmin);
		if (!$ret) exit("<h4>updating of region owner is fail!! ($region, $rgnadmin)</h4>");
		$rginfo = null;
	}

	$voice_mode = $root->mContext->mRequest->getRequest('voice_mode');
	if (isNumeric($voice_mode)) {
		$vcmode = opensim_get_voice_mode($region);
		if ($vcmode!=$voice_mode) {
			$ret = opensim_set_voice_mode($region, $voice_mode);
			if (!$ret) exit("<h4>updating of voice mode is fail!! ($region, $voice_mode)</h4>");
			$vcmode = '';
		}
	}
}


//////////////
$voice_modes[0]['id']    = '0';
$voice_modes[1]['id']    = '1';
$voice_modes[2]['id']    = '2';
$voice_modes[0]['title'] = _MD_XPNSM_VOICE_INACTIVE_CHNL;
$voice_modes[1]['title'] = _MD_XPNSM_VOICE_PRIVATE_CHNL;
$voice_modes[2]['title'] = _MD_XPNSM_VOICE_PERCEL_CHNL;

if ($vcmode=='') $vcmode = opensim_get_voice_mode($region);
$vcmode_title = $voice_modes[$vcmode]['title'];


//////////////
$owner_name = $owner_uuid = '';
if ($rginfo=='') $rginfo = opensim_get_region_info($region);
if ($rginfo!=null) {
	$regionName 	= $rginfo['regionName']; 
	$serverIP 		= $rginfo['serverIP'];
	$serverHttpPort = $rginfo['serverHttpPort'];
	$serverURI 		= $rginfo['serverURI'];
	$locX	 		= $rginfo['locX'];
	$locY 			= $rginfo['locY'];
	$owner_name 	= $rginfo['fullname'];
	$owner_uuid 	= $rginfo['owner_uuid'];
}
else {
	exit("<h4>cannot get region information!! ($region)</h4>");
}


$server = '';
if ($serverURI!='') {
	$dec = explode(':', $serverURI);
	if (!strncasecmp($dec[0], 'http', 4)) $server = $dec[0].':'.$dec[1];
}   
if ($server=='') {
	$server = 'http://'.$serverIP;
}
$server = $server.':'.$serverHttpPort;
$guid = str_replace('-', '', $region);

$locX = $locX/256;
$locY = $locY/256;


$avatar_select = true;
if ($avatars_num>100) $avatar_select = false;

//////////////
$xoopsTpl->assign('grid_name',    $grid_name);
$xoopsTpl->assign('region', 	  $region);
$xoopsTpl->assign('regionName',   $regionName);
$xoopsTpl->assign('guid',         $guid);
$xoopsTpl->assign('locX',         $locX);
$xoopsTpl->assign('locY',         $locY);
$xoopsTpl->assign('owner_name',   $owner_name);
$xoopsTpl->assign('owner_uuid',   $owner_uuid);
$xoopsTpl->assign('server',       $server);
$xoopsTpl->assign('module_url',   CMS_MODULE_URL);

$xoopsTpl->assign('isAdmin',  	  $isAdmin);
$xoopsTpl->assign('action_url',   $action_url);
$xoopsTpl->assign('avatars',      $avatars);
$xoopsTpl->assign('avatar_select',$avatar_select);

$xoopsTpl->assign('vcmode',       $vcmode);
$xoopsTpl->assign('vcmode_title', $vcmode_title);
$xoopsTpl->assign('voice_modes',  $voice_modes);

$xoopsTpl->display('db:xoopensim_sim.html');

?>
