<?php  

function xmldb_block_autoattend_upgrade($oldversion=0) 
{
	global $CFG, $THEME, $DB;

	$dbman = $DB->get_manager();


	// 2013040900
	if ($oldversion < 2013040900) {
		$table = new xmldb_table('autoattend_classes');

		$table->add_field('id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
		$table->add_field('courseid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0');
		$table->add_field('creator', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0');
		$table->add_field('name', XMLDB_TYPE_CHAR, '50', null, XMLDB_NOTNULL, null, null);
		$table->add_field('timemodified', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0');

		$table->add_key('primary', XMLDB_KEY_PRIMARY, array('id'));
		$table->add_index('courseid', XMLDB_INDEX_NOTUNIQUE, array('courseid'));

		if (!$dbman->table_exists($table)) {
			$dbman->create_table($table);
		}
	}

	// 2013040900
	if ($oldversion < 2013040900) {
        $table = new xmldb_table('autoattend_classifies');
        //
        $table->add_field('id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('studentid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('classid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0');

        $table->add_key('primary', XMLDB_KEY_PRIMARY, array('id'));
        $table->add_index('courseid', XMLDB_INDEX_NOTUNIQUE, array('courseid'));
        $table->add_index('studentid', XMLDB_INDEX_NOTUNIQUE, array('studentid'));

        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }
	}

	// 2013040900
	if ($oldversion < 2013040900) {
		$table = new xmldb_table('autoattend_sessions');
		//
		$index = new xmldb_index('groupid', XMLDB_INDEX_NOTUNIQUE, array('groupid'));
		if ($dbman->index_exists($table, $index)) {
			$dbman->drop_index($table, $index);
		}
		$field = new xmldb_field('groupid');
		if ($dbman->field_exists($table, $field)) {
			$dbman->drop_field($table, $field);
		}
		$field = new xmldb_field('classid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'courseid');
		if (!$dbman->field_exists($table, $field)) {
			$dbman->add_field($table, $field);
		}
	}

	// 2013040900
	if ($oldversion < 2013040900) {
		$table = new xmldb_table('autoattend_settings');
		//
		$index = new xmldb_index('groupid', XMLDB_INDEX_NOTUNIQUE, array('groupid'));
		if ($dbman->index_exists($table, $index)) {
			$dbman->drop_index($table, $index);
		}
		$index = new xmldb_index('status', XMLDB_INDEX_NOTUNIQUE, array('status'));
		if ($dbman->index_exists($table, $index)) {
			$dbman->drop_index($table, $index);
		}
		$field = new xmldb_field('groupid');
		if ($dbman->field_exists($table, $field)) {
			$dbman->drop_field($table, $field);
		}
		$field = new xmldb_field('classid', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'courseid');
		if (!$dbman->field_exists($table, $field)) {
			$dbman->add_field($table, $field);
		}
	}

	// 2013040900
	if ($oldversion < 2013040900) {
		$table = new xmldb_table('autoattend_students');
		//
		$index = new xmldb_index('status', XMLDB_INDEX_NOTUNIQUE, array('status'));
		if ($dbman->index_exists($table, $index)) {
			$dbman->drop_index($table, $index);
		}
	}


	// 2013050700
	if ($oldversion < 2013050700) {
		$table = new xmldb_table('autoattend_sessions');
		//
		$index = new xmldb_index('classid', XMLDB_INDEX_NOTUNIQUE, array('classid'));
		$dbman->add_index($table, $index);
	}

	return true;
}

