<?php // $Id: refreshSessions.php, v1.0 2007/03/27 Fumi.Iseki $


require_once('../../config.php');	
require_once('lib.php');


$courseid = required_param('course', PARAM_INTEGER);
$classid  = optional_param('class', 0, PARAM_INTEGER);
$backurl  = optional_param('backurl', '', PARAM_URL);

if (($formdata = data_submitted()) and !confirm_sesskey()) {
	print_error('invalidsesskey');
}

$urlparams['course'] = $courseid;
if ($classid) $urlparams['class'] = $classid;
$PAGE->set_url('/blocks/autoattend/refreshSessions.php', $urlparams);

$wwwBlock = $CFG->wwwroot.'/blocks/autoattend';


// コースの確認
$course = $DB->get_record('course', array('id'=>$courseid));
if (!$course) {
	print_error('courseidwrong', 'block_autoattend');
}

require_login($course->id);

$context   = get_context_instance(CONTEXT_COURSE, $course->id);
$isteacher = jbxl_is_teacher($USER->id, $context);
$isassist  = false;

if (!$isteacher) {
	$isassist = jbxl_is_assistant($USER->id, $context);
	if (!$isassist) {
		print_error('notaccessstudent', 'block_autoattend');
	}
}

$ret = autoattend_update_sessions($courseid);
//if ($ret) add_to_log($courseid, 'autoattend', 'refresh session data', '');

if ($backurl) redirect($backurl);
redirect($wwwBlock.'/index.php?course='.$course->id.'&amp;class='.$classid);

