<?php

require_once('../../config.php');	
require_once('lib.php');


$courseid = required_param('course', PARAM_INTEGER); 

$urlparams['course'] = $courseid;
$PAGE->set_url('/blocks/autoattend/semiautobutton.php', $urlparams);

$wwwBlock = $CFG->wwwroot.'/blocks/autoattend';
$wwwMyURL = $wwwBlock.'/semiautobutton.php';


$course = $DB->get_record('course', array('id'=>$courseid));
if (!$course) {
	print_error('courseidwrong', 'block_autoattend');
}

require_login($course->id);
	
$context   = get_context_instance(CONTEXT_COURSE, $course->id);
$isstudent = jbxl_is_student($USER->id, $context);


// for Student
if ($isstudent) {
	$userid = $USER->id;
	$classinfo = autoattend_get_user_class($userid, $course->id);
	//
	if ($classinfo->classid>=0) {
		$sessions = autoattend_get_nowopen_sessions($course->id, 'S', 'O', time());
		if ($sessions) {
			foreach ($sessions as $session) {
				if ($session->classid==0 or $session->classid==$classinfo->classid) {
					$student = autoattend_get_user_atsession($session->id, $userid);
					if ($student and $student->status=='Y') {
						redirect('semiautoattend.php?course='.$course->id.'&amp;attsid='.$session->id);
					}
				}
			}
		}
	}
}

redirect('index.php?course='.$course->id);

