<?php // $Id: add.php,v 1.7 2006/02/25 18:07:32 dlnsk Exp $

// Modified by Fumi.Iseki to add_one.php  2007/03/19
//                                        2012/04/20
//                                        2013/04/04


require_once('../../config.php');	
require_once($CFG->libdir.'/blocklib.php');
require_once('lib.php');	


$courseid = required_param('course',   PARAM_INTEGER);	// Course id
$classid  = optional_param('class', 0, PARAM_INTEGER);
$mode	  = optional_param('mode', '', PARAM_ALPHA);	// one or empty

if (($formdata = data_submitted()) and !confirm_sesskey()) {
	print_error('invalidsesskey');
}

$urlparams['course'] = $courseid;
if ($classid) $urlparams['class'] = $classid;
if ($mode) 	  $urlparams['mode']  = $mode;
$PAGE->set_url('/blocks/autoattend/add_one.php', $urlparams);

$wwwBlock = $CFG->wwwroot.'/blocks/autoattend';
$wwwMyURL = $wwwBlock.'/add_one.php';
$back2URL = $wwwBlock.'/index.php';


$course = $DB->get_record('course', array('id'=>$courseid));
if (!$course) {
	print_error('courseidwrong', 'block_autoattend');
}

require_login($course->id);

$context = get_context_instance(CONTEXT_COURSE, $course->id);
$isteacher = jbxl_is_teacher($USER->id, $context);
if (!$isteacher) {
	print_error('notaccessnoteacher', 'block_autoattend');
}

$user = $DB->get_record('user', array('id'=>$USER->id));
if (!$user) {
	print_error('nosuchuser', 'block_autoattend');
}


// Print Header
$title = $course->shortname.': '.get_string('autoattend','block_autoattend');
if ($course->category) {
	$title.= ' '.get_string('add_one','block_autoattend');
} 

$PAGE->set_title($title);
$PAGE->set_heading($course->fullname);
$PAGE->set_cacheable(true);
$PAGE->set_button('&nbsp;');
$PAGE->set_headingmenu(navmenu($course));

echo $OUTPUT->header();


$currenttab = 'add_one';	
include('tabs.php');

if ($mode==='one') {
	$sday 		= required_param('sday',	PARAM_INTEGER);
	$smonth		= required_param('smonth', 	PARAM_INTEGER);
	$syear 		= required_param('syear',  	PARAM_INTEGER);		

	$method	 	= required_param('method', 	PARAM_ALPHA);		
	$shour		= required_param('shour',  	PARAM_INTEGER);		
	$smin		= required_param('smin',	PARAM_INTEGER);		
	$ehour		= required_param('ehour',  	PARAM_INTEGER);		
	$emin		= required_param('emin',	PARAM_INTEGER);		
	$lmin		= required_param('lmin',	PARAM_INTEGER);		

	$attendkey  = required_param('attendkey', PARAM_ALPHA);		
	$allowip	= required_param('allowip',   PARAM_TEXT);		
	$desc 		= required_param('desc',      PARAM_TEXT);		

	$randomkey  = optional_param('randomkey',  0, PARAM_INTEGER);		
	$denysameip = optional_param('denysameip', 0, PARAM_INTEGER);		

	if (empty($denysameip)) $denysameip = '0';

	$sessdate	= mktime(0, 0, 0, $smonth, $sday, $syear);
	$starttime  = mktime($shour, $smin, 0, $smonth, $sday, $syear) - $TIME_OFFSET;
	$endtime 	= mktime($ehour, $emin, 0, $smonth, $sday, $syear) - $TIME_OFFSET;
	$latetime	= ($lmin - 1)*MIN_INTVL*ONE_MIN;

	$count = $DB->count_records('autoattend_sessions', 
					array('courseid'=>$course->id, 'classid'=>$classid, 'sessdate'=>$sessdate, 'starttime'=>$starttime));

	if ($count!=0)	{	//duplicate session exists
		print_error('sessionalreadyexists', 'block_autoattend', $wwwMyURL.'?course='.$course->id.'&amp;class='.$classid);	
	}
	else {	
		// insert session
		$rec			  = new stdClass();
		$rec->courseid	  = $course->id;
		$rec->classid	  = $classid;
		$rec->creator	  = $USER->id;
		$rec->sessdate	  = $sessdate;
		$rec->method	  = $method;
		$rec->starttime	  = $starttime;
		$rec->endtime	  = $endtime;
		$rec->latetime	  = $latetime;
		$rec->allowip	  = $allowip;
		$rec->description = $desc;
		$rec->denysameip  = $denysameip;

		if ($method=='S') {
			if (!$attendkey and $randomkey) {
				$rec->attendkey = jbxl_randstr(5, true);
	  		}
	 		else {
				$rec->attendkey = $attendkey;
			}
		}
		else {
			$rec->attendkey = '';
		}

		if ($DB->insert_record('autoattend_sessions', $rec)) {
			//$loginfo = 'start_time='.$starttime.',method='.$method;
			//add_to_log($course->id, 'autoattend', 'add one session', $wwwMyURL, $loginfo);
			notice(get_string('sessionadded', 'block_autoattend'),  $back2URL.'?course='.$course->id.'&amp;class='.$classid);
		} 
		else {
			print_error('errorinaddingsession', 'block_autoattend', $wwwMyURL.'?course='.$course->id.'&amp;class='.$classid);
		}
	}
} 


if($isteacher) { 
	$classes = autoattend_get_session_classes($course->id);
	$nowtime = time();
	include('add_one.html');
}

echo $OUTPUT->footer($course);
