<?php

require_once('../../config.php');	
require_once($CFG->libdir.'/blocklib.php');
require_once('lib.php');

//
define('DEFAULT_PAGE_SIZE', 15);


$courseid 	= required_param('course', PARAM_INTEGER);	 // Course id
$classid  	= optional_param('class', 0, PARAM_INTEGER);
$newclassid = optional_param('newclass', 0, PARAM_INTEGER);
$sort 	  	= optional_param('sort', 'lastname', PARAM_ALPHA);

if (($formdata = data_submitted()) and !confirm_sesskey()) {
	print_error('invalidsesskey');
}

$urlparams['course'] = $courseid;
if ($classid) $urlparams['class'] = $classid;
if ($sort)	  $urlparams['sort']  = $sort;
$PAGE->set_url('/blocks/autoattend/class_division.php', $urlparams);

$wwwBlock = $CFG->wwwroot.'/blocks/autoattend';
$wwwMyURL = $wwwBlock.'/class_division.php';


$course = $DB->get_record('course', array('id'=>$courseid));
if (!$course) {
	print_error('courseidwrong', 'block_autoattend');
}

require_login($course->id);

$context   = get_context_instance(CONTEXT_COURSE, $course->id);
$isassist  = false;
$isteacher = jbxl_is_teacher($USER->id, $context);
if (!$isteacher) {
	$isassist = jbxl_is_assistant($USER->id, $context);
 	if (!$isassist) {
   		print_error('notaccessstudent', 'block_autoattend');
	}
}

$user = $DB->get_record('user', array('id'=>$USER->id));
if (!$user) {
	print_error('nosuchuser', 'block_autoattend');
}



//////////////////////////////////////////////////////////////////////////////////////////
//
function class_division_make_header(&$table, $url_options, $start, $end)
{
	global $CFG, $wwwMyURL;

	$firstname = '<a href="'.$wwwMyURL.$url_options.'&amp;sort=firstname">'.get_string('firstname').'</a>';
	$lastname  = '<a href="'.$wwwMyURL.$url_options.'&amp;sort=lastname">' .get_string('lastname').'</a>';

	if ($CFG->fullnamedisplay=='lastname firstname') { // for better view (dlnsk)
		$fullnamehead = $lastname.' / '.$firstname;
	} 
	else {
		$fullnamehead = $firstname.' / '.$lastname;
	}
	//
	unset($table->head);
	unset($table->align);
	unset($table->size);
	unset($table->wrap);

	$table->head [] = '#';
	$table->align[] = 'center';
	$table->size [] = '20px';
	
	$table->head [] = '';
	$table->align[] = '';
	$table->size [] = '20px';
		
	$table->head [] = $fullnamehead;
	$table->align[] = 'left';
	$table->size [] = '180px';
	$table->wrap [2]= 'nowrap';

	$table->head [] = get_string('classname', 'block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '80px';
	$table->wrap [] = 'nowrap';

	$table->head [] = "<a href=\"javascript:select_all_check_in('TD','cell c4 lastcol',null,$start,$end);\">".get_string('changeclass','block_autoattend')."</a>";
	$table->align[] = 'center';
	$table->size [] = '80px';
	$table->wrap [] = 'nowrap';
	
	return;
}



function class_division_show_table($students, $courseid, $classid)
{
	global $wwwBlock, $OUTPUT;
	$url_options = '?course='.$courseid.'&amp;class='.$classid;
	//
	$table = new html_table();

	$i = 0;
	foreach($students as $student) {
		$classinfo = autoattend_get_user_class($student->id, $courseid);
		if ($classinfo->classid==$classid or $classid==0 or ($classid==NON_CLASSID and $classinfo->classid==0)) {
			$i++;
			$table->data[$student->id][] = $i; 
			$pic_options = array('size'=>20, 'link'=>true, 'alttext'=>true, 'courseid'=>$courseid, 'popup'=>true);
			$table->data[$student->id][] = $OUTPUT->user_picture($student, $pic_options);
			$table->data[$student->id][] = '<a href="'.$wwwBlock.'/index.php?course='.$courseid.
											'&amp;student='.$student->id.'" target="_blank">'.fullname($student).'</a>';
			$table->data[$student->id][] = $classinfo->name;
			$table->data[$student->id][] = '<input type="checkbox" name="changeclass'.$student->id.'" value="1" />';
			//
 			if ($i%DEFAULT_PAGE_SIZE==0) {
				echo '<div align="center">';
 				class_division_make_header($table, $url_options, $i-DEFAULT_PAGE_SIZE, $i);
				echo html_writer::table($table);
				echo '</div>';
				unset($table->data);
			}
		}
	}
	if ($i%DEFAULT_PAGE_SIZE!=0 or $i==0) {
		echo '<div align="center">';
		class_division_make_header($table, $url_options, $i-$i%DEFAULT_PAGE_SIZE, $i);
		echo html_writer::table($table);
		echo '</div>';
	}

	return;
}



//////////////////////////////////////////////////////////////////////////////////////////
// Print Header
$title = $course->shortname.': '.get_string('autoattend','block_autoattend');
if ($course->category) {
	$title.= ' '.get_string('class_division','block_autoattend');
} 

$PAGE->set_title($title);
$PAGE->set_heading($course->fullname);
$PAGE->set_cacheable(true);
$PAGE->set_button('&nbsp;');
$PAGE->set_headingmenu(navmenu($course));

echo $OUTPUT->header();

echo "<script type=\"text/javascript\">
<!--
function select_all_check_in(elTagName, elClass, elId, start, end) {
	var inputs = document.getElementsByTagName('INPUT');
	inputs = filterByParent(inputs, function(el) {return findParentNode(el, elTagName, elClass, elId);});
	for(var i=start; i<end; i++) {
		if(inputs[i].type=='checkbox') {
			inputs[i].checked = !inputs[i].checked;
		}
	}
}
//-->
</script>";


//
$currenttab = 'class_division';
include('tabs.php');

//
$sort = ($sort=='firstname' ? 'firstname' : 'lastname');
$students = jbxl_get_course_students($context, $sort);


// Display Attendance Table
if ($students) {
	//
	if (isset($formdata->change_class)) {
		$cnt = 0;
		foreach($_POST as $key=>$value) {
			if (substr($key, 0, 11)=='changeclass') {
				$studentid = substr($key, 11, strlen($key)-11);
				if (is_numeric($studentid)) {
					$class = autoattend_get_user_class($studentid, $course->id);
					if ($class->classid!=$newclassid) {
						$class->classid = $newclassid;
						if ($class->id!=0) {
							$DB->update_record('autoattend_classifies', $class);
						}
						else {
							$class->id = $DB->insert_record('autoattend_classifies', $class);
						}
						$cnt++;
					}
				}
			}
		}
		if ($cnt>0) {
			autoattend_update_grades($course->id);
		}
	}
	//
	$classes = autoattend_get_session_classes($course->id);
	$url_options = '?course='.$courseid.'&amp;sort='.$sort;
	include('class_division.html');
} 
//
else {
	echo $OUTPUT->heading(get_string('nothingtodisplay'));
}
 
echo $OUTPUT->footer($course);

