<?php // $Id: grade_settings.php, 2005/09/21  Author: Ashok kumar Pola

// Modified by Fumi.Iseki 	2007/03/23
//							2012/04/20
//							2013/04/09


require_once('../../config.php');	
require_once('lib.php');	


$courseid = required_param('course', PARAM_INTEGER);	// Course id
$classid  = optional_param('class', 0, PARAM_INTEGER);
$submit	  = optional_param('submit', '', PARAM_TEXT);

if (($formdata = data_submitted()) and !confirm_sesskey()) {
	print_error('invalidsesskey');
}

$urlparams['course'] = $courseid;
if ($classid) $urlparams['class'] = $classid;
$PAGE->set_url('/blocks/autoattend/grade_settings.php', $urlparams);

$wwwBlock = $CFG->wwwroot.'/blocks/autoattend';
$wwwMyURL = $wwwBlock.'/grade_settings.php';

$course = $DB->get_record('course', array('id'=>$courseid));
if (!$course) {
	print_error('courseidwrong', 'block_autoattend');
}

require_login($course->id);

$context = get_context_instance(CONTEXT_COURSE, $course->id);
$isteacher = jbxl_is_teacher($USER->id, $context);
if (!$isteacher) {
	print_error('notaccessnoteacher', 'block_autoattend');
}

$user = $DB->get_record('user', array('id'=>$USER->id));
if (!$user) {
	print_error('nosuchuser', 'block_autoattend');
}



//////////////////////////////////////////////////////////////////////////////////////////
//
function grade_settings_show_table($settings)
{
	$table = new html_table();
	//
	$table->head [] = '#';
	$table->align[] = 'center';
	$table->size [] = '20px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('acronym','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('description');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('grade');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	//
	$i = 0;
	foreach($settings as $set) { 
		if ($set->status!='Y') { 
			$table->data[$i][] = $i + 1;
			$table->data[$i][] = get_string($set->status.'acronym',    'block_autoattend');
			$table->data[$i][] = get_string($set->status.'acronymfull','block_autoattend');
			$table->data[$i][] = '<input type="text" name="grade'.$set->status.'" size="4" maxlength="4" value="'.$set->grade.'" />';
			$i++;
		}
	}

	echo '<div align="center">';
	echo html_writer::table($table);
	echo '</div>';
}



//////////////////////////////////////////////////////////////////////////////////////////
// Print header
$title = $course->shortname.': '.get_string('autoattend','block_autoattend');
if ($course->category) {
	$title.= ' '.get_string('grade_settings','block_autoattend');
} 

$PAGE->set_title($title);
$PAGE->set_heading($course->fullname);
$PAGE->set_cacheable(true);
$PAGE->set_button('&nbsp;');
$PAGE->set_headingmenu(navmenu($course));

echo $OUTPUT->header();


$currenttab = 'grade_settings';	
include('tabs.php');


if($isteacher) {
	if ($submit) {
		$grades = array();
		$grades['P'] = optional_param('gradeP', 2, PARAM_INTEGER);
		$grades['L'] = optional_param('gradeL', 1, PARAM_INTEGER);
		$grades['E'] = optional_param('gradeE', 1, PARAM_INTEGER);
		$grades['X'] = optional_param('gradeX', 0, PARAM_INTEGER);
		$grades['Y'] = $grades['X'];
		$restore = optional_param('restore', 0, PARAM_INTEGER);
		autoattend_update_grade_settings($course->id, $grades, $restore);
		autoattend_update_grades($course->id);
	}
	//
	$settings = autoattend_get_grade_settings($course->id);
	include('grade_settings.html');
}

echo $OUTPUT->footer($course);
