<?php // $Id: index.php,v 1.9 2006/04/16 20:32:51 dlnsk Exp $
	
// Modified by Fumi.Iseki	2007/03/19
//							2012/04/12


require_once('../../config.php');	
require_once('lib.php');


$courseid   = required_param('course',	     PARAM_INTEGER); 
$classid	= optional_param('class', 0,  	 PARAM_INTEGER);
$action		= optional_param('action', '',   PARAM_ALPHA);
$from		= optional_param('from', '',	 PARAM_ALPHA);
$studentid	= optional_param('student', 0,   PARAM_INTEGER);
$printing	= optional_param('printing', '', PARAM_ALPHA);

if (($formdata = data_submitted()) and !confirm_sesskey()) {
	print_error('invalidsesskey');
}
if ($classid<0) $classid = 0;

$urlparams['course'] = $courseid;
if ($classid)   $urlparams['class']	   = $classid;
if ($action)	$urlparams['action']   = $action;
if ($studentid) $urlparams['student']  = $studentid;
if ($from) 		$urlparams['from'] 	   = $from;
if ($printing) 	$urlparams['printing'] = $printing;
$PAGE->set_url('/blocks/autoattend/index.php', $urlparams);

$wwwBlock = $CFG->wwwroot.'/blocks/autoattend';
$wwwMyURL = $wwwBlock.'/index.php';


$course = $DB->get_record('course', array('id'=>$courseid));
if (!$course) {
	print_error('courseidwrong', 'block_autoattend');
}

require_login($course->id);
	
$user = $DB->get_record('user', array('id'=>$USER->id));
if (!$user) {
	print_error('nosuchuser', 'block_autoattend');
}


//
$context   = get_context_instance(CONTEXT_COURSE, $course->id);
$isstudent = false;
$isassist  = false;
$isteacher = jbxl_is_teacher($USER->id, $context);
if (!$isteacher) {
	$isassist = jbxl_is_assistant($USER->id, $context);
	if (!$isassist) $isstudent = jbxl_is_student($USER->id, $context);
}


// DownLoad (Excel or Text Format)
if ($isteacher or $isassist) {  
	$classes = autoattend_get_session_classes($course->id);
	if($action=='excel') {
		autoattend_download('xls', $course->id, $classes, $classid);
		die();
	}
	else if($action=='text') {
		autoattend_download('txt', $course->id, $classes, $classid);
		die();
	}
}



//////////////////////////////////////////////////////////////////////////////////////////
//
// function
//
function att_sessions_show_table($sessions, $classes, $courseid, $classid)
{
	global $context, $wwwBlock, $isteacher, $DB, $TIME_OFFSET;

	$table = new html_table();
	//
	$table->head [] = '#';
	$table->align[] = 'center';
	$table->size [] = '20px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('date');
	$table->align[] = 'center';
	$table->size [] = '80px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('starttime','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('endtime','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('classname','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('description','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '80px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('keyword','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '65px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('callmethod','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '40px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('callstate','block_autoattend');
	$table->align[] = 'center';
	$table->size [] = '80px';
	$table->wrap [] = 'nowrap';

	$table->head [] = get_string('action');
	$table->align[] = 'center';
	$table->size [] = '60px';
	$table->wrap [] = 'nowrap';

	//
	$totalmember[0] = autoattend_count_attend_students($courseid, 0, $context);
	foreach($classes as $class) { 
		$totalmember[$class->id] = autoattend_count_attend_students($courseid, $class->id, $context);
	}

	//
	$i = 0;
	foreach($sessions as $sessdata) { 
		$ttlcount = $totalmember[$sessdata->classid];
		$attcount = autoattend_count_class_students($sessdata, $courseid, $context, "status<>'Y' AND status<>'X'");

		$table->data[$i][] = $i + 1;
		$table->data[$i][] = strftime(get_string('strftimedmyw',   'block_autoattend'), $sessdata->sessdate  + $TIME_OFFSET);
		$table->data[$i][] = strftime(get_string('strftimehourmin','block_autoattend'), $sessdata->starttime + $TIME_OFFSET);
		$table->data[$i][] = strftime(get_string('strftimehourmin','block_autoattend'), $sessdata->endtime   + $TIME_OFFSET);
		$table->data[$i][] = autoattend_get_session_classname($sessdata->classid);
		$table->data[$i][] = $sessdata->description ? $sessdata->description: get_string('nodescription', 'block_autoattend');
		$table->data[$i][] = $sessdata->attendkey ? $sessdata->attendkey: get_string('novalue', 'block_autoattend');
		$table->data[$i][] = get_string($sessdata->method.'methodfull', 'block_autoattend');
		$table->data[$i][] = get_string($sessdata->state.'statefull', 'block_autoattend').'&nbsp;('.$attcount.'/'.$ttlcount.')';

		$title  = get_string('takeattendance','block_autoattend');
		$actbtn = '<a title="'.$title.'" href="'.$wwwBlock.'/updateAttendance.php?course='.$courseid.'&amp;attsid='.$sessdata->id.'&amp;class='.$classid.'">';

		if($sessdata->state=='C') {
			$actbtn.= '<img src="pix/t/go.gif" alt="'.$title.'" /></a>&nbsp;';
		}
		else if($sessdata->state=='O') {
			$actbtn.= '<img src="pix/b.gif" alt="'.$title.'" /></a>&nbsp;';
		}
		else {
			$actbtn.= '<img src="pix/t/stop.gif" alt="'.$title.'" /></a>&nbsp;';
		}
		if ($isteacher) {
			$title = get_string('editsession','block_autoattend');
			$actbtn.= '<a title="'.$title.'" href="'.$wwwBlock.'/updateSession.php?course='.$courseid.'&amp;attsid='.$sessdata->id.'">';
			$actbtn.= '<img src="pix/t/edit.gif" alt="'.$title.'" /></a>&nbsp;';
			$actbtn.= '<input type="hidden" name="sesskey" value="'.sesskey().'" />';
			$actbtn.= '<input type="checkbox" name="delete'.$sessdata->id.'" value="1" />';
		}
		$table->data[$i][] = $actbtn;

		$i++; 
	}

	echo html_writer::table($table);

	return;
}




//////////////////////////////////////////////////////////////////////////////////////////
// Print Header
//
$title = $course->shortname.': '.get_string('autoattend','block_autoattend');
$PAGE->set_title($title);
$PAGE->set_heading($course->fullname);


// Printing
if ($printing) {
	$PAGE->set_pagelayout('print');
	echo $OUTPUT->header();

	if ($isteacher) {
		$student = $DB->get_record('user', array('id'=>$studentid));
		if ($student) {
			autoattend_print_user($student, $course, 'printing');
		}
		else {
			print_error('nosuchuser', 'block_autoattend');
		}
	}
	else {
		autoattend_print_user($user, $course, 'printing');
	}
	die();
}
 

//
$PAGE->set_cacheable(true);
$PAGE->set_button('&nbsp;');
$PAGE->set_headingmenu(navmenu($course));

echo $OUTPUT->header();


// for Teacher or Assistant
if ($isteacher or $isassist) {
	$sessions = autoattend_get_sessions($course->id, $classid, true);

	if($studentid>0) {		// 個人データを出力
		//$currenttab = 'none';
		//include('tabs.php');
		$student = $DB->get_record('user', array('id'=>$studentid));
		if ($student) {
			autoattend_print_user($student, $course);
			//add_to_log($course->id, 'autoattend', 'view teacher', $wwwMyURL, 'user='.$student->id);
		} 
		else {
			print_error('nosuchuser', 'block_autoattend');
		}
	} 
	else {					// 出欠リスト一覧の表示
		$currenttab = 'sessions';
		include('tabs.php');
		//
		$classes = autoattend_get_session_classes($course->id);
		$url_options = '?course='.$courseid;
		include('index_html.html');
	}
}

// for Student
else if ($isstudent) {
	add_to_log($course->id, 'autoattend', 'view own', $wwwMyURL);
	autoattend_print_user($user, $course);
}

// for Guest
else {
	echo $OUTPUT->heading(get_string('notaccessguest', 'block_autoattend'));
} 


echo $OUTPUT->footer($course);
