
#include "txml.h"


/**
	Tiny XML  txml.c v1.0	'09 2/10

	TuZbg `XML ȈՃp[T 


	SẴp^[̃p[X\ۏႷ̂ł͂܂
	G XML̓p[Xł܂D

		<?xml ... ?> ȊO <? ..... ?>  <! ..... > ͏Ȃiǂݍ݂͍sj
		GeBeB͏ȂD

*/

//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Parser
//

/**
tXML*  xml_parse(char* pp)

	@\FXMLf[^߂āCtXML̃c[\Ɋi[D

	Fpp -- XMLf[^ւ̃|C^D

	߂lF return -- XMLf[^i[ tXML̃AJ[ւ̃|C^ 
					   G[Nꍇ ->state  XML_PARSED ȊO̒li0ȉjD
					@ G[̏ꍇ́C->next ȉɂ̓G[NO܂ł̓eۑ

*/
tXML*  xml_parse(char* pp)
{
	tXML* xml;
	tXML* tag;


	xml = new_tTree_node();					// AJ[
	xml->ldat.id = XML_ANCHOR_TAG;

	// p[X
	tag = xml_partial_parse(xml, pp, TRUE);
	if (tag->state<0) return xml;


	// ɖ߂H
	if (xml==tag) {
		xml->state = XML_PARSED;
	}
	else {
        xml->state = XML_PARSE_ERROR;
		return xml;
	}

	// XML root̐
	if (xml->next!=NULL) {
		int n = 0;
		tag = xml->next;
		while(tag!=NULL) {
			if (tag->ldat.id==XML_TAG_NAME) n++;
			tag = tag->ysis;
		}
		if (n!=1) xml->state = XML_MULTI_ROOT;
	}
	else xml->state = XML_DEFAULT_STATE;

	return xml;
}





/**
tXML*  xml_parse_seq(tXML* xml, char* pp)

	@\FI XMLf[^߂āCtXML̃c[\Ɋi[D
		  S XMLf[^łȂĂ߂łƂ܂ł͉߂D
		  xml NULL̏ꍇ͎IɃc[D
		  fГI XMLf[^͂ꍇɎgpD

	F pp  -- XMLf[^ւ̃|C^D
		   xml -- XMLf[^i[c[\̂̐擪ւ̃|C^Dc[̓r̃^Oł

	߂lF return -- XMLc[f[^̃AJ[ւ̃|C^
					   ->altp ɍŌɏ^Oւ̃|C^i[D
					   ߂sS̏ꍇ ->state ɏԂ̒lD

*/
tXML*  xml_parse_seq(tXML* xml, char* pp)
{
	int   skip = FALSE;
	tXML* tag;

	if (xml==NULL) {
		xml = new_tTree_node();
		xml->ldat.id = XML_ANCHOR_TAG;
		skip = TRUE;
	}
	else {
		tXML* top = find_xml_top(xml);
		if (top==xml) top->state = XML_DEFAULT_STATE;
	}

	tag = xml_partial_parse(xml, pp, skip);
	xml = find_xml_top(xml);
	xml->altp = tag;

	if (xml!=tag) return xml;

	if (tag->state==0) xml->state = XML_PARSED;
	else			   xml->state = tag->state;

	if (xml->next!=NULL) {
		int n = 0;
		tag = xml->next;
		while(tag!=NULL) {
			if (tag->ldat.id==XML_TAG_NAME) n++;
			tag = tag->ysis;
		}
		if (n!=1) xml->state = XML_MULTI_ROOT;
	}
	else xml->state = XML_DEFAULT_STATE;

	return xml;
}





/**
tXML*  xml_parse_file(char* fn)

	@\Ft@CǂݍŃp[XD

	Ffn -- ǂݍރt@C

	߂lF return -- XMLf[^i[ tXML̃AJ[ւ̃|C^ 

*/
tXML*  xml_parse_file(char* fn)
{
	tXML*  xml = NULL;
	Buffer buf;

	buf = read_Buffer_file(fn);
	if (buf.buf!=NULL) {
		xml = xml_parse((char*)(buf.buf));
		free_Buffer(&buf);
	}

	return xml;
}





/**
tXML*  xml_partial_parse(tXML* xml, char* pp, int skip)

	@\FI XMLf[^߂āCtXML̃c[\Ɋi[D
		  S XMLf[^łȂĂ߂łƂ܂ł͉߂D
		  p[T̃C֐DC[Uڂ̊֐gp邱Ƃ͑D

	F pp  -- XMLf[^ւ̃|C^D
		   xml -- XMLf[^i[c[\̂̐擪ւ̃|C^D
		   skip - ŏ̃f[^i^CgȂǁjXLbv邩H TRUE or FLASE

	߂lF return -- Ōɏ^Om[hւ̃|C^D
					   G[̏ꍇ ->state  0̒lD
					   pp NULL̏ꍇ xml, xml NULL̏ꍇ NULLԂD

*/
tXML*  xml_partial_parse(tXML* xml, char* pp, int skip)
{
	int   n, tag_end;
	char* tag_name = NULL;
	char* tag_attr = NULL;
	char* value	   = NULL;
	

	if (pp ==NULL) return xml;
	if (xml==NULL) return NULL;

	if (skip) while (*pp!='\0' && *pp!='<') pp++;

	while (*pp!='\0') {
		n = 1;

		if (*pp=='<') {
			// End TAG		</   >
			if (*(pp+1)=='/') {
				if (xml->state==XML_TAG_STARTED) {
					n = xml_parse_end_tag(pp, &tag_name);
					if (n>0) {
						if (tag_name!=NULL && xml->ldat.key.buf!=NULL) {
							if (!strcmp((const char*)tag_name, (const char*)(xml->ldat.key.buf))) {
								xml->state = XML_TAG_ENDED;
								if (xml->prev!=NULL) xml = xml->prev;
								else n = xml->state = XML_SEQUENCE_ERROR;
							}
							else n = xml->state = XML_PARSE_ERROR;
						}
						else n = xml->state = XML_PARSE_ERROR;
					}
					else xml->state = n;					// G[
				}
				else n = xml->state = XML_PARSE_ERROR;
			}


			// Comment TAG		<!--   -->
			else if (!strncmp(pp+1, "!--", 3)) {
				n = xml_parse_comment_tag(pp, &value);
				if (n>0) {
					xml = add_tTree_node_bystr(xml, XML_COMMENT_TAG, 0, XML_COMMENT_TAG_KEY, value, NULL, 0);
					xml->state = XML_TAG_EMPTY;
					if (xml->prev!=NULL) xml = xml->prev;
					else n = xml->state = XML_SEQUENCE_ERROR;
				}
			}


			// Data TAG			<!     >
			else if (*(pp+1)=='!') {
				n = xml_parse_data_tag(pp, &value);
				if (n>0) {
					xml = add_tTree_node_bystr(xml, XML_DATA_TAG, 0, XML_DATA_TAG_KEY, value, NULL, 0);
					xml->state = XML_TAG_EMPTY;
					if (xml->prev!=NULL) xml = xml->prev;
					else n = xml->state = XML_SEQUENCE_ERROR;
				}
			}


			// Processing TAG  	<?   ?>
			else if (*(pp+1)=='?') {
				n = xml_parse_processing_tag(pp, &tag_name, &tag_attr);
				if (n>0) {
					if (!strncasecmp("xml", tag_name, 3)) {
						tList* lp = xml_parse_attr(tag_attr);
						xml = add_tTree_node_bystr(xml, XML_DOC_TAG, 0, tag_name, NULL, NULL, 0);
						xml->ldat.lst = lp;
					}
					else {
						xml = add_tTree_node_bystr(xml, XML_PROCESS_TAG, 0, tag_name, tag_attr, NULL, 0);
					}
					xml->state = XML_TAG_EMPTY;
					if (xml->prev!=NULL) xml = xml->prev;
					else n = xml->state = XML_SEQUENCE_ERROR;
				}
			}


			// Start TAG  <   > 
			else {
				n = xml_parse_start_tag(pp, &tag_name, &tag_attr, &tag_end);

				if (n>0) {
					tList* lp = xml_parse_attr(tag_attr);
					xml = add_tTree_node_bystr(xml, XML_TAG_NAME, 0, tag_name, NULL, NULL, 0);
					xml->ldat.lst = lp;

					if (tag_end) {
						xml->state = XML_TAG_EMPTY;
						if (xml->prev!=NULL) xml = xml->prev;
						else n = xml->state = XML_SEQUENCE_ERROR;
					}
					else {
						int m;
						xml->state = XML_TAG_STARTED;
						// ^Ol
						m = xml_parse_content(pp+n, &value);			// 0 Ԃ\
						if (m>=0) {
							n += m;
							if (value!=NULL) {
								xml = add_tTree_node_bystr(xml, XML_TAG_CONTENT, 0, value, NULL, NULL, 0);
								xml->state = XML_TAG_ENDED;
								if (xml->prev!=NULL) {
									xml = xml->prev;
									xml->ldat.lv++;
								}
								else n = xml->state = XML_SEQUENCE_ERROR;
							}
						}
						else n = xml->state = m;					// G[
					}
				}
			}


			freeNull(tag_name);
			freeNull(tag_attr);
			freeNull(value);
		}


		// Content		(fГIɓ͂XML content ̓rŏIĂꍇȂ)
		else {
			if (xml->state==XML_TAG_STARTED) {
				n = xml_parse_content(pp, &value);
				if (n>0) {
					if (value!=NULL) {
						xml = add_tTree_node_bystr(xml, XML_TAG_CONTENT, 0, value, NULL, NULL, 0);
						xml->state = XML_TAG_ENDED;
						if (xml->prev!=NULL) {
							xml = xml->prev;
							xml->ldat.lv++;
						}
						else n = xml->state = XML_SEQUENCE_ERROR;
					}
				}
				else n = xml->state = XML_PARSE_ERROR;
				freeNull(value);
			}
			else n = xml->state = XML_PARSE_ERROR;
		}


		// G[
		if (n<=0) return xml;

		pp += n;
		while (*pp==' ' || *pp==TAB || *pp==LF || *pp==CR) pp++;
	}

	return xml;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Paese of TAG
// 

/**
int  xml_parse_start_tag(char* pp, char** tag_name, char** tag_attr, int* tag_end)

	@\FXML̊Jn^ODł^Ǒ^
			<tag_name attr1="value1" attr2="value2">
			<tag_name attr1="value1" attr2="value2" />
	
		 j̊֐ł́C(*tag_attr)̉߂͍sȂ̂ŁC xml_parse_attr() 
			 ōsKvD

	Fpp		-- ^Oւ̃|C^D'<' w|C^D
		  *tag_name -- ^O̖Oi[|C^D
		  *tag_attr -- ^Ȏi[|C^D
		  *tag_end  -- ^OPƂŕĂ邩ǂi[ϐD

	߂lF
		  return	-- 1>=: ^OŜ̒D0 Ԃ邱Ƃ͖D
					   XML_PARSE_ERROR:  p[XG[D
					   XML_MEMORY_ERROR: G[
		  *tag_name -- ^O̖Oi[Dvfree
		  *tag_attr -- ^Ȏi[Di߁j͍sȂDvfree
		  *tag_end  -- ^OPƂŕĂꍇ(Empty Tag) TRUE, łȂꍇ FALSEDvfree
*/
int  xml_parse_start_tag(char* pp, char** tag_name, char** tag_attr, int* tag_end)
{
	int   nn, mm;
	char* pt;

	*tag_end  = FALSE;
	*tag_name = NULL;
	*tag_attr = NULL;

	if (*pp!='<') return XML_PARSE_ERROR;
	pt = pp = pp + 1;
	pt = skip_char(pt, " />");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn = nn + 1;
	*tag_name = (char*)malloc((size_t)(mm + 1));
	if (*tag_name==NULL) return XML_MEMORY_ERROR;
	memcpy(*tag_name, pp, mm);
	(*tag_name)[mm] = '\0';
	//print_message("START --> %s  %d\n", *tag_name, (int)strlen(*tag_name));

	if (isnot_xml_name((unsigned char*)(*tag_name))) return XML_PARSE_ERROR;


	// Empty TAG
	if (*pt=='/') {
		if (*(pt+1)!='>') {
			freeNull(*tag_name);
			return XML_PARSE_ERROR;
		}
		nn += 1;
		*tag_end = TRUE;
		//print_message("END   --> %s  %d\n", *tag_name, (int)strlen(*tag_name));
	}


	// Attribute
	else if (*pt==' ') {
		pp = pt = pt + 1;
		while (*pt==' ' || *pt==TAB || *pt==LF || *pt==CR) pt++;
		nn += (int)(pt - pp) + 1;

		pp = pt;
		pt = skip_char(pt, "/>");
		if (pt==NULL) {
			freeNull(*tag_name);
			return XML_PARSE_ERROR;
		}

		mm = (int)(pt - pp);
		if (mm>0) {
			*tag_attr = (char*)malloc((size_t)(mm + 1));
			if (*tag_attr==NULL) {
				freeNull(*tag_name);
				return XML_MEMORY_ERROR;
			}
			memcpy(*tag_attr, pp, mm);
			(*tag_attr)[mm] = '\0';
			nn += mm;
			//print_message("ATTR  --> %s  %d\n", *tag_attr, (int)strlen(*tag_attr));
		}

		if (*pt=='/') {
			if (*(pt+1)!='>') {
				freeNull(*tag_name);
				freeNull(*tag_attr);
				return XML_PARSE_ERROR;
			}
			nn += 1;
			*tag_end = TRUE;
			//print_message("END   --> %s  %d\n", *tag_name, (int)strlen(*tag_name));
		}
	}
	
	//else {}   *pt=='>'

	return nn + 1;
}





/**
int  xml_parse_end_tag(char* pp, char** tag_name)

	@\FXML̏I^ODł^Ǒ^ </tag_name>
	
	Fpp		-- ^Oւ̃|C^D'<' w|C^D
		  *tag_name -- ^O̖Oi[|C^D

	߂lF
		  return	-- 0>: ^OŜ̒D0 Ԃ邱Ƃ͖D
					   XML_PARSE_ERROR:  p[XG[D
					   XML_MEMORY_ERROR: G[
		  *tag_name -- ^O̖Oi[Dvfree
*/
int  xml_parse_end_tag(char* pp, char** tag_name)
{
	int   nn, mm;
	char* pt;
	char* work;

	if (pp==NULL) return XML_PARSE_ERROR;
	*tag_name = NULL;

	if (strncmp(pp ,"</", 2)) return XML_PARSE_ERROR;

	pt = pp = pp + 2;
	pt = skip_char(pt, ">");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 2;
	work = (char*)malloc((size_t)(mm+1));
	if (work==NULL) return XML_MEMORY_ERROR;
	memcpy(work, pp, mm);
	work[mm] = '\0';
	*tag_name = pack_head_tail_char(work, ' ');
	free(work);
	//print_message("END   --> %s  %d\n", *tag_name, (int)strlen(*tag_name));

	return nn + 1;
}





/**
int  xml_parse_content(char* pp, char** content)

	@\FXML̃RegD <tag_name attr="tag_attr">content</tag_name>
		  l̑Ő󔒁CTAB, LF, CR͍폜D
	
	Fpp	   -- Reg̐擪ւ̃|C^DStart Tag '>' ̎w|C^D
		  *content -- Regi[|C^DRegȂꍇ NULLłD

	߂lF
		  return   -- 0>=: ^Ol̑Ŝ̒D0 Ԃ\(<a></a>̏ꍇj
					  XML_PARSE_ERROR:  p[XG[D
					  XML_MEMORY_ERROR: G[
		  *content -- Regi[DO , TAB, LF, CR͍폜ĂDvfree
*/
int  xml_parse_content(char* pp, char** content)
{
	int   nn=0, mm;
	char* pt;
	char* work;

	if (pp==NULL || content==NULL) return XML_PARSE_ERROR;
	*content = NULL;

	while (*pp==' ' || *pp==TAB || *pp==LF || *pp==CR) {
		pp++;
		nn++;
	}
	if (*pp=='<') return nn;			// <tag><

	pt = pp;
	while (*pt!='<' && *pt!='\0') pt++;

	mm = (int)(pt - pp);
	if (mm==0) return nn;
	nn += mm;

	work = (char*)malloc((size_t)(mm+1));
	if (work==NULL) return XML_MEMORY_ERROR;
	memcpy(work, pp, mm);
	work[mm] = '\0';

	*content = pack_head_tail_char(work, ' ');
	free(work);
	//print_message("VALUE --> %s  %d\n", *content, (int)strlen(*content));

	return nn;
}





/**
tList*  xml_parse_attr(char* pp)

	@\FXML̃^O߂āCXg(tList)ɂD ߂`  AAA="GGG" xxxx="1234"

	FeLXgŕۑĂ鑮ւ̃|C^D

	߂lFXg̐擪ւ̃|C^D
			p[XG[̏ꍇ state  XML_PARSE_ERROR ݒ肳DɏIꍇ
			 XML_TAG_ENDED ݒ肳D
*/
tList*  xml_parse_attr(char* pp)
{
	int	   sz;
	char*  nm;
	char*  vl;
	char*  pt;
	char   qt;
	tList* lp = NULL;
	tList* lt = NULL;


	// ƃ̊m
	if (pp==NULL) return NULL;
	sz = (int)strlen((const char*)pp) + 1;
	nm = (char*)malloc(sz);
	if (nm==NULL) return NULL;
	vl = (char*)malloc(sz);
	if (vl==NULL) {
		free(nm);
		return NULL;
	}

	// Parse for AAA="BBB" CCC="DDDD"
	while (*pp==' ' && *pp!='\0') pp++;
	while (*pp!='\0') {
		pt = pp;
		while (*pt!='=' && *pt!='\0') pt++;
		if (*pt=='\0') {
			if (lt!=NULL) lt->state = XML_PARSE_ERROR;
			break;
		}

		sz = (int)(pt - pp);
		memcpy(nm, pp, (size_t)sz);
		nm[sz] = '\0';

		pt++;
		if (*pt!='"' && *pt!='\'') {
			if (lt!=NULL) lt->state = XML_PARSE_ERROR;
			break;
		}
		else qt = *pt;

		pt++;
		pp = pt;
		while(*pt!=qt && *pt!='\0') pt++;
		if (*pt=='\0') {
			if (lt!=NULL) lt->state = XML_PARSE_ERROR;
			break;
		}

		sz = (int)(pt - pp);
		memcpy(vl+1, pp, (size_t)sz);
		vl[0]	 = qt;
		vl[sz+1] = qt;
		vl[sz+2] = '\0';

		lp = add_tList_node_str(lp, nm, vl);
		if (lt==NULL) lt = lp;
		pp = pt + 1;

		if (*pp!=' ' && *pp!='\0') {
			lt->state = XML_PARSE_ERROR;
			break;
		}
		while (*pp==' ' && *pp!='\0') pp++;
	}

	//
	free(nm);
	free(vl);

	if (lt!=NULL) {
		if (lt->state!=XML_PARSE_ERROR) lt->state = XML_TAG_ENDED;
	}
	return lt;
}





/**
int  xml_parse_processing_tag(char* pp, char** tag_name, char** tag_attr)

	@\FXML̃vZbVO^ODł^Ǒ^ <?processing?>
		  vZbVO͉߂ɁĈ܂ tag_name, tag_attrɊi[D

	Fpp		-- ^Oւ̃|C^D'<' w|C^D
		  *tag_name -- vZbVO̖Oi[|C^D
		  *tag_attr -- vZbVȎi[|C^D

	߂lF
		  return	-- 0>: ^OŜ̒D0 Ԃ邱Ƃ͖D
					   XML_PARSE_ERROR:  p[XG[D
					   XML_MEMORY_ERROR: G[
		  *tag_name -- vZbVO̖Oi[Dvfree
		  *tag_attr -- vZbVȎi[Dvfree
*/
int  xml_parse_processing_tag(char* pp, char** tag_name, char** tag_attr)
{
	int   nn, mm;
	char* pt;

	*tag_name = NULL;
	*tag_attr = NULL;

	if (pp==NULL) return XML_PARSE_ERROR;
	if (strncmp(pp, "<?", 2)) return XML_PARSE_ERROR;

	pt = pp = pp + 2;
	pt = skip_char(pt, " ?");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 2;
	*tag_name = (char*)malloc((size_t)(mm + 1));
	if (*tag_name==NULL) return XML_MEMORY_ERROR;
	memcpy(*tag_name, pp, mm);
	(*tag_name)[mm] = '\0';

	if (isnot_xml_name((unsigned char*)(*tag_name))) return XML_PARSE_ERROR;

	// for attribute
	if (*pt==' ') {
		pp = pt = pt + 1;
		while (*pt==' ' || *pt==TAB || *pt==LF || *pt==CR) pt++;
		nn += (int)(pt - pp) + 1;

		pp = pt;
		pt = skip_char(pt, "?");
		if (pt==NULL) {
			freeNull(*tag_name);
			return XML_PARSE_ERROR;
		}

		mm = (int)(pt - pp);
		if (mm>0) {
			*tag_attr = (char*)malloc((size_t)(mm + 1));
			if (*tag_attr==NULL) {
				freeNull(*tag_name);
				return XML_MEMORY_ERROR;
			}
			memcpy(*tag_attr, pp, mm);
			(*tag_attr)[mm] = '\0';
			nn += mm;
			//print_message("ATTR  --> %s  %d\n", *tag_attr, (int)strlen(*tag_attr));
		}
	}
	
	if (strncmp(pt, "?>", 2)) {
		freeNull(*tag_name);
		freeNull(*tag_attr);
		return XML_PARSE_ERROR;
	}

	return nn + 2;
}





/**
int  xml_parse_comment_tag(char* pp, char** comment)

	@\FXML̃Rg^ODł^Ǒ^ <!--comment-->
		  xml_parse_data_tag() ɐ旧ēKpKvD

	Fpp	  -- ^Oւ̃|C^D'<' w|C^D
		  *coment -- Rgi[|C^D

	߂lF
		  return   -- 0>: ^OŜ̒D0 Ԃ邱Ƃ͖D
					  XML_PARSE_ERROR:  p[XG[D
					  XML_MEMORY_ERROR: G[
		  *commnet -- Rĝ܂܊i[Dvfree
*/
int  xml_parse_comment_tag(char* pp, char** comment)
{
	int   nn, mm;
	char* pt;

	*comment = NULL;
	if (pp==NULL) return XML_PARSE_ERROR;
	if (strncmp(pp, "<!--", 4)) return XML_PARSE_ERROR;

	pt = pp = pp + 4;
	pt = skip_char(pt, ">");
	if (pt==NULL) return XML_PARSE_ERROR;

	pt -= 2;
	if (strncmp(pt, "-->", 3)) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 4;
	*comment = (char*)malloc((size_t)(mm+1));
	if (*comment==NULL) return XML_MEMORY_ERROR;
	memcpy(*comment, pp, mm);
	(*comment)[mm] = '\0';
	//print_message("COMMENT-> %s  %d\n", *comment, (int)strlen(*comment));

	return nn + 3;
}





/**
int  xml_parse_data_tag(char* pp, char** data)

	@\FXML̃f[^^OȋGg^OȂǁjD
		  ł^Ǒ^ <!data>
		  f[^͉߂ɁĈ܂ dataɊi[D

	Fpp	-- ^Oւ̃|C^D'<' w|C^D
		  *data -- f[^i[|C^D

	߂lF
		  return -- 0>: ^OŜ̒D0 Ԃ邱Ƃ͖D
					XML_PARSE_ERROR:  p[XG[D
					XML_MEMORY_ERROR: G[
		  *data  -- f[^̂܂܊i[Dvfree
*/
int  xml_parse_data_tag(char* pp, char** data)
{
	int   nn, mm;
	char* pt;

	*data = NULL;
	if (pp==NULL) return XML_PARSE_ERROR;
	if (strncmp(pp, "<!", 2)) return XML_PARSE_ERROR;

	pt = pp = pp + 2;
	pt = skip_char(pt, ">");
	if (pt==NULL) return XML_PARSE_ERROR;

	nn = mm = (int)(pt - pp);
	if (mm==0) return XML_PARSE_ERROR;

	nn += 2;
	*data = (char*)malloc((size_t)(mm+1));
	if (*data==NULL) return XML_MEMORY_ERROR;
	memcpy(*data, pp, mm);
	(*data)[mm] = '\0';
	//print_message("DATA ---> %s  %d\n", *data, (int)strlen(*data));

	return nn + 1;
}






/**
int  isnot_xml_name(char* pp)

	@\FXMLƂĕsK؂ǂ܂ɔf
		  Ȃ肢Ȃ̂ŁCFALSEƂāCXMLƂēK؂łƂ͌Ȃ

	Fpp --  XMLւ̃|C^

	߂lFTRUE  -- XMLƂĕsK
			FALSE -- XMLƂēK؂Ȃ
*/
int  isnot_xml_name(unsigned char* pp)
{
	if (pp==NULL)  return TRUE;
	if (*pp=='\0') return TRUE;

	while (*pp!='\0') {
		if (*pp<=0x2c) return TRUE;					//  !"#$%&'()*+,
		if (*pp==0x2f) return TRUE;					// /
		if (*pp>=0x3b && *pp<=0x40) return TRUE;	// ;<=>?@
		if (*pp>=0x5b && *pp<=0x5e) return TRUE;	// [\]^
		if (*pp==0x60) return TRUE;					// `
		if (*pp>=0x7b && *pp<=0x7f) return TRUE;	// {|}~DEL
		pp++;
	}
	
	return FALSE;
}







//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tools
//

/** 
void   close_xml(tXML* pp)
	
	@\: p[XG[Nc[Iɐ퉻D

	: pp -- 퉻c[ւ̃|C^D

	߂l: ȂD

*/
void   close_xml(tXML* pp)
{
	if (pp!=NULL) {

		// AJ[
 		if (pp->ldat.id==XML_ANCHOR_TAG) {
			pp->state = XML_PARSED;
			pp->depth = 0;
			if (pp->next!=NULL) {
				pp->next->depth = 1;
				adjust_tTree_depth(pp->next);
				close_xml(pp->next);
			}
			return;
		}

		while(pp->esis!=NULL) pp = pp->esis;
		do {
			if (pp->state!=XML_TAG_EMPTY) pp->state = XML_TAG_ENDED;
			if (pp->ldat.lst!=NULL) {
				if ((pp->ldat.lst)->state!=XML_TAG_EMPTY) (pp->ldat.lst)->state = XML_TAG_ENDED;
			}

			if (pp->next!=NULL) close_xml(pp->next);
	   
			pp = pp->ysis;
		} while(pp!=NULL);
	}  
	   
	return;
}




/** 
void   print_xml(FILE* fp, tXML* pp, int mode)
	
	@\: XML̕\D

	: fp   -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  pp   -- \JnXML^Oւ̃|C^D
		  mode -- XML_ONELINE_FORMAT, XML_CRLF_FORMAT, XML_INDENT_FORMAT

	߂l: ȂD

*/
void   print_xml(FILE* fp, tXML* pp, int mode)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		Buffer buf = xml_inverse_parse(pp, mode);
		if (buf.buf!=NULL) {
			fprintf(fp, "%s", buf.buf);
			free_Buffer(&buf);
		}
		else fprintf(fp, "(XML is NULL)\n");
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	} 
	fflush(fp);
	   
	return;
}




/** 
void   print_xml_tree(FILE* fp, tXML* pp, char* space)
	
	@\: XMLc[̂܂܃c[\DfobOpD
		  |C^ ppȍ~̑SẴ^ÕL[̃obt@WG[o͂ɕ\D
		  \Fq̐[CID, m[h, ^O(^Ol)C^Ǒ

	: fp    -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  pp	-- \Jnm[hւ̃|C^D
		  space -- o𑵂͂̏邽߂̋󔒁iCfgjw肷D

	߂l: ȂD

*/
/*
void   print_xml_tree(FILE* fp, tXML* pp, char* space)
{
	int i;
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");	   // for " -> "
		if (pp->ldat.id==XML_ANCHOR_TAG) pp = pp->next;

		if (pp!=NULL) {
			print_sister_xml_tree_rcsv(fp, pp, space);
		}
		else {
			fprintf(fp, "(XML is ANCHOR only)\n");
		}
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	} 
	fflush(fp);
	   
	return;
}
*/

void   print_xml_tree(FILE* fp, tXML* pp, char* space)
{
	int i;
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");      // for " -> "
		if (pp->ldat.id==XML_ANCHOR_TAG) pp = pp->next;

		if (pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "%d: %d [%d] %s (0)", pp->depth, ld.id, pp->state, ld.key.buf);
			//if (pp->next!=NULL) print_sister_xml_tree(fp, pp->next, space);
			//else fprintf(fp, "\n");
			print_sister_xml_tree(fp, pp, space);
		}
		else {
			fprintf(fp, "(XML is ANCHOR only)\n");
		}
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	}  
	fflush(fp);
  
	return;
}





/** 
void   print_sister_xml_tree(FILE* fp, tXML* pp, char* space)
	
		}
		else {
			fprintf(fp, "(XML is ANCHOR only)\n");
		}
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	}  
	fflush(fp);
  
	return;
}
*/





/** 
void   print_sister_xml_tree(FILE* fp, tXML* pp, char* space)
	
	@\: XMLc[̕\Dpp̎om[ho͂D
		  |C^ ppȍ~̑SẴm[h̃L[̃obt@WG[o͂ɕ\D
		  \Fq̐[CID, m[h, ^O(^Ol)C^Ǒ

	: fp    -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  pp	-- \Jnm[hւ̃|C^D(om[ho͂j
		  space -- o𑵂͂̏邽߂̋󔒁iCfgjw肷D

	߂l: ȂD

*/
void   print_sister_xml_tree(FILE* fp, tXML* pp, char* space)
{
	int i;
	if (pp!=NULL) {
		for(i=1; i<pp->depth; i++)   fprintf(fp, space);
		for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");	   // for " -> "
	}

	print_sister_xml_tree_rcsv(fp, pp, space);
}





/**
void   print_sister_xml_tree_rcsv(FILE* fp, tXML* pp, char* space)

	@\Fprint_sister_xml_tree() ̍ċAp֐

*/
void   print_sister_xml_tree_rcsv(FILE* fp, tXML* pp, char* space)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		if (pp->ldat.id==XML_ANCHOR_TAG) {
			if (pp->next!=NULL) pp = pp->next;
		}

		while(pp->esis!=NULL) pp = pp->esis;
		do {
			int i;
			tList_data ld = pp->ldat;

		   	if (pp->depth>1) fprintf(fp, " -> ");
			i = count_tList((tList*)ld.lst);
			fprintf(fp, "%d: %d [%d] %s (%d)", pp->depth, ld.id, pp->state, ld.key.buf, i);

			if (pp->next!=NULL) print_sister_xml_tree_rcsv(fp, pp->next, space);
			else fprintf(fp, "\n");
	   
			pp = pp->ysis;
			if (pp!=NULL) {
				for(i=1; i<pp->depth; i++)   fprintf(fp, space);
				for(i=1; i<pp->depth-1; i++) fprintf(fp, "    ");	   // for " -> "
			}
		} while(pp!=NULL);
	}  
	else {
		fprintf(fp, "(XML is NULL)\n");
	} 
	fflush(fp);
	   
	return;
}








///////////////////////////////////////////////////////////////////////////////////////
//
// Operation
//

/**
tXML* 	add_xml_tag(tXML* xml, char* name)

	@\FXMLc[xml ̒ɊJn^O}D

*/
tXML* 	add_xml_tag(tXML* xml, char* name)
{
	tList* pp;

	if (xml==NULL || name==NULL) return NULL;

	pp = add_tTree_node_bystr(xml, XML_TAG_NAME, 0, name, NULL, NULL, 0);
	pp->state = XML_TAG_STARTED;
	if (pp->prev!=NULL) pp->prev->ldat.lv++;

	return pp;
}




/**
tXML* 	add_xml_content(tXML* xml, char* content)

	@\FXMLc[xml ̒ɃReg}D
		  xml^Om[hłȂ΃G[iNULLԂj

*/
tXML* 	add_xml_content(tXML* xml, char* content)
{
	tList* pp;

	if (xml==NULL || content==NULL) return NULL;
	if (xml->ldat.id!=XML_TAG_NAME) return NULL;

	pp = add_tTree_node_bystr(xml, XML_TAG_CONTENT, 0, content, NULL, NULL, 0);
	pp->state = XML_TAG_ENDED;
	if (pp->prev!=NULL) pp->prev->ldat.lv++;
  
	return pp;
}




/**
tXML*  get_xml_tag(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
		  Ō̃m[hւ̃|C^ԂD

		  ܂Cpt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_NODE ƂȂĂ^O͔rȂ
		  ԂĂ tXML*  free Ă͂ȂD

	Fpp -- Ώۂ̃c[
		  pt -- p^[

	߂lFpt̍Ō̃^OɑΉ^Oւ̃|C^DfreeĂ͂ȂD

	----------------------------------------------------------------
	F	pp						  pt
			A --> B --> M			  C --> M --> Y
			  --> C --> M --> X			   
						  --> Y	--> Z   
					--> N
		̏ꍇCpp Yւ̃|C^ԂD
*/
tXML*  get_xml_tag(tXML* pp, tXML* pt)
{
	int fnd;
	tXML* tt;
	tXML* pm;

	if (pp==NULL || pt==NULL) return NULL;

	pm = pp;
	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	tt = find_xml_end(pt);
	if (tt==NULL) return FALSE;

	while(pp->esis!=NULL) pp = pp->esis;
	fnd = find_match_xml(pp, pt);
	if (fnd) tt = tt->altp;
	else     tt = NULL;

	clear_tTree_ctrl(pm);

	return tt;
}




/**
int set_xml_tag(tXML* pp, tXML* pt, char* name)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
		@Ō̃m[hɃ^ORs[D

		@pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂ
		  m[h͔rȂD
	
	Fpp   -- ΏۂXMLc[
		  pt   -- p^[
		  name -- pt̍Ō̃^OɑΉ^OɃRs[^OD

	߂lFTRUE : ݒ肷^Om[hDɐݒꂽǂ͕sD
			FALSE: ݒ肷^Om[hȂD
*/
int set_xml_tag(tXML* pp, tXML* pt, char* name)
{
	tXML* tt;

	if (pp==NULL || pt==NULL || name==NULL) return FALSE;

	tt = get_xml_tag(pp, pt);
	if (tt==NULL) return FALSE;
	
	copy_s2Buffer(name, &(tt->ldat.key));

	return TRUE;
}




/**
int set_xml_end_tag(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
	@@@Ō̃m[h pt̍Ō̃^O̒li܂ޑjRs[D

		@Cpt̍Ō̃m[hɊւĂ͔rȂ(Rs[p)D

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD
		  Rs[ŝ pt̍Ō̃m[ĥ݂łD

		@Rs[鑮 ldat.id, ldat.lv, ldat.sz, ldat.key, ldat.val, ldat.ptr, ldat.lst
		@ldat.val, ldat.ptr, ldat.lst ɂẮCptŒlݒ肳ĂȂ΁CusȂD
	
	Fpp -- ΏۂXMLc[
		  pt -- p^[

	߂lFTRUE : ݒ肷}Dɐݒꂽǂ͕sD
			FALSE: ݒ肷}ȂD
*/
int set_xml_end_tag(tXML* pp, tXML* pt)
{
	int	  ret;
	tXML* tt;
	tXML* pm;


	if (pp==NULL || pt==NULL) return FALSE;

	pm = pp;
	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return FALSE;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return FALSE;
	}

	tt = find_xml_end(pt);
	if (tt==NULL) return FALSE;
	tt->ctrl = TREE_NOCMP_COPY_NODE;		// ׂȂDŌɃRs[D

	while(pp->esis!=NULL) pp = pp->esis;
	ret = find_match_xml(pp, pt);
	if (ret) {
		copy_tTree_byctrl(pt);
		adjust_tTree_depth(pp);
	}

	clear_tTree_ctrl(pm);

	return ret;
}




/**
tXML*  get_xml_content(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
		  Ō̃^ÕRegւ̃|C^ԂD

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD

		  ԂĂ tXML*  free Ă͂ȂD

	Fpp -- Ώۂ̃c[
		  pt -- p^[

	߂lFpt̍Ō̃^O̎̃^OɑΉRegւ̃|C^DfreeĂ͂ȂD

	----------------------------------------------------------------
	F	pp						  pt
			A --> B --> M			  C --> M --> Y
			  --> C --> M --> X			   
						  --> Y	--> Z   
					--> N
		̏ꍇCZ ւ̃|C^ԂD
*/
tXML*  get_xml_content(tXML* pp, tXML* pt)
{
	int fnd;
	tXML* tt = NULL;
	tXML* pm;
	tXML* dm;

	if (pp==NULL || pt==NULL) return NULL;

	pm = pp;
	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	tt = find_xml_end(pt);
	if (tt==NULL) return NULL;
	dm = add_xml_content(tt, "DUMMY");
	dm->ctrl = TREE_NOCMP_NODE;

	while(pp->esis!=NULL) pp = pp->esis;

	fnd = find_match_xml(pp, pt);
	if (fnd) tt = dm->altp;
	else     tt = NULL;

	del_xml(&dm);
	clear_tTree_ctrl(pm);

	return tt;
}




/**
int set_xml_content(tXML* pp, tXML* pt, char* content)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
	@@@Ō̃^ÕReg contentŒuD

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD
	
	Fpp  -- ΏۂXMLc[
		  pt  -- p^[
		  val -- pt̍Ō̃^OɑΉ^OɃRs[^OlD

	߂lFTRUE : ݒ肷}Dɐݒꂽǂ͕sD
			FALSE: ݒ肷}ȂD
*/
int set_xml_content(tXML* pp, tXML* pt, char* content)
{
	tXML* tt;

	if (pp==NULL || pt==NULL || content==NULL) return FALSE;

	tt = get_xml_content(pp, pt);
	if (tt==NULL) return FALSE;
	
	copy_s2Buffer(content, &(tt->ldat.key));

	return TRUE;
}




/**
tList*  get_xml_attr(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
		  Ō̃m[h̃^OlԂD

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD

	Fpp -- Ώۂ̃c[
		  pt -- p^[

	߂lFpt̍Ō̃^OΉɂCpp̃^Ȏl

*/
tList*  get_xml_attr(tXML* pp, tXML* pt)
{
	tList* lp = NULL;
	tXML*  tt;

	if (pp==NULL || pt==NULL) return NULL;

	tt  = get_xml_tag(pp, pt);
	if (tt!=NULL) lp = tt->ldat.lst;	

	return lp;
}




/**
int   set_xml_attr(tXML* pp, tXML* pt, tList* at)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɍŏɈv}́C
	@@@Ō̃m[hɃ^ȎƂ at̒lRs[D

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD

	Fpp -- Ώۂ̃c[
		  pt -- p^[
		  at -- ݒ肷鑮̊i[ꂽXgDldat.keyɑCldat.valɑl("'t)

	߂lFTRUE : ݒ肷}Dɐݒuꂽǂ͕sD
			FALSE: ݒ肷}ȂD

*/
int   set_xml_attr(tXML* pp, tXML* pt, tList* at)
{
	tXML* tt;

	if (pp==NULL || pt==NULL || at==NULL) return FALSE;

	tt  = get_xml_tag(pp, pt);
	if (tt!=NULL) {
		del_all_tList(&(tt->ldat.lst));
		tt->ldat.lst = dup_tList(at);
	}
	else return FALSE;

	return TRUE;
}




/**
char*   get_first_tag_name(tXML* xml)

	@\FXMLc[̍ŏ̃^O̖OԂD

	Fxml -- XMLc[

	߂lFXMLc[̍ŏ̃^O̖ODfreeĂ͂ȂD

*/
char*   get_first_tag_name(tXML* xml)
{  
	char* tagname = NULL;
   
	if (xml==NULL) return NULL;
	tList* lp = xml;
	if (lp->ldat.id==XML_ANCHOR_TAG) lp = lp->next;
   
	while (lp!=NULL) {
		if (lp->ldat.id==XML_TAG_NAME) {
			if (lp->ldat.key.buf!=NULL) {
				tagname = (char*)lp->ldat.key.buf;
				break;
			}
		}
		lp = lp->ysis;
	}
	return tagname;
}




/**
int	  replace_xml_content(tXML* pp, tXML* pt, char* src, char* dst)


*/
int	  replace_xml_content(tXML* pp, tXML* pt, char* src, char* dst)
{
	tXML*  tt;
	Buffer tg;

	if (pp==NULL || pt==NULL || src==NULL || dst==NULL) return FALSE;

	tt = get_xml_content(pp, pt);
	if (tt==NULL) return FALSE;

	tg = replace_sBuffer_bystr(tt->ldat.key, src, dst);
	if (tg.buf==NULL) return FALSE;

	free_Buffer(&(tt->ldat.key));
	tt->ldat.key = tg;
	
	return TRUE;
}




/**
tXML*  find_match_xml_end_tag(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCpt̍Ō̃^OɑΉ 
		  pp̃m[hւ̃|C^ԂDm[h ^OCReĝǂłD

	Fpp -- ΏۂXML
		  pt -- p^[̕D

	߂lFstr̍Ō̃m[hɑΉ pp̃m[hD

*/
tXML*  find_match_xml_end_tag(tXML* pp, tXML* pt)
{
	int    ret;
	tXML*  tt = NULL;
	tXML*  pm;

	if (pp==NULL || pt==NULL) return NULL;

	pm  = pp;
	ret = find_match_tTree(pp, pt);
	if (ret) {
		tt = find_xml_end(pt);
		if (tt!=NULL) {
			tt = tt->altp;
		}
	}

	clear_tTree_ctrl(pm);

	return tt;
}






////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
	tXML*  	get_xml_tag(tXML* pp, tXML* pt)
	tXML*  	set_xml_tag(tXML* pp, tXML* pt, char* val)
	int 	set_xml_end_tag(tXML* pp, tXML* pt)

	tXML*  	get_xml_content(tXML* pp, tXML* pt)
	int 	set_xml_content(tXML* pp, tXML* pt, char* val)
	tList*  get_xml_attr(tXML* pp, tXML* pt)
	int   	set_xml_attr(tXML* pp, tXML* pt, tList* at)

	int	  	replace_xml_content(tXML*pp, tXML* pt, char* src, char* dst)

	 _bystr o[W
*/

tXML*  get_xml_tag_bystr(tXML* pp, char* str)
{
	tXML* tx;
	tXML* tt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	tt = get_xml_tag(pp, tx);
	del_xml(&tx);

	return tt;
}



int  set_xml_tag_bystr(tXML* pp, char* str, char* val)
{
	tXML*  tx;
	int	rt;

	if (pp==NULL || str==NULL || val==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_tag(pp, tx, val);
	del_xml(&tx);

	return rt;
}



int  set_xml_end_tag_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	int	rt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_end_tag(pp, tx);
	del_xml(&tx);

	return rt;
}



tXML*  get_xml_content_bystr(tXML* pp, char* str)
{
	tXML* tx;
	tXML* tt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	tt = get_xml_content(pp, tx);
	del_xml(&tx);

	return tt;
}




int  set_xml_content_bystr(tXML* pp, char* str, char* val)
{
	tXML*  tx;
	int	rt;

	if (pp==NULL || str==NULL || val==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_content(pp, tx, val);
	del_xml(&tx);

	return rt;
}




tList*  get_xml_attr_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	tList* tt;

	if (pp==NULL || str==NULL) return FALSE;

	tx = xml_parse(str);
	tt = get_xml_attr(pp, tx);
	del_xml(&tx);

	return tt;
}



int  set_xml_attr_bystr(tXML* pp, char* str, tList* at)
{
	tXML* tx;
	int   rt;

	if (pp==NULL || str==NULL || at==NULL) return FALSE;

	tx = xml_parse(str);
	rt = set_xml_attr(pp, tx, at);
	del_xml(&tx);

	return rt;
}



int	  replace_xml_content_bystr(tXML*pp, char* str, char* src, char* dst)
{
	tXML* tx;
	int   rt;

	if (pp==NULL || src==NULL || src==NULL || dst==NULL) return FALSE;

	tx = xml_parse(str);
	rt = replace_xml_content(pp, tx, src, dst);
	del_xml(&tx);

	return rt;
}







////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
tList*  get_xml_tag_list(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɈv}́CŌ̃m[hւ
		  |C^XgɊi[ĕԂD|C^̓Xg altpɊi[D

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD

	Fpp -- Ώۂ̃c[
		  pt -- p^[

	߂lFYm[hւ̃|C^(altp)܂񂾃Xgւ̃|C^
*/
tList*  get_xml_tag_list(tXML* pp, tXML* pt)
{
	tList* lp;

	if (pp==NULL || pt==NULL) return NULL;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	lp = find_match_xml_endlist(pp, pt);

	return lp;
}




/**
tList*  get_xml_content_list(tXML* pp, tXML* pt)

	@\FXMLc[ pp XMLc[ ptƓp^[̎}TCptɈv}́CŌ̃^O
		  Regւ̃|C^XgɊi[ĕԂD|C^̓Xg altpɊi[D

		  pt ̒ ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ƂȂĂm[h
		  rȂD̃m[h͕KvD

	Fpp -- Ώۂ̃c[
		  pt -- p^[

	߂lFYm[hւ̃|C^(altp)܂񂾃Xgւ̃|C^

*/
tList*  get_xml_content_list(tXML* pp, tXML* pt)
{
	tList* lp;
	tList* dm;

	if (pp==NULL || pt==NULL) return NULL;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return NULL;
	}
	if (pt->ldat.id==XML_ANCHOR_TAG) {
		if (pt->next!=NULL) pt = pt->next;
		else return NULL;
	}

	dm = find_xml_end(pt);
	if (dm==NULL) return NULL;
	dm = add_xml_content(dm, "DUMMY");
	dm->ctrl = TREE_NOCMP_NODE;

	lp = find_match_xml_endlist(pp, pt);
	del_xml(&dm);

	return lp;
}




/**
int  set_xml_content_list(tXML* pp, tXML* pt, char* content)

	@\Fget_xml_content_list() ŌoReg, content ŒuD

	Fpp  -- ΏۂXMLc[
		  pt  -- p^[
		  content -- ̃^Ol  

	߂lFm[ȟ
*/
int  set_xml_content_list(tXML* pp, tXML* pt, char* content)
{
	int    num = 0;
	tList* lt;
	tList* lp;

	if (pp==NULL  || pt==NULL || content==NULL)  return 0;

	lp = lt = get_xml_content_list(pp, pt);
	if (lt==NULL) return 0;

	while (lt!=NULL) {
		if (lt->altp!=NULL) {
			copy_s2Buffer(content, &(lt->altp->ldat.key));
			num++;
		}
		lt = lt->next;
	}
	del_tList(&lp);

	return num;
}





/**
tList*  get_xml_tag_list_bystr(tXML* pp, char* str)


*/
tList*  get_xml_tag_list_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	tList* tt;

	if (pp==NULL || str==NULL) return NULL;

	tx = xml_parse(str);
	tt = get_xml_tag_list(pp, tx);
	del_xml(&tx);

	return tt;
}





/**
tList*  get_xml_conetnt_list_bystr(tXML* pp, char* str)


*/
tList*  get_xml_content_list_bystr(tXML* pp, char* str)
{
	tXML*  tx;
	tList* tt;

	if (pp==NULL || str==NULL) return NULL;

	tx = xml_parse(str);
	tt = get_xml_content_list(pp, tx);
	del_xml(&tx);

	return tt;
}




/**
int  set_xml_content_list_bystr(tXML* pp, tXML* pt, char* content)


*/
int  set_xml_content_list_bystr(tXML* pp, char* str, char* content)
{
	tXML* tx;
	int   rt;

	if (pp==NULL  || str==NULL || content==NULL) return 0;

	tx = xml_parse(str);
	rt = set_xml_content_list(pp, tx, content);
	del_xml(&tx);

	return rt;
}








////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
tXML*  dup_merge_xml(tXML* pp, tXML* tp)

	@\FXMLc[ pp̒XMLc[ tp𕡐D

	Fpp -- ꂽc[̃gbvƂȂm[h
		  tp -- c[

	߂lFꂽ XMLc[ւ̃|C^D
			pp NULLłȂꍇ pp
			pp NULL̏ꍇ́Ctp𕡐c[̃gbvD

*/
tXML*  dup_merge_xml(tXML* pp, tXML* tp)
{
	tXML* pt;

	if (tp==NULL) return pp;

	if (tp->ldat.id==XML_ANCHOR_TAG) {
		if (tp->next!=NULL) tp = tp->next;
		else return pp;
	}

	pp = dup_merge_tTree(pp, tp);

	if (pp->ldat.id!=XML_ANCHOR_TAG) {
		pt = new_tTree_node();
		pt->ldat.id = XML_ANCHOR_TAG;
		pt->depth = 0;
		add_tTree(pt, pp);
		close_xml(pt);
		return pt;
	}

	return pp;
}






/**
tXML*  del_xml(tXML** pp) 

	@\Fw肵m[hȉXMLc[폜D

	F*pp -- 폜c[̐擪m[h

	߂lF폜XMLc[̐em[hւ̃|C^D
*/
tXML*  del_xml(tXML** pp)
{
	tXML* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	// qm[h̍폜
	if ((*pp)->next!=NULL) del_sisters_children_xml(&((*pp)->next));

	// g̍폜
	pt = (*pp)->prev;
	if (pt!=NULL) {
		if (pt->next==*pp) pt->next = (*pp)->ysis;
		if (pt->back==*pp) pt->back = (*pp)->esis;
		pt->num--;
	}
	if ((*pp)->ysis!=NULL) (*pp)->ysis->esis = (*pp)->esis;
	if ((*pp)->esis!=NULL) (*pp)->esis->ysis = (*pp)->ysis;

	free_tListdata(&((*pp)->ldat));
	free(*pp);
	*pp = NULL;

	return pt;
}  



/**
tXML*  del_sister_xml(tXML** pp) 

	@\Fw肵m[hȉXMLc[폜D

	F*pp -- 폜c[̐擪m[h

	߂lF폜XMLc[̐em[hւ̃|C^D
*/
tXML*  del_sister_xml(tXML** pp)
{
	tXML* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	pt = (*pp)->prev;
	if (pt!=NULL) {
		pt->next = NULL;
		pt->back = NULL;
		pt->num  = 0;
	}

	del_sisters_children_xml(pp);

	return pt;
}  




/**
tXML*  del_sisters_children_xml(tXML** pp) 
   
	@\Fw肵m[h̎oXMLc[CqXMLc[폜D
		  w肵XMLm[h폜D
   
	F*pp -- 폜XMLc[̋N_m[h
   
	߂lF폜c[S̐em[hւ̃|C^D
   
	jċApDem[hɑ΂鏈͍sȂ̂ŁCʓrĂяoōsƁD

*/
tXML*  del_sisters_children_xml(tXML** pp)
{  
	tXML* pm;
	tXML* pt;
   
	if (pp!=NULL || *pp==NULL) return NULL;
	pt = (*pp)->prev;
   
	pm = *pp;
	while (pm->esis!=NULL) pm = pm->esis;
	while (pm!=NULL) {
		tXML* pw = pm;
		if (pm->next!=NULL) del_sisters_children_xml(&(pm->next));
		pm = pm->ysis;

		free_tListdata(&(pw->ldat));
		free(pw);
	}
   
	*pp = NULL;

	return pt;
}





/**
void  del_all_xml(tXML** pp)
   
	@\: XMLc[̑Sm[h̍폜D|C^ pp̃m[h܂XMLc[Ŝ폜D
		  pp ̓c[ł΁CǂwĂĂǂD
   
	: *pp -- 폜Jnm[hւ̃|C^D
				 c[ł΁CǂwĂĂǂD
   
	߂l: ȂD
*/
void  del_all_xml(tXML** pp)
{  
	tXML* pm;

	if (pp==NULL || *pp==NULL) return;
   
	pm = *pp;
	while (pm->prev!=NULL) pm = pm->prev;
	del_xml(&pm);

	*pp = NULL;
	return;
}








///////////////////////////////////////////////////////////////////////////////////////////////
//
// Inverse Parse
//

/**
Buffer  xml_inverse_parse(tXML* pp, int mode)

	@\FppɊi[ꂽ XMLf[^̏ɖ߂ BufferɊi[Dxml_parse() ̋tD

	Fpp   -- XMLf[^̊i[ꂽc[ւ̃|C^
		@mode -- XML֖߂̏
					XML_ONELINE_FORMAT: sȂ̈sɂD
					XML_CRLF_FORMAT   : ^ȌI CR(0x0d), LF(0x0a)ŉsD
					XML_INDENT_FORMAT : 擪ɃCfg(TAB)C^OƂɉs CR LF (0x0d,0x0a)D

		  XML_CRLF_FORMAT, XML_INDENT_FORMAT Ń^Olꍇ́Cl͂ރ^O͉sȂD

	߂lFϊXMLf[^i[ BufferϐD
*/
Buffer  xml_inverse_parse(tXML* pp, int mode)
{
	int cnt;
	Buffer buf;

	buf = init_Buffer();
	if (pp==NULL) return buf;
	if (pp->ldat.id==XML_ANCHOR_TAG) pp = pp->next;
	if (pp==NULL) return buf;

	cnt = count_tTree(pp);
	buf = make_Buffer(cnt*LPASS);
	if (buf.buf==NULL) return buf;

	while (pp->esis!=NULL) pp = pp->esis;
	xml_to_Buffer(pp, &buf, mode, pp->depth);

	return buf;
}






/**
void   xml_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)

	@\Fxml_inverse_parse()p̕⏕֐D
@@@@@ppɊi[ꂽ XMLf[^̏ɖ߂ BufferɊi[D

	Fpp   -- XMLf[^̊i[ꂽc[ւ̃|C^
		  buf  -- ϊXMLf[^i[ BufferϐD
		@mode -- XML֖߂̏
					XML_ONELINE_FORMAT: sȂ̈sɂD
					XML_CRLF_FORMAT   : ^ȌI CR(0x0d), LF(0x0a)ŉsD
					XML_INDENT_FORMAT : 擪ɃCfg(TAB)C^OƂɉsD
		  indent -- Cfgtn߂[Dmode XML_INDENT_MODE ̂Ƃ̂ݗLD
*/
void   xml_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)
{
	do {
		xml_opentag_to_Buffer(pp, buf, mode, indent);
		if (pp->next!=NULL) xml_to_Buffer(pp->next, buf, mode, indent);
		xml_closetag_to_Buffer(pp, buf, mode, indent);
		
		pp = pp->ysis;
	} while(pp!=NULL);

	return;
}






/**
void   xml_opentag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)

	@\Fc[XML̃I[v^Õf[^̏ɖ߂ BufferɊi[D

	Fpp   -- XMLf[^̊i[ꂽc[̃m[hւ̃|C^
		  buf  -- ϊXMLf[^i[ BufferϐD
		@mode -- XML֖߂̏
						XML_ONELINE_FORMAT: sȂ̈sɂD
						XML_CRLF_FORMAT   : ^ȌI CR(0x0d), LF(0x0a)ŉsD
						XML_INDENT_FORMAT : 擪ɃCfg(TAB)C^OƂɉsD
		  indent -- Cfgtn߂[Dmode XML_INDENT_MODE ̂Ƃ̂ݗLD

*/
void   xml_opentag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)
{
	int i;


	// Name TAG
	if (pp->ldat.id==XML_TAG_NAME) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<", buf);
		cat_Buffer(&(pp->ldat.key), buf);
		if (pp->ldat.lst!=NULL) {
			xml_attr_to_Buffer(pp->ldat.lst, buf);
		}
		if (pp->next==NULL) {
			if (pp->state==XML_TAG_EMPTY) cat_s2Buffer(" />", buf);
			else {
				cat_s2Buffer("></", buf);
				cat_Buffer(&(pp->ldat.key), buf);
				cat_s2Buffer(">", buf);
			}
		}
		else {
			cat_s2Buffer(">", buf);
		}

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) {
			if (pp->ldat.lv!=1 || pp->num!=1) cat_s2Buffer("\r\n", buf);
		}
	}
	

	// Content
	else if (pp->ldat.id==XML_TAG_CONTENT) {
		if (mode==XML_INDENT_FORMAT) {
			if (pp->prev!=NULL && (pp->prev->ldat.lv!=1 || pp->prev->num!=1)) {
				char* tabs = (char*)malloc(pp->depth-indent+1);
				if (tabs!=NULL) {
					for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
					tabs[pp->depth-indent] = '\0';
					cat_s2Buffer(tabs, buf);
					free(tabs);
				}
				//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
			}
		}

		cat_Buffer(&(pp->ldat.key), buf);

		//if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) {
			if (pp->prev!=NULL && (pp->prev->ldat.lv!=1 || pp->prev->num!=1)) cat_s2Buffer("\r\n", buf);
		}
	}


	// xml TAG
	else if (pp->ldat.id==XML_DOC_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<?", buf);
		if (pp->ldat.key.buf!=NULL) {
			cat_Buffer(&(pp->ldat.key), buf);
		}
		if (pp->ldat.lst!=NULL) {
			xml_attr_to_Buffer(pp->ldat.lst, buf);
		}
		cat_s2Buffer("?>", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	// Comment TAG
	else if (pp->ldat.id==XML_COMMENT_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<!--", buf);
		if (pp->ldat.val.buf!=NULL) {
			cat_Buffer(&(pp->ldat.val), buf);
		}
		cat_s2Buffer("-->", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	// Data TAG
	else if (pp->ldat.id==XML_DATA_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<!", buf);
		if (pp->ldat.val.buf!=NULL) {
			cat_Buffer(&(pp->ldat.val), buf);
		}
		cat_s2Buffer(">", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	// Processing TAG
	else if (pp->ldat.id==XML_PROCESS_TAG) {
		if (mode==XML_INDENT_FORMAT) {
			char* tabs = (char*)malloc(pp->depth-indent+1);
			if (tabs!=NULL) {
				for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
				tabs[pp->depth-indent] = '\0';
				cat_s2Buffer(tabs, buf);
				free(tabs);
			}
			//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
		}

		cat_s2Buffer("<?", buf);
		if (pp->ldat.key.buf!=NULL) {
			cat_Buffer(&(pp->ldat.key), buf);
		}
		if (pp->ldat.lst!=NULL) {
			xml_attr_to_Buffer(pp->ldat.lst, buf);
		}
		cat_s2Buffer(" ?>", buf);

		if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
	}


	return;
}





/**
void   xml_closetag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)

	@\Fc[XML̃N[Y^Õf[^̏ɖ߂ BufferɊi[D

	Fpp   -- XMLf[^̊i[ꂽc[̃m[hւ̃|C^
		  buf  -- ϊXMLf[^i[ BufferϐD
		@mode -- XML֖߂̏
					XML_ONELINE_FORMAT: sȂ̈sɂD
					XML_CRLF_FORMAT   : ^ȌI CR(0x0d), LF(0x0a)ŉsD
					XML_INDENT_FORMAT : 擪ɃCfg(TAB)C^OƂɉsD
		  indent -- Cfgtn߂[Dmode XML_INDENT_MODE ̂Ƃ̂ݗLD

*/
void   xml_closetag_to_Buffer(tXML* pp, Buffer* buf, int mode, int indent)
{
	int i;

	if (pp->ldat.id==XML_TAG_NAME) {
		if (pp->next!=NULL) {
			if (mode==XML_INDENT_FORMAT) {
				if (pp->ldat.lv!=1 || pp->num!=1) {
					char* tabs = (char*)malloc(pp->depth-indent+1);
					if (tabs!=NULL) {
						for (i=indent; i<pp->depth; i++) tabs[i-indent] = '\t';
						tabs[pp->depth-indent] = '\0';
						cat_s2Buffer(tabs, buf);
						free(tabs);
					}
					//for (i=indent; i<pp->depth; i++) cat_s2Buffer("\t", buf);
				}
			}

			cat_s2Buffer("</", buf);
			cat_Buffer(&(pp->ldat.key), buf);
			cat_s2Buffer(">", buf);

			if (mode==XML_INDENT_FORMAT || mode==XML_CRLF_FORMAT) cat_s2Buffer("\r\n", buf);
		}
	}

	return;
}





/**
void   xml_attr_to_Buffer(tList* pp, Buffer* buf)

	@\FXgɕۑꂽ^ȎeLXg֖߂D

	Fpp  -- f[^i[ꂽXgւ̃|C^D
		  buf -- ϊf[^i[ BufferϐD

*/
void   xml_attr_to_Buffer(tList* pp, Buffer* buf)
{
	while (pp!=NULL) {
		cat_s2Buffer(" ", buf);
		cat_Buffer(&(pp->ldat.key), buf);

		if (pp->ldat.val.buf!=NULL) {
			cat_s2Buffer("=", buf);
			cat_Buffer(&(pp->ldat.val), buf);
		}
		pp = pp->next;
	}
}







/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Search Function for XML
//         tTree p̊֐Ƃقړ
//

/**
int  find_match_xml(tXML* pp, tXML* pt)

	@\Fc[ pp c[ ptƓp^[̎}TC 
		  p^[̒Tł L[l݂̂rCm[hl͔rȂD
		  Cpt->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
	
		  c[p^[ꍇCtr̊em[h altpɂ́CԍŏɌΉ pp̊em[h
		  ̃|C^i[D

	check_match_xml() Ƃ̈ႢD
		check_match_xml() łׂ͔}̊Jnm[hppɌŒ肳D
		find_match_xml()  ppړȂ猟łD

	Fpp -- Ώۂ̃c[
		  pt -- p^[̃c[

	߂lFTRUE:  pp ptc[p^[݂D
		  		   pt̊em[h altpɂ́CԍŏɌΉ pp̊em[hւ̃|C^i[D
			FALSE: ppɓc[p^[͖D̏ꍇCptaltp̒l͕sƂȂD
*/
int  find_match_xml(tXML* pp, tXML* pt)
{
	int   ret;
	tXML* pm;

	pm = pp;
	while(pp!=NULL) {
		ret = check_match_xml(pp, pt);
		if (ret) return TRUE;

		if (pp->next!=NULL) {
			ret = find_match_xml(pp->next, pt);
			if (ret) {
				clear_tTree_ctrl(pm);
				return TRUE;
			}
		}
		pp = pp->ysis;
	}

	return FALSE;
}




/**
tXML*  find_match_xml_endlist(tXML* pp, tXML* pt)

	@\Fc[ pp c[ ptƓp^[̎}SĒTāC̎}̍Ō̃m[hւ̏XgɂĕԂD
		@Ym[hւ̃|C^ ԂꂽeXgaltp ێĂD 

		  rł L[l݂̂rCm[hl͔rȂD
		  ܂Cpt->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
	
	Fpp -- Ώۂ̃c[
		  pt -- p^[̃c[

	߂lFYm[hւ̃|C^ێ郊XgD

*/
tXML*  find_match_xml_endlist(tXML* pp, tXML* pt)
{
	tXML*  te;
	tList* lp;

	te = find_xml_end(pt);
	while(pp->esis!=NULL) pp = pp->esis;

	lp = find_match_xml_endlist_rcsv(pp, pt, te);
	if (lp!=NULL) clear_tTree_ctrl(pp);
	
	return lp;
}




/**
tList*  find_match_xml_endlist_rcsv(tXML* pp, tXML* pt, tXML* te)

	@\Ffind_match_xml_endlist() ̕⏕֐

*/
tList*  find_match_xml_endlist_rcsv(tXML* pp, tXML* pt, tXML* te)
{
	tList* lt = NULL;
	tList* lp = NULL;
					
	while(pp!=NULL) {			 
		int ret = check_match_xml(pp, pt);
		if (ret && te->altp!=NULL) {
			tList* lm = new_tList_node();
			lm->altp = te->altp;  
			lt = insert_tList(lt, lm);
			if (lp==NULL) lp = lt;
			te->altp = NULL;
		}  
							
		if (pp->next!=NULL) {	 
			tList* lm = find_match_xml_endlist_rcsv(pp->next, pt, te);
			if (lm!=NULL) {	   
				lt = insert_tList(lt, lm);
				if (lp==NULL) lp = lt;
				clear_tTree_ctrl(pp->next);
			}
		}
								   
		if (!ret) pp = pp->ysis;	// ꍇ͂xDȂꍇ֎ցD
	}

	return lp;
}




/**
int  check_match_xml(tXML* tp, tXML* tr)

	@\FXMLc[ tp XMLc[ trƓǂD

		  tp ̃gbv tr ̃gbv̓L[lvĂKvDvĂȂ΁Cp^[͖ƂD
		  Ctr->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D

		  x tp̎}̍Ō̃m[hɑ΂Ă ctrl TREE_ALREADY_FOUND_NODE ݒ肷̂ŁCă`FbN
		@ꍇȂǂ ctrl NAKvD

		  c[p^[ꍇCtr̊em[h altpɂ́CԍŏɌ
		  Ή tp̊em[hւ̃|C^i[D

	Ftp -- Ώۂ̃c[
		  tr -- p^[̃c[

	߂lFTRUE:  tp trƓc[p^[݂D
		  		   tr̊em[h altpɂ́CԍŏɌΉ tp̊em[hւ̃|C^i[D
			FALSE: tpɓc[p^[͖D̏ꍇCtr altp̒l͕sƂȂD

*/
int  check_match_xml(tXML* tp, tXML* tr)
{
	int   ret;
	tXML* te;
	tXML* ts;

	tXML* tt;
	tXML* ta;
	tXML* tb;


	if (tp==NULL || tr==NULL) return FALSE;

	te = find_tList_end(tr);

	ts = tp;
	while (ts!=NULL) {
		tt = cmp_sisters_xml(ts, tr);		// ̊Kw trƑSĈvĂ镔邩mF
		if (tt==NULL) return FALSE;			// vĂȂ΁CFALSE
		
		ta  = tt;							// ׂc[
		tb  = tr;							// ׂp^[
		ret = TRUE;
		while (tb!=NULL && ret) {
			if (tb->next==NULL) ret = TRUE;
			// ->ta, ->tb->tx: FALSE
			else if (tb->next!=NULL && ta->next==NULL) ret = FALSE;
			// ->ta->xa, ->tb->xb: xaxb`FbN
			else ret = check_match_xml(ta->next, tb->next);

			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (ret) {
			if (tr==te) tt->ctrl = TREE_ALREADY_FOUND_NODE;
			return TRUE;
		}

		ts = tt->ysis;
	}

	return FALSE;
}




/**
tXML*  cmp_sisters_xml(tXML* tp, tXML* tr)

	@\FXMLm[h tp̎om[h tr̎om[hƓ XML^O܂̓Regł邩rD
		  Ctr->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
		  ܂ tp->ctrl  TREE_ALREADY_FOUND_NODE ̏ꍇ́CɈvȂD

		  m[hp^[ꍇCtr̊em[h altpɂ͑Ή tp̊em[hւ̃|C^i[D
		  ܂ tp̊em[h ctrlɂ TREE_ALREADY_FOUND_NODE ݒ肳D

	Ftp -- ׂom[h̒m[h
		  tr -- Tom[hp^[̒m[h

	߂lFtp trƓp^[n܂m[hւ̃|C^D
		  	tr̊em[h altpɂ͑Ή tp̊em[hւ̃|C^i[D
			NULL: tpɓop^[͖D

	----------------------------------------------------------------
	F	tp						tr
			--> A (1)				--> A 		A, B, X  L[l(ldat.key.buf)
			--> B (2)				--> X
			--> A (3)
			--> X (4)
			--> A (5)
			--> X (6)

		̏ꍇCcmp_sisters_xml(tp, tr)  (3)ւ̃|C^ԂD܂ tr Am[h
		 altp ɂ (3) ւ̃|C^Ctr Xm[haltpɂ(4)ւ̃|C^i[
		DŏɌp^[̂ݕ]D

*/
tXML*  cmp_sisters_xml(tXML* tp, tXML* tr)
{
	tXML* ta;
	tXML* tb = NULL;
	tXML* ts;

	ts = tp;
	while (ts!=NULL){
		ta = ts;
		tb = tr;
		while (ta!=NULL && tb!=NULL) {
			// vȂꍇ break
			if (ta->ctrl==TREE_ALREADY_FOUND_NODE) break;
			if (tb->ctrl!=TREE_NOCMP_NODE && tb->ctrl!=TREE_NOCMP_COPY_NODE) {
				if ((ta->ldat).key.buf!=NULL && (tb->ldat).key.buf!=NULL) {
					if (ta->ldat.id!=tb->ldat.id || strcmp((char*)((ta->ldat).key.buf), (char*)((tb->ldat).key.buf))) break;
				}
				else break;
			}

			// ta  tb ͈v
			tb->altp = ta;
			ta = ta->ysis;
			tb = tb->ysis;
		}

		// ts  tr ͊SɈv
		if (tb==NULL) return ts;

		ts = ts->ysis;
	}

	return NULL;
}










//////////////////////////////////////////////////////////////////////////////////////
//
// Simple Tag Functions  (Pȍ\̃^Ȏ)
//

/**
Buffer  get_tag_content(tXML* tp, char* name, int no)

	@\Ftp XMLf[^ noԖڂ̃^O <tag_name>tag_content</tag_name> tag_content̃Rs[𓾂D
		  ^ÕRegꍇ́Cŏ̃Reĝ݂ԂD

*/
Buffer  get_tag_content(tXML* tp, char* name, int no)
{
	Buffer content;
	tXML*  tt;
	
	content = init_Buffer();
	if (tp==NULL || name==NULL) return content;

	if (no<=0) no = 1;
	tt = strncmp_tTree(tp, name, 0, no);
	if (tt!=NULL) {
		if (tt->next!=NULL) {
			tt = tt->next;
			while (tt!=NULL && tt->ldat.id!=XML_TAG_CONTENT) tt = tt->ysis;
			if (tt==NULL) return content;
			content = dup_Buffer(tt->ldat.key);
		}
	}

	return content;
}




/**
int   get_tag_integer(tXML* tp, char* name, int no)

	@\FtpXMLf[^ noԖڂ̃^O <tag_name>tag_content()</tag_name>  tag_content()𓾂D

*/
int   get_tag_integer(tXML* tp, char* name, int no)
{
	int	   ret;
	Buffer content;

	content = get_tag_content(tp, name, no);

	if (content.buf==NULL) ret = 0;
	else				   ret = atoi((const char*)content.buf);
	free_Buffer(&content);

	return  ret;
}




/**
int   return_exist_tag(tXML* tp, char* name, int no, Buffer* content)

	@\Fbuf̒ ^O <name>content</name> ݂邩ǂ`FbND
		  ݂ꍇ͂̃^ÕReg̃Rs[ content Ɋi[CTRUE ԂD

*/
int   return_exist_tag(tXML* tp, char* name, int no, Buffer* content) 
{
	Buffer buf;
	
	buf = get_tag_content(tp, name, no);
	if (buf.buf==NULL) return FALSE;

	if (content!=NULL) *content = buf;
	return TRUE;
}





/**
int  replace_all_tag_integer(tXML* tp, char* name, int src, int dst)

	@\FXMLc[ pp ^O namełSẴ^ÕRegijCsrc dstɏD
			
	Ftp   -- uΏۂ̃c[
		  name -- us^Õ^O
		  src  -- uΏۂ̃^ÕRegij
		  dst  -- ũ^ÕRegij
	
	߂lFum[h̐
*/
int  replace_all_tag_integer(tXML* tp, char* name, int src, int dst)
{
	int  n;
	char nums[20], numd[20];

	snprintf(nums, 10, "%d", src);
	snprintf(numd, 10, "%d", dst);

	n = replace_all_tag_contents(tp, name, nums, numd);

	return n;
}





/**
int	 replace_all_tag_contents(tXML* pp, char* name, char* src, char* dst)

	@\FXMLc[ pp ^O namełSẴ^ÕRegCsrc dstɏD
		  ̃^Oɕ̃RegꍇɂΉD
			
	Ftp   -- uΏۂ̃c[
		  name -- us^Õ^ODNULL̏ꍇ͑SĂ̕D
		  src  -- uΏۂ̃^ÕRegïꕔłjD NULL ̏ꍇ͑SĂ̕
		  dst  -- ũ^ÕReg
	
	߂lFu^O̐

*/
int	 replace_all_tag_contents(tXML* pp, char* name, char* src, char* dst)
{
	int  n;

	if (pp==NULL || dst==NULL) return 0;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return 0;
	}
	while(pp->esis!=NULL) pp = pp->esis;

	n = replace_all_tag_contents_rcsv(pp, name, src, dst);

	return n;
}





/**
int	 replace_all_tag_contents_rcsv(tXML* pp, char* name, char* src, char* dst)

	@\Freplace_all_tag_content() ̕⏕֐

*/
int	 replace_all_tag_contents_rcsv(tXML* pp, char* name, char* src, char* dst)
{
	int  n = 0;

	while(pp!=NULL) {
		if (pp->ldat.key.buf!=NULL && pp->ldat.id==XML_TAG_NAME && pp->ldat.lv>0) {
			if (name==NULL || !strcmp(name, (const char*)(pp->ldat.key.buf))) {
				tXML* tt = pp->next;

				// ̃Reg
				while (tt!=NULL) {
					if (tt->ldat.id==XML_TAG_CONTENT) {
						if (src==NULL) {
							copy_s2Buffer(dst, &(tt->ldat.key));
							n++;
						}
						else if (tt->ldat.key.buf!=NULL && strstr((const char*)tt->ldat.key.buf, src)!=NULL) {
							Buffer buf = replace_sBuffer_bystr(tt->ldat.key, src, dst);
							free_Buffer(&(tt->ldat.key));
							tt->ldat.key = buf;
							n++;
						}
					}
					tt = tt->ysis;
				}
			}
		}

		if (pp->next!=NULL) n += replace_all_tag_contents_rcsv(pp->next, name, src, dst);

		pp = pp->ysis;
	}

	return n;
}





/**
int	 replace_all_tag_byid(tXML* pp, char* src, char* dst, int id)

	@\FXMLc[ pp ^O̎ʂ idłSẴ^O̓e src dstɏD
			
	Ftp   -- uΏۂ̃c[
		  src  -- uΏۂ̃^ÕRegïꕔłjD NULL ̏ꍇ͑SĂ̕
		  dst  -- ũ^ÕReg
		  id   -- uΏۂ̃m[hIDDid<0 ȂSẴm[h
	
	߂lFu^O̐

*/
int	 replace_all_tag_byid(tXML* pp, char* src, char* dst, int id)
{
	int  n;

	if (pp==NULL || dst==NULL) return 0;

	if (pp->ldat.id==XML_ANCHOR_TAG) {
		if (pp->next!=NULL) pp = pp->next;
		else return 0;
	}
	while(pp->esis!=NULL) pp = pp->esis;

	n = replace_all_tag_byid_rcsv(pp, src, dst, id);

	return n;
}





/**
int	 replace_all_tag_byid_rcsv(tXML* pp, char* src, char* dst, int id)

	@\Freplace_all_tag_byid() ̕⏕֐

*/
int	 replace_all_tag_byid_rcsv(tXML* pp, char* src, char* dst, int id)
{
	int  n = 0;

	while(pp!=NULL) {
		if (id<0 || pp->ldat.id==id) {
			if (src==NULL) {
				copy_s2Buffer(dst, &(pp->ldat.key));
				n++;
			}
			else if (pp->ldat.key.buf!=NULL && strstr((const char*)pp->ldat.key.buf, src)!=NULL) {
				Buffer buf = replace_sBuffer_bystr(pp->ldat.key, src, dst);
				free_Buffer(&(pp->ldat.key));
				pp->ldat.key = buf;	
				n++;
			}
		}

		if (pp->next!=NULL) n += replace_all_tag_byid_rcsv(pp->next, src, dst, id);

		pp = pp->ysis;
	}

	return n;
}






