/* vi: set tabstop=4 nocindent paste: */

#ifndef  __JBXL_TOOLS_HEADER_
#define  __JBXL_TOOLS_HEADER_


/**
ėpc[wb_  tools.h

  ˑ֌W
	  #include "common.h"

 */



#include "common.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <ctype.h>


#ifdef WIN32
	#include <winsock2.h>		// for ntohl, ntohs, htonl, htons
	#ifndef HAVE_TIME_H
		#define  HAVE_TIME_H
	#endif
#else
	#include <unistd.h>	
#endif


#ifdef HAVE_ARPA_INET_H
	#include <arpa/inet.h>
#endif

#ifdef TIME_WITH_SYS_TIME
	#include <time.h>
	#include <sys/time.h>
#else
	#ifdef HAVE_TIME_H 
		#include <time.h>
	#endif 
	#ifdef HAVE_SYS_TIME_H 
		#include <sys/time.h>
	#endif 
#endif

#ifdef HAVE_SYS_PARAM_H 
	#include <sys/param.h>
#endif

#ifdef HAVE_SYSLOG_H
	#include <syslog.h>
#endif

#ifdef HAVE_WAIT_H 
	#include <wait.h>
#endif
#ifdef HAVE_SYS_WAIT_H 
	#include <sys/wait.h>
#endif

#ifdef HAVE_SYS_ERRNO_H 
	#include <sys/errno.h>
#else
	#include <errno.h>
#endif
#include <signal.h>



/**
}N

  CR   s				^M  0x0d
  LF   CtB[h  	^J  0x0a
  TAB  ^u				^I  0x09			
 */
#define  CR	 	0x0d		// s 
#define  LF	 	0x0a		// CtB[h 
#define  TAB	0x09		// ^u 

#define  US	 	0
#define  EUC	1			//  
#define  SJIS   2			//  
#define  UTF8   3			//  


#define UNKNOWN_ENDIAN 0
#ifndef LITTLE_ENDIAN
	#define  LITTLE_ENDIAN  1234
	#define  BIG_ENDIAN 	4321
	#define  PDP_ENDIAN 	3412
#endif



/**
oCg^ Oobt@

*/
typedef  struct _ringbuffer {
	unsigned char* buf;
	int   bufsz;			// obt@̃TCY
	int   spoint;			// obt@f[^̊Jn_
	int   epoint;			// obt@f[^̏I_+1 (f[^̒ǉ_)
	int   npoint;			// ̃bZ[W̃X^[g|Cg
	int   datasz;			// ۑĂf[^̑Ŝ̒
	int   datano;			// i[Ăf[^̐
	int   state;			// Oobt@̏
} ringbuffer;


#define  mstream   ringbuffer	// oCg^ bZ[WXg[




/**
ϐ

  int DebugMode;  ON ̏ꍇ fobN[hł邱ƂDftHgOFFD
  int KanjiCode;  pR[hDUS, SJIS, EDUDftHg USD

 */
extern int   DebugMode; 
extern int   KanjiCode;
extern int   UnitTestMode;

extern char  LocalIPNum[4];

extern int	 HostEndian;


#define  LOCAL_IPADDR  "127.0.0.1"



// not C++
#ifndef CPLUSPLUS
	int  isNull(void* p);
	#define freeNull(p)     {if(!isNull(p)) free(p); (p)=NULL;}
#endif




/**/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// ij
char*   get_line(char* str, int n);					// str̃obt@ nsڂoDsR[h͍폜Dvfree
char*   awk (char* str, char cc, int n);			// cc؂LƂ, str̃obt@ nԖڂ̍ڂԂDvfree
char*   cawk(char* str, char cc, int n);			// Acc؂LƂ, str̃obt@ nԖڂ̍ڂԂDvfree

char*   cut_str(char* buf, int ls, int le);			// buf[ls]`buf[le] ؂oDv free
char*   dup_str(char* buf);							// 𕡐Dv free
char*	skip_char(char* mesg, const char* check);	// check[]̉ꂩ̕܂Ń|C^XLbvD " ' ͊SXLbv
char*  	pack_char(char* mesg, char cc);				// 񒆋yсC擪cc()CIcc()CCR, LF 폜Dv free
char*  	pack_head_tail_char(char* mesg, char cc);	// ̐擪cc()CTAB, CR, LFDIcc()CTAB, CR, LF 폜Dv free
char*  	change_esc(char* mesg);						// 񒆂 CR, LF  \r, \n ɕϊDv free
char*   chomp(char* str);							// ŏ̉sR[hȍ~𖳌ɂD
char*   double_bs(char* fn);						// 񒆂 \  \\ɒuԂDv free
char*   numbering_name(char* fmt, int n);			// tH[}bg fmtɏ]āCn܂ޕoDv free

char*	ltostr(long int n);							// long int 𕶎ɕϊDfree ͕sv	
char*	ultostr(unsigned long int n);				// unsigned long int 𕶎ɕϊDfree ͕sv	
char*	ftostr(float n);							// float 𕶎ɕϊDfree ͕sv	

int 	hexstr2i(const char* str);					// 16i̕𐮐ɕϊD

void	swap_byte(void* p, int s, int b);			// s̒p̃oCgboCgɋtɂD
short   swaps(short p);								// 16bit ̏㉺8bitւD
int	 	swapl(int   p);								// 32bit p8bitÂtɂ
void	reverse_str(uByte* p, int s);				// oCg(octet)tɂD
void	upper_string(char* str);
//void	int_swap(int* p, int* s);					// f[^ւD
#define int_swap(p, s) 	{int swap=(p); (p)=(s); (s)=swap;}



// r
int  	bincmp(unsigned char* b1, unsigned char* b2, int n);		// oCif[^ n Byteׂ
int	 	strnrvscmp(const char* s1, const char* s2, int n);			//  s1 s2납 nrD
int	 	strncaservscmp(const char* s1, const char* s2, int n);		//  s1 s2납 nrD
char*   strstrcase(const char* buf, const char* nd);				//  buf̒ɕ nd邩ǂ`FbND啶͋ʂȂD

int	 	ex_strncmp(const char* s1, const char* s2, int n);			//  s1s2grD
int	 	ex_strncasecmp(const char* s1, const char* s2, int n);	  	//  s1s2grD
int	 	ex_strnrvscmp(const char* s1, const char* s2, int n);		//  s1s2납grD
int	 	ex_strncaservscmp(const char* s1, const char* s2, int n);	//  s1s2납grD


// GfBA  (}N isBigEndian ntohs() gṕj
int 	is_little_endian(void);
int 	is_big_endian(void);
void 	check_endian(void);

double 	double_from_little_endian(void* ptr);
float 	float_from_little_endian(void* ptr);
int  	int_from_little_endian(void* ptr);
short 	short_from_little_endian(void* ptr);
double 	double_from_big_endian(void* ptr);
float 	float_from_big_endian(void* ptr);
int  	int_from_big_endian(void* ptr);
short 	short_from_big_endian(void* ptr);


// 
char*   get_local_time(void);


// o
void	print_escape(char* format, char* mesg);			// GXP[v܂ރbZ[W̏óistderrj
void	fdump(FILE* fp, unsigned char* mesg, int n);	// 16i_vfo
void	print_16x(FILE* fp, unsigned char* mesg, int n);// 16i_vfoiPsj


// R[h
void	kanji_convert(unsigned char* mesg);				// ϐ KnjiCodeɏ]ĊR[hϊD
void	kanji_convert_euc2sjis(unsigned char* mesg);	// EUCSJISɕϊD
void	kanji_convert_sjis2euc(unsigned char* mesg);	// SJISEUCɕϊD
void	euc2sjis(unsigned char *c1, unsigned char *c2);	// EUC  -> SJIS
void	sjis2euc(unsigned char *c1, unsigned char *c2);	// SJIS -> EUC


// t@C
int		file_from_to(char* s, char* d, char* mode);		// modeɏ],t@C s dɃRs[D
int		fp_from_to(FILE* s, FILE* d, long int sz);		// t@C s dɃRs[D
char*   get_file_name(char* str);						// tpXt@Cւ̃|C^oD
unsigned long file_size(char* fn);						// t@C̑傫ԂD
int	 	file_exist(char* fn);							// t@C݂̑D
FILE* 	file_chmod_open(char* fn, char* fm, mode_t mode);
char*   temp_filename(const char*, int);

unsigned char* 	read_file (char* fname, unsigned long int* size);
long int  		write_file(char* fname, unsigned char* buf, unsigned long int size);



// 
void	init_rand(void);								// /dev/urandom f[^ŗ̌n
char*   randstr(int n);									// _ A-Za-z0-9 ܂ł̕ nD
unsigned char* randbit(int n);							// _ n bit̃oCi𐶐D
#define random_str(n)   temp_filename(NULL, (n))


// Base64
unsigned char*  encode_base64(unsigned char* str, int  sz);
unsigned char*  decode_base64(unsigned char* str, int* sz);
unsigned char*  encode_urlenc(unsigned char* str, int  sz);
unsigned char*  decode_urlenc(unsigned char* str, int* sz);
unsigned char*  encode_quoted_printable(unsigned char* str, int  sz);
unsigned char*  decode_quoted_printable(unsigned char* str, int* sz);
unsigned char*  encode_hex(unsigned char cc);
unsigned char	decode_hex(unsigned char c1, unsigned char c2);


// oCg^Oobt@[
ringbuffer* 	new_ringbuffer(void);
ringbuffer  	init_ringbuffer(void);
ringbuffer  	make_ringbuffer(int sz);
void  			del_ringbuffer  (ringbuffer** pp);
void  			free_ringbuffer (ringbuffer* pp);
void  			clear_ringbuffer(ringbuffer* pp);
int   			put_ringbuffer(ringbuffer* rb, unsigned char* pp, int sz);
unsigned char* 	get_ringbuffer(ringbuffer* rb, int sz);

#define  char_ringbuffer(b, n)		(b).buf[((n)%((b).bufsz))]


// bZ[WXg[
int   			put_mstream(mstream* sb, unsigned char* pp);
unsigned char* 	get_mstream(mstream* sb);
unsigned char* 	fgets_mstream(unsigned char* mesg, mstream* sb);

#define  init_mstream()		init_ringbuffer()
#define  new_mstream()		new_ringbuffer()
#define  make_mstream(s)  	make_ringbuffer((s))
#define  free_mstream(s)  	free_ringbuffer((s))
#define  del_mstream(s)   	del_ringbuffer((s))
#define  clear_mstream(s) 	clear_ringbuffer((s))


// UUID
unsigned char*  uuid2guid(unsigned char* p);
unsigned char*  guid2uuid(unsigned char* p);


#ifndef WIN32
// vZX
void  	set_sigterm_child(void (*handler)(int));
void  	sigterm_child(int signal);

void  	ignore_sigterm_child(void);

void	set_sigsegv_handler(void (*handler)(int));
void	trap_segmentation_falt(int signal);

#define  set_sigseg_handler(h)    set_sigsegv_handler((h))

#endif


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// for Windows

#ifdef WIN32

//void  bzero(char* p, unsigned int n);
//void  bcopy(char* f, char* t, unsigned int n);

#endif   // WIN32



/**/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// }N֐
//

/**
	copy_file(src, dst)	 src dsփt@CRs[D
	cat_file (src, dst)	 src dstփt@C catD
*/
#define copy_file(src, dst)  file_from_to((src), (dst), "wb");
#define cat_file(src, dst)   file_from_to((src), (dst), "ab");



//#define  isBigEndian	((sWord)1==htons((sWord)1))
//#define  isLittleEndian ((sWord)1!=htons((sWord)1))

#define  isBigEndian	(is_big_endian())
#define  isLittleEndian (is_little_endian())


/**
  ntoh_st(p, s)   network` host`ցD\pɑ΂ soCgÂϊD
  hton_st(p, s)   host` network`ցD\pɑ΂ soCgÂϊD
  ntoh_ar(p, s)   network` host`ցDsoCg̔zpɑ΂ĕϊD
  hton_ar(p, s)   host` network`ցDsoCg̔zpɑ΂ĕϊD
  ntoh_data(p, s, c) network` host`. soCg̃f[^p ɑ΂ coCgÂϊD
  hton_data(p, s, c) host` network`. soCg̃f[^p ɑ΂ coCgÂϊD
 */
#define  ntoh_st(p, s) {if (!isBigEndian) swap_byte((void*)(p), sizeof(*(p)), (s));}
#define  hton_st(p, s) {if (!isBigEndian) swap_byte((void*)(p), sizeof(*(p)), (s));}
#define  ntoh_ar(p, s) {if (!isBigEndian) swap_byte((void*)(p), (s), sizeof(*(p)));}
#define  hton_ar(p, s) {if (!isBigEndian) swap_byte((void*)(p), (s), sizeof(*(p)));}

#define  ntoh_data(p, s, c) {if (!isBigEndian) swap_byte((void*)(p), (s), (c));}
#define  hton_data(p, s, c) {if (!isBigEndian) swap_byte((void*)(p), (s), (c));}



/////////////////////////////////////////////////////////////////////////////////////
// for Debug

/**
G[bZ[W֐
	DEBUG_MESG, DEBUG_ESCP:
    	-DEBUG IvVŃRpCꂽɏo͂D
		ÓIɐ䂷ꍇɎgpD܂쐬̃fobOŎgpꍇɎgpCiłł͍폜\D
*/

void	print_message(char*, ...);					// obt@OȂ̃bZ[Wóistderrj
void	fprint_message(FILE*, char*, ...);			// obt@OȂ̃bZ[Wo

#define   print_mesg  print_message
#define  fprint_mesg fprint_message


#ifdef _DEBUG
	#ifndef EBUG
		#define EBUG
	#endif
#endif


#ifdef EBUG
	#define DEBUG_MESG  print_message
	#define DEBUG_ESCP  print_escape
	#ifndef _DEBUG
		#define _DEBUG
	#endif
#else
	#define DEBUG_MESG(f, ...)  {}
	#define DEBUG_ESCP(f, ...)  {}
#endif


#define  DEBUG_MODE  if(DebugMode==ON)


#endif

