#ifndef  DISABLE_OPENNI


#ifndef  __JBXL_CPP_OPENNI_DEV_H_
#define  __JBXL_CPP_OPENNI_DEV_H_




#include  <XnCppWrapper.h>
#include  <XnUSB.h>

#include  "common++.h"
#include  "buffer.h"

//#include  "NiTool.h"




//#define   OPENNI_XGA_MODE

#ifdef  OPENNI_XGA_MODE
	#define OPENNI_DEPTH_XSIZE  XN_XGA_X_RES
	#define OPENNI_DEPTH_YSIZE  XN_XGA_Y_RES
	#define OPENNI_DEPTH_FPS    15
#else
	#define OPENNI_DEPTH_XSIZE  XN_VGA_X_RES
	#define OPENNI_DEPTH_YSIZE  XN_VGA_Y_RES
	#define OPENNI_DEPTH_FPS    30
#endif





//
namespace jbxl {





class  COpenNiDevice
{
public:
	COpenNiDevice(void);
	~COpenNiDevice(void) { free();}

	BOOL	m_has_camera;
	Buffer  m_err_mesg;


public:
	BOOL	init(BOOL use_image);
	BOOL	init(char* fname, BOOL use_image);
	void	free(void);

	// Generators
	BOOL	create_Context(char* fname=NULL);
	BOOL	create_Image (BOOL easy=FALSE);
	BOOL	create_Depth (BOOL easy=FALSE);
	BOOL	create_User  (BOOL easy=FALSE);
	BOOL	create_Player(BOOL easy=FALSE);

	void	delete_Context(void);
	void	delete_Image(void);
	void	delete_Depth(void);
	void	delete_User(void);
	void	delete_Player(void);


public:
	XnMapOutputMode			outputMode;

	xn::Context*			context;	
	xn::ImageGenerator*		image;
	xn::DepthGenerator*		depth;
	xn::UserGenerator*		user;
	xn::Player*				player;

	xn::ImageMetaData*		imageMD;
	xn::DepthMetaData*		depthMD;
	xn::SceneMetaData*		sceneMD;	// for User

	//uByte*				imageData;
	//XnLabel*				depthData;
};


}		// namespace


#endif
#endif

