#pragma once


#ifndef  DISABLE_KINECT_SDK


#include  <NuiApi.h>

#include  "ExClass.h"
#include  "KinectDevice.h"

#include  "NiToolWin.h"
#include  "Rotation.h"
#include  "RingBuffer.h"



//
namespace jbxwl {




class  CKinectWin
{
public:
	CKinectWin(void);
	~CKinectWin(void) { free();}

	CKinectDevice*	device;

	CString	m_err_mesg;

	int		m_scale;
	BOOL	m_is_detected;
	BOOL	m_is_tracking;
	BOOL	m_is_mirroring;
	BOOL	m_use_image;
	BOOL	m_use_led;
	BOOL	m_use_motor;
	BOOL	m_enable_motor;

	BOOL	m_use_knct_smth;

	NUI_TRANSFORM_SMOOTH_PARAMETERS smoothParam;

	float	m_confidence;
	double	m_ground_level;


public:
	ExCmnHead*	pViewData;
	BOOL	hasDepthData;


public:
	BOOL	init(void);
	void	free(void);
	void	deleteDevice(void);

	CString	get_err_message(void) { return m_err_mesg;}


public:
	//
	void	clearJointsData(void);
	void	clearAvatarDetected(void);
	BOOL	checkAvatarDetected(void);

	BOOL	openUSBDevice(void)   { return TRUE;}
	void    closeUSBDevice(void)  {}
	void	setLEDColor(int col)  {}	// { if (m_use_led) set_LEDColor(col);}
	void	setTiltMotor(int ang);

	void	setMirroring(BOOL mirror);
	int		getDevState(void) { if (device==NULL) return NI_STATE_DETECT_STOPPED; else return device->m_state;}

	BOOL	startDetection(void);
	BOOL	stopDetection(void);

	int		getTrackingUser(void)   { if (device!=NULL) return device->get_TrackingUser(); else return 0;}
	void	setTrackingSearch(void) { if (device!=NULL) device->set_TrackingSearch();}

	void	makeDisplayImage(void);
	BOOL	trackingJoints(void);

	void	getJointsPosData(void);
	void	getJointsRotData(void) {}

	void	set2DCoordinate(void);
	void	drawSkeleton(int col);
	void    drawJointConnection(int j1, int j2, int col);

	BOOL	initRingBuffer(void);
	void	freeRingBuffer(void);
	void	clearRingBuffer(void);
	void	backup2RingBuffer(void);

	Vector4	jointPositionData(int joint);


public:
	virtual void saveJointsData(void) {}
	virtual void logingJointsData(void) {}
	
	virtual void checkBoneLength(void) {}
	virtual void checkGroundLevel(void) {}
	virtual void convertJointsData(void) {}			// for over ride

	virtual void lostTrackingUser(int uid) {}
	virtual void detectTrackingUser(int uid) {}


protected:
	void	setDevState(int state) { if (device!=NULL) device->m_state = state;}


public:
	// Data
	Vector<double>	startPos;

	Vector<double>	posVect[KINECT_MAX_JOINT_NUM];
	Quaternion		rotQuat[KINECT_MAX_JOINT_NUM];
	Vector<int>		crdVect[KINECT_MAX_JOINT_NUM];	// for 2D Image

	CRingBuffer		posRing[KINECT_MAX_JOINT_NUM];
	CRingBuffer		rotRing[KINECT_MAX_JOINT_NUM];
};





}		// namespace







#endif
