#pragma once


#include  "tools++.h"

#include  "Vector.h"
#include  "Rotation.h"

#include  "WinTools.h"
#include  "NiToolWin.h"
#include  "NiJointsTool.h"

#include  "NiJointsTool.h"
#include  "BVHTool.h"
#include  "VMDTool.h"





//
namespace jbxwl {

using namespace jbxl;




class  CNiFileTool
{
public:
	CNiFileTool(void)		   { clear_data();}
	CNiFileTool(NiSDK_Lib lib) { clear_data(); init(lib);}

	~CNiFileTool(void);


private:
	NiSDK_Lib		m_lib;
	BOOL			m_enable_wfile;				// ꎞt@Cɏ݉\
	FILE*			m_wfp;
	FILE*  			m_rfp;


protected:
	void			clear_data(void);
	void			init(NiSDK_Lib lib);

	BOOL			open_wfile(LPCTSTR fname);
	BOOL			open_rfile(LPCTSTR fname);
	void			close_wfile(void);
	void			close_rfile(void);


public:
	// Frame Data
	int				frame_start;
	int				frame_ptr;
	int				frame_num;

	NiFrameData*	frame_data;
	
	int				frame_timer;
	unsigned short	lap_timer;
	float			play_time;
	float			time_scale;


public:
	CJTextTool*		JTXT_Tool;
	CVMDTool*		VMD_Tool;
	CBVHTool*		BVH_Tool;


public:
	CBaseFrameTool* frameTool;

	// Joints Text
	void			writeJointsText(Vector<double>* pos, Quaternion* rot, BOOL mirror);
	int				readJointsTextFile(LPCTSTR fname);
	BOOL			saveAsJointsText(LPCTSTR fname, LPCTSTR backup);

	// BVH
	int				readBVHFile(LPCTSTR fname);
	BOOL			saveAsBVH(LPCTSTR fname, LPCTSTR backup);

	// VMD
	int				readVMDFile(LPCTSTR fname);


public:
	// Frame Data
	void			clearFrameData(void);

	BOOL			startFrame(int start=0);
	BOOL			nextFrame(BOOL next=TRUE);
	void			setFrame(int frame);
	BOOL			resetFrame(void) { return startFrame();}


public:
	// Joints
	void			clearStartPosition(void) { start_pos.init(1.0);}
	void			clearJointsData(void);

	void			getFrameData(BOOL mirror, int frame=-1);


	Vector<double>	start_pos;

	Vector<double>	posVect[NI_JOINT_NUM];
	Quaternion		rotQuat[NI_JOINT_NUM];

};






}		// namespace

