#pragma once



#ifndef  DISABLE_OPENNI



#include  "OpenNiTool.h"
#include  "NiToolWin.h"

#include  "ExView.h"
#include  "Rotation.h"
#include  "RingBuffer.h"



//
namespace jbxwl {




class  COpenNiWin : public COpenNiTool
{
public:
	COpenNiWin(void);
	~COpenNiWin(void) { free();}

	CString	m_err_mesg;

	int		m_scale;
	BOOL	m_is_tracking;
	BOOL	m_is_detected;
	BOOL	m_is_mirroring;
	BOOL	m_use_image;
	BOOL	m_use_led;
	BOOL	m_use_motor;
	BOOL	m_enable_motor;

	BOOL	m_use_nite_smth;

	int		m_profile;
	float	m_confidence;
	float	m_nite_smooth;
	double	m_ground_level;


public:
	ExCmnHead*	pViewData;
	BOOL		hasDepthData;


public:
	BOOL	init(void);
	void	free(void);

	CString	get_err_message(void);


public:
	//
	void	deleteDevice(void) { delete_Device();}
	void	clearJointsData(void);
	void	clearAvatarDetected(void);
	BOOL	checkAvatarDetected(void);

	BOOL	startDetection(BOOL force_pose);
	BOOL	stopDetection(void);

	BOOL	openUSBDevice(void)   { return open_USB_Device();}
	void    closeUSBDevice(void)  { close_USB_Device();}
	void	setLEDColor(int col)  { if (m_use_led) set_LED_Color(col);}
	void	setTiltMotor(int ang);
	void	setMirroring(BOOL mirror);

	int     getDevState(void) { return m_state;}

	void	makeDisplayImage(void);
	BOOL	trackingJoints(BOOL use_rot_data);

	void	getJointsPosData(int uid);
	void	getJointsRotData(int uid);

	int 	getTrackingUser(void)   { return get_TrackingUser();}
	void	setTrackingSearch(void) { set_TrackingSearch();}

	void    set2DCoordinate(void);
	void	drawSkeleton(int col);
	void	drawJointConnection(int j1, int j2, int col);

	BOOL	initRingBuffer(void);
	void	freeRingBuffer(void);
	void	clearRingBuffer(void);
	void	backup2RingBuffer(void);


public:
	virtual void saveJointsData(void) {}
	virtual void logingJointsData(void) {}

	virtual void checkBoneLength(void) {}
	virtual void checkGroundLevel(void) {}
	virtual void convertJointsData(void) {}			// for over ride

	virtual void lostTrackingUser(int uid) {}
	virtual void detectTrackingUser(int uid) {}


protected:
	void    setDevState(int state) { m_state = state;}


public:
	// Data
	Vector<double>	startPos;

	Vector<double>	posVect[OPENNI_MAX_JOINT_NUM];
	Quaternion		rotQuat[OPENNI_MAX_JOINT_NUM];
	Vector<int>		crdVect[OPENNI_MAX_JOINT_NUM];	// for 2D Image

	CRingBuffer		posRing[OPENNI_MAX_JOINT_NUM];
	CRingBuffer		rotRing[OPENNI_MAX_JOINT_NUM];
};






}		// namespace




#endif