//
// ċA`\ȃvOXo[JE^
//

#include  "ProgressBarDLG.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


using namespace jbxwl;




//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CProgressBarDLG _CAO iċA`\ȃrWAvOXo[[JE^] for VC++j
//

CProgressBarDLG::CProgressBarDLG(LPCTSTR tn, BOOL edp, CWnd* pParent) 
		: CDialog(CProgressBarDLG::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProgressBarDLG)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂D
	//}}AFX_DATA_INIT

	Init();

	dialogID = CProgressBarDLG::IDD;
	pWnd     = pParent;
	progBar  = NULL;
	gmax     = PROGRESS_COUNTERMAX;
	title    = tn;
	enableDisPatcher = edp;
}





//
//
//
CProgressBarDLG::CProgressBarDLG(UINT nIDTemplate, LPCTSTR tn, BOOL edp, CWnd* pParent) 
		: CDialog(nIDTemplate, pParent)
{
	Init();

	dialogID = nIDTemplate;
	pWnd     = pParent;
	progBar  = NULL;
	gmax     = PROGRESS_COUNTERMAX;
	title    = tn;
	enableDisPatcher = edp;
}




// 
CProgressBarDLG::CProgressBarDLG(CProgressBarDLG* counter, LPCTSTR tn, BOOL edp)
{
	Init();

	parent = counter;
	title  = tn;
	enableDisPatcher = edp;
}



//
//
//
CProgressBarDLG::~CProgressBarDLG()
{
	if (child !=NULL) delete  child;		// qΐɎł炤D
	if (parent!=NULL) parent->child = NULL;	// eΉ؂D
	Stop();									// ~D
}




void CProgressBarDLG::Init()
{
	dialogID = 0;
	pWnd    = NULL;
	progBar = NULL;
	
	max    = 0;
	fill   = 0;
	pos    = 0;

	gmax   = 0;
	base   = 0;
	grate  = 1.0;
	lrate  = 1.0;
	prate  = 1.0;
	parent = NULL;
	child  = NULL;
	title  = _T("");
	enableDisPatcher = TRUE;
}





void  CProgressBarDLG::Clear()
{
	title  = _T("");
	base   = 0;
	grate  = 1.0;
	lrate  = 1.0;
	prate  = 1.0;

	max    = 0;
	fill   = 0;
	pos    = 0;

	if (child!=NULL) delete child;
	child = NULL;

	if (progBar!=NULL) progBar->SetPos(0);
}







BOOL  CProgressBarDLG::OnInitDialog()
{
	if (parent==NULL) {
		//RECT r;
		//r.left=10; r.top=10; r.right=300; r.bottom=30;
		//progBar->Create(WS_VISIBLE|WS_CHILD|WS_BORDER, r, this, IDD_PROGBAR);
		if (progBar==NULL) progBar = (CProgressCtrl*)GetDlgItem(IDC_PROGBAR_M);

	}
	return TRUE;
}






void CProgressBarDLG::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProgressBarDLG)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂D
	//}}AFX_DATA_MAP
}




BEGIN_MESSAGE_MAP(CProgressBarDLG, CDialog)
	//{{AFX_MSG_MAP(CProgressBarDLG)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()




//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CProgressBarDLG bZ[W nh

//
// JE^̖ڐ́u݈ʒuvu݈ʒu+mv̊Ԃ
// VJE^Ƃč蒼i`ChJE^jD
//
// ̋@\͊֐̒ŃJE^[JCY邽߂ɗpD
// [JCYꂽJE^́Cʏ̃JE^ƓlɎgpłD
//			  V`ChJE^CSetMax()ResetRate()
//			    ڐ̔䗦ς邱Ƃ\D
//
CVCounter* CProgressBarDLG::MakeChildCounter(int m)
{
	if (m<=0) return NULL;
	ResetRate(m, m);				// YԂ lrate 1.0ɖ߂D

	child = new CProgressBarDLG(this, (LPCTSTR)title, enableDisPatcher);
	child->SetMax(m);
	return (CVCounter*)child;
}




//
// `ChJE^Ƃ̎q
//
void  CProgressBarDLG::DeleteChildCounter()
{
	PutFill();
	if (child!=NULL) delete child;
	child = NULL;
}





//
// ݂̃ANeBuigp\jȃJE^iԉ̎qJE^j𓾂D
//
// ̋@\͊֐̃[JCYꂽJE^ŁCݗLȃJE^
// 邽߂̗pD
//
CVCounter* CProgressBarDLG::GetUsableCounter()
{
	if (child==NULL) return (CVCounter*)this;
	else  return child->GetUsableCounter();
}





//
// Progress Dialogɕ\łőlw肷D
//
void  CProgressBarDLG::SetMax(int num)
{
	if (num<=0)  return;

	if (gmax==0) gmax = num;
	grate = (float)gmax/(float)num;
	fill = max = num;
}





//
// Progress Dialog̊JnDWindow\D
// m ͖ڐ̍őlɂȂD
//
void  CProgressBarDLG::Start(int m, char* tn)
{
	cancel = false;

	if (parent==NULL) {
		this->Create(dialogID, pWnd);
		this->ShowWindow(SW_SHOW);

		if (tn!=NULL) title = mbs2ts(tn);
		if (!title.IsEmpty()) SetWindowText(title);
		start = true;

		if (progBar!=NULL) {
			progBar->SetPos(0);
			progBar->SetRange((short)0, (short)PROGRESS_COUNTERMAX);
			progBar->SetStep(1);
		}
	}
	SetMax(m);
}





//
// Progress Dialog̒~DWindowCϐD
//
void  CProgressBarDLG::Stop()
{
	max   = 0;
	pos   = 0;
	fill  = 0;
	base  = 0;
	grate = 1.0;
	lrate = 1.0;
	title = _T("");
	cancel = false;
	start  = false;

	if (parent==NULL) {
		DestroyWindow();
//		deleteNull(progBar);
	}
}





//
// _CAÕ^Cgݒ肷D
//
void  CProgressBarDLG::SetTitle(char* tn)
{
	if (tn!=NULL) title = mbs2ts(tn);

	if (parent!=NULL) {
		parent->SetTitle(tn);
	}
	else {
		if (start) SetWindowText(title);
	}
}





//
// Progress Dialog̖ڐCڕWl(fill)܂Ŗ߂D
// ftHgł͖ڕWl(fill) maxɂȂD܂i[JCYꂽj
// Sڐ𖄂߂D
// ResetRate()֐ĂԂƁCQڕWlfillƂȂD
//
void  CProgressBarDLG::PutFill()
{
	pos = fill;
	int mem = base + (int)(grate*lrate*pos + 0.5);

	if (parent!=NULL) {
		parent->SetPos(mem);
	}
	else {
		progBar->SetPos(mem);
	}

	if (enableDisPatcher) DisPatcher();
}





//
// Progress Dialog̖ڐ́u݈ʒuvu݈ʒu+rngv̊Ԃ
// num Ń}bviTCYjȂDnum͂̏Ԃł̖ڕWlfillƂȂD
// rng ͐, num͔񕉂łȂ΂ȂȂD
//
void  CProgressBarDLG::ResetRate(int rng, int num)
{
	if (rng<=0 || num<0) return;
	if (num==0) num = 1;

	base  = base + (int)(pos*lrate*grate + 0.5);
	lrate = (float)rng/(float)num;
	pos   = 0;
	fill  = num;
}




void  CProgressBarDLG::StepIt(int n)
{
	pos += n;
	int mem = base + (int)(grate*lrate*pos + 0.5);

	if (parent!=NULL) {
		parent->SetPos(mem);
	}
	else {
		progBar->SetPos(mem);
	}

	if (enableDisPatcher) DisPatcher();
}





void  CProgressBarDLG::SetPos(int num)
{
	if ((int)(lrate*num)>fill) return;

	pos = num;
	int mem = base + (int)(grate*lrate*pos + 0.5);

	if (parent!=NULL) {
		parent->SetPos(mem);
	}
	else {
		progBar->SetPos(mem);
	}

	if (enableDisPatcher) DisPatcher();
}







bool  CProgressBarDLG::isCanceled()
{
	if (parent==NULL) return cancel;
	else return parent->isCanceled();
}





//
// EBhEN[YꂽꍇD
//
BOOL CProgressBarDLG::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (wParam==IDCANCEL) cancel = true;

	return CDialog::OnCommand(wParam, lParam);
}
