#pragma once


#ifndef  DISABLE_KINECT_SDK


#include  <NuiApi.h>

#include  "ExClass.h"
#include  "buffer.h"
#include  "WinTools.h"

#include  "Vector.h"




/*
mode:
	NUI_INITIALIZE_FLAG_USES_COLOR					JC[W
	NUI_INITIALIZE_FLAG_USES_DEPTH					fvX
	NUI_INITIALIZE_FLAG_USES_DEPTH_AND_PLAYER_INDEX	fvXƃ[U[x
	NUI_INITIALIZE_FLAG_USES_SKELETON				XPg
*/



#define	  KINECT_MAX_JOINT_NUM	NUI_SKELETON_POSITION_COUNT		//  20
#define   KINECT_MAX_USERS_NUM	7
//#define   KINECT_MAX_USERS_NUM	NUI_SKELETON_COUNT (6)




//
namespace jbxwl {

	
//
// Image NX
//
class  CKinectImage : public EventHandler
{
public:
	CKinectImage(void);
	~CKinectImage(void) { free();}

public:
	HANDLE  m_stream;
	uByte*	m_data;
	int		m_data_len;

	int		m_xsize;
	int		m_ysize;
	int		m_fps;

public:
	void	free(void);
	void	make_data(void);
};



//
// Depth NX
//
class  CKinectDepth : public EventHandler
{
public:
	CKinectDepth(void);
	~CKinectDepth(void) { free();}

public:
	HANDLE  m_stream;
	uByte*	m_data;
	int		m_data_len;

	BOOL	has_map;
	int*	m_xmap_i2d;
	int*	m_ymap_i2d;
	int*	m_xmap_d2i;
	int*	m_ymap_d2i;
	int		m_map_len;

	int		m_xsize;
	int		m_ysize;
	int		m_fps;

	int		userLabel[KINECT_MAX_USERS_NUM];

public:
	void	free(void);
	void	make_data(void);
	void	make_map (void);

	int		get_user_index(int i, int j);
	uWord	get_depth(int i, int j);

	void	get_users(void);
	void	get_image_coord(int* i, int* j);
};



//
// Skeleton NX
//
class  CKinectSkeleton : public EventHandler
{
public:
	CKinectSkeleton(void);
	~CKinectSkeleton(void) { free();}

public:
	HANDLE  m_stream;
	NUI_SKELETON_DATA m_data;

public:
	void	free(void);
};






///////////////////////////////////////////////////////////////////////////////
//
// Device NX
//

class  CKinectDevice
{
public:
	CKinectDevice(void);
	~CKinectDevice(void) { free();}

	INuiSensor*		 context;	
	CKinectImage*	 image;
    CKinectDepth*	 depth;
	CKinectSkeleton* skeleton;
	
	NUI_IMAGE_FRAME		imageFrame;
	NUI_IMAGE_FRAME		depthFrame;
	NUI_SKELETON_FRAME  skltnFrame;

	int		m_count;
	int		m_state;
	CString	m_err_mesg;

	int		m_xsize;
	int		m_ysize;
	int		m_fps;

	int		tracking_start;
	int		tracking_user;
	
	//
	NUI_TRANSFORM_SMOOTH_PARAMETERS* smoothParam;

	//
	Vector4 jointPosData[KINECT_MAX_JOINT_NUM];


public:
	BOOL	init(DWORD mode, BOOL use_image);
	void	free(void);
	void	clear_JointsData(void);

	BOOL	create_Context(DWORD mode, int index=0);

	BOOL	create_Image(void);
	BOOL	create_Depth(void);
	BOOL	create_Skeleton(void);

	void	delete_Context(void);
	void	delete_Image(void);
	void	delete_Depth(void);
	void	delete_Skeleton(void);

	BOOL	wait_Image(DWORD msec=INFINITE);
	BOOL	wait_Depth(DWORD msec=INFINITE);
	BOOL	wait_Skeleton(DWORD msec=INFINITE);

	BOOL	start_Detection(void);
	BOOL	stop_Detection(void);

	int		get_TrackingUser(void);
	void	set_TrackingSearch(void);
};








///////////////////////////////////////////////////////////////////////////////
//
// CallBack
//

void  CALLBACK  KinectStatusProc(HRESULT hr, const OLECHAR* instanceName, const OLECHAR* deviceName);





}		// namespace




#endif
