#ifndef  DISABLE_OPENNI


#ifndef  __JBXL_CPP_OPENNI_TOOL_H_
#define  __JBXL_CPP_OPENNI_TOOL_H_




#include  "OpenNiDevice.h"
#include  "NiTool.h"



#define	  OPENNI_MAX_JOINT_NUM		25		// see <XnTypes.h>   24 + 1 
#define   OPENNI_MAX_USERS_NUM		6
#define   OPENNI_LEN_POSE_NAME		20
#define	  OPENNI_JOINT_CONFIDENCE	0.5



//
namespace jbxl {





class  COpenNiTool
{
public:
	COpenNiTool(void);
	~COpenNiTool(void) { free();}


	COpenNiDevice*	device;
	int			m_state;
	Buffer		m_err_mesg;

	int			tracking_user;
	int			tracking_start;


public:
	BOOL	init(BOOL use_camera);
	void	free(void);
	void	delete_Device(void);
	void	clear_JointsData(void);


	// Capabilities
	BOOL	make_Skeleton(BOOL force_pose, int profile, float smooth);
	void	clear_Skeleton(void);
	void	clear_Tracking(void);


	// Detection
	BOOL	start_Detection(BOOL force_pose, int profile, float smooth);
	BOOL	stop_Detection(void);

	int 	get_TrackingUser(void);
	void	set_TrackingSearch(void);


	// Call Back
	BOOL	setup_CallBacks(void);
	void	clear_CallBacks(void);

	BOOL	set_UserCallbacks(xn::UserGenerator::UserHandler newUser, xn::UserGenerator::UserHandler lostUser, void* cookie);
	BOOL	set_PoseCallbacks(xn::PoseDetectionCapability::PoseDetection detectPose, xn::PoseDetectionCapability::PoseDetection lostPose, void* cookie);
	BOOL	set_CalibCallbacks(xn::SkeletonCapability::CalibrationStart calibStart, xn::SkeletonCapability::CalibrationEnd calibEnd, void* cookie);

	void	unset_UserCallbacks(void);
	void	unset_PoseCallbacks(void);
	void	unset_CalibCallbacks(void);


	// Joints
	void		get_JointsPositionData(XnUserID nId);
	void		get_JointsRotationData(XnUserID nId);

	XnVector3D	jointPositionData(int joint);
	XnMatrix3X3	jointRotationData(int joint);
	float		jointPositionConfidence(int joint);
	float		jointRotationConfidence(int joint);


	// File
	BOOL	create_Recorder(char* file_name, BOOL use_image);
	void	delete_Recorder(void);

	BOOL	start_Recorde(char* file_name, BOOL use_image);
	void	stop_Recorde(void);


	// USB
	BOOL	open_USB_Device (void);
	void	close_USB_Device(void);
	void	set_LED_Color (int col);
	void	set_Tilt_Motor(int ang);


public:
	XnStatus				rc;
	xn::Recorder*			recorder;

	XnChar*					poseName;
	xn::PoseDetectionCapability* pose;
	xn::SkeletonCapability*	skeleton;

	XnCallbackHandle		userCallbacks;
	XnCallbackHandle		poseCallbacks;
	XnCallbackHandle		calibCallbacks;

	XnUserID				dUsers[OPENNI_MAX_USERS_NUM];
	XnUInt16				nUsers;

	// USB
	XN_USB_DEV_HANDLE		usb_dev;
	XnUSBConnectionString*	devPath;


protected:
	XnVector3D				jointPosData[OPENNI_MAX_JOINT_NUM];			// no data at [0]
	XnMatrix3X3				jointRotData[OPENNI_MAX_JOINT_NUM];			// no data at [0]
	XnConfidence			jointPosConfidence[OPENNI_MAX_JOINT_NUM];
	XnConfidence			jointRotConfidence[OPENNI_MAX_JOINT_NUM];
};





////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Callback Functions

void  XN_CALLBACK_TYPE userDetect(xn::UserGenerator& user, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE userLost  (xn::UserGenerator& user, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE poseDetect(xn::PoseDetectionCapability& pose, const XnChar* poseName, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE poseLost  (xn::PoseDetectionCapability& pose, const XnChar* poseName, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE calibStart(xn::SkeletonCapability& skeleton, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE calibEnd  (xn::SkeletonCapability& skeleton, XnUserID nId, XnBool success, void* cookie);




}		// namespace


#endif
#endif










////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Information

/*
XnTypes.h

typedef enum XnSkeletonJoint
{
	XN_SKEL_HEAD			= 1,
	XN_SKEL_NECK			= 2,
	XN_SKEL_TORSO			= 3,
	XN_SKEL_WAIST			= 4,

	XN_SKEL_LEFT_COLLAR		= 5,
	XN_SKEL_LEFT_SHOULDER	= 6,
	XN_SKEL_LEFT_ELBOW		= 7,
	XN_SKEL_LEFT_WRIST		= 8,
	XN_SKEL_LEFT_HAND		= 9,
	XN_SKEL_LEFT_FINGERTIP	=10,

	XN_SKEL_RIGHT_COLLAR	=11,
	XN_SKEL_RIGHT_SHOULDER	=12,
	XN_SKEL_RIGHT_ELBOW		=13,
	XN_SKEL_RIGHT_WRIST		=14,
	XN_SKEL_RIGHT_HAND		=15,
	XN_SKEL_RIGHT_FINGERTIP	=16,

	XN_SKEL_LEFT_HIP		=17,
	XN_SKEL_LEFT_KNEE		=18,
	XN_SKEL_LEFT_ANKLE		=19,
	XN_SKEL_LEFT_FOOT		=20,

	XN_SKEL_RIGHT_HIP		=21,
	XN_SKEL_RIGHT_KNEE		=22,
	XN_SKEL_RIGHT_ANKLE		=23,
	XN_SKEL_RIGHT_FOOT		=24	
} XnSkeletonJoint;
*/