/* vi: set tabstop=4 nocindent noautoindent: */

/**  
	IP Address Tool
		
				by Fumi Iseki '05 09/21
*/



#include "ipaddr_tool.h"




/**
tList*  read_ipaddr_file(char* fn)

	@\Ft@C IPAhXǂݍŁC[IPAhX]/[lbg}XN]@̌`
		  ϊāCXgɊi[DFQDNIPAhXɕϊ
		  FQDNłȂhCC / Ȍ𖳎ĕ̂܂܃XgɊi[D

		  f[^̓ǂݎ莞Ɏ̏sȂD
			Ő,CR,LF͍폜
			s͖D
			# ȍ~͖D

	Ffn  -- t@C

	߂lFXgւ̃|C^
*/
tList*  read_ipaddr_file(char* fn)
{
	tList* lp;
	tList* lt;

	lp = read_tList_file(fn, 2);
	if (lp==NULL) return NULL;

	lt = to_ipaddress_list(lp);
	del_all_tList(&lp);

	return lt;
}





/**
tList*  read_ipaddr_fp(FILE* fp)

	@\Ft@C IPAhXǂݍŁC[IPAhX]/[lbg}XN]@̌`
		  ϊāCXgɊi[DFQDNIPAhXɕϊ
		  FQDNłȂhCC / Ȍ𖳎ĕ̂܂܃XgɊi[D

		  f[^̓ǂݎ莞Ɏ̏sȂD
			Ő,CR,LF͍폜
			s͖D
			# Ŏn܂C܂ ()# Ŏn܂s͖D

	Ffp  -- t@C|C^

	߂lFXgւ̃|C^
*/
tList*  read_ipaddr_fp(FILE* fp)
{
	tList* lp;
	tList* lt;

	lp = read_tList_fp(fp, 1);
	if (lp==NULL) return NULL;

	lt = to_ipaddress_list(lp);
	del_all_tList(&lp);

	return lt;
}




/**
tList*  to_ipaddress_list(tList* lp)

	@\FXg IPAhX [IPAhX]/[lbg}XN]@̌`
		  ϊāCVXgɊi[DFQDNIPAhXɕϊ
		  ϊ to_address_num8() gpDCIDERΉD
		  FQDNłȂhCC / Ȍ𖳎ĕ̂܂
		  VXgɊi[D
		   is_host_in_list()ȂǂɍsȂ߂̑O

	FϊOit@CȂǂǂݍ񂾂܂܁j̃f[^̓Xg

	߂lFϊĐVXgD

*/
tList*  to_ipaddress_list(tList* lp)
{
	unsigned char* num;
	char*          addr;
	tList* ls = NULL;
	tList* lt = NULL;

	if (lp==NULL) return NULL;
	if (lp->ldat.key.buf==NULL) return NULL;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			if ((lp->ldat.key.buf)[0]!='#') {
				num = to_address_num8((char*)lp->ldat.key.buf, 1);
				if (num!=NULL) {
					addr = to_address_char8(num);
					free(num);
					if (addr!=NULL) {
						ls = add_tList_node_str(ls, addr, NULL);
						free(addr);
					}	//  addr==NULL ƂȂꍇ̓ŝ
				}
				else {
					addr = awk((char*)lp->ldat.key.buf, '/', 1);
					if (addr!=NULL) {
						int i = 0;
						while(addr[i]!='\0' && addr[i]!=',' && addr[i]!=' ') i++;
						addr[i] = '\0';
						ls = add_tList_node_str(ls, addr, NULL);
						free(addr);
					}
				}
				if (lt==NULL) lt = ls;
			}
		}
		lp = lp->next;
	}
	
	return lt;
}






/**
int  is_host_in_list(tList* lp, unsigned char* num, char* hname)

	@\FXglp L[Ɋi[Ă zXg num, hname lbg[Nɑ邩
		@ǂ`FbNDnum  hname ͂ǂ炩w肳ĂΏ\łD
		  悸Clp̃L[iFQDNj hname rD܂CL[hC̈ꕔ
		  ꍇ hnameƔrivjD
		@ɁClp̃L[hCłȂꍇiIPAhX̏ꍇj num ƔrD
	
	Flp    -- `FbNIPAhXij̊i[Ă郊XgD
		  num   -- rIPAhXi1byte unsigned ^j4Byte
			       8Byte^(addr/mask)ł쓮邪Clbg}XN͖D
		  hname -- rzXgijDʏ numtꂽ́D

	߂lFFALSE -- Xgɓlbg[NɑGg݂͑ȂD
			TRUE  -- Xgɓlbg[NɑGg݂D
*/
int  is_host_in_list(tList* lp, unsigned char* num, char* hname)
{
	unsigned char* addr;

	if (lp==NULL) return FALSE;
	if (lp->ldat.key.buf==NULL) return FALSE;
	if (hname==NULL && num==NULL) return FALSE;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 0);
			if (addr==NULL && hname!=NULL) {
				if (!strnrvscmp((const char*)lp->ldat.key.buf, hname, strlen((const char*)lp->ldat.key.buf))) return TRUE;
			}
			else if(addr!=NULL && num!=NULL) {
				if (is_same_network_num(addr, num, &(addr[4]))) return TRUE;
			}
		}
		lp = lp->next;
	}
	
	return FALSE;
}







/**
int  is_ipaddr_num_in_list(tList* lp, unsigned char* num)

	@\FXglp L[Ɋi[Ă zXg num lbg[Nɑ邩
		@ǂ`FbND
		  Xg̃L[FQDNłĂ`FbN\D
	
	Flp  -- `FbNIPAhXij̊i[Ă郊XgD
		  num -- rIPAhXi1byte unsigned ^j4Byte
			     8Byte^(addr/mask)ł쓮邪Clbg}XN͖D

	߂lFFALSE -- Xgɓlbg[NɑGg݂͑ȂD
			TRUE  -- Xgɓlbg[NɑGg݂D

*/
int  is_ipaddr_num_in_list(tList* lp, unsigned char* num)
{
	unsigned char* addr;

	if (lp==NULL || num==NULL) return FALSE;
	if (lp->ldat.key.buf==NULL) return FALSE;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 1);
			if (addr!=NULL) {
				if (is_same_network_num(num, addr, &(addr[4]))) return TRUE;
			}
		}
		lp = lp->next;
	}
	
	return FALSE;
}






/**
void  print_address_in_list(FILE* fp, tList* lp)

	@\FXg̃hCC܂IPAhX\D
		  FQDNIPAhXɕϊĕ\D

	FhC܂IPAhXL[Ɋi[Xgւ̃|C^

*/
void  print_address_in_list(FILE* fp, tList* lp)
{
	unsigned char* addr;

	while (lp!=NULL) {
		if (lp->ldat.key.buf!=NULL && strlen((const char*)lp->ldat.key.buf)>0) {
			addr = to_address_num8((char*)lp->ldat.key.buf, 1);
			if (addr!=NULL) {	
				fprintf(fp, "[%d.%d.%d.%d/%d.%d.%d.%d]\n", addr[0],addr[1],addr[2],addr[3],addr[4],addr[5],addr[6],addr[7]);
			}
			else { 		// 炭hC
				fprintf(fp, "[%s]\n", lp->ldat.key.buf);
			}
		}
		lp = lp->next;
	}
	return;
}





