/* vi: set tabstop=4 nocindent noautoindent: */

/**
	Protocol
					by Fumi Iseki 2005 10/10
								  2009 2/5
*/



#include "protocol.h"



#ifdef CPLUSPLUS
	using namespace jbxl;
#endif



//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Protocol Header
//

/**
tList*  get_protocol_header_list(Buffer buf, char deli, int fstline, int rcntnt)

	@\Fbuf vgRwb_ikey'deli' data ̌`j𕪉ăXgɊi[D'deli'͋ED
		  fstline TRUȄꍇCwb_̈sڂ HDLIST_FIRST_LINE_KEY ̃L[ăXgɊi[D

		  ܂C̊֐̓obt@OȂǂ͍sȂ̂ŁCwb_ɃRec̍ŏ̕ꍞމ\D
		  rcntnt TRUȄꍇ́CHDLIST_CONTENTS_KEY L[ɂăRecXgɊi[DFALSȄꍇ͖D
		  Rec̃TCY傫Cǂݍ܂ꍇCHDLIST_CONTENTS_KEYm[h͕D

		  wb_̒lsɂȂꍇCwb_ HDLIST_CONTINUE ƂāC̃m[hɊi[D

	Fbuf	  -- wb_i[ϐ
		  deli	  -- wb_̌o(Key)Ƃ̋EDHTTP SMTPł ':'
		  fstline -- sڂʈɂ邩H sڂ key'deli' data ̌`łȂvgRp, ex) HTTP, SIP
		  rcntnt  -- RecǂނH

	߂lFwb_i[Xgւ̃|C^D

*/
tList*  get_protocol_header_list(Buffer buf, char deli, int fstline, int rcntnt)
{
	tList* lp;

	if (buf.buf==NULL) return NULL;

	lp = get_protocol_header_list_seq(NULL, buf, deli, fstline, rcntnt);
	if (lp!=NULL) lp = find_tList_top(lp);

	return lp;
}





/**
Buffer  restore_protocol_header(tList* list, char* deli, int mode)

	@\F
		Xg listɕۑꂽf[^wb_f[^𕜌D
		mode==ON Ȃ listɕꍞłRec̓eĕԂD
		
		get_protocol_header_list() ̋tD

*/
Buffer  restore_protocol_header(tList* list, char* deli, int mode, int* hdsz)
{
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL) return buf;

	buf = make_Buffer(RECVBUFSZ);

	while(list!=NULL) {
		if (!strcmp((const char*)(list->ldat.key.buf), HDLIST_FIRST_LINE_KEY)) {
			copy_Buffer(&(list->ldat.val), &buf);
			cat_s2Buffer("\r\n", &buf);
		}
		else if (!strcmp((const char*)(list->ldat.key.buf), HDLIST_CONTINUE)) {
			buf.buf[buf.vldsz] = TAB;
			buf.vldsz++;
			cat_Buffer(&(list->ldat.val), &buf);
			cat_s2Buffer("\r\n", &buf);
		}
		else if (!strcmp((const char*)(list->ldat.key.buf), HDLIST_END_KEY)) {
			break;
		}
		else if (strcmp((const char*)(list->ldat.key.buf), HDLIST_CONTENTS_KEY)) {
			cat_Buffer(&(list->ldat.key), &buf);
			cat_s2Buffer(deli, &buf);
			cat_Buffer(&(list->ldat.val), &buf);
			cat_s2Buffer("\r\n", &buf);
		}

		list = list->next;
	}
	if (buf.vldsz>0) cat_s2Buffer("\r\n", &buf);

	if (hdsz!=NULL) *hdsz = buf.vldsz;

	if (mode==ON) {
		int nn = 1;
		tList* pl = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, nn);
		while (pl!=NULL && pl->ldat.val.buf!=NULL) {
			cat_Buffer(&(pl->ldat.val), &buf);
			pl = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, ++nn);
		}
	}

	return buf;
}





/**
Buffer  restore_protocol_contents(tList* list)

	@\F
		Xg listɕۑꂽf[^Rec𕜌D

*/
Buffer  restore_protocol_contents(tList* list)
{
	Buffer buf;
	tList* lp;
	int nn = 1;

	buf = make_Buffer(BUFSZ);

	lp = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, nn);
	while (lp!=NULL && lp->ldat.val.buf!=NULL) {
		cat_Buffer(&(lp->ldat.val), &buf);
		lp = strncmp_tList(list, HDLIST_CONTENTS_KEY, 0, ++nn);
	}

	return buf;
}





/**
void	set_protocol_contents(tList* list, Buffer contents)

	ӁFvgRɈˑ̂ŁCRecTCY̍ČvZ͍sȂD


*/
void	set_protocol_contents(tList* list, Buffer contents)
{
	while (list!=NULL) {
		if (list->ldat.key.buf!=NULL && !strcmp((char*)list->ldat.key.buf, HDLIST_CONTENTS_KEY)) {
			free_Buffer(&list->ldat.val);
			list->ldat.val = dup_Buffer(contents);

			while (is_header_continue(list)) del_tList_node(list->next);								
			break;
		}

		list = list->next;
	}

	return;
}






/**
tList*  get_protocol_header_list_seq(tList* lp, Buffer buf, char deli, int fstline, int rcntnt)

	@\Fbuf vgRwb_ikey'deli' data ̌`j𕪉ăXgɊi[D'deli'͋ED
		@V[PVɐĂяoƂ\D
		  lp==NULL ŏԁiÓIϐjZbĝŁCŏ lp NULLɂ邱ƁD

		  fstline TRUȄꍇCwb_̈sڂ HDLIST_FIRST_LINE_KEY ̃L[ăXgɊi[D

		  ܂C̊֐̓obt@OȂǂ͍sȂ̂ŁCwb_ɃRec̍ŏ̕ꍞމ\D
		  rcntnt TRUȄꍇ́CHDLIST_CONTENTS_KEY L[ɂăRecXgɊi[DFALSȄꍇ͖D
		  Rec̃TCY傫Cǂݍ܂ꍇCHDLIST_CONTENTS_KEYm[h͕D

		  wb_̒lsɂȂꍇCwb_ HDLIST_CONTINUE ƂāC̃m[hɊi[D

		  lp!=NULL ܂ fstlineFALSE ̏ꍇ͈sڂ͍̏sȂD

	Flp	  -- wb_i[郊Xgւ̃|C^D
					 NULL̏ꍇ̓XgV쐬DNULLłȂꍇ͂̃XgɃwb_񂪒ǉD
		  buf	 -- wb_i[ϐ
		  deli	-- wb_̌o(Key)Ƃ̋EDHTTP SMTPł ':'
		  fstline -- sڂʈɂ邩H sڂ key'deli' data ̌`łȂvgRp, ex) HTTP, SIP
		  rcntnt  -- RecǂނH

	߂lFԍŌɍ쐬Xgm[hւ̃|C^D
			Xg̃gbv𓾂ɂ find_tList_top(tList* pp) pD

	ϐFin_contents Recł邱Ƃ\D
		  crlfCount    CR,LF̐

*/
tList*  get_protocol_header_list_seq(tList* lp, Buffer buf, char deli, int fstline, int rcntnt)
{
	static int crlfCount  = 0;
	static int inContents = FALSE;
	int	i=0, n=0, size;
	Buffer key, data;


	if (buf.buf==NULL) return NULL;

	size = buf.vldsz;
	data = make_Buffer(size+1);
	key  = make_Buffer(LBUF);

	if (lp==NULL) {
		crlfCount  = 0;
		inContents = FALSE;
	}


	// FIRST LINE 
	if (fstline && lp==NULL) {
		while(buf.buf[i]!=0x0a && buf.buf[i]!='\0' && i<size && n<size) {
			data.buf[n++] = buf.buf[i++];
		}
		if (data.buf[n-1]==0x0d) {
			i--;
			n--;
		}

		data.buf[n] = '\0';
		data.vldsz  = n;
		copy_s2Buffer(HDLIST_FIRST_LINE_KEY, &key);
		lp = add_tList_node_Buffer(NULL, key, data);

		if (buf.buf[i]=='\0' || i==size) {
			free_Buffer(&key);
			free_Buffer(&data);
			return lp;
		}
		clear_Buffer(&key);
		clear_Buffer(&data);
	}


	// HEADER
	while(buf.buf[i]!='\0' && i<size && !inContents) {
		// Check Previous Line's CR & LF
		if (i+1<size && buf.buf[i]==0x0d && buf.buf[i+1]==0x0a) {
			i = i + 2;
			if (crlfCount==1) {			// for previous called function
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
			else crlfCount = 1;
		}
		else if (buf.buf[i]==0x0a) {
			i = i + 1;
			if (crlfCount==1) {			// for previous called function
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
			else crlfCount = 1;
		}

		// 
		if (i+1<size && buf.buf[i]==0x0d && buf.buf[i+1]==0x0a) {
			i = i + 2;
			if (crlfCount==1) {
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
		}
		else if (i<size && buf.buf[i]==0x0a) {
			i = i + 1;
			if (crlfCount==1) {
				copy_s2Buffer(HDLIST_END_KEY, &key);
				lp = add_tList_node_Buffer(lp, key, data);
				crlfCount  = 0;
				inContents = TRUE;
				break;	
			}
		}

		if (buf.buf[i]=='\0' || i==size) break;


		// HEADER KEY
		n = 0;
		if (buf.buf[i]==TAB || buf.buf[i]==' ') {
			copy_s2Buffer(HDLIST_CONTINUE, &key);
		}
		else {
			while(buf.buf[i]!=deli && buf.buf[i]!='\0' && i<size && n<LBUF) {
				key.buf[n++] = buf.buf[i++];
			}
			key.buf[n] = '\0';
			key.vldsz  = n;
		}
		while ((buf.buf[i]==deli ||buf.buf[i]==' '||buf.buf[i]==TAB) && i<size) i++;


		// HEADER VALUE
		n = 0;
		while(buf.buf[i]!=0x0a && buf.buf[i]!='\0' && i<size && n<size) {
			data.buf[n++] = buf.buf[i++];
		}
		if (data.buf[n-1]==0x0d) {
			i--;
			n--;
		}
		data.buf[n] = '\0';
		data.vldsz  = n;

		lp = add_tList_node_Buffer(lp, key, data);

		crlfCount = 0;
		clear_Buffer(&key);
		clear_Buffer(&data);
	}
	

	// CONTENTS (Text or Binary)
	if (rcntnt && i<size && inContents) {
		crlfCount = 0;
		clear_Buffer(&key);
		clear_Buffer(&data);
		copy_s2Buffer(HDLIST_CONTENTS_KEY, &key);

		n = 0;
		while(i<size && n<size) {
	   		data.buf[n++] = buf.buf[i++];
		}
		data.vldsz = n;

		lp = add_tList_node_Buffer(lp, key, data);
	}
	
	free_Buffer(&key);
	free_Buffer(&data);

	return lp;
}





/**
tList*  get_protocol_header_list_file(char* fname, char deli, int fstline, int rcntnt)

	@\Ft@C fname wb_ǂݍŕCXgɊi[ĕԂD

	Ffname   -- ǂݍރt@C
		  deli	-- wb_̌o(Key)Ƃ̋EDHTTP SMTPł ':'
		  fstline -- sڂʈɂ邩H sڂ key'deli' data ̌`łȂvgRp, ex) HTTP, SIP
					 'deli'͋E
		  rcntnt  -- RecǂނH

	߂lFwb_i[Xgւ̃|C^D

*/
tList*  get_protocol_header_list_file(char* fname, char deli, int fstline, int rcntnt)
{
	Buffer buf;
	tList* lp;

	if (fname==NULL) return NULL;

	buf = read_Buffer_file(fname);
	lp  = get_protocol_header_list(buf, deli, fstline, rcntnt);

	return lp;
}





//////////////////////////////////////////////////////////////////////////////////////////////////
// Search

/**
Buffer  search_protocol_header(tList* list, char* key, int no) 

	@\Fwb_Xg̒ noԖڂ keym[hToClildat.val.bufj̃Rs[ԂD
		  lsɓnꍇ́C\r\n }čsD
		  ł key̒ɍ킹D܂, key̓P[XCZVeBuD

	Flist -- Ώۂ̃wb_i[Xg
		  key  -- wb_ʁD
		  no   -- wb_ʂ̃m[hꍇCԖڂ̃m[hw肷DP琔D

	߂lF
			vfree
*/
Buffer  search_protocol_header(tList* list, char* key, int no) 
{
	tList* pp;
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;
	
	pp = strncasecmp_tList(list, key, 0, no);		// Sv
	if (pp!=NULL) {
		buf = dup_Buffer(pp->ldat.val);

		while (is_header_continue(pp)) {
			cat_s2Buffer("\r\n", &buf);
			pp = pp->next;
			cat_Buffer(&(pp->ldat.val), &buf);
		}
	}
	
	return buf;
}





/**
Buffer  search_protocol_header_item(tList* list, char* key, int no, char deli, int nm) 

	@\Fkey L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځijԂD

	Flist -- Ώۂ̃wb_i[Xg
		  key  -- wb_ʁD
		  no   -- wb_ʂꍇCԖڂ̃m[hw肷DP琔D
		  deli -- m[hlij̋؂蕶D
		@nm   -- deli ؂蕶ƂĉԖڂ̍ڂH 1琔D

	߂lF
		 w肵ځij̃Rs[D

*/
Buffer  search_protocol_header_item(tList* list, char* key, int no, char deli, int nm) 
{
	Buffer buf, itm;

	buf = search_protocol_header(list, key, no);
	if (buf.buf==NULL) return buf;
	
	itm = cawk_Buffer(buf, deli, nm);
	free_Buffer(&buf);

	return itm;
}





/**
Buffer  search_protocol_header_value(tList* list, char* key, char* data, int no) 

	@\Fwb_Xg̒ noԖڂ keym[hToCdataŎn܂m[h̒lildat.val.bufj̃Rs[ԂD
		  key, data̓P[XCZVeBuDdata sɌpĂꍇ́CpĂsPƂ̍sƂČD

	Flist -- Ώۂ̃wb_i[Xg
		  key  -- wb_ʁD
	@@@data -- wb_l̍ŏ̕DNULL ȂSĂƈvD
		  no   -- wb_ʂ̃m[hꍇCԖڂ̃m[hw肷DP琔D
	
	߂lFvm[h̃m[hl̃Rs[D

*/
Buffer  search_protocol_header_value(tList* list, char* key, char* data, int no) 
{
	Buffer buf;
	char*  str;
	int	   len, nm;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_protocol_header(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = (int)strlen(data); 
	
	nm = 0;
	while (list!=NULL) {
		if (list->ldat.key.buf!=NULL && !strcasecmp((char*)list->ldat.key.buf, key)) {
			str = (char*)list->ldat.val.buf;

			if (str!=NULL && !strncasecmp(str, data, len)) {
				nm++;
				if (no==nm) {
					buf = make_Buffer_bystr(str);
					return buf;
				}
			}

			while (is_header_continue(list)) {
				list = list->next;
				str  = (char*)list->ldat.val.buf;
				if (str!=NULL && !strncasecmp(str, data, len)) {
					nm++;
					if (no==nm) {
						buf = make_Buffer_bystr(str);
						return buf;
					}
				}
			}
		}

		list = list->next;
	}

	return buf;
}





/**
Buffer  search_protocol_header_partvalue(tList* list, char* key, char* data, int no) 

	@\Fwb_Xg̒ noԖڂ keym[hToCdata̕܂ރm[h̒lildat.val.bufj̃Rs[ԂD
		  key, data̓P[XCZVeBuDdata sɌpĂꍇ́CpĂsPƂ̍sƂČD

	Flist -- Ώۂ̃wb_i[Xg
		  key  -- wb_ʁD
	@@@data -- wb_l̍ŏ̕DNULL ȂSĂƈvD
		  no   -- wb_ʂ̃m[hꍇCԖڂ̃m[hw肷DP琔D

	߂lFvm[h̃m[hl̃Rs[D
*/
Buffer  search_protocol_header_partvalue(tList* list, char* key, char* data, int no) 
{
	Buffer buf;
	char*  str;
	int	   len, nm;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_protocol_header(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = (int)strlen(data); 
	
	nm = 0;
	while (list!=NULL) {
		if (list->ldat.key.buf!=NULL && !strcasecmp((char*)list->ldat.key.buf, key)) {
			str = (char*)list->ldat.val.buf;

			if (str!=NULL && strstrcase(str, data)) {
				nm++;
				if (no==nm) {
					buf = make_Buffer_bystr(str);
					return buf;
				}
			}

			while (is_header_continue(list)) {
				list = list->next;
				str  = (char*)list->ldat.val.buf;
				if (str!=NULL && strstrcase(str, data)) {
					nm++;
					if (no==nm) {
						buf = make_Buffer_bystr(str);
						return buf;
					}
				}
			}
		}

		list = list->next;
	}

	return buf;
}








//////////////////////////////////////////////////////////////////////////////////////////////////
// Set

/*
int 	set_protocol_header(tList* list, char* key, char* value, int no, int add_mode)

	@\FXg(lt) noԖڂ keỹm[hl valueݒ肷D
		  no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂Đݒ肪sD
		  keym[h݂C mode==ON ̏ꍇ́CXg̍ŌiRec̑OjɒǉD

		  set_value_tList() Ƃ̈Ⴂ́Cǉ̒ǉ̎d̂݁D(in Lib/tlist.c)

	F
		list   -- Ώۂ̃Xg
		key	   -- ݒsm[h̃L[
		value  -- ݒ肳镶D
		no	   -- ڂ̃m[hɑ΂ĐݒsD1琔D
				  0ȉ̏ꍇkeyv邷ׂẴm[hɑ΂ĐݒsD
		add_mod - ̒lON w肵m[hꍇCm[hXg̍ŌiRec̑OjɒǉD

   ߂lF
		ݒ肳ꂽm[h̐Dw肳ꂽm[h݂Ȃꍇ́iǉꂽꍇj0
		̏ꍇ̓G[D

*/
int 	set_protocol_header(tList* list, char* key, int no, char* value, int add_mode)
{
	int cn = set_value_tList(list, key, no, value, OFF);

	// Not Found
	if (add_mode==ON && cn==0) {
		tList* pm = strncmp_tList(list, HDLIST_END_KEY, 0, 1);
		if (pm!=NULL && pm->prev!=NULL) {
			add_tList_node_str(pm->prev, key, value);
		}
		else {
			add_tList_node_str(list, key, value);
		}
	}

	return cn;
}





/**
int 	replace_protocol_header(tList* list, char* key, char* srcval, char* value, int no)

	@\FXg(lt) noԖڂ keym[h̒l srcval̕ value ɒuD
		  no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂ĒusD

		  replace_valute_tList() Ɠ֐ (in Lib/tlist.c)

	F
		list   -- Ώۂ̃Xg
		key	   -- usm[h̃L[
		srcval -- uΏۂ̕D
		value  -- usD
		no	   -- ڂ̍ڂu邩D1琔D0ȉ̏ꍇkeyvSĂ̍ڂu

	߂lF
		ύXꂽm[h̐Dw肳ꂽm[h݂Ȃ́iǉꂽꍇj0
		̏ꍇ̓G[D

	#define replace_protocol_header(l, k, n, s, d)	replace_value_tList((l), (k), (n), (s), (d))
*/





/**
int		set_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* value)

	@\Fkey L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځij
		@value ݒ肷D

	Flist -- Ώۂ̃wb_i[Xg
		  key  -- wb_ʁD
		  no   -- wb_ʂꍇCԖڂ̃m[hw肷DP琔D
				  no 0ȉ̏ꍇ keyvSẴm[hɑ΂đsD
		  deli -- m[hlij̋؂蕶D
		@nm   -- deli ؂蕶ƂĉԖڂ̍ڂH 1琔D
		  value - ݒ肷镶D

	߂lFݒsm[hD

int		set_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* value)
*/





/**
int		replace_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)

	@\Fkey L[ɂ noԖڂ̃m[h̒l̒ŁCdeli؂ɂ nmԖڂ̍ځij
		@srcval valueŒuD

	Flist  -- Ώۂ̃wb_i[Xg
		  key   -- wb_ʁD
		  no	-- wb_ʂꍇCԖڂ̃m[hw肷DP琔D
				   no 0ȉ̏ꍇ keyvSẴm[hɑ΂đsD
		  deli  -- m[hlij̋؂蕶D
		@nm	-- deli ؂蕶ƂĉԖڂ̍ڂH 1琔D
		  srcval - uΏۂ̕DNULLȂw肵ڂ̕S
		  value  - u镶D

	߂lFusm[hD

int		replace_protocol_header_item(tList* list, char* key, int no, char deli, int nm, char* srcval, char* value)
*/





/**
int search_crlfcrlf(char* mesg) 

	@\F񒆂̋sTDsR[h 0x0d, 0x0a ܂ 0x0a

	߂lFs̎̍s̐擪̈ʒu
			-1 ̏ꍇ͋sD

*/
int  search_crlfcrlf(char* mesg) 
{
	int cr = 0;		// dummy
	int lf = 0;
	int i;

	if (mesg==NULL)	return -2;
	if (mesg[0]==0x0a) return 1;
	if (mesg[0]==0x0d && mesg[1]==0x0a) return 2;

	i = 0;
	while(mesg[i]!='\0') {
		if	  (mesg[i]==0x0d) cr++;
		else if (mesg[i]==0x0a) lf++;
		else {
			cr = lf = 0;
		}

		if (lf==2) return i+1;
		i++;
	}
	return -1;
}




/**
int  is_header_continue(tList* pp)

	@\Fpp wĂwb_l̃Xg֑Ă邩ǂ肷D
		  vgRł́Cwb_lsɓnꍇɑD

*/
int  is_header_continue(tList* pp)
{
	if (pp==NULL || pp->next==NULL || pp->next->ldat.key.buf==NULL)	return FALSE;
	if (!strcmp((const char*)pp->next->ldat.key.buf, HDLIST_CONTINUE)) return TRUE;
	return FALSE;
}






