#ifndef __BREP_H_
#define __BREP_H_


/**
  BREP Cu  modified by Fumi.Iseki

		LGPLD
		http://breplibrary.sourceforge.net/  BRL
*/


#include "common++.h"

#include <string>
#include <list>
#include <algorithm>

#include "Vector.h"
#include "Tolerance.h"
#include "ClassBox.h"


using namespace jbxl;



#define  COUNTER_RATE  100	// JE^\Ԋu



//class  DllExport std::list;
//class  DllExport std::basic_string;


class  DllExport BREP_SOLID;
class  DllExport BREP_SHELL;
class  DllExport BREP_FACE;
class  DllExport BREP_CONTOUR;
class  DllExport BREP_EDGE;
class  DllExport BREP_WING;
class  DllExport BREP_VERTEX;
class  DllExport OctreeNode;



typedef std::list<BREP_SHELL*>   BREP_SHELL_RING;
typedef std::list<BREP_FACE*>    BREP_FACE_RING;
typedef std::list<BREP_CONTOUR*> BREP_CONTOUR_RING;
typedef std::list<BREP_EDGE*>    BREP_EDGE_RING;
typedef std::list<BREP_WING*>    BREP_WING_RING;
typedef std::list<BREP_VERTEX*>  BREP_VERTEX_RING;




DllExport BREP_WING* BrepCreateWingWithoutContour(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2);

DllExport BREP_EDGE* BrepFindEdge(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2);
DllExport BREP_EDGE* CreateEdge(BREP_VERTEX* v1, BREP_VERTEX* v2);

DllExport BREP_VERTEX*  AddVertex2Octree(BREP_VERTEX* vertex, OctreeNode* octree);

DllExport void ComputeVertexNormal(BREP_VERTEX* vert);
DllExport void BrepConnectWingToVertex(BREP_WING* wing);
DllExport void BrepDestroyWing(BREP_WING* wing);
DllExport int  VertexCompare(BREP_VERTEX* v1, BREP_VERTEX* v2);
DllExport BREP_WING* BrepEdgeOtherWing(BREP_WING* wing);
//DllExport void FaceClose(BREP_VERTEX *vertex);





/*********************************  BREP_SOLID  *********************************/

class  DllExport BREP_SOLID 
{
public:
	unsigned int facetno;
	unsigned int vertexno;

	BREP_SHELL_RING shells;
	RBound<double>  rbound;
	OctreeNode*     octree;
	CVCounter*		counter;		// zvʃJE^

	BREP_CONTOUR_RING  contours;
	BREP_WING_RING	   wings;

public:
	BREP_SOLID();
	~BREP_SOLID();

	void  DataCloseCallback();
	void  ConnectShell(BREP_SHELL* shell);
	void  DisconnectShell(BREP_SHELL* shell);
};





/*********************************  BREP_SHELL  *********************************/

class DllExport BREP_SHELL
{
public:
	BREP_SOLID*     solid;
	BREP_FACE_RING  faces;
	RBound<double>  rbound;

public:
	BREP_SHELL(BREP_SOLID* pr_solid);
	~BREP_SHELL();

	void DataCloseCallback();
	void ConnectFace(BREP_FACE* face);
	void DisconnectFace(BREP_FACE* face);
};





/*********************************  BREP_FACE  *********************************/

class DllExport BREP_FACE
{
public:
	BREP_SHELL*  shell;
	BREP_CONTOUR_RING outer_contours;

	VECTOR<double> normal;
	RBound<double> rbound;
	double	d;				// 萔C_畽ʂւ̋*(-1)
	double  tolerance;

public:
	BREP_FACE(BREP_SHELL* pr_shell);
	~BREP_FACE();

	void DataCloseCallback();
	void ConnectContour(BREP_CONTOUR* contour);
	void DisconnectContour(BREP_CONTOUR* contour);
	void ComputePlaneEquation();
};





/*********************************  BREP_CONTOUR  *********************************/

class DllExport BREP_CONTOUR
{
public:
	BREP_FACE*  face;
	BREP_WING*  wing;
	RBound<double>  rbound;
	VECTOR<double>  normal;
	int  dup_edge;		// dGbW̐D

public:
	BREP_CONTOUR(BREP_FACE* pr_face);
	~BREP_CONTOUR();

	void DataCloseCallback();
	void ConnectWing(BREP_WING* wing);
	void DisconnectWing(BREP_WING* wing);

	void DestroyWings();
	void IterateWings   (void (*func)(BREP_WING*));
	void IterateVertices(void (*func)(BREP_VERTEX*));
	void ComputeNormal();

	BREP_WING* CreateWing(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2);
};





/*********************************  BREP_WING  *********************************/

class DllExport BREP_WING
{
public:
	BREP_VERTEX*  vertex;  // Start of Vertex
	BREP_WING*    prev;
	BREP_WING*    next;

	BREP_EDGE*    edge;
	BREP_CONTOUR* contour;

public:
	BREP_WING(BREP_VERTEX* v);
	~BREP_WING() {}
};





/*********************************  BREP_EDGE  *********************************/

class DllExport BREP_EDGE
{
public:	
	BREP_WING* wing1;
	BREP_WING* wing2;
	VECTOR<double>  center;

	BREP_EDGE_RING* edge_ring;	// dGbW̃Xgւ̃|C^
	bool   complete;			// SȃGbWDQ Wing͋ɎgpĂD
	double tolerance;

public:
	BREP_EDGE(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2);
	~BREP_EDGE();

	void DataCloseCallback();
};





/*********************************  BREP_VERTEX  *********************************/

class DllExport BREP_VERTEX
{
public:
	BREP_WING_RING  wing_ring;
	VECTOR<double>  point;
	VECTOR<double>  normal;

	double tolerance;

public:
	BREP_VERTEX();
	~BREP_VERTEX();

	void DataCloseCallback();
	void DisconnectWing(BREP_WING* wing);
	void ComputeNormal();
	void ComputeTolerance();

	//  [copy]
	void IterateWings(void (*func)(BREP_WING*));
};





/*********************************  OctreeNode  *********************************/

class DllExport OctreeNode
{
public:
	BREP_SOLID*  solid;

private:
	BREP_VERTEX* vertex;
	OctreeNode*  child[8];


public:
	//
	// OctreeNodẽRXgN^́CVɗ̈炸Ƀ|C^Rs[邱Ƃɒ!!
	OctreeNode(BREP_VERTEX* new_vertex, BREP_SOLID* sld/*=NULL*/);

	~OctreeNode();


	// 
	//  Octree Vertex new_vertex̂̂o^Do^ OctreeNodeԂD
	//                            ^^^^^^^^
	//  ɓʒuVertexo^ς݂̏ꍇ́C OctreeNodeԂD
	//  AddWithDuplicates() Ƃ͖߂lႤ̂ŒӂD
	OctreeNode* AddWithUnique(BREP_VERTEX* new_vertex);


	//
	//  Octree Vertex new_vertex ̂̂o^Ddo^D                           ^^^^^^^^
	//  Octreẽgbṽ|C^ԂD
	OctreeNode* AddWithDuplicates(BREP_VERTEX* new_vertex);

	//
	//  Vertex element Ɠʒuɂ Vertex܂ރm[hԂD
	OctreeNode* FindSubtree(BREP_VERTEX* element);

	
	//
	//  Vertex element Ɠʒuɂ VertexԂD
	//  [copy]
	BREP_VERTEX* Find(BREP_VERTEX* element);


	//
	//  [copy]
	void Iterate(void (*func)(BREP_VERTEX*));


	friend  BREP_VERTEX* AddVertex2Octree(BREP_VERTEX* vertex, OctreeNode* octree);
};







#endif

