
/**
  g BREP Cu


*/

#include "exBrep.h"
#include "TriBrep.h"


using namespace jbxl;



/*********************************  SOLID  *********************************/

SOLID::SOLID()  {}


SOLID::~SOLID() {}




/*********************************  SHELL  *********************************/

SHELL::SHELL(SOLID* pr_solid) : BREP_SHELL((BREP_SOLID*)pr_solid) {}


SHELL::~SHELL() {}




/*********************************  FACE  *********************************/

FACE::FACE(SHELL* pr_shell) : BREP_FACE((BREP_SHELL*)pr_shell) 
{ 
	deletable = false; 
	initdata  = false;
}


FACE::~FACE() {}








/*********************************  CONTOUR  *********************************/


CONTOUR::CONTOUR(FACE* pr_face) : BREP_CONTOUR((BREP_FACE*)pr_face) 
{
	hasCollisionVector = false;
	collision = false;
}


CONTOUR::~CONTOUR() {}




void  CONTOUR::DataCloseCallback()
{
	BREP_CONTOUR::DataCloseCallback();
	if (!hasCollisionVector) ComputeDirectRS();
}





/**
	Փ˔pxNǧvZ
*/
void  CONTOUR::ComputeDirectRS()
{
	TVector<double> point = ToTVector((VERTEX*)(wing->next->vertex));
	directR  = point - ToTVector((VERTEX*)(wing->vertex));
	directS  = ToTVector((VERTEX*)(wing->next->next->vertex)) - point;
	directRS = directR^directS;
	directR.norm();
	directS.norm();
	directRS.norm();
	hasCollisionVector = true;
}








/*********************************  WING  *********************************/

WING::WING(VERTEX* vx) : BREP_WING((BREP_VERTEX*)vx) {}


WING::~WING() {}




/*********************************  EDGE  *********************************/

EDGE::EDGE(VERTEX* v1, VERTEX* v2) : BREP_EDGE((BREP_VERTEX*)v1, (BREP_VERTEX*)v2) {}


EDGE::~EDGE() {}




/*********************************  VERTEX  *********************************/

VERTEX::VERTEX() 
{
	forbidden_ring = NULL;
	distance2 = HUGE_VAL;
}



VERTEX::~VERTEX() {
	if (forbidden_ring!=NULL) delete(forbidden_ring);
}








/*********************************  Tolerance  *********************************/

DllExport void SetBrepZeroEPS(double eps)	
{
	Zero_Eps = eps;
}



DllExport void SetBrepVertexTolerance(double tol)
{
	Vertex_Tolerance = tol;
}



DllExport void SetBrepEdgeTolerance(double tol)
{
	Edge_Tolerance = tol;
}


DllExport void SetBrepFaceTolerance(double tol)		
{
	Face_Tolerance = tol;
}


DllExport void SetBrepCollisionTolerance(double tol)
{
	Collision_Tolerance = tol;
}



DllExport void SetBrepSINTolerance(double tol)
{
	Sin_Tolerance = tol;
}


DllExport void SetBrepAbsVertexTolerance(double tol)
{
	Abs_Vertex_Tolerance = tol;
}



















