#ifndef  __EX_BREP_H
#define  __EX_BREP_H

/**
  g BREP Cu


*/

#include  "Brep.h"
#include  "TVector.h"


using namespace jbxl;



class   DllExport SOLID;
class	DllExport SHELL;
class	DllExport FACE;
class   DllExport CONTOUR;
class	DllExport WING;
class	DllExport EDGE;
class   DllExport VERTEX;


//class  DllExport std::basic_string<char,std::char_traits<char>,std::allocator<char>>;



DllExport void SetBrepZeroEPS(double eps);	
DllExport void SetBrepVertexTolerance(double tol);
DllExport void SetBrepEdgeTolerance(double tol);
DllExport void SetBrepFaceTolerance(double tol);	
DllExport void SetBrepCollisionTolerance(double tol);
DllExport void SetBrepSINTolerance(double tol);
DllExport void SetBrepAbsVertexTolerance(double tol);





/*********************************  SOLID  *********************************/

class DllExport SOLID : public BREP_SOLID
{
public:

	BREP_CONTOUR_RING  surplus_contours;
	BREP_WING_RING     shortage_wings;
	std::string  name;

public:
	SOLID();
	~SOLID();
};







/*********************************  SHELL  *********************************/

class DllExport SHELL : public BREP_SHELL
{
public:

public:
	SHELL(SOLID* pr_solid);
	~SHELL();
};







/*********************************  FACE  *********************************/

class DllExport FACE : public BREP_FACE
{
public:
	bool   deletable;		// 폜\
	bool   initdata; 		// f[^iǂݍ݃f[^j

public:
	FACE(SHELL* pr_shell);
	~FACE();
};







/*********************************  CONTOUR  *********************************/

class DllExport CONTOUR : public BREP_CONTOUR
{
public:
	// QRS  OpContourՓˌop
	TVector<double>  directR;
	TVector<double>  directS;
	TVector<double>  directRS;
	bool  hasCollisionVector;
	bool  collision;

public:
	CONTOUR(FACE* pr_face);
	~CONTOUR();

	void  DataCloseCallback();
	void  ComputeDirectRS();
};







/*********************************  WING  *********************************/

class DllExport WING : public BREP_WING
{
public:

public:
	WING(VERTEX* vx);
	~WING();
};







/*********************************  EDGE  *********************************/

class DllExport EDGE : public BREP_EDGE
{
public:

public:
	EDGE(VERTEX* v1, VERTEX* v2);
	~EDGE();
};







/*********************************  VERTEX  *********************************/

class  DllExport VERTEX : public BREP_VERTEX
{
public:
	double  distance2;
	BREP_VERTEX_RING*  forbidden_ring;  // ݂ Edge𒣂邱Ƃ֎~ꂽ Vertex Ring

public:
	VERTEX();
	~VERTEX();

};





#endif 

