/* vi: set tabstop=4 nocindent noautoindent: */

/**
	Buffer^T|[gvO  buffer.c   v.1.3

  	wb_
	  	#include "buffer.h"

 */

#include "buffer.h"



/**
Buffer*  new_Buffer()

	@\FBuffer^ϐoD

	FȂD

	߂lFo Buffer^ϐւ̃|C^D
			쐬ɎsꍇNULLԂD
*/
Buffer*  new_Buffer(void)
{
	Buffer*  buf;

	buf = (Buffer*)malloc(sizeof(Buffer));
	if (buf==NULL) return NULL;

	memset(buf, 0, sizeof(Buffer));
	buf->vldsz = -1;

	return buf;
}





/**
Buffer  init_Buffer()

	@\FBuffer^ϐԂD

	߂lFꂽBuffer^ϐD

	F
		a = init_Buffer() ƂꍇCaɌXlĂꍇC̒l free
		Ȃ̂ŒӁD
*/
Buffer  init_Buffer()
{
	Buffer  buf;

	memset(&buf, 0, sizeof(Buffer));
	buf.vldsz = -1;

	return buf;
}





/**
Buffer  make_Buffer(int sz)

	@\FBuffer^ϐ̃obt@oD
		  sz  Buffer^ϐ̃obt@̑傫D
		  obt@ 0x00ŏDbufsz=sz, vldsz=0 ƂȂD

	Fsz -- Buffer^ϐ̃obt@̑傫D

	߂lFo Buffer^ϐD
			obt@̍쐬Ɏsꍇ,obt@̃TCY(bufsz) 0,obt@ւ̃|C^ NULLƂȂD
*/
Buffer  make_Buffer(int sz)
{
	Buffer  buf;

	memset(&buf, 0, sizeof(Buffer));
	if (sz<=0) return buf;

	buf.bufsz = sz;
	buf.buf = (unsigned char*)malloc(buf.bufsz+1);

	if (buf.buf==NULL) {
		buf.bufsz = 0;
		buf.vldsz = -1;
	}
	else memset(buf.buf, 0, buf.bufsz+1);

	return buf;
}





/**
Buffer  make_Buffer_bystr(char* str)

	@\F񂩂CBuffer^ϐ̃obt@oD
		  make_Buffer_bystr("")  Bufferϐ̏ɂgpD
		  oCif[^ Bufferϐoɂ́Cset_Buffer()pD 

	Fsz -- Buffer^ϐ̃obt@Ɋi[镶

	߂lFo Buffer^ϐDobt@̍쐬Ɏsꍇ,
			obt@̃TCY(bufsz) 0,obt@ւ̃|C^ NULLƂȂD

	#define  make_Buffer_bystr(s)	set_Buffer((void*)(s), -1)
*/






/**
Buffer  make_Buffer_bychar(unsigned char cc)

	@\FCBuffer^ϐ̃obt@oD
		  make_Buffer_bychar('\0')  Bufferϐ̏ɂgpD

	Fsz -- Buffer^ϐ̃obt@Ɋi[镶

	߂lFo Buffer^ϐDobt@̍쐬Ɏsꍇ,
			obt@̃TCY(bufsz) 0,obt@ւ̃|C^ NULLƂȂD
*/
Buffer  make_Buffer_bychar(unsigned char cc)
{
	Buffer  buf;
	
	buf = make_Buffer(LADDR);
	if (buf.buf==NULL) return buf;

	buf.buf[0] = cc;
	buf.vldsz = 1;
	return buf;
}








/**
void  free_Buffer(Buffer* buf)

	@\FBuffer^ϐ̃obt@JD

	Fbuf  -- Jobt@ Bufferf[^ւ̃|C^D

 */
void  free_Buffer(Buffer* buf)
{
	if (buf!=NULL) {
		freeNull(buf->buf);
		memset(buf, 0, sizeof(Buffer));
		buf->vldsz = -1;
	}
}





/**
void   del_Buffer(Buffer** buf)

	@\Fnew_Buffer()ōo Buffer^ϐ폜D

	Fbuf -- 폜 Bufferf[^̃|C^ւ̃|C^D

 */
void   del_Buffer(Buffer** buf)
{
	if (buf!=NULL && *buf!=NULL) {
		freeNull((*buf)->buf);
		free(*buf);
		*buf = NULL;
	}
}





/**
Buffer  set_Buffer(void* buf, int len)

	@\FBuffer^ϐ̃obt@V, ̃obt@ 
		  bufRs[Dlen̓Rs[f[^D len 0
		  ꍇ, buf͕ƂĈD
		  buf ̏ꍇ make_Buffer_bystr() gp\D

	Fbuf  -- Rs[obt@ւ̃|C^D
		  len  -- obt@(oCgP)D

	߂l; Vꂽ Buffer^f[^D
 */
Buffer  set_Buffer(void* buf, int len)
{
	Buffer  str;

	str = init_Buffer();
	if (buf==NULL) return str;

	if (len<0) len = (int)strlen((char*)buf);
	str = make_Buffer((int)((len+1)*BUFFER_FACT));
	if (str.buf==NULL) return str;

	memcpy(str.buf, buf, len);
	str.vldsz = len;
	return  str;
}





/**
Buffer  dup_Buffer(Buffer buf)

	@\FBuffer^ϐ̃Rs[D

	Fbuf -- Rs[ϐD

	߂l; Vꂽ Buffer^f[^D
 */
Buffer  dup_Buffer(Buffer buf)
{
	Buffer  str;

	str = make_Buffer(buf.bufsz);
	memcpy(str.buf, buf.buf, buf.bufsz);
	str.vldsz = buf.vldsz;
	str.state = buf.state;
	return  str;
}





/**
Buffer  rept_Buffer(unsigned char cc, int n)

	@\Fcc nJԂBuffer^f[^ԂD

	Fcc -- JԂD
		  n  -- JԂ񐔁D

	߂l; Vꂽ Buffer^f[^D
 */
Buffer  rept_Buffer(unsigned char cc, int n)
{
	int  i;
	Buffer  str;
	
	if (n<=0) n = 1;
	str = make_Buffer(n);
	for (i=0; i<n; i++) str.buf[i] = cc;
	str.vldsz = n;
	return  str;
}





/**
void  clear_Buffer(Buffer* str)

	@\FBuffer^ϐ ̃obt@ 0NAD

	Fstr -- NA Buffer^f[^ւ̃|C^D

 */
void  clear_Buffer(Buffer* str)
{
	memset(str->buf, 0, str->bufsz+1);
	str->vldsz = 0;
	str->state = 0;
}






/**
int  copy_Buffer(Buffer* src, Buffer* dst)
  
	@\FBuffer^ϐ src dstփobt@Rs[D, dst 
		  src̃obt@Rs[邾̃Xy[Xꍇ, V
		  obt@̈mۂăRs[D

	Fsrc -- Rs[ւ̃|C^D
		  dst -- Rs[ւ̃|C^D

	߂lF 0ȏ  dst̃obt@ɃRs[ꂽD
				-1  src܂ dst NULL 
				-2  ̊mۂɎsDsȂD


	(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ
			  ȂD܂ȉ̂悤Ȏg͊ԈႢD

			  func(Buffer buf){ 
				  ...............
				  copy_Buffer(&src, &buf);
				  ...............
			  }

		͉L̂悤ɕύXD

			  func(Buffer buf){ 
				  ...............
				  copy_Buffer(&src, &buf);
				  ...............
			  }

		RF֐Ńobt@̑傫ς\邪CĂяo
			  ͂̂Ƃm邱ƂłȂD

 */
int  copy_Buffer(Buffer* src, Buffer* dst)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (src->buf==NULL) return -1;

	sz = src->vldsz;
	if (sz<0)  sz = (int)strlen((const char*)src->buf);
	if (sz==0) return 0;

	if (dst->bufsz < sz) {
		unsigned char* buf;
		//dz  = (int)((src->bufsz+1)*BUFFER_FACT);
		dz  = (int)((sz+1)*BUFFER_FACT);
		buf = (unsigned char*)malloc(dz+1);
		if (buf==NULL) return -2;

	   	free(dst->buf);
		dst->bufsz = dz;
		dst->buf   = buf;
	}

	//memset(dst->buf, 0, dst->bufsz+1);		too late
	memcpy(dst->buf, src->buf, sz);
	dst->buf[sz] = '\0';
	dst->vldsz = sz;
	dst->state = 0;

	return  sz;
}





/**
int  cat_Buffer(Buffer* src, Buffer* dst)
  
	@\FBufferϐ src dstփobt@ catD, dst src
		  obt@ cat邾̃Xy[Xꍇ͐VɃobt@̈
		  mۂ catD

	Fsrc -- catւ̃|C^D
		  dst -- catւ̃|C^D

	߂lF 0ȏ  dst̃obt@ɃRs[ꂽD
				-1  src܂ dst NULL 
				-2  ̊mۂɎsDsȂD


	(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ
			  ȂD܂ȉ̂悤Ȏg͊ԈႢD

			  func(Buffer buf){ 
				  ...............
				  cat_Buffer(&src, &buf);
				  ...............
			  }

		͉L̂悤ɕύXD

			  func(Buffer* buf){ 
				  ...............
				  cat_Buffer(&src, buf);
				  ...............
			  }

		RF֐Ńobt@̑傫ς\邪CĂяo
			  ͂̂Ƃm邱ƂłȂD

 */
int  cat_Buffer(Buffer* src, Buffer* dst)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (src->buf==NULL) return -1;

	sz = src->vldsz;
	if (sz<0) sz = (int)strlen((const char*)src->buf);
	if (sz==0) return 0;

	dz = dst->vldsz;
	if (dz<0) {
		if (dst->buf!=NULL) dz = (int)strlen((const char*)dst->buf);
		else				dz = 0;
	}

	if (dst->bufsz < sz+dz) {
		Buffer buf;			 	// dst̑Ҕ 
		buf.bufsz = dst->bufsz;
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;

 		buf.buf[buf.bufsz] = '\0';
		memcpy(buf.buf, dst->buf, buf.bufsz);
		free_Buffer(dst);

		//dst->bufsz = (int)((buf.bufsz+src->bufsz+1)*BUFFER_FACT);
		dst->bufsz = (int)((buf.bufsz+sz+1)*BUFFER_FACT);
		dst->buf   = (unsigned char*)malloc(dst->bufsz+1);
		if (dst->buf==NULL) {
	   		*dst = buf;
	   		return -2;
		}
		memset(dst->buf, 0, dst->bufsz+1);
		memcpy(dst->buf, buf.buf, buf.vldsz);
		free_Buffer(&buf);
	}

	//memset(dst->buf+dz, 0, dst->bufsz-dz+1);  too late
	memcpy(dst->buf+dz, src->buf, sz);
	dst->buf[dz+sz] = '\0';
	dst->vldsz = sz + dz;
	dst->state = 0;

	return  dst->vldsz;
}





/**
int  copy_b2Buffer(void* src, Buffer* dst, int sz)
  
	@\FCӂ̃oCif[^src Buffer^ϐdst copyD
		  , dst src̃obt@ copy邾̃Xy[Xꍇ
		  VɃobt@̈mۂ copyD
		  sz 0̏ꍇ, src͕ƂĈD

	Fsrc -- copy̔CӃf[^ւ̃|C^D
		  dst -- copyBuffer^ϐւ̃|C^D
		  sz  -- copyoCgD

	߂lF 0ȏ  dst̃obt@ɃRs[ꂽD
				-1  src܂ dst NULL 
				-2  ̊mۂɎsDsȂD


	(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ
			  ȂD܂ȉ̂悤Ȏg͊ԈႢD

			  func(Buffer buf){ 
				  ...............
				  copy_b2Buffer(&src, &buf, n);
				  ...............
			  }

		͉L̂悤ɕύXD

			  func(Buffer* buf){ 
				  ...............
				  copy_b2Buffer(&src, buf, n);
				  ...............
			  }

		RF֐Ńobt@̑傫ς\邪Cfunc Ăяo
			  ł͂̂Ƃm邱ƂłȂD

 */
int  copy_b2Buffer(void* src, Buffer* dst, int len)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (len<0) sz = (int)strlen((const char*)src);
	else	   sz = len;
	if (sz<=0) return 0;

	if (dst->bufsz < sz) {
		unsigned char* buf;
		dz  = (int)((sz+1)*BUFFER_FACT);
		buf = (unsigned char*)malloc(dz+1);
		if (buf==NULL) return -2;
	   	free(dst->buf);
		dst->bufsz = dz;
		dst->buf   = buf;
	}

	memcpy(dst->buf, src, sz);
	dst->buf[sz] = '\0';
	dst->vldsz = sz;
	dst->state = 0;

	return  sz;
}





/**
int  cat_b2Buffer(void* src, Buffer* dst, int len)

	@\FCӂ̃oCif[^src Buffer^ϐdst catD
		  , dst src̃obt@ cat邾̃Xy[Xꍇ
		  VɃobt@̈mۂ catD
		  sz 0̏ꍇ, src͕ƂĈD

	Fsrc -- cat̔CӃf[^ւ̃|C^D
		  dst -- catBuffer^ϐւ̃|C^D
		  len -- catoCgD

	߂lF 0ȏ  dst̃obt@ɃRs[ꂽD
				-1  src܂ dst NULL 
				-2  ̊mۂɎsDsȂD


	(dv): ֐Ŏgpꍇ,Qƌ^ȊÖɑ΂Ă̊֐pĂ
			  ȂD܂ȉ̂悤Ȏg͊ԈႢD

			  func(Buffer buf){ 
				  ...............
				  cat_b2Buffer(&src, &buf, n);
				  ...............
			  }

		͉L̂悤ɕύXD

			  func(Buffer* buf){ 
				  ...............
				  cat_b2Buffer(&src, buf, n);
				  ...............
			  }

		RF֐Ńobt@̑傫ς\邪Cfunc Ăяo
			  ł͂̂Ƃm邱ƂłȂD

 */
int  cat_b2Buffer(void* src, Buffer* dst, int len)
{
	int sz, dz;

	if (src==NULL || dst==NULL) return -1;
	if (len<0) sz = (int)strlen((const char*)src);
	else	   sz = len;
	if (sz<=0) return 0;
   
	dz = dst->vldsz;
	if (dz<0) {
		if (dst->buf!=NULL) dz = (int)strlen((const char*)dst->buf);
		else				dz = 0;
	}

	if (dst->bufsz < sz+dz) {
		Buffer buf;			 // dst̑Ҕ 
		buf.bufsz = dst->bufsz;
		buf.vldsz = dz;
		buf.buf   = (unsigned char*)malloc(buf.bufsz+1);
		if (buf.buf==NULL) return -2;

 		buf.buf[buf.bufsz] = '\0';
		memcpy(buf.buf, dst->buf, buf.bufsz);
		free_Buffer(dst);

		dst->bufsz = (int)((buf.bufsz+sz+1)*BUFFER_FACT);
		dst->buf   = (unsigned char*)malloc(dst->bufsz+1);
		if (dst->buf==NULL) {
	   		*dst = buf;
	   		return -2;
		}
		memset(dst->buf, 0, dst->bufsz+1);
		memcpy(dst->buf, buf.buf, buf.vldsz);
		free_Buffer(&buf);
	}

	memcpy(dst->buf+dz, src, sz);
	dst->buf[dz+sz] = '\0';
	dst->vldsz = sz + dz;
	dst->state = 0;

	return  dst->vldsz;
}




/**
int  copy_s2Buffer(char* src, Buffer* dst)
  
	@\Fchar*ϐ src Buffer^ϐdst֕ copyD
		  , dst srcRs[邾̃Xy[Xꍇ, V
		  obt@̈mۂăRs[D

	Fsrc -- Rs[ւ̃|C^D
		  dst -- Rs[ւ̃|C^D

	߂lF	 0  src܂ dst NULL 
				-1  ̊mۂɎsDsȂD
			 1ȏ  dst̃obt@ɃRs[ꂽD


	#define copy_s2Buffer(s, d)  copy_b2Buffer((void*)(s), (d), (int)strlen((const char*)(s)))
			 
*/





/**
int  cat_s2Buffer(char* src, Buffer* dst)
  
	@\Fchar*ϐ src Buffer^ϐdst֕ catD
		  , dst src̕ cat邾̃Xy[Xꍇ
		  VɃobt@̈mۂ catD

	Fsrc -- catւ̃|C^D
		  dst -- catւ̃|C^D

	߂lF	 0  src܂ dst NULL 
				-1  ̊mۂɎsDsȂD
			 1ȏ  dst̃obt@ɃRs[ꂽD


	#define cat_s2Buffer(s, d)  cat_b2Buffer((void*)(s), (d), (int)strlen((const char*)(s)))

*/





int  copy_i2Buffer(int src, Buffer* dst)
{
	char num[LEN_INT];

	snprintf(num, LEN_INT-1, "%d", src);
	return copy_b2Buffer((void*)num, dst, (int)strlen(num));
}





int  cat_i2Buffer(int src, Buffer* dst)
{
	char num[22];

	snprintf(num, 21, "%d", src);
	return cat_b2Buffer((void*)num, dst, (int)strlen(num));
}





/**
int  cmp_Buffer(Buffer src, Buffer dst, int n)
  
	@\Fobt@̔rD
		  Bufferϐ src dst̃obt@rDn<=0 Ȃ Sv,
		  n>0 Ȃ 擪 noCgrD

	Fsrc -- rւ̃|C^D
		  dst -- rւ̃|C^D
		  n   -- rD

	߂lF 0  src dst͈vĂD
			 1  src dstƈvĂȂD
			-1  obt@ NULL
			-2  n  vldsz 傫

	: f[^̂ݓKpDR[fBOx^x^D
 */
int  cmp_Buffer(Buffer src, Buffer dst, int n)
{
	int i;

	if (src.buf==NULL || dst.buf==NULL) return -1;
	if (n>src.vldsz   || n>dst.vldsz)   return -2;
	
	if (n<=0) {
		if (src.vldsz!=dst.vldsz) return 1;
		else n = src.vldsz;
	}
	
	for (i=0; i<n; i++) {
		if (src.buf[i]!=dst.buf[i]) return 1;
	}
	return 0;
}





/**
Buffer  encode_base64_Buffer(Buffer buf)

	@\FoCif[^ buf.buf buf.vldszoCg Base64ɃGR[h
		  Dbuf.vldsz -1ȉ̏ꍇ buf.vldsz buf.buf̍ŏ 
		  0x00̂܂ł̒(strlen()+1)ƂȂD܂ buf.buf ͕
		  ȂD

		  ̓obt@ 3byte(8bit*3)̏ꍇ, o̓obt@ 4byte
		  (6bit*4)ƂȂD̓obt@ 6bitEłȂꍇ, 6bitE
		  ܂ 0tꂽƌD 
		  o̓obt@ 4byteEłȂꍇ, 4byteE܂ '='t
		  ďo͂D ܂,o̓obt@ł 60bytẻs͍sȂD
		  ʂ n byte ͂ꂽꍇ, Base64̏o͂̕ (n+2)/3*4 
		  byte ƂȂD

	Fbuf -- Base64ɃGR[hf[^D

	߂lFBase64ɃGR[hꂽ(Buffer^)

	F'A',0x00,0x01 𕶎(sz=1)Ƃ݂Ȃĕ "QQ==" ƂȂD
		'A',0x00,0x01  3byte𕄍(sz=3) "QQAB" ƂȂD
*/
Buffer  encode_base64_Buffer(Buffer buf)
{
	unsigned char* bas;
	int	 sz;
	Buffer  ecd;
	 
	memset(&ecd, 0, sizeof(Buffer));

	if (buf.buf==NULL) return ecd;
	if (buf.vldsz<0) sz = (int)strlen((const char*)buf.buf);
	else		 	 sz = buf.vldsz;
	bas = encode_base64(buf.buf, sz);
	if (bas==NULL) return ecd;
	
	ecd = make_Buffer(sz);
	if (ecd.buf==NULL) {
		free(bas);
		return ecd;
	}

	copy_s2Buffer((char*)bas, &ecd);

	free(bas);
	return ecd;
}




/**
Buffer  decode_base64_Buffer(Buffer str)

	@\Fstr̃obt@ Base64fR[hD
		  ϊ str.buf̐擪珇sDA-Za-z0-9+/ ȊO͖
		  (ႦΉsR[h)D

		  ̓obt@ 4byte(6bit*4)̏ꍇ, o̓obt@ 3byte
		  (8bit*3)ƂȂD̓obt@̃oCg 4̔{łȂꍇ
		  (sȃf[^), Ȃ̓obt@ɂ '='}Ă
		  ̂Ƃ݂ȂD

	Fstr -- Base64fR[h镶D

	߂lFBase64fR[hꂽf[^(Buffer^)

	F"QQ" fR[h 'A',0x00 ƂȂD
*/
Buffer  decode_base64_Buffer(Buffer str)
{
	int	sz;
	Buffer dcd;
	unsigned char* bas;

	memset(&dcd, 0, sizeof(Buffer));
	if (str.buf==NULL) return dcd;

	bas = decode_base64(str.buf, &sz);
	if (bas==NULL) return dcd;

	dcd = make_Buffer(sz);
	if (dcd.buf==NULL) {
		free(bas);
		return dcd;
	}

	copy_b2Buffer(bas, &dcd, sz);
	dcd.vldsz = sz;

	free(bas);
	return dcd;
}





/**
Buffer  get_line_Buffer(Buffer str, int n)

	@\Fs̕obt@Cӂ̍soD
		  str̃obt@ nsڂoDsR[h͍폜D
		  n  1琔Dos Buffer^ϐ̃obt@Ɋi[iRs[j
		  ĕԂD

	Fstr -- Ώۂ̕(܂މs)D
		  n   -- s̎wD

	߂lFw肳ꂽ nsڂ̕(Buffer^)Ds͊܂܂ȂD
*/
Buffer  get_line_Buffer(Buffer str, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf;
	Buffer ret;

	ret = init_Buffer();
	buf = str.buf;
	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!=LF && buf[i]!=CR && buf[i]!='\0') i++;
		while (buf[i]==LF || buf[i]==CR) i++;
	}
	if (buf[i]=='\0') return  ret;

	pos = i;
	while (buf[i]!=LF && buf[i]!=CR && buf[i]!='\0') i++;
	cnt = i - pos;

	if (cnt!=0) {  
	ret = make_Buffer(cnt);
	if (ret.buf==NULL) return str;
		for(i=0; i<cnt; i++) ret.buf[i] = buf[pos+i];
	}
	ret.vldsz = (int)strlen((const char*)ret.buf);

	return  ret;
}





/**
Buffer  awk_Buffer(Buffer str, char cc, int n)

	@\FBufferɑ΂ awkD
		  cc؂LƂ, str̃obt@ nԖڂ̍ڂԂD
		  n  1琔D

	Fstr -- ΏەD
		  cc  -- ؂蕶D
		  n   -- ڂ̎wD

	߂lFw肳ꂽ nԖڂ̍ڂ̕(Buffer^)D

*/
Buffer  awk_Buffer(Buffer str, char cc, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf = str.buf;
	Buffer item = init_Buffer();

	if (buf==NULL) return item;
	if (n<=0) n = 1;

	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		if (buf[i]==cc) i++;
	}
	if (buf[i]=='\0') return item;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = make_Buffer(cnt);
	if (item.buf==NULL) return item;
	for (i=0; i<cnt; i++) item.buf[i] = buf[pos+i];
	item.vldsz = (int)strlen((const char*)item.buf);

	return item;
}





/**
Buffer  cawk_Buffer(Buffer str, char cc, int n)

	@\FBufferɑ΂(ό`)awkD
		  cc؂LƂ, str̃obt@ nԖڂ̍ڂԂD
		  n  1琔DA cc(؂)͈̋؂Ƃ݂ȂD

	Fstr -- ΏەD
		  cc  -- ؂蕶D
		  n   -- ڂ̎wD

	߂lFw肳ꂽ nԖڂ̍ڂ̕(Buffer^)D
*/
Buffer  cawk_Buffer(Buffer str, char cc, int n)
{
	int i, j, pos, cnt;
	unsigned char* buf = str.buf;
	Buffer item = init_Buffer();

	if (buf==NULL) return item;
	if (n<=0) n = 1;

	i = 0;
	for(j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		while (buf[i]!='\0' && buf[i]==cc) i++;
	}
	if (buf[i]=='\0') return item;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = make_Buffer(cnt);
	if (item.buf==NULL) return item;
	for (i=0; i<cnt; i++) item.buf[i] = buf[pos+i];
	item.vldsz = (int)strlen((const char*)item.buf);

	return item;
}




/**
void kanji_convert_Buffer(Buffer* str)

	@\Fϐ KanjiCode(tools.h) ɏ]ĊR[hϊD

	Fstr -- ϊ镶Buffer^f[^DeD

	F݂ KanjiCode SJIS̏ꍇ̂ EUC SJISɕϊD
 */
void kanji_convert_Buffer(Buffer* str)
{
	int i; 
	unsigned char *c1, *c2;

	if (KanjiCode==SJIS) {
		i = 0;
		while(str->buf[i]!='\0'){
			c1 = &(str->buf[i]);
			c2 = c1 + 1;
			if(*c1>=0xa1 && *c1<=0xfe){
				euc2sjis(c1, c2);	
				i = i + 2;
			} 
			else  i++;
		}
	}			  
	/*
	else if (KanjiCode==EUC) {
		i = 0;
		while(str->buf[i]!='\0'){
			c1 = (unsigned char) str->buf[i];
			c2 = (unsigned char) str->buf[i+1];
			if((c1>=0x81 && c1<=0x9f) || (c1>=0xe0 && c1<=0xff)) {
				sjis2euc(c1, c2);	
				i = i + 2;
			} 
			else  i++;
		}
	} 
	*/			 
}




/**
Buffer  randstr_Buffer(int n)

	@\F_ A-Za-z0-9+/ ܂ł̕ nD

	Fn -- o͂镶D

	߂lF_ɐꂽ n̕(Buffer^)D
*/
Buffer  randstr_Buffer(int n)
{
	char   base[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	Buffer pass;
	int	i, sz;

	pass = make_Buffer(n);
	if (pass.buf==NULL) return pass;

	sz = (int)strlen(base);
	for (i=0; i<n; i++) pass.buf[i] = base[rand()%sz];
	pass.vldsz = n;

	return pass;
}





/**
Buffer  randbit_Buffer(int n) 

	@\F_ n bit̃oCi𐶐D

	Fn -- o͂ bitD

	߂lF_ɐꂽ n bit̃f[^(Buffer^)D
 */
Buffer  randbit_Buffer(int n) 
{
	int   i, sz;
	Buffer str;
	
	sz = (n+7)/8;
	str = make_Buffer(sz);
	if (str.buf==NULL) return str;
	str.vldsz = sz;

	for (i=0; i<n; i++) setBit(str.buf, i, rand()%2);
	return str;	 
}





/**
Buffer  dump_Buffer(Buffer buf)

	@\FBuffer^ϐ̃fobOp 16i Buffer^ϐɏo͂
		  buf.buf buf.vldszoCg16i\D 
		  buf.vldsz<0 ̏ꍇ Ƃ݂ȂD

	Fbuf -- ϊ Buffer^f[^D
*/
#define  DUMP_BUFFER_LINE_SIZE	 85  	// 16*5("%02x "+"%c ") + 5("   "+"\r\n");
#define  DUMP_BUFFER_DELI_START	 48 	// 16*3("%02x ") 
#define  DUMP_BUFFER_CHAR_START	 51  	// 16*3("%02x ") + 3("   ") 

Buffer  dump_Buffer(Buffer buf)
{
	int    sz;
	char   wrkbuf[10];
	Buffer str = init_Buffer();

	if (buf.buf==NULL) return str;
	if (buf.vldsz<0) sz = strlen((const char*)buf.buf)+1;
	else			 sz = buf.vldsz;

	int lineno = (sz + 15)/16;
	str = make_Buffer(lineno*DUMP_BUFFER_LINE_SIZE+1);

	int l;
	for (l=0; l<lineno; l++) {
		int sp = l*DUMP_BUFFER_LINE_SIZE;
		int i  = 0;
		while (i<16) {
			sprintf(wrkbuf, "%02x ", buf.buf[l*16+i]);
			memcpy(str.buf+sp+i*3, wrkbuf, 3);

			if (buf.buf[l*16+i]>=0x20 && buf.buf[l*16+i]<=0x7e) {
				sprintf(wrkbuf, "%c ", buf.buf[l*16+i]);
				memcpy(str.buf+sp+DUMP_BUFFER_CHAR_START+i*2, wrkbuf, 2);
			}
			else {
				memcpy(str.buf+sp+DUMP_BUFFER_CHAR_START+i*2, ". ", 2);
			}

			if (l*16+i>=sz) {
				memcpy(str.buf+sp+i*3, "   ", 3);
				memcpy(str.buf+sp+DUMP_BUFFER_CHAR_START+i*2, "  ", 2);
			}

			i++;
		}
		memcpy(str.buf+sp+DUMP_BUFFER_DELI_START, "   ", 3);
		str.buf[sp+DUMP_BUFFER_LINE_SIZE-2] = '\r';
		str.buf[sp+DUMP_BUFFER_LINE_SIZE-1] = '\n';
	}
	
	str.vldsz = lineno*DUMP_BUFFER_LINE_SIZE;
	return str;
}





/**
int  recalc_strlen_Buffer(Buffer* buf)

	@\FBuffer^ϐ̃f[^𕶎ƌȂāC̒ԂD
		@܂Cvldsz ČvZD
*/
int  recalc_strlen_Buffer(Buffer* buf)
{
	int len = (int)strlen((char*)buf->buf);
	buf->vldsz = len;
	return len;
}





/**
void  chomp_Buffer(Buffer* str)

	@\Fŏ̉sR[hȍ~𖳎D

	Fstr -- s𖳌ɂ镶(Buffer^)D
 */
void  chomp_Buffer(Buffer* str)
{
	int i, len;
	
	if (str->buf==NULL) return;

	len = (int)strlen((const char*)str->buf);
	for (i=0; i<len; i++) {
		if (str->buf[i]==LF || str->buf[i]==CR) {
			str->buf[i] = '\0';
			str->vldsz = (int)strlen((const char*)str->buf);
			return;
		}
	}
}





int  isText_Buffer(Buffer buf)
{
	if (buf.vldsz==(int)strlen((const char*)buf.buf)) return TRUE;
	return FALSE;
}






////////////////////////////////////////////////////////////////////////////////////
//
// File I/O
// 

/**
int  fgets_Buffer(Buffer* str, FILE* fp)

	@\FgfgetsD̓ǂݍ݂ɎgpDsR[h͍폜D
	 	  str̃obt@͗\ߏ\ȑ傫mۂĂȂ΂ȂȂD 

	Fstr -- ǂ݂ނ߂ Buffer^f[^obt@D
		  fp  -- ǂ݂ރt@Cւ̃|C^D

	߂lFǂݍ񂾕̒isR[h܂ށjD
*/
int  fgets_Buffer(Buffer* str, FILE* fp)
{
	int   n, m;

	memset(str->buf, 0, str->bufsz);
	fgets((char*)str->buf, str->bufsz, fp);
	m = (int)strlen((const char*)str->buf);

	n = 0;
	while(str->buf[n]!=LF && str->buf[n]!=CR && str->buf[n]!='\0') n++;
	str->buf[n] = '\0';
	str->vldsz  = n;

//	if (KanjiCode!=US) kanji_convert_Buffer(str);

	return m;
}






/**
int  read_lines_Buffer(Buffer* str, FILE* fp)

	@\Fs̓ǂݍ݁D̓ǂݍ݂ɎgpD
	 	  str̃obt@͗\ߏ\ȑ傫mۂĂȂ΂ȂȂD 

	Fstr -- ǂ݂ނ߂ Buffer^f[^obt@D
		  fp  -- ǂ݂ރt@Cւ̃|C^D

	߂lFǂݍ񂾑Sf[^̒D
*/
int  read_lines_Buffer(Buffer* str, FILE* fp)
{
	Buffer buf;

	buf = make_Buffer(str->bufsz);
	if (buf.buf==NULL) return -1;

	fgets((char*)buf.buf, buf.bufsz, fp);
	buf.vldsz = (int)strlen((const char*)buf.buf);
	copy_Buffer(&buf, str);
	clear_Buffer(&buf);

	while (!feof(fp)) {
		fgets((char*)buf.buf, buf.bufsz, fp);
		buf.vldsz = (int)strlen((const char*)buf.buf);
		cat_Buffer(&buf, str);
		clear_Buffer(&buf);
	}

	free_Buffer(&buf);
	return str->vldsz;
}






/**
Buffer  read_Buffer_file(char* fn)

	@\Ft@C fn ̓e Buffer^ϐɓǂݍݕԂD

*/
Buffer  read_Buffer_file(char* fn)
{
	int     sz;
	Buffer  buf;
	FILE*   fp;

	buf = init_Buffer();

	sz = file_size(fn);
	if (sz<=0) return buf;

	fp = fopen(fn, "rb");
	if (fp==NULL) return buf;

	buf = read_Buffer_data(fp, sz);
	fclose(fp);
	
	return buf;
}




/**
Buffer  read_Buffer_data(FILE* fp, int sz)

	@\Ft@C|C^ fp  szoCgBuffer^ϐɓǂݍ݁CԂD

*/
Buffer  read_Buffer_data(FILE* fp, int sz)
{
	int     cc;
	Buffer  buf;

	buf = init_Buffer();
	if (sz<0) return buf;

	buf = make_Buffer(sz);
	if (buf.buf==NULL) return buf;
	buf.vldsz = sz;

	cc = (int)fread(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) {
		free_Buffer(&buf);
		return buf;
	}
	
	return buf;
}





/**
int   save_Buffer_file(Buffer buf, char* fn)

	@\Ft@C fn  Buffer^ϐ bufށD

	Fbuf --  Buffer^ϐD
		  fn  -- t@C

	߂lFTRUE@ݐD
		@@FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int   save_Buffer_file(Buffer buf, char* fn)
{
	int   cc;
	FILE* fp;

	fp = fopen(fn, "wb");
	if (fp==NULL) return FALSE;

	cc = (int)fwrite(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) return FALSE;
	fclose(fp);
	
	return TRUE;
}






////////////////////////////////////////////////////////////////////////////////////
//
//  񑀍
// 


/**
Buffer  erase_bBuffer(Buffer buf, char* bin, int len);

	@\Fbuf.buf ɂ bin ̃f[^ie1ByteCsj폜D

	Fbuf -- 삷 Bufferϐ
		  bin -- 폜f[^i[ւ̃|C^
		  len -- binf[^̒

	߂lFϊi[ BufferϐDvfree

*/
Buffer  erase_bBuffer(Buffer buf, char* bin, int len)
{
	int	 i, j, n;
	char cc;

	Buffer res = dup_Buffer(buf);
	Buffer wrk = make_Buffer(buf.vldsz+1);

	for (i=0; i<len; i++) {
		cc = bin[i];
		n  = 0;
		for (j=0; j<res.vldsz; j++) {
			if (cc!=res.buf[j]) wrk.buf[n++] = res.buf[j];
		}
		wrk.vldsz = n;

		copy_Buffer(&wrk, &res);
		clear_Buffer(&wrk);
	}
				
	free_Buffer(&wrk);

	return res;
}





/**
Buffer  replace_Buffer(Buffer buf, Buffer frm, Buffer tos)

	@\Fbuf.buf  frm.buf  tos.buf ŒûԂD
		  frm.buf  buf.buf ƃ̈悪dȂĂ͂ȂD
		  ^ Buffer ɂ̂ݑΉD

	Fbuf -- 삷 Bufferϐ
		  frm -- ϊ镶i[Bufferϐ
		  tos -- ϊ̕i[Bufferϐ

	߂lFϊi[ BufferϐDvfree

	#define replace_Buffer(b, f, t)    replace_sBuffer_bystr((b), (char*)((f).buf), (char*)((t).buf))
*/




/**
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos)

	@\Fbuf.buf  frm  tos ŒûԂD
		  frm  buf.buf ƃ̈悪dȂĂ͂ȂD
		  ^ Buffer ɂ̂ݑΉD

	Fbuf -- 삷 Bufferϐ
		  frm -- ϊ镶
		  tos -- ϊ̕

	߂lFϊi[ BufferϐDvfree

	#define replace_sBuffer(b, f, t)    replace_sBuffer_bystr((b), (f), (t))
*/





/**
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos)

	@\Fbuf.buf  frm  tos ŒûԂD
		  frm  buf.buf ƃ̈悪dȂĂ͂ȂD
		  ^ Buffer ɂ̂ݑΉD

	Fbuf -- 삷 Bufferϐ
		  frm -- ϊ镶
		  tos -- ϊ̕

	߂lFϊi[ BufferϐDvfree
*/
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos)
{
	int	i, j, flen, tlen;
	Buffer res;

	res = init_Buffer();
	if (buf.buf==NULL || frm==NULL || tos==NULL) return res;

	flen = (int)strlen(frm);
	tlen = (int)strlen(tos);
	if (buf.vldsz<0) buf.vldsz = (int)strlen((const char*)buf.buf);

	res = make_Buffer((int)((buf.vldsz+tlen-flen+1)*BUFFER_FACT));

	i = j = 0;
	while (i<buf.vldsz && j<res.bufsz) {
		if (!strncmp((const char*)(buf.buf+i), frm, flen)){
			res.vldsz = (int)strlen((const char*)res.buf);
			cat_s2Buffer(tos, &res);
			i += flen;
			j += tlen;
		}
		else {
			res.buf[j++] = buf.buf[i++];
		}
	}

	res.vldsz = (int)strlen((const char*)res.buf);
	return res;
}





/**
int  replace_sBuffer_file(char* fn, Buffer frm, Buffer tos)

	@\FeLXgt@C frm ̕ tos ɏ

	Ffn  -- 삷t@C
		  frm -- ϊ镶
		  tos -- ϊ̕

	߂lFTRUE@ݐD
		@@FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int  replace_sBuffer_file(char* fn, Buffer frm, Buffer tos)
{
	int  ret;
	Buffer buf, res;

	buf = read_Buffer_file(fn);
	if (buf.buf==NULL) return FALSE;

	res = replace_Buffer(buf, frm, tos);
	free_Buffer(&buf);
	if (res.buf==NULL) return FALSE;

	ret = save_Buffer_file(res, fn);
	free_Buffer(&buf);

	return ret;
}








////////////////////////////////////////////////////////////////////////////////////
//
//  wb_ijtt@CI/O
// 
/**
int   save_Buffer2_fp(Buffer key, Buffer buf, FILE* fp)

	@\Ft@C fp  2Buffer^ϐ key bufށD
	      f[^pt@C쐬ƂɎgpD

	Fkey -- ރL[Buffer^ϐD
		  buf -- ރf[^Buffer^ϐD
		  fp  -- t@CfBXNv^

	߂lFTRUE@ݐD
		@@FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int   save_Buffer2_fp(Buffer key, Buffer buf, FILE* fp)
{
	int   cc;
	
	cc = save_Buffer_fp(key, fp);
	if (!cc) return FALSE;

	cc = save_Buffer_fp(buf, fp);
	if (!cc) return FALSE;
	
	return TRUE;
}





/**
int   save_Buffer_fp(Buffer buf, FILE* fp)

	@\Ft@C fp  Buffer^ϐ bufށDbufɐ旧C
	@@@buf̑傫 int ŏ܂D

	Fbuf --  Buffer^ϐD
		  fp  -- t@CfBXNv^

	߂lFTRUE@ݐD
		@@FALSE ݂ɎsDt@C̓e͕ۏ؂ȂD
*/
int   save_Buffer_fp(Buffer buf, FILE* fp)
{
	int   cc, sz;

	sz = htonl(buf.vldsz);
	cc = (int)fwrite(&sz, sizeof(sz), 1, fp);
	if (cc!=1) return FALSE;

	cc = (int)fwrite(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) return FALSE;
	
	return TRUE;
}





/**
Buffer  read_Buffer_fp(FILE* fp)

	@\Ft@C fp  Buffer^ϐ bufǂݍށD
		  t@C̐擪Ƀt@CTCY4Byte̒lKv

	Ffp  -- t@CfBXNv^
	
	߂lFǂݍ buf Buffer^ϐD

*/
Buffer  read_Buffer_fp(FILE* fp)
{
	int     cc, sz;
	Buffer  buf;

	buf = init_Buffer();
	cc = (int)fread(&sz, sizeof(sz), 1, fp);
	if (cc!=1) return buf;
	sz = ntohl(sz);

	buf = make_Buffer(sz);
	if (buf.buf==NULL) return buf;
	buf.vldsz = sz;
	cc = (int)fread(buf.buf, buf.vldsz, 1, fp);
	if (cc!=1) {
		free_Buffer(&buf);
		return buf;
	}
	
	return buf;
}





/**
int  read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp)

	@\Ft@C fp  2Buffer^ϐ key bufǂݍށD
	      f[^pt@C̓ǂݍݎɎgpD

	Fkey -- ǂݍރL[Buffer^ϐւ̃|C^D
		  buf -- ǂݍރf[^Buffer^ϐւ̃|C^D
		  fp  -- t@CfBXNv^
	
	߂lFTRUE@ǂݍݐD
		@@FALSE ǂݍ݂ɎsD

*/
int  read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp)
{
	if (key==NULL || buf==NULL) return FALSE;

	*key = init_Buffer();
	*buf = init_Buffer();
	
	*key = read_Buffer_fp(fp);
	if (key->buf==NULL) return FALSE;

	*buf = read_Buffer_fp(fp);
	if (buf->buf==NULL) {
		free_Buffer(key);
		return FALSE;
	}

	return TRUE;
}









/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// etc. etc.
//

/**
char*  dup_string(char* src)

	@\FRs[D

*/
char*  dup_string(char* src)
{
	if (src==NULL) return NULL;
		
	Buffer buf = make_Buffer_bystr(src);
	return (char*)buf.buf;
}



