/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_BUFFER_H_
#define  __JBXL_BUFFER_H_


/**
	Buffer^T|[gwb_  buffer.h

  	ˑ֌W
	  	#include "common.h"
	  	#include "tools.h"
 */


#include "tools.h"






/**
Buffer^

  Buffer^͕񑀍쎞̔zjh~Dbuffer.c Buffer^Ή
  ֐g, vO}(Cup)͔zjlKv͖D
  ʏ, vldsz̓vO}(Cup)ۏ؂Ȃ΂ȂȂD
  Buffer^ϐԂ֐ł͏ vldszݒ肳Ă邩ӂׂłD
  ,f[^̏ꍇ -1ȉɂĂĂ悢D
   bufsz̓obt@̒ϐłCvO}Ă͂ȂD

  Buffer^ϐ̓obt@̈𓮓IɊmۂ̂,gpIK
  del_Buffer(܂ free_Buffer)Ńobt@̈JȂ΂ȂȂD

  Fbuf[bufsz]̓VXegp̂,vO} buf[bufsz]͖
	  ̂ƂĈƁD
  
  oϐ
	int   bufsz		 mۂĂobt@̑傫 - 1D
	int   vldsz		 oCif[^ꍇ,f[^̗L߂D
	int   state		 ϐ̏Ԃ\D
	unsigned char* buf  obt@̐擪ւ̃|C^Dstr[bufsz]͕K 0x00ƂȂD
*/

typedef struct _Buffer {
	int   bufsz;
	int   vldsz;
	int   state;
	unsigned char* buf;
} Buffer;




// Buffer ϐ̗̈mۂ̂߂̗̈m۔{
#define  BUFFER_FACT   (1.5)





/**/
Buffer* new_Buffer(void);
Buffer  init_Buffer(void);
Buffer  make_Buffer(int sz);
Buffer  make_Buffer_bychar(unsigned char cc);
Buffer  set_Buffer(void* buf, int sz);
Buffer  dup_Buffer(Buffer str);
Buffer  rept_Buffer(unsigned char cc, int n);

void	del_Buffer(Buffer** buf);
void	free_Buffer(Buffer* buf);
void	clear_Buffer(Buffer* buf);

#define make_Buffer_bybin(s, l)	set_Buffer((void*)(s), (l))
#define make_Buffer_bin(s, l)	set_Buffer((void*)(s), (l))
#define make_Buffer_bystr(s)	set_Buffer((void*)(s), -1)
#define make_Buffer_str(s)		set_Buffer((void*)(s), -1)
#define make_Buffer_char(s)  	make_Buffer_bychar(s)

int		copy_Buffer(Buffer* src, Buffer* dst);
int		cat_Buffer (Buffer* src, Buffer* dst);

int		copy_b2Buffer(void* src, Buffer* dst, int sz);
int		cat_b2Buffer (void* src, Buffer* dst, int sz);
int		copy_i2Buffer(int src, Buffer* dst);
int		cat_i2Buffer (int src, Buffer* dst);

#define copy_s2Buffer(s, d) 	copy_b2Buffer((void*)(s), (d), (int)strlen((const char*)(s)))
#define cat_s2Buffer(s, d) 	 	cat_b2Buffer((void*)(s),  (d), (int)strlen((const char*)(s)))



// c[
void	kanji_convert_Buffer(Buffer* mesg);
Buffer  encode_base64_Buffer(Buffer buf);
Buffer  decode_base64_Buffer(Buffer buf);

Buffer  get_line_Buffer(Buffer buf, int n);  
Buffer  awk_Buffer (Buffer buf, char cc, int n);
Buffer  cawk_Buffer(Buffer buf, char cc, int n);

int	 	cmp_Buffer(Buffer src, Buffer dst, int n);
void	chomp_Buffer(Buffer* buf);
int		isText_Buffer(Buffer buf);
Buffer	dump_Buffer(Buffer buf);
int		recalc_strlen_Buffer(Buffer* buf);

//#define strlen_Buffer(b) 			strlen((char*)((b).buf))
#define strcmp_Buffer(a, b)			cmp_Buffer((a), (b), 0)
#define strncmp_Buffer(a, b, n)		cmp_Buffer((a), (b), (n))
#define bincmp_Buffer(a, b)			cmp_Buffer((a), (b), 0)
#define binncmp_Buffer(a, b, n)		cmp_Buffer((a), (b), (n))

Buffer  randstr_Buffer(int n);			   // p n 
Buffer  randbit_Buffer(int n);			   // rbg n 


// t@CI/O
int	 	fgets_Buffer(Buffer* str, FILE* fp);	// gfgets
int		read_lines_Buffer(Buffer* str, FILE* fp);

Buffer  read_Buffer_file(char* fn);
Buffer  read_Buffer_data(FILE* fp, int sz);
int	 	save_Buffer_file(Buffer buf, char* fn);


// 폜
Buffer  erase_bBuffer(Buffer buf, char* bin, int len);
#define erase_Buffer(b, f)			erase_bBuffer((b), (char*)((f).buf), (f).vldsz))
#define erase_sBuffer(b, f)			erase_bBuffer((b), (char*)(f), strlen(f))


// u
Buffer  replace_sBuffer_bystr(Buffer buf, char* frm, char* tos);
int	 	replace_sBuffer_file(char* fn, Buffer frm, Buffer tos);
#define replace_sBuffer(b, f, t)	replace_sBuffer_bystr((b), (f), (t))
#define replace_Buffer(b, f, t)		replace_sBuffer_bystr((b), (char*)((f).buf), (char*)((t).buf))



// wb_()tt@CI/O
int	 	save_Buffer_fp(Buffer, FILE*);
Buffer  read_Buffer_fp(FILE*);
int   	save_Buffer2_fp(Buffer  key, Buffer  buf, FILE* fp);
int  	read_Buffer2_fp(Buffer* key, Buffer* buf, FILE* fp);



// ̑
char*   dup_string(char* src);
#define dup_str(s)		dup_string((s))



/**/





#endif




