/*
OtBbNpiCT摜jt@Co͊֐  
							   	

  wb_
	  #include "Gio.h"
*/


#include "tools++.h"

#include "ClassBox.h"
#include "Gio.h"
#include "JpegTool.h"


using namespace jbxl;




///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// t@CʎqƋʃwb_ɂI/OT|[g


/**
CmnHead   jbxl::readRasData(FILE* fp)

	@\: SUN RASTER`̃OtBbNt@CǂݍށD

	: *fp -- ǂݍނst@C̃t@CʎqD

	߂lFǂݍ񂾃OtBbNf[^̋ʃwb_D
			G[ꍇ kindo HEADER_ERRORƂȂD
			܂G[̎ނɂ xsizeωD
			   xsize   ERROR_GRAPH_MEMORY  G[D

  	oOF24rbgȏ̃GfBA͖
*/
CmnHead   jbxl::readRasData(FILE* fp)
{
	RasHead rhd;
	CmnHead  hd;
	int   i, linebyte, databyte;
	uByte null[2], *buf;
	sWord* wptr;

	hd.kind  = RAS_DATA;
	hd.bsize = 32;
	hd.buf   = NULL;
	hd.grptr = NULL;

	fseek(fp, 0, 0);
	fread(&rhd, hd.bsize, 1, fp);
	ntoh_st(&rhd, 4);

	hd.xsize = rhd.ras_width;
	hd.ysize = rhd.ras_height;
	hd.zsize = 1;
	hd.depth = rhd.ras_depth;
	hd.lsize = hd.xsize*hd.ysize*((hd.depth+7)/8);
	hd.buf   = (uByte*)malloc(hd.bsize);
	if (hd.buf==NULL) {
 		hd.xsize = ERROR_GRAPH_MEMORY;
		hd.kind  = HEADER_ERROR;
		return hd;
	}
	memcpy(hd.buf, (uByte*)&rhd, hd.bsize);

	hd.grptr = (uByte*)malloc(hd.lsize);
	if (hd.grptr==NULL) {
		freeNull(hd.buf);
 		hd.xsize = ERROR_GRAPH_MEMORY;
		hd.kind  = HEADER_ERROR;
		return hd;
	}
	buf = (uByte*)hd.grptr;

	fseek(fp, rhd.ras_maplength, 1); 

	databyte = hd.xsize*((hd.depth+7)/8);
	linebyte = rhd.ras_length/hd.ysize;

	if (databyte==linebyte) {
		fread(buf, hd.lsize, 1, fp);
	}
	else {
		for (i=0; i<hd.ysize; i++) {
			fread(buf, databyte, 1, fp);
			fread(null, linebyte-databyte, 1, fp);
			buf += databyte;
		}
	}

	if (hd.depth==16){
		wptr = (sWord*)hd.grptr;
		for(i=0; i<hd.xsize*hd.ysize; i++) wptr[i] = ntohs(wptr[i]);
	}

	return hd;
}






/**
int   jbxl::writeRasData(FILE* fp, CmnHead* hd, int obit)

	@\: FXȉ摜f[^SUN RASTER^Ńt@CɕۑD

	: fp   -- ۑt@C|C^D
		  *hd  -- ۑf[^qʃwb_D
		  obit -- SUN RASTER̂PsNZ̃rbg(8, 24T|[g)D

	߂lF0>   񂾃oCgD
			ERROR_GRAPH_MEMORY   G[D
*/
int   jbxl::writeRasData(FILE* fp, CmnHead* hd, int obit)
{
	RasHead shd;
	int  i, j, k, l, linebyte, databyte, depth, lsize;
	uByte null=0x00, *ptr, *buf;

	obit = Xabs(obit);
	if (hd->kind == RAS_DATA) {
		unsigned int u;
		memcpy((sByte*)&shd, hd->buf, hd->bsize);
		ptr = (uByte*)malloc(hd->lsize);
  		if (ptr==NULL)  return ERROR_GRAPH_MEMORY;
		lsize = hd->lsize;
		for (u=0; u<hd->lsize; u++) ptr[u] = hd->grptr[u];
	}
	else { // CT -> RAS 
		if (hd->depth==16) {

	   		if (obit==8) depth = 8;
			else		 depth = 24;

			lsize = hd->xsize*hd->ysize*depth/8;
			buf = (uByte*)malloc(lsize);
  			if (buf==NULL)  return ERROR_GRAPH_MEMORY;

			if (obit==8) {
				int   max = 255; // 8bit mode ł̍ől 
				uWord* wp = (uWord*)hd->grptr;
				for (i=0; i<hd->xsize*hd->ysize; i++) {
	   				max = Max(max, wp[i]);
				}
				for (i=0; i<hd->ysize*hd->xsize; i++) {
					buf[i] = 255*wp[i]/max;
				}
	   		}
			else {
				k = l = 0;
				for (i=0; i<hd->ysize*hd->xsize; i++) {
					buf[k++] = hd->grptr[l++];
					buf[k++] = hd->grptr[l++];
					buf[k++] = null;
				}
			}
		}
		else {
			depth = hd->depth;
			lsize = hd->lsize;
			buf   = (uByte*)hd->grptr;
		}

		databyte = hd->xsize*depth/8;
		linebyte = lsize/hd->ysize;
		if (linebyte%2==1) {
			linebyte++;
			lsize = linebyte*hd->ysize;
		}

		shd.ras_magic	 = RAS_MAGIC;
		shd.ras_width	 = hd->xsize;
		shd.ras_height	 = hd->ysize;
		shd.ras_depth	 = depth;
		shd.ras_length	 = lsize;
		shd.ras_type	 = RT_STANDARD;
		shd.ras_maptype  = RMT_NONE;
		shd.ras_maplength= 0;

		ptr = (uByte*)malloc(lsize);
  		if (ptr==NULL) {
			if (hd->depth==16) free(buf);
			return -2;
  		}

		k = l = 0;
		for (i=0 ; i<hd->ysize; i++) {
			for (j=0; j<databyte; j++)			ptr[k++] = buf[l++];
			for (j=0; j<linebyte-databyte; j++) ptr[k++] = null;
		}

		if (hd->depth==16) free(buf);
	}

	hton_st(&shd, 4);
	fwrite(&shd, sizeof(RasHead), 1, fp);
	fwrite(ptr, lsize, 1, fp);

	free(ptr);
	return  sizeof(RasHead)+lsize;
}





/**
CmnHead   jbxl::readUserSetData(FILE* fp, CmnHead* chd, bool cnt=false);

	@\: Iy[^w̃wb_`ɂăOtBbNt@CǂݍށD
		  wb_`̃`FbNit@CTCY̐Ȃǁj͍sȂ̂ŁC͌Ăяo̐ӔCƂȂD
		  gGfBAΉD
		  JE^̏ꍇ͒xȂD


	: *fp ---- ǂݍނst@C̃t@CʎqD
		  *chd --- ǂݍރt@C̃wb_ꂽ CmnHead. 
						JE^gpꍇF  kind, xsize, ysize, zsize, bsize K{D
						JE^gpȂꍇFkind, bsize, lseize K{D
		   cnt --- ǂݍݏ󋵃JE^gp邩ǂDtrue -- gpD

	߂lFǂݍ񂾃OtBbNf[^̋ʃwb_D
			G[ꍇ kindo HEADER_ERRORƂȂD
			܂G[̎ނɂ xsizeωD
			   xsize   ERROR_GRAPH_HEADER  Iy[^w̃wb_ȂD
					   ERROR_GRAPH_MEMORY  G[D
					   ERROR_GRAPH_CANCEL  LZD

	oOF24rbgȏ̃GfBA͖
*/
CmnHead   jbxl::readUserSetData(FILE* fp, CmnHead* chd, bool cnt)
{
	CmnHead hd;
	init_CmnHead(&hd);
	CVCounter* counter = NULL;

	if (chd==NULL) {
		hd.xsize = ERROR_GRAPH_MEMORY;
		return hd;
	}
	else if ((chd->kind&0x0ff)!=USERSET_DATA) {
		hd.xsize = ERROR_GRAPH_MEMORY;
		return hd;
	}
	hd = *chd;

	// wb_ǂݍ
	fseek(fp, 0, 0);
	hd.buf = (uByte*)malloc(hd.bsize);
	if (hd.buf==NULL) {
		hd.xsize = ERROR_GRAPH_MEMORY;
		hd.kind  = HEADER_ERROR;
		return hd;
	}
	fread((void*)hd.buf, hd.bsize, 1, fp);


	// JE^
	if (hd.zsize>=10 && cnt) {
		counter = GetUsableGlobalCounter();
		if (counter!=NULL) {
			//counter->SetTitle("[Uwt@Cǂݍݒ");
			counter->SetMax((hd.zsize+1)/10);
			counter->SetPos(1);
		}
	}

	hd.grptr = (uByte*)malloc(hd.lsize);
	if (hd.grptr==NULL) {
		freeNull(hd.buf);
		hd.xsize = ERROR_GRAPH_MEMORY;
		hd.kind  = HEADER_ERROR;
		return hd;
	}

	fseek(fp, hd.bsize, 0);

	if (counter==NULL) {
		fread(hd.grptr, hd.lsize, 1, fp);
	}
	else {
		int psize = hd.xsize*hd.ysize*((hd.depth+7)/8);
		for (int i=0; i<hd.zsize; i++) {
			fread(hd.grptr+i*psize, psize, 1, fp);
			if (i%10==0) {
				counter->StepIt();
				if (counter->isCanceled()) {	// LZ
					free_CmnHead(&hd);
	   				hd.xsize = ERROR_GRAPH_CANCEL;
					hd.kind  = HEADER_ERROR;
					return hd;
				}
			}
		}
	}

	if (hd.depth==16) {
		if (checkBit(chd->kind, HAS_LENDIAN) && is_little_endian()) {
			// CPU ƃt@C Little EndianȂ̂ŁCȂD
		}
		else {
			sWord* wptr = (sWord*)hd.grptr;
			for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) wptr[i] = ntohs(wptr[i]);
		}
	}

	if (counter!=NULL) counter->PutFill();
	return hd;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CTt@CT|[g
//

/**
CmnHead   jbxl::readMoonFile(char* fn, bool no_ntoh)

	@\: MOON_DATA`i16bitj̃OtBbNt@CǂݍށD

	: *fp -- ǂݍނst@CD
		  no_ntoh -- truȅꍇCGfBA̕ϊsȂD

	߂lFǂݍ񂾃OtBbNf[^̋ʃwb_D
			G[ꍇ kindo HEADER_ERRORƂȂD
			܂G[̎ނɂ xsizeωD
			   xsize   ERROR_GRAPH_MEMORY G[D
*/
CmnHead   jbxl::readMoonFile(char* fn, bool no_ntoh)
{
	CmnHead hd;
	FILE* fp;
	unsigned int fsz;

	memset(&hd, 0, sizeof(CmnHead));
	hd.kind  = HEADER_ERROR;

	fsz = file_size(fn);
	if (fsz==0) {
		hd.xsize = ERROR_GRAPH_NOFILE;
		return hd;
	}
	if ((fp=fopen(fn,"rb"))==NULL) {
		hd.xsize = ERROR_GRAPH_OPFILE;
		return hd;
	}

	hd = readMoonData(fp, fsz, no_ntoh);
	return hd;
}





/**
CmnHead   jbxl::readMoonData(FILE* fp, unsigned int fsz, bool no_ntoh)

	@\: MOON_DATA`i16bitj̃OtBbNt@CǂݍށD

	: *fp -- ǂݍނst@C̃t@CʎqD
		  fsz -- t@C̃TCYi`FbNɎgp, 0ȉȂ`FbNȂj
		  no_ntoh -- truȅꍇCGfBA̕ϊsȂD

	߂lFǂݍ񂾃OtBbNf[^̋ʃwb_D
			G[ꍇ kindo HEADER_ERRORƂȂD
			܂G[̎ނɂ xsizeωD
			   xsize   -2  G[D
*/
CmnHead   jbxl::readMoonData(FILE* fp, unsigned int fsz, bool no_ntoh)
{
	int	i;
	CTHead chd;
	CmnHead hd;

	hd.kind  = HEADER_ERROR;
	hd.bsize = 64;		// Moon`̃wb_TCY

	// wb_ǂݍ
	fseek(fp, 0, 0);
	fread((void*)&chd, hd.bsize, 1, fp);
	ntoh_st(&chd, 2);

	hd.xsize = chd.xsize - chd.cutleft - chd.cutright;
	hd.ysize = chd.ysize - chd.cutup   - chd.cutdown;
	hd.zsize = 1;
	hd.depth = 16;
	hd.lsize = hd.xsize*hd.ysize*(hd.depth/8);
	hd.buf   = NULL;
	hd.grptr = NULL;
	if (fsz>0 && fsz!=hd.bsize+hd.lsize) return hd;
	
	hd.buf   = (uByte*)malloc(hd.bsize);
	if (hd.buf==NULL) {
		hd.xsize = ERROR_GRAPH_MEMORY;
		return hd;
	}
	hd.kind  = MOON_DATA;
	memcpy(hd.buf, &chd, hd.bsize);

	hd.grptr = (uByte*)malloc(hd.lsize);
	if (hd.grptr==NULL) {
		freeNull(hd.buf);
		hd.xsize = ERROR_GRAPH_MEMORY;
		hd.kind  = HEADER_ERROR;
		return hd;
	}

	fseek(fp, hd.bsize, 0);
	fread(hd.grptr, hd.lsize, 1, fp);

	if (!no_ntoh) {
		sWord* wptr = (sWord*)hd.grptr;
		for (i=0; i<hd.xsize*hd.ysize; i++) wptr[i] = ntohs(wptr[i]);
	}
	return hd;
}








///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// DICOM

/**
int   jbxl::dicomHeader(FILE* fp, int fsize, int* dsize, int* xsize, int* ysize, int* depth, float* rzxy)

	@\: 
		DICOM^̃t@Cwb_ǂ݂D

	: 
		fp	  -- DICOM^t@Cւ̃t@Cʎq
		fsize -- t@C̃TCYD
		*dsize - OtBbNf[^̑傫i[D

	߂l:
		>1  ǂ݂񂾃wb_̑傫 (ByteP)D
		0   wb_̋؂ʂłȂD
		ERROR_IVDARG_GRAPH  sȈ (fp, fsize, dsize)
		ERROR_GRAPH_MEMORY  s
	
		*dsize  OtBbNf[^̑傫
		*rzxy   Z̘cD0.0 ȂsD
*/
int   jbxl::dicomHeader(FILE* fp, int fsize, int* dsize, int* xsize, int* ysize, int* depth, float* rzxy)
{
	int    i, j, sz, rp, ef;
	int    ln, hsize;
	int	   xs = 0, ys = 0, dp = 0;
	float  rz = 0.0;

	uWord  dt, cn[2];
	uWord* wp;


	if (fp==NULL || fsize<=0 || dsize==NULL) return ERROR_GRAPH_IVDARG;

	*dsize = 0;
	if (rzxy!=NULL) *rzxy = 0.0;
	ef = OFF;
	fseek(fp, 0, 0);

	/////////////////////////////////////////////////////////////////////
	// wb_̋؂o
	rp = (int)fread(&dt, sizeof(uWord), 1, fp);
	while(!feof(fp) && ef!=ON) {
		//if ((uWord)ntohs(dt)==0xe07f) {
		if (dt==DICOM_PIXEL_GROUP) {
			rp += (int)fread(&dt, sizeof(uWord), 1, fp);
			//if ((uWord)ntohs(dt)==0x1000) {
			if (dt==DICOM_PIXEL_ELEMENT) {
				rp += (int)fread(&cn, sizeof(uWord), 2, fp);
				//if ((uWord)ntohs(cn[0])==0x4f57 && cn[1]==0x0000) {
				if (cn[0]==DICOM_PIXCEL_VR && cn[1]==0x0000) {
					rp += (int)fread(&cn, sizeof(uWord), 2, fp);
					*dsize = *(int*)cn;
					hsize = rp*sizeof(uWord);
					if (fsize>=*dsize+hsize) {		// footer
						ef = ON;
						break;
					}
				}
				else {
					*dsize = *(int*)cn;
					hsize = rp*sizeof(uWord);
					if (fsize>=*dsize+hsize) {		// footer
						ef = ON;
						break;
					}
				}
			}
  		}
		rp += (int)fread(&dt, sizeof(uWord), 1, fp);
	}

	if (!ef) return 0;

	sz = rp*sizeof(uWord);
	wp = (uWord*)malloc(sz);
	if (wp==NULL) return ERROR_GRAPH_MEMORY;


	/////////////////////////////////////////////////////////////////////
	// wb_ǂݍ
	fseek(fp, 0, 0);
	fread(wp, sz, 1, fp);


	for (i=0; i<sz/2-3; i++) {
		//if ((uWord)ntohs(wp[i])==0x2800 && (uWord)ntohs(wp[i+1])==0x3000) {
		if (wp[i]==DICOM_IMAGE_GROUP) {

			// Z̘c
			if (wp[i+1]==DICOM_PXLSPC_ELEMENT) {
				char   rx[LNAME], ry[LNAME];
				uByte* bp;

				memset(rx, 0, LNAME);
				memset(ry, 0, LNAME);

				if (wp[i+2]==DICOM_STR_VR) ln = wp[i+3];
				else                       ln = *(int*)&wp[i+2];

				if (ln<LNAME-1) {
					bp = (uByte*)&wp[i+4];
					j  = 0;
					while (j<ln-1 && bp[j]!='\\') {
						rx[j] = bp[j];
						j++;
					}
					ln -= j + 1;
					bp += j + 1;
					j   = 0;
					while (j<ln-1 && bp[j]!=' ') {
						ry[j] = bp[j];
						j++;
					}
					if (!strcmp(rx, ry)) {
						rz = (float)atof(rx);
					} 
				}
			}

			// X TCY
			else if (wp[i+1]==DICOM_XSIZE_ELEMENT) {
				if (wp[i+2]==DICOM_INT_VR) ln = wp[i+3];
				else                       ln = *(int*)&wp[i+2];
				if (ln==2) {
					xs = (int)*(sWord*)&wp[i+4];
				}
				else if (ln==4) {
					xs = *(int*)&wp[i+4];
				}
			}

			// Y TCY
			else if (wp[i+1]==DICOM_YSIZE_ELEMENT) {
				if (wp[i+2]==DICOM_INT_VR) ln = wp[i+3];
				else                       ln = *(int*)&wp[i+2];
				if (ln==2) {
					ys = (int)*(sWord*)&wp[i+4];
				}
				else if (ln==4) {
					ys = *(int*)&wp[i+4];
				}
			}

			// Depth
			else if (wp[i+1]==DICOM_DEPTH_ELEMENT) {
				if (wp[i+2]==DICOM_INT_VR) ln = wp[i+3];
				else                       ln = *(int*)&wp[i+2];
				if (ln==2) {
					dp = (int)*(sWord*)&wp[i+4];
				}
				else if (ln==4) {
					dp = *(int*)&wp[i+4];
				}
			}
		}
	}
	free(wp);
	
	if (rzxy!=NULL)  *rzxy  = rz;
	if (xsize!=NULL) *xsize = xs;
	if (ysize!=NULL) *ysize = ys;
	if (depth!=NULL) *depth = dp;
		
	return sz;
}





/**
MSGraph<sWord>   jbxl::readDicomFile(char* fn)

	@\F
		DICOM`̃f[^ǂݍށD
		݂͂܂Iȋ@\ȂD

	oOF
		depth = 16bit Œ

*/
MSGraph<sWord>   jbxl::readDicomFile(char* fn)
{
	int	fsize;
	FILE*  fp;
	MSGraph<sWord> vp;

	memset(&vp, 0, sizeof(MSGraph<sWord>));

	fsize = file_size(fn);
	if (fsize<=0) {
		vp.xs = ERROR_GRAPH_NOFILE;
		return vp;
	}

	if ((fp=fopen(fn,"r"))==NULL) {
		vp.xs = ERROR_GRAPH_OPFILE;
		return vp;
	}

	vp = readDicomData(fp, fsize);
	fclose(fp);

	return vp;
}





MSGraph<sWord>   jbxl::readDicomData(FILE* fp, int fsize)
{
	int	   sz, dsize;
	int    xsize, ysize, depth;
	float  rzxy;
	MSGraph<sWord> vp;

	memset(&vp, 0, sizeof(MSGraph<sWord>));

	sz = dicomHeader(fp, fsize, &dsize, &xsize, &ysize, &depth, &rzxy);
	if (sz<=0) {
		vp.xs = ERROR_GRAPH_HEADER;
		return vp;
	}

	if (dsize!=xsize*ysize*((depth+7)/8)) {
		vp.xs = ERROR_GRAPH_HEADER;
		return vp;
	}

	if ((depth+7)/8!=2) {
		vp.xs = ERROR_GRAPH_HEADER;
		return vp;
	}

	vp.set(xsize, ysize, 1, 0, 0, rzxy);

	fseek(fp, sz, 0);
	fread(vp.gp, dsize, 1, fp);

	return vp;
}






///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// t@CƋʃwb_ɂI/O

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// t@CƋʃwb_

/**
CmnHead   jbxl::readXHead(char* fn)

	@\: t@C Commonwb_ǂݍށDf[^{͓̂ǂݍ܂ȂD
		@t@Cʂ̎ʂɎgpD

	: *fname -- wb_̓ǂݍ݂st@CD

	߂lFǂݍ񂾃OtBbNf[^Lq鋤ʃwb_if[^{͖̂jD
			G[Ȃ kind = HEADER_ERROR ƂȂD
*/
CmnHead   jbxl::readXHead(char* fn, CmnHead* chd)
{
	FILE	*fp;
	int		fsz, hsz, csz;
	CmnHead hd;


	hsz = sizeof(CmnHead);
	memset(&hd, 0, hsz);
	hd.kind = HEADER_ERROR;

	fsz = (int)file_size(fn);
	if (fsz<=0) {
		hd.xsize = ERROR_GRAPH_NOFILE;
		return hd;
	}
 

	///////////////////////////////////////////////////////////////////////
	// Iy[^w̃f[^`mFi\߃wb_ɏ񂪐ݒ肳Ăj
	//
	if (chd!=NULL && (chd->kind&0x00ff)==USERSET_DATA) {
		if (chd->zsize<=0) chd->zsize = 1;
		chd->lsize = chd->xsize*chd->ysize*chd->zsize*((chd->depth+7)/8);
		if (fsz==(int)(chd->bsize+chd->lsize)) {	// t@CTCỸ`FbN
			return *chd;
		}
	}


	if ((fp=fopen(fn,"rb"))==NULL) {
		hd.xsize = ERROR_GRAPH_OPFILE;
		return hd;
	}


	///////////////////////////////////////////////////////////////////////
	// ʃwb_̓ǂݍ
	//
	fseek(fp, 0, 0);
	fread(&hd, hsz, 1, fp);
	hd.grptr = NULL;
	ntoh_st(&hd, 4);


	// Sun Raster
	if (hd.kind==RAS_MAGIC) {
		hd.kind = RAS_DATA;
		DEBUG_MESGLN("readXHead: Sun Raster File");
		fclose(fp);
		hd.depth = hd.zsize;
		hd.zsize = 1;
		hd.lsize = file_size(fn) - sizeof(RasHead);
		hd.bsize = 0;
		hd.buf = NULL;
		hd.grptr = NULL;
		return hd;
	}


	// Common wb_
	if (hd.kind>0 && hd.kind<=NUM_KDATA && fsz==(int)(hsz+hd.bsize+hd.lsize)) {
		if (hd.zsize<=0) hd.zsize = 1;
		if (hd.bsize>0) {
			hd.buf = (uByte*)malloc(hd.bsize);
			if (hd.buf==NULL) {
				free_CmnHead(&hd);
				hd.xsize = ERROR_GRAPH_MEMORY;
				hd.kind  = HEADER_ERROR;
				fclose(fp);
				return hd;
			}

			fseek(fp, hsz, 0);
			fread(hd.buf, hd.bsize, 1, fp);
			ntoh_ar((sWord*)hd.buf, hd.bsize);		
		}

		DEBUG_MESGLN("readXHead: Common wb_");
		DEBUG_MESGLN("readXHead: wb_     kind  = %d", hd.kind);
		DEBUG_MESGLN("readXHead: t@CTCY fsz   = %d", fsz);
		DEBUG_MESGLN("readXHead: wb_TCY   hsz   = %d", sizeof(CmnHead));
		DEBUG_MESGLN("readXHead: wb_obt@ bsize = %d", hd.bsize);
		DEBUG_MESGLN("readXHead: f[^TCY   lsize = %d", hd.lsize);
		DEBUG_MESGLN("readXHead: TCY         %dx%dx%d %d", hd.xsize, hd.ysize, hd.zsize, hd.depth);
		
		fclose(fp);
		return hd;
	}
	memset(&hd, 0, hsz);


	///////////////////////////////////////////////////////////////////////
	// CT File (Moon)
	//
	CTHead cthd;
	csz = sizeof(CTHead);
	fseek(fp, 0, 0);
	fread(&cthd, csz, 1, fp);
	ntoh_st(&cthd, 2);

	hd.xsize = cthd.xsize - cthd.cutleft - cthd.cutright;
	hd.ysize = cthd.ysize - cthd.cutup   - cthd.cutdown;
	hd.zsize = 1;
	hd.depth = 16;
	hd.bsize = csz;
	hd.lsize = hd.xsize*hd.ysize*hd.zsize*((hd.depth+7)/8);

	if (fsz==(int)(hd.bsize+hd.lsize)) {
		hd.kind = MOON_DATA;
		hd.buf  = (uByte*)malloc(csz);
		if (hd.buf==NULL) {
			free_CmnHead(&hd);
			hd.xsize = ERROR_GRAPH_MEMORY;
			hd.kind  = HEADER_ERROR;
			fclose(fp);
			return hd;
		}
		memcpy(hd.buf, &cthd, csz);

		DEBUG_MESGLN("readXHead: CT t@C");
		DEBUG_MESGLN("readXHead: wb_     kind  = %d", hd.kind);
		DEBUG_MESGLN("readXHead: t@CTCY fsz   = %d", fsz);
		DEBUG_MESGLN("readXHead: wb_TCY   hsz   = %d", sizeof(CmnHead));
		DEBUG_MESGLN("readXHead: wb_obt@ bsize = %d", hd.bsize);
		DEBUG_MESGLN("readXHead: f[^TCY   lsize = %d", hd.lsize);
		DEBUG_MESGLN("readXHead: TCY         %dx%dx%d %d", hd.xsize, hd.ysize, hd.zsize, hd.depth);

		fclose(fp);
		return hd;
	}
	memset(&hd, 0, hsz);


	///////////////////////////////////////////////////////////////////////
	// Dicom
	//
	int	  ls, sz, dsize, xsize, ysize, depth;
	float rzxy;

	sz = dicomHeader(fp, fsz, &dsize, &xsize, &ysize, &depth, &rzxy);
	ls = xsize*ysize*((depth+7)/8);
	if (sz>0 && dsize==ls) {
		hd.kind  = DICOM_DATA;
		hd.xsize = xsize;
		hd.ysize = ysize;
		hd.zsize = 1;
		hd.depth = depth;
		hd.bsize = sizeof(CTHead);
		hd.lsize = ls;
		hd.buf   = (uByte*)malloc(hd.bsize);
		hd.grptr = NULL; 
								 
		CTHead* pcthd = (CTHead*)hd.buf;
		memset(pcthd, 0, hd.bsize);
		pcthd->xsize  = hd.xsize;
		pcthd->ysize  = hd.ysize;

		if (rzxy>0.0) {
			pcthd->anydata[0] = (sWord)(rzxy*RZXY_RATE);
			pcthd->anydata[1] = RZXY_RATE;
			hd.kind |= HAS_RZXY;
		}

		fclose(fp);
		return hd;
	}


	///////////////////////////////////////////////////////////////////////
	// Well Known t@C
	//
	fseek(fp, 0, 0);
	Buffer buf = read_Buffer_data(fp, 32);


	// TIFF
	/*
	if (head[0]=='I' && head[1]=='I') {
		if (head[2]==0x2a && head[3]==0x00) {
			DEBUG_MESGLN("readXHead: TIFFf[^`");
			hd.kind = TIFF_DATA;
			fclose(fp);
			return hd;
		}
	}
	if (head[0]=='M' && head[1]=='M') {
		if (head[2]==0x00 && head[3]==0x2a) {
			DEBUG_MESGLN("readXHead: TIFFf[^`");
			hd.kind = TIFF_DATA;
			fclose(fp);
			return hd;
		}
	}*/


	// JPEG
	if (isJPEGHeader(buf)) {
		DEBUG_MESGLN("readXHead: JPEGf[^`");
		hd.kind = JPEG_RGB_DATA;	// JPEG_RGB_DATA or JPEG_MONO_DATA
		fclose(fp);
		free_Buffer(&buf);
		return hd;
	}

	free_Buffer(&buf);


	///////////////////////////////////////////////////////////////////////
	// Another Unknown File Format
	//
	DEBUG_MESGLN("readXHead: m̃f[^`");
	memset(&hd, 0, hsz);
	hd.kind  = UN_KNOWN_DATA;
	hd.lsize = fsz;

	fclose(fp);
	return hd;
}






/**
CmnHead   jbxl::readXHeadFile(char* fn, CmnHead* chd, bool cnt=false)

	@\: f[^ʂ肵āCOtBbNf[^ǂݍ݁CCommon `ɕϊD
		  USERSET_DATȀꍇ chd w肷D܂ chd kind ɂ̓IvV̏
		  i݂̓GfBÂ݁j

		@T|[gĂf[^`, 
				Common `  : Common `ɂēǂݍށD(CT_RGN_SL͖T|[g)
				Sun Raster@ : Common `ɕϊDwb_ RAS_DATA ɂȂ 
				Moon(CT)@@ : Common `ɕϊDwb_ MOON_DATA ɂȂD
				DICOM        : Common `ɕϊD512x512xZŒDwb_ DICOM_DATAɂȂD
				USERSET_DATA : CmnHead* chd Ńwb_w肵āCǂݍ݂sDwb_ USERSET_DATAɂȂD
				Unkonwn @@ : t@Ĉ܂܁Chd->grptr֓ǂݍށDwb_ UN_KNOWN_DATA ɂȂD
		  CUN_KNOWN_DATȀꍇ CmnHaed hd->kind, hd->lsize(t@C), hd->gptr̂ݗLD

	: *fname -- ǂݍނst@CD
		  *chd  --- USERSET_DATAw̏ꍇCt@C̃wb_D
					܂̓t@CɊւIvVwłi݂̓GfBȀ̂݁jD
		  cnt   --- zJE^gp邩H

	߂lFǂݍ񂾃OtBbNf[^Lq鋤ʃwb_D
			G[Ȃ kind = HEADER_ERROR ƂȂD܂G[̎ނɂ xsizeωD
			   xsize   ERROR_GRAPH_OPFILE  t@CI[vG[D
					   ERROR_GRAPH_MEMORY  G[D
					   ERROR_GRAPH_CANCEL  LZ by [U

	oOFCommon`̉f[x 24,32bit̏ꍇ̃GfBA
*/
CmnHead   jbxl::readXHeadFile(char* fn, CmnHead* chd, bool cnt)
{
	FILE* fp;
	int	  fsz, hsz;
	bool  no_ntoh = false;
	CmnHead hd;
	CVCounter* counter = NULL;


	memset(&hd, 0, sizeof(CmnHead));
	hd.kind = HEADER_ERROR;

	fsz = (int)file_size(fn);
	if (fsz==0) {
		hd.xsize = ERROR_GRAPH_NOFILE;
		return hd;
	}

	if ((fp=fopen(fn,"rb"))==NULL) {
		hd.xsize = ERROR_GRAPH_OPFILE;
		return hd;
	}


	///////////////////////////////////////////////////////////////////////
	// Iy[^w̃f[^`mFi\߃wb_ɏ񂪐ݒ肳Ăj
	//
	if (chd!=NULL) {
		// t@CCPŨGfBA
		if (checkBit(chd->kind, HAS_LENDIAN) && is_little_endian()) {
			no_ntoh = true;
		}

		// Iy[^w̃f[^`DJE^T|[g
		if ((chd->kind&0x00ff)==USERSET_DATA) {
			if (chd->zsize<=0) chd->zsize = 1;
			chd->lsize = chd->xsize*chd->ysize*chd->zsize*((chd->depth+7)/8);
			if (fsz==(int)(chd->bsize+chd->lsize)) {		// t@CTCỸ`FbN
				DEBUG_MESGLN("readXHeadFile: Iy[^w̃f[^`");
				hd = readUserSetData(fp, chd, true);		// JE^L 

				// 24, 32bit Ή
				if (hd.depth==16 && !no_ntoh) {
					sWord* wptr = (sWord*)hd.grptr;
					for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) {
						wptr[i] = ntohs(wptr[i]);
					}
				}

				fclose(fp);
				return hd;
			}
		}
	}


	///////////////////////////////////////////////////////////////////////
	// ʃwb_̓ǂݍ
	//
	hsz = sizeof(CmnHead);
	fseek(fp, 0, 0);
	fread(&hd, hsz, 1, fp);
	ntoh_st(&hd, 4);


	// Sun Raster
	if (hd.kind==RAS_MAGIC) {
		DEBUG_MESGLN("readXHeadFile: Sun Rasterf[^`");
		hd = readRasData(fp); 
		fclose(fp);
		return hd;
	}


	// Common` 
	// f[^ǂݎł hd.lsize==0 ̃t@CTCYiCT_RGN_SLj͂܂T|[gĂȂ
	if (hd.kind>0 && hd.kind<=NUM_KDATA && fsz==(int)(hsz+hd.bsize+hd.lsize)) {
		DEBUG_MESGLN("readXHeadFile: Commonf[^`");
		if (hd.zsize<=0) hd.zsize = 1;

		// JE^
		if (hd.zsize>=10 && cnt) {
			counter = GetUsableGlobalCounter();
			if (counter!=NULL) {
				//counter->SetTitle("Commont@Cǂݍݒ");
				counter->SetMax(hd.zsize/10);
				counter->SetPos(0);
			}
		}
		
		if (hd.bsize>0) hd.buf = (uByte*)malloc(hd.bsize);
		hd.grptr = (uByte*)malloc(hd.lsize);
		if ((hd.bsize>0&&hd.buf==NULL) || hd.grptr==NULL) {
			free_CmnHead(&hd);
	   		hd.xsize = ERROR_GRAPH_MEMORY;
			hd.kind  = HEADER_ERROR;
			fclose(fp);
			return hd;
	  	}
		fseek(fp, hsz, 0);
		if (hd.bsize>0) {
			fread(hd.buf, hd.bsize, 1, fp);
			ntoh_ar((sWord*)hd.buf, hd.bsize);
		}
		
		// wb_̂
		if (hd.lsize==0) {
			fclose(fp);
			if (counter!=NULL) counter->PutFill();
			return hd;
		}

		// f[^{
		if (counter==NULL) {
			fread(hd.grptr, hd.lsize, 1, fp);
		}
		else {
			int psize = hd.xsize*hd.ysize*((hd.depth+7)/8);
			for (int i=0; i<hd.zsize; i++) {
				fread(hd.grptr+i*psize, psize, 1, fp);
				if (i%10==0) {
					counter->StepIt();
					if (counter->isCanceled()) {	// LZ
						//counter->Stop();
						free_CmnHead(&hd);
	   					hd.xsize = ERROR_GRAPH_CANCEL;
						hd.kind  = HEADER_ERROR;
						fclose(fp);
						return hd;
					}
				}
			}
		}

		// 24, 32bit Ή
		if (hd.depth==16 && !no_ntoh) {
			sWord* wptr = (sWord*)hd.grptr;
			for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) {
				wptr[i] = ntohs(wptr[i]);
			}
		}

		fclose(fp);
		if (counter!=NULL) counter->PutFill();
		return hd;
	}
	memset(&hd, 0, hsz);


	///////////////////////////////////////////////////////////////////////
	// Moon` 16bit
	//
	hd = readMoonData(fp, fsz, no_ntoh);
	if ((hd.kind & 0x00ff)==MOON_DATA) {
		DEBUG_MESGLN("readXHeadFile: Moonf[^`");
		fclose(fp);
		return hd;
	}
	memset(&hd, 0, hsz);


	///////////////////////////////////////////////////////////////////////
	// DICOMt@C
	//
	MSGraph<sWord> vp = readDicomData(fp, fsz);
	if (vp.gp!=NULL) {
		DEBUG_MESGLN("readXHeadFile: DICOMf[^`");
		hd.kind  = DICOM_DATA;
		hd.xsize = vp.xs;
		hd.ysize = vp.ys;
		hd.zsize = vp.zs;
		hd.depth = 16;
		hd.bsize = sizeof(CTHead);
		hd.lsize = vp.xs*vp.ys*vp.zs*2;
		hd.buf   = (uByte*)malloc(hd.bsize);
		hd.grptr = (uByte*)vp.gp;
				
		CTHead* pcthd = (CTHead*)hd.buf;
		memset(pcthd, 0, hd.bsize);
		pcthd->xsize  = (sWord)hd.xsize;
		pcthd->ysize  = (sWord)hd.ysize;
		//pcthd->ctmin	= 0;
		//pcthd->ctmax	= 0;
		//pcthd->cutup	= 0;
		//pcthd->cutdown  = 0;
		//pcthd->cutleft  = 0;
		//pcthd->cutright = 0;
		
		if (vp.RZxy>0.0) {
			pcthd->anydata[0] = (sWord)(vp.RZxy*RZXY_RATE);
			pcthd->anydata[1] = RZXY_RATE;
			hd.kind |= HAS_RZXY;
		}

		if (!no_ntoh) {
			sWord* wptr = (sWord*)hd.grptr;
			for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) {
				wptr[i] = ntohs(wptr[i]);
			}
		}

		fclose(fp);
		return hd;
	}


	///////////////////////////////////////////////////////////////////////
	// Well Known t@C
	//
	fseek(fp, 0, 0);
	Buffer buf = read_Buffer_data(fp, 32);


	// TIFF
	/*
	fread(head, 32, 1, fp);
	if (head[0]=='I' && head[1]=='I') {
		if (head[2]==0x2a && head[3]==0x00) {
			DEBUG_MESGLN("readXHeadFile: TIFFf[^`");
			hd.kind = TIFF_DATA;
			//fclose(fp);
			//return hd;
		}
	}
	if (head[0]=='M' && head[1]=='M') {
		if (head[2]==0x00 && head[3]==0x2a) {
			DEBUG_MESGLN("readXHeadFile: TIFFf[^`");
			hd.kind = TIFF_DATA;
			//fclose(fp);
			//return hd;
		}
	}*/


	// JPEG
	if (isJPEGHeader(buf)) {
		DEBUG_MESGLN("readXHeadFile: JPEGf[^`");
		JPEGImage jpg = readJPEGData(fp);
		hd = JPEGImage2CmnHead(jpg);

		if (hd.zsize==1) hd.kind = JPEG_MONO_DATA;
		jpg.free();
		free_Buffer(&buf);
		fclose(fp);
		return hd;
	}

	free_Buffer(&buf);


	///////////////////////////////////////////////////////////////////////
	// ͕s\Df[^̂܂ܓǂݍ݁@UN_KNOWN_DATA
	//
	DEBUG_MESGLN("readXHeadFile: m̃f[^`");
	memset(&hd, 0, hsz);

	hd.grptr = (uByte*)malloc(fsz);
	if (hd.grptr==NULL) {
	   	hd.xsize = ERROR_GRAPH_MEMORY;
		hd.kind  = HEADER_ERROR;
		fclose(fp);
		return hd;
	}
	fseek(fp, 0, 0);
	fread(hd.grptr, fsz, 1, fp);

	hd.kind  = UN_KNOWN_DATA;
	hd.lsize = fsz;

	fclose(fp);
	return hd;
}




/**
CmnHead   jbxl::readCmnHeadFile(char* fn, CmnHead* chd, bool cnt=false)

	@\: f[^ʂ chdŎw肵āCOtBbNf[^ǂݍ݁CCommon `ɕϊD

		@T|[gĂf[^`, 
				Common `  : Common `ɂēǂݍށD(CT_RGN_SL͖T|[g)
				Sun Raster@ : Common `ɕϊDwb_ RAS_DATA ɂȂ 
				Moon(CT)@@ : Common `ɕϊDwb_ MOON_DATA ɂȂD
				DICOM        : Common `ɕϊD512x512xZŒDwb_ DICOM_DATAɂȂD
				USERSET_DATA : CmnHead* chd Ńwb_w肵āCǂݍ݂sDwb_ USERSET_DATAɂȂD
				Jpeg         : Common `ɕϊDwb_ JPEG_RGB_DATAɂȂDmNJPEG̏ꍇ JPEG_MONO_DATA
				Tiff         : T|[gDCommon `ɕϊDwb_ TIFF_DATAɂȂD

	: *fname -- ǂݍނst@CD
		  *chd  --- t@C̃wb_D
		  cnt   --- zJE^gp邩H

	߂lFǂݍ񂾃OtBbNf[^Lq鋤ʃwb_D
			G[Ȃ kind = HEADER_ERROR ƂȂD܂G[̎ނɂ xsizeωD
			   xsize   ERROR_GRAPH_OPFILE  t@CI[vG[D
					   ERROR_GRAPH_MEMORY  G[D
					   ERROR_GRAPH_CANCEL  LZ by [U

	oOFCommon`̉f[x 24,32bit̏ꍇ̃GfBA
*/
CmnHead   jbxl::readCmnHeadFile(char* fn, CmnHead* chd, bool cnt)
{
	FILE* fp;
	int	  kind, fsz, hsz;
	bool  no_ntoh = false;
	CmnHead hd;
	CVCounter* counter = NULL;


	memset(&hd, 0, sizeof(CmnHead));
	hd.kind  = HEADER_ERROR;
	hd.xsize = ERROR_GRAPH_HEADER;

	if (chd==NULL) return hd;

	fsz = (int)file_size(fn);
	if (fsz==0) {
		hd.xsize = ERROR_GRAPH_NOFILE;
		return hd;
	}

	if ((fp=fopen(fn,"rb"))==NULL) {
		hd.xsize = ERROR_GRAPH_OPFILE;
		return hd;
	}


	// t@CCPŨGfBA
	if (checkBit(chd->kind, HAS_LENDIAN) && is_little_endian()) {
		no_ntoh = true;
	}
	kind = chd->kind & 0x00ff;


	// Iy[^w̃f[^`DJE^T|[g
	if (kind == USERSET_DATA) {
		if (chd->zsize<=0) chd->zsize = 1;
		chd->lsize = chd->xsize*chd->ysize*chd->zsize*((chd->depth+7)/8);
		if (fsz==(int)(chd->bsize+chd->lsize)) {		// t@CTCỸ`FbN
			DEBUG_MESGLN("readCmnHeadFile: Iy[^w̃f[^`");
			hd = readUserSetData(fp, chd, true);		// JE^L 

			// 24, 32bit Ή
			if (hd.depth==16 && !no_ntoh) {
				sWord* wptr = (sWord*)hd.grptr;
				for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) {
					wptr[i] = ntohs(wptr[i]);
				}
			}
		}
	}


	// DICOMt@CD
	else if (kind==DICOM_DATA) {
		MSGraph<sWord> vp = readDicomData(fp, fsz);
		if (vp.gp!=NULL) {
			DEBUG_MESGLN("readCmnHeadFile: DICOMf[^`");
			hd.kind  = DICOM_DATA;
			hd.xsize = vp.xs;
			hd.ysize = vp.ys;
			hd.zsize = vp.zs;
			hd.depth = 16;
			hd.bsize = sizeof(CTHead);
			hd.lsize = vp.xs*vp.ys*vp.zs*2;
			hd.buf   = (uByte*)malloc(hd.bsize);
			hd.grptr = (uByte*)vp.gp;
				
			CTHead* pcthd = (CTHead*)hd.buf;
			memset(pcthd, 0, hd.bsize);
			pcthd->xsize  = (sWord)hd.xsize;
			pcthd->ysize  = (sWord)hd.ysize;
			//pcthd->ctmin	= 0;
			//pcthd->ctmax	= 0;
			//pcthd->cutup	= 0;
			//pcthd->cutdown  = 0;
			//pcthd->cutleft  = 0;
			//pcthd->cutright = 0;

			if (vp.RZxy>0.0) {
				pcthd->anydata[0] = (sWord)(vp.RZxy*RZXY_RATE);
				pcthd->anydata[1] = RZXY_RATE;
				hd.kind |= HAS_RZXY;
			}

			if (!no_ntoh) {
				sWord* wptr = (sWord*)hd.grptr;
				for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) {
					wptr[i] = ntohs(wptr[i]);
				}
			}
		}
	}


	// Sun Raster
	else if (kind==RAS_DATA) {
		DEBUG_MESGLN("readCmnHeadFile: Sun Rasterf[^`");
		hd = readRasData(fp); 
	}
	

	// Moon` 16bit
	else if (kind==MOON_DATA) {
		DEBUG_MESGLN("readCmnHeadFile: Moonf[^`");
		hd = readMoonData(fp, fsz, no_ntoh);
	}


	// JPEG
	else if (kind==JPEG_RGB_DATA || kind==JPEG_MONO_DATA) {
		DEBUG_MESGLN("readCmnHeadFile: JPEGf[^`");
		JPEGImage jpg = readJPEGData(fp);
		hd = JPEGImage2CmnHead(jpg);
		jpg.free();
	}


	// TIFF
	/*else if (kind == TIFF_DATA) {


	}*/


	// Common` 
	else if (kind!=UN_KNOWN_DATA) {
		// f[^ǂݎł hd.lsize==0 ̃t@CTCYiCT_RGN_SLj͂܂T|[gĂȂ
		DEBUG_MESGLN("readCmnHeadFile: Commonf[^`");

		hsz = sizeof(CmnHead);
		fseek(fp, 0, 0);
		fread(&hd, hsz, 1, fp);
		ntoh_st(&hd, 4);
		if (hd.zsize<=0) hd.zsize = 1;

		// JE^
		if (hd.zsize>=10 && cnt) {
			counter = GetUsableGlobalCounter();
			if (counter!=NULL) {
				//counter->SetTitle("Commont@Cǂݍݒ");
				counter->SetMax(hd.zsize/10);
				counter->SetPos(0);
			}
		}

		if (hd.bsize>0) hd.buf = (uByte*)malloc(hd.bsize);
		hd.grptr = (uByte*)malloc(hd.lsize);
		if ((hd.bsize>0&&hd.buf==NULL) || hd.grptr==NULL) {
			free_CmnHead(&hd);
	   		hd.xsize = ERROR_GRAPH_MEMORY;
			hd.kind  = HEADER_ERROR;
			fclose(fp);
			return hd;
	  	}
		fseek(fp, hsz, 0);
		if (hd.bsize>0) {
			fread(hd.buf, hd.bsize, 1, fp);
			ntoh_ar((sWord*)hd.buf, hd.bsize);
		}
		
		// wb_̂
		if (hd.lsize==0) {
			if (counter!=NULL) counter->PutFill();
		}
		else {
			// f[^{
			if (counter==NULL) {
				fread(hd.grptr, hd.lsize, 1, fp);
			}
			else {
				int psize = hd.xsize*hd.ysize*((hd.depth+7)/8);
				for (int i=0; i<hd.zsize; i++) {
					fread(hd.grptr+i*psize, psize, 1, fp);
					if (i%10==0) {
						counter->StepIt();
						if (counter->isCanceled()) {	// LZ
							//counter->Stop();
							free_CmnHead(&hd);
	   						hd.xsize = ERROR_GRAPH_CANCEL;
							hd.kind  = HEADER_ERROR;
							fclose(fp);
							return hd;
						}
					}
				}
			}

			// 24, 32bit Ή
			if (hd.depth==16 && !no_ntoh) {
				sWord* wptr = (sWord*)hd.grptr;
				for (int i=0; i<hd.xsize*hd.ysize*hd.zsize; i++) {
					wptr[i] = ntohs(wptr[i]);
				}
			}

			if (counter!=NULL) counter->PutFill();
		}
	}

	else {
		DEBUG_MESGLN("readCmnHeadFile: m̃f[^`w肳ꂽD(%04x, %04x)", chd->kind, (uWord)kind);
	}


	fclose(fp);
	return hd;
}







/**
int   jbxl::writeCmnHeadFile(char* fn, CmnHead* hd, bool cnt)

	@\: ʉ摜f[^CTt@CƂĕۑD

		  ̋ʉ摜f[^̃wb_ʂ MOON_DATA ܂ USERSET_DATȀꍇ 
		  CT(MOON)`ŕۑD
		  RAS_DATA, JPEG_RGB_DATA, JPEG_MONO_DATA, TIFF_DATȀꍇ͂ꂼ̌`ŕۑD(TIFF_DATA͖T|[g)
		  CT_DATA, CT_3DM, CT_3D_VOL ꍇ͂̂܂܋ʌ` (wb_͂̂܂)ŕۑD
		  
		T|[gĂwb_ʂ 
			CT_DATA, USERSET_DATA, CT_3DM, CT_3D_VOL, RAS_DATA, MOON_DATA, JPEG_RGB_DATA, JPEG_MONO_DATA, JPEG16_XXX_DATA

		wb_ɕKvȏ
			hd->kind, xsize, ysize, zsize, depth, grptr, (buf)@@@@( )͏ȗ.
	

	: *fn  -- ۑt@CD
		  *hd  -- ۑf[^qʃwb_D

	߂lF0 >   񂾃TCYD
			ERROR_GRAPH_IVDARG   sD
			ERROR_GRAPH_MEMORY   G[D
			ERROR_GRAPH_OPFILE   t@CI[vG[D
			ERROR_GRAPH_WRFILE	 ݃t@CTCYsv
			ERROR_GRAPH_RDFILE   ݃t@C̍ēǂݎs
			ERROR_GRAPH_HEADER   ݃t@C̃wb_ُ
*/
int   jbxl::writeCmnHeadFile(char* fn, CmnHead* hd, bool cnt)
{
	CmnHead cmd;
	FILE* fp;
	int   csize, psize;
	int   kind = hd->kind & 0x0ff;

	if (kind==UN_KNOWN_DATA) return ERROR_GRAPH_HEADER;
	if (hd==NULL || hd->lsize==0) return ERROR_GRAPH_IVDARG;

	if ((fp=fopen(fn,"wb"))==NULL) {
		DEBUG_MESGLN("WRITECMNHEADFILE: G[Ft@CI[vs");
		return ERROR_GRAPH_OPFILE;
	}
	DEBUG_MESGLN("writeCmnHeadFile: t@C = %d ŏݒD%dx%dx%d", hd->kind, hd->xsize, hd->ysize, hd->zsize);
	

	// Write File
	csize = writeCmnHeadData(fp, hd, cnt);
	fclose(fp);
	if (csize<0) return (int)csize;
	

	// SUN RASTER
	if (kind==RAS_DATA) return csize;

	// JPEG
	if (kind==JPEG_RGB_DATA   || kind==JPEG_MONO_DATA) return csize;
	if (kind==JPEG_ARGB_DATA  || kind==JPEG_RGBA_DATA) return csize;
	if (kind==JPEG16_RGB_DATA || kind==JPEG16_ARGB_DATA || kind==JPEG16_RGBA_DATA) return csize;

	// TIFF
	//if (kind==TIFF_DATA) return csize;


	// ݃`FbN
	int fsz = (int)file_size(fn);
	if (kind==MOON_DATA) psize = hd->bsize+hd->lsize;
	else psize = sizeof(CmnHead)+hd->bsize+hd->lsize;

	if (fsz!=psize) {
		DEBUG_MESGLN("WRITECMNHEADFILE: G[F݃t@C̃TCYȂ %d != %d", psize, fsz);
		return ERROR_GRAPH_WRFILE;
	}
	if (kind==MOON_DATA) return psize;

	if ((fp=fopen(fn,"rb"))==NULL) {
		DEBUG_MESGLN("WRITECMNHEADFILE: G[Ft@CFăI[vs");
		return ERROR_GRAPH_RDFILE;
	}
 
	fread((sByte*)&cmd, sizeof(CmnHead), 1, fp);
	ntoh_st(&cmd, 4);
	if (cmd.xsize!=hd->xsize || cmd.ysize!=hd->ysize || cmd.zsize!=hd->zsize ||
		cmd.bsize!=hd->bsize || cmd.lsize!=hd->lsize || cmd.depth!=hd->depth || cmd.kind!=hd->kind) {
		DEBUG_MESGLN("WRITECMNHEADFILE: G[Ft@Cwb_Fwb_ُ");
		fclose(fp);
		return ERROR_GRAPH_HEADER;
	}

	fclose(fp);
	return  csize;
}







/**
int   jbxl::writeCmnHeadData(File* fp, CmnHead* hd, bool cnt)

	@\: 
		ʉ摜f[^t@CƂĕۑD
		̋ʉ摜f[^̃wb_ʂ MOON_DATA ܂ USERSET_DATȀꍇ CT(MOON)`ŕۑD
		RAS_DATA, JPEG_RGB_DATA, JPEG_MONO_DATA, TIFF_DATȀꍇ͂ꂼ̌`ŕۑD(TIFF_DATA͖T|[g)
		CT_DATA, CT_3DM, CT_3D_VOL ꍇ͂̂܂܋ʌ`(wb_ʂ͂̂܂)ŕۑD
		JE^T|[gD

		T|[gĂwb_ʂ 
			CT_DATA, USERSET_DATA, CT_3DM, CT_3D_VOL, RAS_DATA, MOON_DATA, JPEG_RGB_DATA, JPEG_MONO_DATA

		wb_ɕKvȏ
			hd->kind, xsize, ysize, zsize, depth, grptr, (buf)@@@@( )͏ȗ.

	: *fp  -- ۑt@C̎ʎqD
		  *hd  -- ۑf[^qʃwb_D

	߂lF0 >   񂾃TCYD
			ERROR_GRAPH_HEADER	 wb_G[
			ERROR_GRAPH_MEMORY   G[
			ERROR_GRAPH_CANCEL	 LZ
*/
int   jbxl::writeCmnHeadData(FILE* fp, CmnHead* hd, bool cnt)
{
	CTHead  chd;
	CmnHead cmd;
	CVCounter* counter = NULL;
	sByte* ptr;
	int i, j, k, l;
	int csize, psize;
	int kind = hd->kind & 0x00ff;

	if (kind==UN_KNOWN_DATA) return ERROR_GRAPH_HEADER;


	// SUN RASTER
	if (kind==RAS_DATA) {
		//csize = writeRasData(fp, hd, hd->depth);
		csize = writeRasData(fp, hd, 8);
		return csize;
	}

	// JPEG
	if (kind==JPEG_RGB_DATA   || kind==JPEG_MONO_DATA   || kind==JPEG_ARGB_DATA || kind==JPEG_RGBA_DATA ||
		kind==JPEG16_RGB_DATA || kind==JPEG16_ARGB_DATA || kind==JPEG16_RGBA_DATA) {
		JPEGImage jpg = CmnHead2JPEGImage(*hd);
		csize = writeJPEGData(fp, jpg, 100);
		jpg.free();
		return csize;
	}

	// TIFF
	/*if (kind==TIFF_DATA) {
		csize = 
		return csize;
	}*/



	////////////////////////////////////////////////////////////////////////
	// CT : wb_̏

	if (hd->zsize<=0) hd->zsize = 1;
	if (hd->depth<=0) hd->depth = 16;

	psize = hd->xsize*hd->ysize*((hd->depth+7)/8); 
	hd->lsize = psize*hd->zsize;
	ptr = (sByte*)malloc(hd->lsize);
	if (ptr==NULL) return ERROR_GRAPH_MEMORY;

	// CTHead chd D
	if (kind==CT_DATA || kind==CT_3DM || kind==CT_3D_VOL) {
		DEBUG_MESGLN("writeCmnHeadData: CTf[^");
		DEBUG_MESGLN("writeCmnHeadData: wb_obt@ bsize = %d", hd->bsize);
		DEBUG_MESGLN("writeCmnHeadData: f[^TCY   lsize = %d", hd->lsize);
		DEBUG_MESGLN("writeCmnHeadData: TCY         %dx%dx%d %d", hd->xsize, hd->ysize, hd->zsize, hd->depth);

		memcpy(&chd, hd->buf, hd->bsize);
		chd.anydata[2] += TempBase;
		hton_st(&chd, 2);

		memcpy(ptr, hd->grptr, hd->lsize);
	}
	else if (kind==MOON_DATA || kind==USERSET_DATA) {	
		chd.xsize	= htons((sWord)hd->xsize);
		chd.ysize	= htons((sWord)hd->ysize);
		chd.ctmin	= 0;
		chd.ctmax	= 0;
		chd.cutup	= 0;
		chd.cutdown = 0;
		chd.cutleft = 0;
		chd.cutright= 0;

		k = l = 0;
		if (hd->depth<16){   
			for (i=0; i<hd->xsize*hd->ysize; i++) {
				for (j=0; j<hd->depth/8; j++) ptr[k++] = 0x00;
				for (j=hd->depth/8; j<2; j++) ptr[k++] = hd->grptr[l++];
			}
		}
		else if (hd->depth==16) {
			for (i=0; i<hd->xsize*hd->ysize; i++) {
				for (j=0; j<2; j++) ptr[k++] = hd->grptr[l++];
			}
		}
		else {
			for (i=0; i<hd->xsize*hd->ysize; i++) {
				for (j=0; j<2; j++) ptr[k++] = hd->grptr[l++];
				l += (hd->depth)/8 - 2;
			}
		}
	}
	else {
		DEBUG_MESGLN("writeCmnHeadData: T|[gĂȂwb_^Cv %d", hd->kind);
		free(ptr);
		return 0;
	}


	////////////////////////////////////////////////////////////////////////
	// f[^

	csize = 0;
	// ʃwb_
	if (kind==CT_DATA || kind==CT_3DM || kind==CT_3D_VOL) {
		// JE^
		if (hd->zsize>=10 && cnt) {
			counter = GetUsableGlobalCounter();
			if (counter!=NULL) {
				//counter->SetTitle("Commont@Cݒ");
				counter->SetMax((hd->zsize+1)/10);
				counter->SetPos(1);
			}
		}

		cmd = *hd;
		cmd.grptr = NULL;
		hton_st(&cmd, 4);
		csize = sizeof(CmnHead);
		fwrite(&cmd, csize, 1, fp);
	}


   	// CTwb_
	fwrite(&chd, sizeof(CTHead), 1, fp);
	csize += sizeof(CTHead);


	// {̃f[^
	hton_ar((sWord*)ptr, hd->lsize);

	if (counter==NULL) {
		fwrite(ptr, hd->lsize, 1, fp);
		csize += hd->lsize;
	}
	else {
		for (i=0; i<hd->zsize; i++) {
			fseek(fp, csize, 0);
			fwrite(ptr+i*psize, psize, 1, fp);
			csize += psize;
			if (i%10==0) {
				counter->StepIt();
				if (counter->isCanceled()) {	// LZ
					free(ptr);
					return ERROR_GRAPH_CANCEL;
				}
			}
		}
	}

	free(ptr);
	if (counter!=NULL) counter->PutFill();

	return  csize;
}




