
/**
]ENH[^jI Cu  Quaternion.cpp

*/


#include  "Rotation.h"


using namespace jbxl;



/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// NH[^jI NX
//

void  Quaternion::set(double S, double X, double Y, double Z, double N)
{
	s  = S;
	x  = X;
	y  = Y;
	z  = Z;
	n  = N;

	if (n<=0.0) {
		n = sqrt(s*s + x*x + y*y + z*z);
	}
}



void  Quaternion::normalize() 
{
	double nrm = sqrt(s*s + x*x + y*y + z*z);
	
	if (nrm>=Zero_Eps) {
		s  = s/nrm;
		x  = x/nrm;
		y  = y/nrm;
		z  = z/nrm;
		n  = 1.0;
	}
	else {
		init();
	}
}



void  Quaternion::setRotation(double e, Vector<double> v)
{
	if (v.n!=1.0) v.normalize();

	double s2 = e/2.0;
	s  = cos(s2);
	x  = v.x*sin(s2);
	y  = v.y*sin(s2);
	z  = v.z*sin(s2);
	n  = 1.0;
}



// X->Y->Z
void  Quaternion::setEulerXYZ(Vector<double> e)
{
	Vector<double> ex(1.0, 0.0, 0.0, 1.0);  
	Vector<double> ey(0.0, 1.0, 0.0, 1.0);  
	Vector<double> ez(0.0, 0.0, 1.0, 1.0);

	Quaternion qx, qy, qz;
	qx.setRotation(e.x, ex);
	qy.setRotation(e.y, ey);
	qz.setRotation(e.z, ez);

	(*this) = qz*qy*qx;
}



// Z->Y->X
void  Quaternion::setEulerZYX(Vector<double> e)
{
	Vector<double> ex(1.0, 0.0, 0.0, 1.0);  
	Vector<double> ey(0.0, 1.0, 0.0, 1.0);  
	Vector<double> ez(0.0, 0.0, 1.0, 1.0);

	Quaternion qx, qy, qz;
	qx.setRotation(e.z, ex);
	qy.setRotation(e.y, ey);
	qz.setRotation(e.x, ez);

	(*this) = qx*qy*qz;
}



// X->Z->Y
void  Quaternion::setEulerXZY(Vector<double> e)
{
	Vector<double> ex(1.0, 0.0, 0.0, 1.0);  
	Vector<double> ey(0.0, 1.0, 0.0, 1.0);  
	Vector<double> ez(0.0, 0.0, 1.0, 1.0);

	Quaternion qx, qy, qz;
	qx.setRotation(e.x, ex);
	qy.setRotation(e.z, ey);
	qz.setRotation(e.y, ez);

	(*this) = qy*qz*qx;
}



// Y->Z->X
void  Quaternion::setEulerYZX(Vector<double> e)
{
	Vector<double> ex(1.0, 0.0, 0.0, 1.0);  
	Vector<double> ey(0.0, 1.0, 0.0, 1.0);  
	Vector<double> ez(0.0, 0.0, 1.0, 1.0);

	Quaternion qx, qy, qz;
	qx.setRotation(e.z, ex);
	qy.setRotation(e.x, ey);
	qz.setRotation(e.y, ez);

	(*this) = qx*qz*qy;
}



// Y->X->Z
void  Quaternion::setEulerYXZ(Vector<double> e)
{
	Vector<double> ex(1.0, 0.0, 0.0, 1.0);  
	Vector<double> ey(0.0, 1.0, 0.0, 1.0);  
	Vector<double> ez(0.0, 0.0, 1.0, 1.0);

	Quaternion qx, qy, qz;
	qx.setRotation(e.y, ex);
	qy.setRotation(e.x, ey);
	qz.setRotation(e.z, ez);

	(*this) = qz*qx*qy;
}



// Z->X->Y
void  Quaternion::setEulerZXY(Vector<double> e)
{
	Vector<double> ex(1.0, 0.0, 0.0, 1.0);  
	Vector<double> ey(0.0, 1.0, 0.0, 1.0);  
	Vector<double> ez(0.0, 0.0, 1.0, 1.0);

	Quaternion qx, qy, qz;
	qx.setRotation(e.y, ex);
	qy.setRotation(e.z, ey);
	qz.setRotation(e.x, ez);

	(*this) = qy*qx*qz;
}



Matrix<double>  Quaternion::getRotMatrix()
{
	Matrix<double> mtx(2, 3, 3);	// 3x3  2}gbNX

	mtx.element(1, 1) = 1.0 - 2.0*y*y - 2.0*z*z;
	mtx.element(1, 2) = 2.0*x*y - 2.0*s*z;
	mtx.element(1, 3) = 2.0*x*z + 2.0*s*y;
	mtx.element(2, 1) = 2.0*x*y + 2.0*s*z;
	mtx.element(2, 2) = 1.0 - 2.0*x*x - 2.0*z*z;
	mtx.element(2, 3) = 2.0*y*z - 2.0*s*x;
	mtx.element(3, 1) = 2.0*x*z - 2.0*s*y;
	mtx.element(3, 2) = 2.0*y*z + 2.0*s*x;
	mtx.element(3, 3) = 1.0 - 2.0*x*x - 2.0*y*y;

	return mtx;
}




//
// Exec Rotation  qv(~q)
//
Vector<double>  Quaternion::execRotation(Vector<double> v)
{
	Quaternion inv = ~(*this);
	Quaternion qut = ((*this)*(v*inv));
	Vector<double> vct = qut.getVector();

	return vct;
}





/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// ]sCIC[p
//

Matrix<double>  jbxl::EulerXYZ2RotMatrix(Vector<double> eul)
{
	Matrix<double> mtx(2, 3, 3);

	double sinx = sin(eul.x);
	double cosx = cos(eul.x);
	double siny = sin(eul.y);
	double cosy = cos(eul.y);
	double sinz = sin(eul.z);
	double cosz = cos(eul.z);

	mtx.element(1, 1) = cosy*cosz;
	mtx.element(1, 2) = sinx*siny*cosz - cosx*sinz;
	mtx.element(1, 3) = cosx*siny*cosz + sinx*sinz;
	mtx.element(2, 1) = cosy*sinz;
	mtx.element(2, 2) = sinx*siny*sinz + cosx*cosz;
	mtx.element(2, 3) = cosx*siny*sinz - sinx*cosz;
	mtx.element(3, 1) = -siny;
	mtx.element(3, 2) = sinx*cosy;
	mtx.element(3, 3) = cosx*cosy;

	return mtx;
}




Matrix<double>  jbxl::EulerZYX2RotMatrix(Vector<double> eul)
{
	Matrix<double> mtx(2, 3, 3);

	double sinx = sin(eul.x);
	double cosx = cos(eul.x);
	double siny = sin(eul.y);
	double cosy = cos(eul.y);
	double sinz = sin(eul.z);
	double cosz = cos(eul.z);

	mtx.element(1, 1) = cosy*cosz;
	mtx.element(1, 2) = -cosy*sinz;
	mtx.element(1, 3) = siny;
	mtx.element(2, 1) = cosx*sinz + sinx*siny*cosz;
	mtx.element(2, 2) = cosx*cosz - sinx*siny*sinz;
	mtx.element(2, 3) = -sinx*cosy;
	mtx.element(3, 1) = sinx*sinz - cosx*siny*cosz;
	mtx.element(3, 2) = sinx*cosz + cosx*siny*sinz;
	mtx.element(3, 3) = cosx*cosy;

	return mtx;
}




Vector<double>  jbxl::RotMatrix2EulerXYZ(Matrix<double> mtx, Vector<double>* vct)
{
	Vector<double> eul(0.0, 0.0, 0.0);
	Vector<double> ev[2];

	double m31 = mtx.element(3, 1);
	if (m31<-1.0 || m31>1.0) return eul;

	// m31==1.0 || m31==-1.0
	if (1.0-m31<Zero_Eps || 1.0+m31<Zero_Eps) {
		double m12 = mtx.element(1, 2);
		double m13 = mtx.element(1, 3);
	
		if (1.0-m31<Zero_Eps) {				// m31==1.0
			ev[0].y = ev[1].y = -PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(-m12, -m13) - ev[0].z;
			ev[1].x = atan2(-m12, -m13) - ev[1].z;
		}
		else {								// m31==-1.0
			ev[0].y = ev[1].y = PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(m12, m13) + ev[0].z;
			ev[1].x = atan2(m12, m13) + ev[1].z;
		}
	}

	else {
		double m11 = mtx.element(1, 1);
		double m21 = mtx.element(2, 1);
		double m32 = mtx.element(3, 2);
		double m33 = mtx.element(3, 3);

		ev[0].y = -asin(m31); 
		if (ev[0].y>=0.0) ev[1].y =  PI - ev[0].y;
		else		  	  ev[1].y = -PI - ev[0].y;

		double cy1 = cos(ev[0].y);
		double cy2 = cos(ev[1].y);
		if (Xabs(cy1)<Zero_Eps || Xabs(cy2)<Zero_Eps) return eul;

		ev[0].x = atan2(m32/cy1, m33/cy1);
		ev[1].x = atan2(m32/cy2, m33/cy2);
		ev[0].z = atan2(m21/cy1, m11/cy1);
		ev[1].z = atan2(m21/cy2, m11/cy2);
	}

	//
	if (vct!=NULL) {
		vct[0] = ev[0];
		vct[1] = ev[1];
	}

	//
	int nn[2] = {0, 0};
	for (int i=0; i<2; i++) {
		if (Xabs(ev[i].x)>=PI_DIV2) nn[i]++;	
		if (Xabs(ev[i].y)>=PI_DIV2) nn[i]++;	
		if (Xabs(ev[i].z)>=PI_DIV2) nn[i]++;	
	}

	if (nn[0]<=nn[1]) eul = ev[0];
	else              eul = ev[1];

	return eul;
}




Vector<double>  jbxl::RotMatrixElements2EulerXYZ(double m11, double m12, double m13, double m21, double m31, double m32, double m33, Vector<double>* vct)
{
	Vector<double> eul(0.0, 0.0, 0.0);
	Vector<double> ev[2];

	if (m31<-1.0 || m31>1.0) return eul;

	// m31==1.0 || m31==-1.0
	if (1.0-m31<Zero_Eps || 1.0+m31<Zero_Eps) {
		if (1.0-m31<Zero_Eps) {				// m31==1.0
			ev[0].y = ev[1].y = -PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(-m12, -m13) - ev[0].z;
			ev[1].x = atan2(-m12, -m13) - ev[1].z;
		}
		else {								// m31==-1.0
			ev[0].y = ev[1].y = PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(m12, m13) + ev[0].z;
			ev[1].x = atan2(m12, m13) + ev[1].z;
		}
	}

	else {
		ev[0].y = -asin(m31); 
		if (ev[0].y>=0.0) ev[1].y =  PI - ev[0].y;
		else		  	  ev[1].y = -PI - ev[0].y;

		double cy1 = cos(ev[0].y);
		double cy2 = cos(ev[1].y);
		if (Xabs(cy1)<Zero_Eps || Xabs(cy2)<Zero_Eps) return eul;

		ev[0].x = atan2(m32/cy1, m33/cy1);
		ev[1].x = atan2(m32/cy2, m33/cy2);
		ev[0].z = atan2(m21/cy1, m11/cy1);
		ev[1].z = atan2(m21/cy2, m11/cy2);
	}

	//
	if (vct!=NULL) {
		vct[0] = ev[0];
		vct[1] = ev[1];
	}

	//
	int nn[2] = {0, 0};
	for (int i=0; i<2; i++) {
		if (Xabs(ev[i].x)>=PI_DIV2) nn[i]++;	
		if (Xabs(ev[i].y)>=PI_DIV2) nn[i]++;	
		if (Xabs(ev[i].z)>=PI_DIV2) nn[i]++;	
	}

	if (nn[0]<=nn[1]) eul = ev[0];
	else              eul = ev[1];

	return eul;
}





Vector<double>  jbxl::RotMatrix2EulerZYX(Matrix<double> mtx, Vector<double>* vct)
{
	Vector<double> eul(0.0, 0.0, 0.0);
	Vector<double> ev[2];

	double m13 = mtx.element(1, 3);
	if (m13<-1.0 || m13>1.0) return eul;

	// m13==1.0 || m13==-1.0
	if (1.0-m13<Zero_Eps || 1.0+m13<Zero_Eps) {
		double m21 = mtx.element(2, 1);
		double m31 = mtx.element(3, 1);
	
		if (1.0-m13<Zero_Eps) {				// m13==1.0
			ev[0].y = ev[1].y = PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(m21, -m31) - ev[0].z;
			ev[1].x = atan2(m21, -m31) - ev[1].z;
		}
		else {								// m13==-1.0
			ev[0].y = ev[1].y = -PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(-m21, m31) + ev[0].z;
			ev[1].x = atan2(-m21, m31) + ev[1].z;
		}
	}

	else {
		double m11 = mtx.element(1, 1);
		double m12 = mtx.element(1, 2);
		double m23 = mtx.element(2, 3);
		double m33 = mtx.element(3, 3);

		ev[0].y = asin(m13); 
		if (ev[0].y>=0.0) ev[1].y =  PI - ev[0].y;
		else		      ev[1].y = -PI - ev[0].y;

		double cy1 = cos(ev[0].y);
		double cy2 = cos(ev[1].y);
		if (Xabs(cy1)<Zero_Eps || Xabs(cy2)<Zero_Eps) return eul;

		ev[0].x = atan2(-m23/cy1, m33/cy1);
		ev[1].x = atan2(-m23/cy2, m33/cy2);
		ev[0].z = atan2(-m12/cy1, m11/cy1);
		ev[1].z = atan2(-m12/cy2, m11/cy2);
	}

	//
	if (vct!=NULL) {
		vct[0] = ev[0];
		vct[1] = ev[1];
	}

	//
	double t0 = Xabs(ev[0].x) + Xabs(ev[0].y) + Xabs(ev[0].z);
	double t1 = Xabs(ev[1].x) + Xabs(ev[1].y) + Xabs(ev[1].z);
		
	if (t0<=t1) eul = ev[0];
	else        eul = ev[1];

	return eul;
}




Vector<double>  jbxl::RotMatrixElements2EulerZYX(double m11, double m12, double m13, double m21, double m23, double m31, double m33, Vector<double>* vct)
{
	Vector<double> eul(0.0, 0.0, 0.0);
	Vector<double> ev[2];

	if (m13<-1.0 || m13>1.0) return eul;

	// m13==1.0 || m13==-1.0
	if (1.0-m13<Zero_Eps || 1.0+m13<Zero_Eps) {	
		if (1.0-m13<Zero_Eps) {				// m13==1.0
			ev[0].y = ev[1].y = PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(m21, -m31) - ev[0].z;
			ev[1].x = atan2(m21, -m31) - ev[1].z;
		}
		else {								// m13==-1.0
			ev[0].y = ev[1].y = -PI_DIV2;
			ev[0].z = 0.0;
			ev[1].z = PI_DIV2;
			ev[0].x = atan2(-m21, m31) + ev[0].z;
			ev[1].x = atan2(-m21, m31) + ev[1].z;
		}
	}

	else {
		ev[0].y = asin(m13); 
		if (ev[0].y>=0.0) ev[1].y =  PI - ev[0].y;
		else		      ev[1].y = -PI - ev[0].y;

		double cy1 = cos(ev[0].y);
		double cy2 = cos(ev[1].y);
		if (Xabs(cy1)<Zero_Eps || Xabs(cy2)<Zero_Eps) return eul;

		ev[0].x = atan2(-m23/cy1, m33/cy1);
		ev[1].x = atan2(-m23/cy2, m33/cy2);
		ev[0].z = atan2(-m12/cy1, m11/cy1);
		ev[1].z = atan2(-m12/cy2, m11/cy2);
	}

	//
	if (vct!=NULL) {
		vct[0] = ev[0];
		vct[1] = ev[1];
	}

	//
	double t0 = Xabs(ev[0].x) + Xabs(ev[0].y) + Xabs(ev[0].z);
	double t1 = Xabs(ev[1].x) + Xabs(ev[1].y) + Xabs(ev[1].z);
		
	if (t0<=t1) eul = ev[0];
	else        eul = ev[1];

	return eul;
}




Vector<double>  jbxl::Quaternion2EulerXYZ(Quaternion qut, Vector<double>* vct)
{
	Matrix<double> mtx = qut.getRotMatrix();
	Vector<double> eul = RotMatrix2EulerXYZ(mtx, vct);
	mtx.free();

	return eul;
}




Vector<double>  jbxl::Quaternion2EulerZYX(Quaternion qut, Vector<double>* vct)
{
	Matrix<double> mtx = qut.getRotMatrix();
	Vector<double> eul = RotMatrix2EulerZYX(mtx, vct);
	mtx.free();

	return eul;
}




Quaternion  jbxl::V2VQuaternion(Vector<double> a, Vector<double> b)
{
	Quaternion qut;

	if (a.n<Zero_Eps || b.n<Zero_Eps) return qut;
	a.normalize();
	b.normalize();

	Vector<double> xx = a^b;
	xx.normalize();
	if (xx.n<Zero_Eps) return qut;

	double cs2 = (a*b)/2.0;			// /2 = 0`/2
	double cs  = sqrt(0.5 + cs2);
	double sn  = sqrt(0.5 - cs2);

	qut.set(cs, xx.x*sn, xx.y*sn, xx.z*sn, 1.0);
	return qut;
}




Quaternion  jbxl::V2VQuaternion(Vector<double> a, Vector<double> b, Vector<double> c)
{
	Vector<double> sv = b - a;
	Vector<double> ev = c - b;

	Quaternion qut = V2VQuaternion(sv, ev);
	return qut;
}
