// InputNumDLG.cpp : t@C
//

#include "stdafx.h"

#include "common++.h"
#include "tools++.h"
#include "InputNumDLG.h"


using namespace jbxwl;



//////////////////////////////////////////////////////////////////////////////////////////
//
// CInputNumDLG _CAO
//

IMPLEMENT_DYNAMIC(CInputNumDLG, CDialog)

CInputNumDLG::CInputNumDLG(CWnd* pParent /*=NULL*/)
	: CDialog(CInputNumDLG::IDD, pParent)
{
	valtlBox = NULL;
	valBox   = NULL;

	valtl = "";
	val   = 0;
}



CInputNumDLG::CInputNumDLG(CString vt, int v, CWnd* pParent /*=NULL*/)
	: CDialog(CInputNumDLG::IDD, pParent)
{
	valtlBox = NULL;
	valBox   = NULL;

	valtl = vt;
	val   = v;
}



CInputNumDLG::~CInputNumDLG()
{
}



void CInputNumDLG::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}




BEGIN_MESSAGE_MAP(CInputNumDLG, CDialog)
END_MESSAGE_MAP()


// CInputNumDLG bZ[W nh



BOOL  CInputNumDLG::OnInitDialog()
{
	char buf[LMNAME];

	valtlBox = (CStatic*)GetDlgItem(IDC_INM_VALTTL);
	valBox   = (CEdit*)GetDlgItem(IDC_INM_VAL);

	if (valtl!="") valtlBox->SetWindowText((LPCTSTR)valtl);

	bzero(buf, LMNAME);
	snprintf(buf, LMNAME-1, "%d", val);
	valBox->SetWindowText((LPCTSTR)buf);

	return TRUE;
}



void  CInputNumDLG::OnOK() 
{
	char buf[LMNAME];

	bzero(buf, LMNAME);
	valBox->GetWindowText(buf, LMNAME-1);
	val = atoi(buf);

	CDialog::OnOK();
	return;
}






//////////////////////////////////////////////////////////////////////////////////////////
//
// CInputFloatNumDLG _CAO
//

IMPLEMENT_DYNAMIC(CInputFloatNumDLG, CDialog)

CInputFloatNumDLG::CInputFloatNumDLG(CWnd* pParent /*=NULL*/)
	: CDialog(CInputFloatNumDLG::IDD, pParent)
{
	valtlBox = NULL;
	valBox   = NULL;

	valtl = "";
	val   = 0.0;
}



CInputFloatNumDLG::CInputFloatNumDLG(CString vt, double v, CWnd* pParent /*=NULL*/)
	: CDialog(CInputFloatNumDLG::IDD, pParent)
{
	valtlBox = NULL;
	valBox   = NULL;

	valtl = vt;
	val   = v;
}



CInputFloatNumDLG::~CInputFloatNumDLG()
{
}



void CInputFloatNumDLG::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}




BEGIN_MESSAGE_MAP(CInputFloatNumDLG, CDialog)
END_MESSAGE_MAP()


// CInputFloatNumDLG bZ[W nh



BOOL  CInputFloatNumDLG::OnInitDialog()
{
	char buf[LMNAME];

	valtlBox = (CStatic*)GetDlgItem(IDC_INM_FLTTTL);
	valBox   = (CEdit*)GetDlgItem(IDC_INM_FLT);

	if (valtl!="") valtlBox->SetWindowText((LPCTSTR)valtl);

	bzero(buf, LMNAME);
	snprintf(buf, LMNAME-1, "%8f", val);
	valBox->SetWindowText((LPCTSTR)buf);

	return TRUE;
}



void  CInputFloatNumDLG::OnOK() 
{
	char buf[LMNAME];

	bzero(buf, LMNAME);
	valBox->GetWindowText(buf, LMNAME-1);
	val = atof(buf);

	CDialog::OnOK();
	return;
}







//////////////////////////////////////////////////////////////////////////////////////////
//
// CInputMultiFloatNumDLG _CAO
//

IMPLEMENT_DYNAMIC(CInputMultiFloatNumDLG, CDialog)

CInputMultiFloatNumDLG::CInputMultiFloatNumDLG(CWnd* pParent /*=NULL*/)
	: CDialog(CInputMultiFloatNumDLG::IDD, pParent)
{
	for (int i=0; i<6; i++) {
		valtlBox[i] = NULL;
		valBox[i]   = NULL;
		valtl[i]    = "";
		val[i]		= 0.0;
	}
}



CInputMultiFloatNumDLG::CInputMultiFloatNumDLG(CString t0, double v0, CString t1, double v1, CString t2, double v2, 
			                         CString t3, double v3, CString t4, double v4, CString t5, double v5, CWnd* pParent)
	: CDialog(CInputMultiFloatNumDLG::IDD, pParent)
{
	for (int i=0; i<6; i++) {
		valtlBox[i] = NULL;
		valBox[i]   = NULL;
	}

	valtl[0] = t0;
	valtl[1] = t1;
	valtl[2] = t2;
	valtl[3] = t3;
	valtl[4] = t4;
	valtl[5] = t5;
	val[0]   = v0;
	val[1]   = v1;
	val[2]   = v2;
	val[3]   = v3;
	val[4]   = v4;
	val[5]   = v5;
}



CInputMultiFloatNumDLG::~CInputMultiFloatNumDLG()
{
}



void CInputMultiFloatNumDLG::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}




BEGIN_MESSAGE_MAP(CInputMultiFloatNumDLG, CDialog)
END_MESSAGE_MAP()


// CInputNumDLG bZ[W nh



BOOL  CInputMultiFloatNumDLG::OnInitDialog()
{
	valtlBox[0] = (CStatic*)GetDlgItem(IDC_INM_MLT_VALTTL0);
	valtlBox[1] = (CStatic*)GetDlgItem(IDC_INM_MLT_VALTTL1);
	valtlBox[2] = (CStatic*)GetDlgItem(IDC_INM_MLT_VALTTL2);
	valtlBox[3] = (CStatic*)GetDlgItem(IDC_INM_MLT_VALTTL3);
	valtlBox[4] = (CStatic*)GetDlgItem(IDC_INM_MLT_VALTTL4);
	valtlBox[5] = (CStatic*)GetDlgItem(IDC_INM_MLT_VALTTL5);

	valBox[0]   = (CEdit*)GetDlgItem(IDC_INM_MLT_VAL0);
	valBox[1]   = (CEdit*)GetDlgItem(IDC_INM_MLT_VAL1);
	valBox[2]   = (CEdit*)GetDlgItem(IDC_INM_MLT_VAL2);
	valBox[3]   = (CEdit*)GetDlgItem(IDC_INM_MLT_VAL3);
	valBox[4]   = (CEdit*)GetDlgItem(IDC_INM_MLT_VAL4);
	valBox[5]   = (CEdit*)GetDlgItem(IDC_INM_MLT_VAL5);

	
	char buf[LMNAME];

	for (int i=0; i<6; i++) {
		if (valtl[i]!="") {
			valtlBox[i]->SetWindowText((LPCTSTR)valtl[i]);
			bzero(buf, LMNAME);
			snprintf(buf, LMNAME-1, "%8f", val[i]);
			valBox[i]->SetWindowText((LPCTSTR)buf);
		}
		else {
			CString mesg;
			mesg.LoadString(IDS_STR_UNUSED);
			valtlBox[i]->SetWindowText(mesg);
			valtlBox[i]->EnableWindow(FALSE);
			valBox[i]->SetWindowText((LPCTSTR)"0.0");
			valBox[i]->EnableWindow(FALSE);
		}
	}

	return TRUE;
}



void  CInputMultiFloatNumDLG::OnOK() 
{
	char buf[LMNAME];

	for (int i=0; i<6; i++) {
		bzero(buf, LMNAME);
		valBox[i]->GetWindowText(buf, LMNAME-1);
		val[i] = atof(buf);
	}

	CDialog::OnOK();
	return;
}








/////////////////////////////////////////////////////////////////////////////////////////

BOOL  jbxwl::InputNumDLG(CString title, int* val)
{
	CInputNumDLG* inpdlg = new CInputNumDLG(title, *val);
	if (inpdlg->DoModal()!=IDOK) { 
		delete(inpdlg);
		return FALSE;
	}

	*val = inpdlg->val;
	delete(inpdlg);
	return TRUE;
}




BOOL  jbxwl::InputFloatNumDLG(CString title, double* val)
{
	CInputFloatNumDLG* inpdlg = new CInputFloatNumDLG(title, *val);
	if (inpdlg->DoModal()!=IDOK) { 
		delete(inpdlg);
		return FALSE;
	}

	*val = inpdlg->val;
	delete(inpdlg);
	return TRUE;
}




BOOL  jbxwl::InputMultiFloatNumDLG(CString t0, double* v0, CString t1, double* v1, CString t2, double* v2,
								   CString t3, double* v3, CString t4, double* v4, CString t5, double* v5)
{
	CString  ttl[6];
	double   val[6];

	for (int i=0; i<6; i++) {
		ttl[i] = "";
		val[i] = 0.0;
	}

	if (t0!="" && v0!=NULL) {
		ttl[0] = t0;
		val[0] = *v0;
	}
	if (t1!="" && v1!=NULL) {
		ttl[1] = t1;
		val[1] = *v1;
	}
	if (t2!="" && v2!=NULL) {
		ttl[2] = t2;
		val[2] = *v2;
	}
	if (t3!="" && v3!=NULL) {
		ttl[3] = t3;
		val[3] = *v3;
	}
	if (t4!="" && v4!=NULL) {
		ttl[4] = t4;
		val[4] = *v4;
	}
	if (t5!="" && v5!=NULL) {
		ttl[5] = t5;
		val[5] = *v5;
	}

	CInputMultiFloatNumDLG* inpdlg = new CInputMultiFloatNumDLG(ttl[0], val[0], ttl[1], val[1], ttl[2], val[2],
																ttl[3], val[3], ttl[4], val[4], ttl[5], val[5]);
	if (inpdlg->DoModal()!=IDOK) { 
		delete(inpdlg);
		return FALSE;
	}

	if (v0!=NULL) *v0 = inpdlg->val[0];
	if (v1!=NULL) *v1 = inpdlg->val[1];
	if (v2!=NULL) *v2 = inpdlg->val[2];
	if (v3!=NULL) *v3 = inpdlg->val[3];
	if (v4!=NULL) *v4 = inpdlg->val[4];
	if (v5!=NULL) *v5 = inpdlg->val[5];

	delete(inpdlg);
	return TRUE;
}

