
#pragma once



#include  "stdafx.h"
#include   <Afxmt.h> 

#include  "LogRingBuffer.h"


#define  MAXBUFFERLINE 3000


//
namespace jbxwl {

using namespace jbxl;




class  CLogWndView;
class  CLogWndFrame;



class CLogWndDoc : public CDocument
{
protected:
	CLogWndDoc();
	CLogWndDoc(int bufsz, BOOL binhex=TRUE);

	DECLARE_DYNCREATE(CLogWndDoc)

public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

	CLogWndFrame*  pFrame;
	CLogWndView*   pView;

	CString	 Title;
	BOOL	 binHexMode;


public:
	void  lprintBuffer(Buffer buf, int input=LOG_RB_MESG);
	void  lprintString(char* str,  int input=LOG_RB_MESG);
	void  lprintFormat(char* fmt, ...);
	void  lfprintFormat(int input,  char* fmt, ...);

	void  printBuffer(Buffer buf, int input=LOG_RB_MESG);
	void  printString(char* str,  int input=LOG_RB_MESG);
	void  printFormat(char* fmt, ...);
	void  fprintFormat(int input,  char* fmt, ...);


public:
	virtual ~CLogWndDoc();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif



protected:
	DECLARE_MESSAGE_MAP()


public:
	CString				save_fname;
	CLogRingBuffer*		ringBuffer;
	CCriticalSection	criticalKey;


public:
	void		free(void);
	void		clear(void);
	int			writeLogFile(void);
	CString		easyGetSaveFileName(LPCSTR title, HWND hWnd);

	void		DeleteContents(void);
	CLogWndView*	GetView(void);
};




}		// namespace