



//#include "stdafx.h"

#include "DxBaseClass.h"


using namespace jbxwl;





//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CDxBaseView for DirectX

CDxBaseView::CDxBaseView()
{
	lpD3D		= NULL;
	lpD3DDevice = NULL;	// DirectX9 3DfoCX
	lpBackBuffer= NULL;	// obNobt@
	lpSurface   = NULL;	// T[tF[X
	lpTexture   = NULL;	// eNX`

	lpDInput	= NULL;
	lpDMouse	= NULL;	// }EXfoCX
	lpDKeyBoard	= NULL;	// L[{[hoCX

	bufferSize.x = bufferSize.y = 0;
}





CDxBaseView::~CDxBaseView()
{
	//DEBUG_ERR("DESTRUCT   CDxBaseView");
	if (pApp!=NULL) pApp->ViewDistructor(this);		// ʃAvP[Vɒʒm

//	RELEASE(lpDMouse);		// [X֎~
//	RELEASE(lpDKeyBoard);	// [X֎~
	RELEASE(lpTexture);
	RELEASE(lpSurface); 
	RELEASE(lpBackBuffer);
	RELEASE(lpD3DDevice);
}





/**
	@\F  DirectX9̃foCXD
	F	int cxs, cys EBhȄTCYCȗꍇ͉摜f[^(cmnHead)ɍ킹D
	ߒlF  FTRUE, sFFALSE
	F  
*/
BOOL  CDxBaseView::InitDx9Device(int xsize, int ysize, CWnd* cwnd)
{
	lpD3D = GpD3D;
	if (cwnd ==NULL) cwnd = this;
	SetDx9Parameter(&d3dParam, xsize, ysize);

	lpD3DDevice = Dx9CreateGraphic(lpD3D, &d3dParam, cwnd->m_hWnd);
	if (lpD3DDevice==NULL) return FALSE;
	
	// CvbgfoCX
	lpDMouse    = GpDMouse;
	lpDKeyBoard = GpDKeyBoard;
	
	return TRUE; 
}





//
void  CDxBaseView::ClearDx9Object()
{
	hasViewData = FALSE;
	RELEASE(lpBackBuffer);
	RELEASE(lpSurface);
}




//
//  foCX̃p[^ݒ肷DI[o[[h\D
//
void   CDxBaseView::SetDx9Parameter(D3DPRESENT_PARAMETERS* d3dParam, int xsize, int ysize)
{
	RECT rect;
		
	if (xsize>0 && ysize>0) {
		rect.right  = xsize;
		rect.bottom = ysize;
	}
	else {
		this->GetClientRect(&rect);
	}
	rect.right  = (int)(rect.right*1.5);
	rect.bottom = (int)(rect.bottom*1.5);

	ZeroMemory(d3dParam, sizeof(D3DPRESENT_PARAMETERS));
	d3dParam->BackBufferWidth        = rect.right; 
	d3dParam->BackBufferHeight       = rect.bottom;  
	d3dParam->BackBufferCount        = 1; 
	d3dParam->Windowed               = TRUE;
	d3dParam->SwapEffect             = D3DSWAPEFFECT_DISCARD;
//	d3dParam->SwapEffect             = D3DSWAPEFFECT_FLIP;
	d3dParam->BackBufferFormat       = D3DFMT_UNKNOWN;
	d3dParam->EnableAutoDepthStencil = TRUE;
	d3dParam->AutoDepthStencilFormat = D3DFMT_D16;
}





//
// EBhEʂɎ܂悤ɑ傫ČvZ
//
POINT  CDxBaseView::GetWindowDisplaySize(POINT pt)
{
	D3DDISPLAYMODE disp;

	lpD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &disp);	// [gEBhẼTCY
	int scrSize = Min(disp.Width, disp.Height)*2/3;

	int sz = Max(pt.x, pt.y);
	if (sz<=0) return pt; 
	
	float rs = 1.0f;
	if (sz>scrSize) {
		rs   = (float)scrSize/sz;
		pt.x = (int)(pt.x*rs);
		pt.y = (int)(pt.y*rs);
	}

	//wRateSize.Format("  (%3d%%)", (int)(rs*100+0.5));
	return pt;
}






/**
}EX{^`FbN
	}EX̉ꂽ{^`FbND

	߂l
		0 : {^͉ĂȂD
		1 : {^
		2 : E{^
		3 : {^

	 DirectInput gpD(~~;
*/
int   CDxBaseView::GetMouseButton() 
{
	int  ret = 0;
	DIMOUSESTATE dims;

	if (lpDMouse!=NULL && activeWin) {
		lpDMouse->Acquire();
		HRESULT hr = lpDMouse->GetDeviceState(sizeof(DIMOUSESTATE), &dims);
		if (SUCCEEDED(hr)) {
			if      (dims.rgbButtons[0]==0x80) ret = 1;				
			else if (dims.rgbButtons[1]==0x80) ret = 2;				
			else if (dims.rgbButtons[2]==0x80) ret = 3;								
		}
//		lpDMouse->Unacquire();
	}
	return  ret;
}






void  CDxBaseView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	if (lpDMouse!=NULL) {	
		lpDMouse->Unacquire();
		if (bActivate && pActivateView==this) {
			lpDMouse->Acquire();
		}
	}

	CExView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}









//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CDx3DBaseView NX
//

CDx3DBaseView::CDx3DBaseView()
{
	vb = lb = NULL;

	rotation  = false;
	ctrlMouse = true;
	reverseZ  = false;

	angleX = angleY = angleZ = 0.0f;
	angle = 0.0f;
	rTime = gTime = 0.0f;
	lTime = 1.0f;
	mWheelAc = 0.0f;

	startTime = (float)timeGetTime();

	D3DXMatrixIdentity(&matRotate);	
	D3DXMatrixIdentity(&matTrans);	
	D3DXMatrixIdentity(&matTemp);
}






CDx3DBaseView::~CDx3DBaseView()
{
	//DEBUG_ERR("DESTRUCT   CDx3DBaseView");
	if (pApp!=NULL) pApp->ViewDistructor(this);		// ʃAvP[Vɒʒm

	ReleaseVB();
}





void  CDx3DBaseView::SwitchRotation() 
{
	if (rotation) {
		rotation = false;
	}
	else {
		gTime = rTime = (float)timeGetTime() - startTime;
		rotation = true;
	}
	angleX = angleY = angleZ = 0.0f;
}





/**
]
  	̊֐̊OŁCmatTransisړj`Ă邱ƁD
	DirectInput ͋̂ŎgȂ....

*/
void  CDx3DBaseView::ExecRotation() 
{
	HRESULT  hr;

	rTime = (float)timeGetTime() - startTime;

	if (rotation) {
		angle = angle + (rTime - gTime);
		D3DXMatrixRotationY(&matRotateY, angle/(200.0f*10));
		D3DXMatrixRotationX(&matRotateX, angle/(100.0f*10));
		matRotate = matTemp*matRotateX*matRotateY;
	}

	else {
		DIMOUSESTATE dims;
		float  mwheel = 0.0f;

		if (lpDMouse!=NULL && activeWin) {
			lpDMouse->Acquire();
			hr = lpDMouse->GetDeviceState(sizeof(DIMOUSESTATE), &dims);
			if (SUCCEEDED(hr)) {
				if (ctrlMouse) {	// ctrlMouse: }EXɂ鑀삪\ǂD
					mwheel = (float)dims.lZ;
					if (dims.rgbButtons[0]==0x80) {	
						POINT pt = GetMousePos();
						if (pt.x>=0 && pt.y>=0) {
							angleX = (float)dims.lX;
							angleY = (float)dims.lY;
							ExRotationAngle();			// Ăяo̓sɂpxւD
							lTime  = rTime - gTime;
						}
						else ctrlMouse = false;
					}
				}
				if (dims.rgbButtons[0]!=0x80 && !ctrlMouse) {
					POINT pt = GetMousePos();						// NCAg̈ōNbN
					if (pt.x>=0 && pt.y>=0) ctrlMouse = true;		// }EXɂ鑀삪\ɁD
				}											 
			}
		}
		if (mwheel!=0.0f) {
			mWheelAc = mWheelAc - mwheel/2000.f;
			ExMouseWheel();
		}

		D3DXMatrixRotationX(&matRotateX, angleX/150.f*((rTime-gTime)/lTime));
		D3DXMatrixRotationY(&matRotateY, angleY/150.f*((rTime-gTime)/lTime));
		D3DXMatrixRotationZ(&matRotateZ, angleZ/150.f*((rTime-gTime)/lTime));
		matRotate = matTemp = matRotate*matRotateX*matRotateY*matRotateZ;
		angle = 0.0f;
	}
	gTime = rTime;

	matWorld = matTrans*matRotate;
	lpD3DDevice->SetTransform(D3DTS_WORLD, &matWorld);
}













/////////////////////////////////////////////////////////////////
// `

void  CDx3DBaseView::OnTimer(UINT nIDEvent) 
{
	if (hasViewData) {
		if (doReSize) ExecWindowReSize(clientRect.right, clientRect.bottom);
		else          ExecRotation();
		ExecRender();
	}
	else  DEBUG_ERR("CDx3DBaseView::OnTimer: \\ȃf[^܂");
}





void  CDx3DBaseView::OnDraw(CDC* pDC)
{
	if (hasViewData && timerID==-1) {
		if (doReSize) ExecWindowReSize(clientRect.right, clientRect.bottom);
		else          ExecRotation();
		ExecRender();
	}
	else if (!hasViewData) DEBUG_ERR("CDx3DBaseView::OnDraw: \\ȃf[^܂");
}











//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
	@\F  DirectX9̃foCXZbgD

	F	lpD3DDevice		ZbgDirectX9foCX 
			*d3dParam		foCXZbĝ߂̃p[^D쐬Ɏgp̂w肷D
			*pviw			̃foCXĂ CDxBaseViewNXw肷Dȗ\iNULLj  

	ߒlF  Zbg HRESULT

	F  D3DPOOL_DEFAULTǗ̃\[XȂǂ́CfoCX̃ZbgsOɂJC
			ZbgɍĂъlȂ΂ȂȂDpviw CDxBaseViewNX̃|C^ݒ
			ꍇC֐Ƃ pviw->ClearDx9Object() ĂяoCĊl֐Ƃ 
			pviw->InitDx9Object()ĂяoD̂Q̊֐́CCDxBaseViewNX̌pNX
			̒ŃI[o[ChȂ΂ȂȂDpviw  NULLw肵ꍇ́C\[X
			̊JEĊl͍sȂD

			CDxBaseView* Ɏ̂ŁCDx9.cpp ւ͓ȂD
*/
HRESULT   jbxwl::ResetDx9Device(LPDIRECT3DDEVICE9 lpD3DDevice, D3DPRESENT_PARAMETERS* pd3dParam, CDxBaseView* pviw)
{
	HRESULT hr = lpD3DDevice->TestCooperativeLevel();
	if (hr==D3D_OK) return hr;

	do {
		Sleep(100);
		hr = lpD3DDevice->TestCooperativeLevel();
	} while (hr==D3DERR_DEVICELOST);	// foCXZbgł悤ɂȂ܂ő҂D

	if (hr==D3DERR_DEVICENOTRESET) {	// Zbg\
		if (pviw) pviw->ClearDx9Object();
		hr = lpD3DDevice->Reset(pd3dParam); 
		if (hr==D3D_OK) {				// Zbg
			if (pviw) pviw->InitDx9Object();
		}
	}
	return  hr;	
}




