/**
	SLKinect.h  by Fumi.Iseki (c)


*/



#pragma once

#ifndef __AFXWIN_H__
	#error "PCH ɑ΂Ẵt@CCN[hO 'stdafx.h' CN[hĂ"
#endif


#include  "resource.h"       // C V{

#include  "KinectWnd.h"
#include  "MainFrm.h"

#include  "Vector.h"
#include  "Rotation.h"

#include  "WinBaseLib.h"
#include  "GnMFCLib.h"
#include  "MFCLib.h"
#include  "LogWndFrame.h"



#define    SL_MAX_JOINT_NUM		19
#define	   SL_SHM_SIZE			64	


// EBhETCY
#define	   APP_WND_XSIZE		800
#define	   APP_WND_YSIZE		650


#define    EXKINECT_WND_CONFIDENCE	0.8




using namespace jbxl;
using namespace jbxwl;



////////////////////////////////////////////////////////////////////////////////////
//
// CExKinectWnd:@
//

class  CExKinectWnd : public CKinectWnd
{
public:
	CExKinectWnd();
	~CExKinectWnd() {}


public:
	BOOL			isUseCamera;
	BOOL			isCalibrated;

	BOOL			printPosMode;
	BOOL			printRotMode;
	BOOL			printQutMode;

	Vector<double>	startPos;

public:
	void			clearBoneData(void);
	void			clearStartPosData(void);
	void			setStartPosData(Vector<double> vect);

public:
	Vector<double>	posVect[OPENNI_MAX_JOINT_NUM];
	Vector<double>	prvVect[OPENNI_MAX_JOINT_NUM];

	Quaternion		rotQuat[OPENNI_MAX_JOINT_NUM];
	Quaternion		prvQuat[OPENNI_MAX_JOINT_NUM];

	virtual void	logingJointsData(int uid);
	virtual void	convertData(int uid);
	
	void			convertRot2SLData(int uid);
	void			convertPos2SLData(int uid) {};

};





////////////////////////////////////////////////////////////////////////////////////
//
// CSLKinectApp:
//

class CSLKinectApp : public CWinApp, public CAppCallBack
{
public:
	CMainFrame*			pMainFrame;

	CLogWndFrame*		pLogFrame;
	CLogWndDoc*			pLogDoc;
		
	CDxDirectView*		pSensorView;
	CDx3DDirectView*	pModelView;

	CExKinectWnd*		kinect;

	int					cameraScale;
	BOOL				nowMirroring;

	BOOL				isShmCreated;
	HANDLE				mapHandle[SL_MAX_JOINT_NUM];
	double*				ptrShm[SL_MAX_JOINT_NUM];


public:
	CSLKinectApp();
	~CSLKinectApp();

	void	DeleteKinect() { if (kinect!=NULL) delete(kinect); kinect = NULL;}

	CMultiDocTemplate*  pDocTemplLOG;
	CMultiDocTemplate*  pDocTemplSNR;
	CMultiDocTemplate*  pDocTemplMDL;

	void	SensorWndOpen(void);

	BOOL	CreateShm(void);
	void	CloseShm(void);
	void	ClearShm(void);


public:
	virtual BOOL InitInstance();

	virtual void FrameDistructor(CExFrame* frm);
	virtual void ViewDistructor(CExView* view);

	afx_msg void OnAppAbout();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnModelingWndOpen();
	afx_msg void OnLogWndOpen();
	afx_msg void OnSnsrWndOpen_x1();
	afx_msg void OnSnsrWndOpen_x2();
	afx_msg void OnSnsrWndOpen_x3();
	afx_msg void OnSnsrWndOpen_x4();
	afx_msg void OnSettingLogingmode();
	afx_msg void OnSettingViewmode();
};


extern CSLKinectApp theApp;



