// SetLogMode.cpp : t@C
//

#include "stdafx.h"
#include "SLKinect.h"
#include "SetLogMode.h"


// CSetLogMode _CAO

IMPLEMENT_DYNAMIC(CSetLogMode, CDialog)

CSetLogMode::CSetLogMode(BOOL pos, BOOL rot, BOOL qut, CWnd* pParent /*=NULL*/)
	: CDialog(CSetLogMode::IDD, pParent)
{
	posPrintMode	= pos;
	rotPrintMode	= rot;
	qutPrintMode	= qut;

	posCBox			= NULL;
	rotCBox			= NULL;
	qutCBox			= NULL;
}



CSetLogMode::~CSetLogMode()
{
}



void CSetLogMode::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}




BEGIN_MESSAGE_MAP(CSetLogMode, CDialog)
END_MESSAGE_MAP()




BOOL CSetLogMode::OnInitDialog()
{
	CDialog::OnInitDialog();

	posCBox = (CButton*)GetDlgItem(IDC_CHECK_LOG_POSITION);
	rotCBox = (CButton*)GetDlgItem(IDC_CHECK_LOG_ROT_MATRIX);
	qutCBox = (CButton*)GetDlgItem(IDC_CHECK_LOG_QUATERNION);

	if (posPrintMode) posCBox->SetCheck(1);
	else              posCBox->SetCheck(0);

	if (rotPrintMode) rotCBox->SetCheck(1);
	else              rotCBox->SetCheck(0);
	
	if (qutPrintMode) qutCBox->SetCheck(1);
	else              qutCBox->SetCheck(0);

	return TRUE;
}



void CSetLogMode::OnOK()
{
	if (posCBox->GetCheck()) posPrintMode = TRUE;
	else                     posPrintMode = FALSE;

	if (rotCBox->GetCheck()) rotPrintMode = TRUE;
	else                     rotPrintMode = FALSE;
	
	if (qutCBox->GetCheck()) qutPrintMode = TRUE;
	else                     qutPrintMode = FALSE;

	CDialog::OnOK();
}

