/* vi: set tabstop=4 nocindent noautoindent: */

/**
ÍpCu  cipher.c

  wb_ 
	  #include "cipher.h"

 */





#include "cipher.h"




/**
Buffer  xlcrypt(Buffer str, Buffer salt)

	@\: crypt֐(DES)ɂ passwd̑diQjnbVlD
		  salt̒ɉ,pX[h𑽏dɃnbVlD
		  salt2ByteɈnbVlsD

	: passwd	nbVlpX[hD
		  salt 		saltL[D(j

	߂l: nbVlꂽpX[hXgODsaltL[͕ԂȂDʏ 11Byte.

 */
Buffer  xlcrypt(Buffer str, Buffer salt)
{
	int   i, len, lsalt;
	char* passwd;
	char  pass[LPASS+1];
	Buffer ret;

	memset(pass, 0, LPASS+1);
	len = Min((int)strlen((const char*)str.buf), LPASS);
	memcpy(pass, str.buf, len);

	lsalt = ((int)strlen((const char*)salt.buf)/2)*2;
	if (lsalt>=2) {
		passwd = (char*)crypt((const char*)pass, (const char*)salt.buf);
		if (strncmp((const char*)salt.buf, "$1$", 3)) {
			// DES
			for (i=2; i<lsalt; i=i+2) {
				passwd = (char*)crypt((const char*)(passwd+2), (const char*)(salt.buf+i));
			}
			ret = set_Buffer(passwd+2, -1);
		}
		else {
			// MD5
			ret = set_Buffer(passwd+12, -1);
		}
	}
	else {
		ret = init_Buffer();
	}

	return ret;
}





/**
void  setkey_byBase64(Buffer key)

	@\: Base64ɂăGR[hꂽfR[h,
		  encrypt֐(DES)̈ÍL[ƂĐݒ肷DL[͒ʏ
		  8Byte(64bit),LȂ͍̂ŏ7Byte(56bit)łD

	: key	 Í̃L[

	߂l: ȂD
*/
void  setkey_byBase64(Buffer key)
{
	Buffer tmpkey, deskey; 

	tmpkey = decode_base64_Buffer(key);
	deskey = to_bin64(tmpkey); 

	setkey((const char*)deskey.buf);
	free_Buffer(&tmpkey);
	free_Buffer(&deskey);
	return;
}
	



/**
void  setkey_byBuffer(Buffer key)

	@\: AXL[(8Byte)p,encrypt֐(DES)̈ÍL[
		  ݒ肷D,L[ƂėLȂ͍̂ŏ7BytełD

	: key  -- Í̃L[

	߂l: ȂD
*/
void  setkey_byBuffer(Buffer key)
{
	Buffer deskey; 

	deskey = to_bin64(key); 
	setkey((const char*)deskey.buf);
	free_Buffer(&deskey);

	return;
}





/**
Buffer  encrypt_Buffer(Buffer buf, int mode)

	@\: oCif[^̈Í܂͕s(DES)D
		  ̊֐ĂԑO, setkey_XXXX()֐ňÍL[ݒ肵Ȃ
		  ȂȂD

	: buf   --  Í܂͕sf[^D
		  mode  --  0  Í
				--  1  

	߂l: Í̏ꍇ -- Íꂽf[^D
			̏ꍇ -- ꂽf[^D
*/
Buffer  encrypt_Buffer(Buffer buf, int mode)
{
	Buffer  str, cry;

	str = to_bin64(buf);
	encrypt((char*)str.buf, mode);
	cry = from_bin64(str);
	free_Buffer(&str);
	return  cry;
}




/**
Buffer  encrypt_Base64(Buffer str, int mode)

	@\: ̈Í܂͕s(DES)DÍ܂͕
		  Base64ŃGR[hĂDł͈U Base64
		  fR[hďȂCĂуGR[hD
		  ̊֐ĂԑO, setkey_XXXX()֐ňÍL[ݒ肵Ȃ
		  ȂȂD

	: str   --  Í܂͕s Base64D
		  mode  --  0  Í
				--  1  

	߂l: Í܂͕ꂽDBase64ŃGR[hD
*/
Buffer  encrypt_Base64(Buffer buf, int mode)
{
	Buffer dec, str, enc;

	dec = decode_base64_Buffer(buf);
	str = encrypt_Buffer(dec, mode);
	free_Buffer(&dec);

	enc = encode_base64_Buffer(str);
	free_Buffer(&str);
	return enc;
}






/**
Buffer  to_bin64(Buffer str)

	@\FBit 0,1̃oCg(64Byte)ɕϊ (bin64`Ɍւ)D
		  Ⴆ΁A 2 0,0,0,0,0,.....,0,1,0 ̃oCg(64Byte)ɂȂD

	Fstr   oCgɕϊrbgD

	߂lFϊꂽoCgD1oCg 0,1̗Dbin64`D
*/
Buffer  to_bin64(Buffer str)
{
	int	i, mi;
	Buffer ret;

	ret = make_Buffer(64);
	if (ret.buf==NULL) return ret;

	mi = Min(64, str.vldsz*8);
	for (i=0; i<mi; i++) ret.buf[i] = (uByte)getBit(str.buf, i);
	ret.vldsz = mi;
	return ret;
}





/**
Buffer  from_bin64(Buffer str)

	@\F0,1̃oCg(64Byte, bin64`) 8bytẽrbgɕϊD

	Fstr   rbgɕϊoCgD64Byte. bin64`D

	߂lFϊꂽrbgD8Byte.  64bit.
*/
Buffer  from_bin64(Buffer str)
{
	int	i;
	Buffer ret;
	
	ret = init_Buffer();
	if (str.vldsz!=64) return ret;

	ret = make_Buffer(8);
	if (ret.buf==NULL) return ret;

	for (i=0; i<64; i++) setBit(ret.buf, i, (int)str.buf[i]);
	ret.vldsz = 8;
	return  ret;
}





/**
void  dump_bin64(char* format, Buffer str)

	@\Fbin64`WG[o͂ɕ\D

	Fformat  bin64̓e\Oɕ\^CgD
		  str	 \ bin64`̃oCg

	߂lFȂD
*/
void  dump_bin64(char* format, Buffer str)
{
	int  i;

	fprintf(stderr, format);
	for (i=0; i<str.vldsz; i++) fprintf(stderr, "%1d", str.buf[i]);
	fprintf(stderr, "\n");
}



