
#ifndef  __JBXL_CPP_OPENNI_TOOL_H_
#define  __JBXL_CPP_OPENNI_TOOL_H_



#include  <XnCppWrapper.h>

#include  "common++.h"
#include  "buffer.h"



//
namespace jbxl {



//#define   OPENNI_XGA_MODE

#define   OPENNI_MAX_USERS_NUM		6
#define	  OPENNI_MAX_JOINT_NUM		25	// see <XnTypes.h>   24 + 1 

#define	  OPENNI_JOINT_CONFIDENCE	0.5

#define   OPENNI_LEN_POSE_NAME		20

#define   OPENNI_DETECT_STOPPED		0
#define   OPENNI_DETECT_STARTING	1
#define   OPENNI_DETECT_EXEC		2
#define   OPENNI_DETECT_STOPPING	3



#ifdef  OPENNI_XGA_MODE
	#define OPENNI_DEPTH_XSIZE  XN_XGA_X_RES
	#define OPENNI_DEPTH_YSIZE  XN_XGA_Y_RES
	#define OPENNI_DEPTH_FPS    15
#else
	#define OPENNI_DEPTH_XSIZE  XN_VGA_X_RES
	#define OPENNI_DEPTH_YSIZE  XN_VGA_Y_RES
	#define OPENNI_DEPTH_FPS    30
#endif





class  COpenNiTool
{
public:
	COpenNiTool(void)	  { init();}
	~COpenNiTool(void)	  { free();}

	int		m_scale;
	int     m_state;
	Buffer  m_err_mesg;

public:
	void	init();
	void	free(void);
	void	clearJointsData(void);

	BOOL	create_Image(void);
	BOOL	create_User(void);
	BOOL	create_Depth(void);
	BOOL	make_Skeleton(void);
	BOOL	setup_CallBacks(void);

	void	delete_Image(void);
	void	delete_User(void);
	void	delete_Depth(void);

	void	clear_CallBacks(void);
	void	clear_Skeleton(void);
	void	clear_Tracking(void);

	BOOL	setUserCallbacks(xn::UserGenerator::UserHandler newUser, xn::UserGenerator::UserHandler lostUser, void* cookie);
	BOOL	setPoseCallbacks(xn::PoseDetectionCapability::PoseDetection detectPose, xn::PoseDetectionCapability::PoseDetection lostPose, void* cookie);
	BOOL	setCalibCallbacks(xn::SkeletonCapability::CalibrationStart calibStart, xn::SkeletonCapability::CalibrationEnd calibEnd, void* cookie);

	void	unsetUserCallbacks(void);
	void	unsetPoseCallbacks(void);
	void	unsetCalibCallbacks(void);

	BOOL	start_Detection(void);
	BOOL	stop_Detection(void);

	std::string	getJointName(XnSkeletonJoint joint);
	void		getJointsPositionData(XnUserID nId);
	void		getJointsRotationData(XnUserID nId);

	XnVector3D		jointPositionData(XnSkeletonJoint joint) { return jointPosData[(int)joint];}
	XnMatrix3X3		jointRotationData(XnSkeletonJoint joint) { return jointRotData[(int)joint];}
	float			jointPositionConfidence(XnSkeletonJoint joint) { return (float)jointPosConfidence[(int)joint];}
	float			jointRotationConfidence(XnSkeletonJoint joint) { return (float)jointRotConfidence[(int)joint];}


public:
	xn::Context*			context;	
	xn::ImageGenerator*		image;
	xn::DepthGenerator*		depth;
	xn::UserGenerator*		user;

	xn::PoseDetectionCapability* pose;
	xn::SkeletonCapability*	skeleton;

	xn::ImageMetaData*		imageMD;
	xn::DepthMetaData*		depthMD;
	xn::SceneMetaData*		sceneMD;

	XnChar*					poseName;

	XnMapOutputMode			outputMode;

	XnCallbackHandle		userCallbacks;
	XnCallbackHandle		poseCallbacks;
	XnCallbackHandle		calibCallbacks;

	XnUserID				dUsers[OPENNI_MAX_USERS_NUM];
	XnUInt16				nUsers;
	XnStatus				rc;

	uByte*					imageData;
	XnLabel*				depthData;

protected:
	XnVector3D				jointPosData[OPENNI_MAX_JOINT_NUM];			// no data at [0]
	XnMatrix3X3				jointRotData[OPENNI_MAX_JOINT_NUM];			// no data at [0]
	XnConfidence			jointPosConfidence[OPENNI_MAX_JOINT_NUM];
	XnConfidence			jointRotConfidence[OPENNI_MAX_JOINT_NUM];

};




////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Callback Functions

void  XN_CALLBACK_TYPE userDetect(xn::UserGenerator& user, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE userLost  (xn::UserGenerator& user, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE poseDetect(xn::PoseDetectionCapability& pose, const XnChar* poseName, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE poseLost  (xn::PoseDetectionCapability& pose, const XnChar* poseName, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE calibStart(xn::SkeletonCapability& skeleton, XnUserID nId, void* cookie);
void  XN_CALLBACK_TYPE calibEnd  (xn::SkeletonCapability& skeleton, XnUserID nId, XnBool success, void* cookie);




}		// namespace


#endif










////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Information

/*
XnTypes.h

typedef enum XnSkeletonJoint
{
	XN_SKEL_HEAD			= 1,
	XN_SKEL_NECK			= 2,
	XN_SKEL_TORSO			= 3,
	XN_SKEL_WAIST			= 4,

	XN_SKEL_LEFT_COLLAR		= 5,
	XN_SKEL_LEFT_SHOULDER	= 6,
	XN_SKEL_LEFT_ELBOW		= 7,
	XN_SKEL_LEFT_WRIST		= 8,
	XN_SKEL_LEFT_HAND		= 9,
	XN_SKEL_LEFT_FINGERTIP	=10,

	XN_SKEL_RIGHT_COLLAR	=11,
	XN_SKEL_RIGHT_SHOULDER	=12,
	XN_SKEL_RIGHT_ELBOW		=13,
	XN_SKEL_RIGHT_WRIST		=14,
	XN_SKEL_RIGHT_HAND		=15,
	XN_SKEL_RIGHT_FINGERTIP	=16,

	XN_SKEL_LEFT_HIP		=17,
	XN_SKEL_LEFT_KNEE		=18,
	XN_SKEL_LEFT_ANKLE		=19,
	XN_SKEL_LEFT_FOOT		=20,

	XN_SKEL_RIGHT_HIP		=21,
	XN_SKEL_RIGHT_KNEE		=22,
	XN_SKEL_RIGHT_ANKLE		=23,
	XN_SKEL_RIGHT_FOOT		=24	
} XnSkeletonJoint;
*/