
#ifndef  __JBXL_CPP_VECTOR_H_
#define  __JBXL_CPP_VECTOR_H_


/**
xNgCu

	template <typename T=double> class DllExport Vector		// RxNg̒`
	template <typename T=double> class DllExport Vector2D	// QxNg̒`, pgbNȖʗp
	template <typename T=int> class DllExport  PCoordinate	// p`̍W̒li[NX
	template <typename T=int> class DllExport RBound		// E\

	template <typename T> inline bool disJunctBounds(RBound<T> b1, RBound<T> b2);
*/



#include "common++.h"
#include "tools++.h"

#include <stdlib.h>
#include <math.h>

#include "Tolerance.h"



//
namespace  jbxl {



#define  VECTOR    Vector
#define  VECTOR2D  Vector2D


#define  BOUNDARY_BLANK 5		// E RBound<T> ̗]





/**
template <typename T=double> class Vector

	RxNg̒`

*/
template <typename T=double> class DllExport Vector
{
public:
	T x;
	T y;
	T z;

	double n;		// m

public:
	Vector(T X=0, T Y=0, T Z=0, double N=0.0) { set(X, Y, Z, N);}
	~Vector(void) {}

	T      norm2(void) { return (x*x + y*y + z*z);}
	double norm(void)  { n=sqrt((double)(x*x + y*y + z*z)); return n;}
	void   normalize(void);

	void   set(T X, T Y=0, T Z=0, double N=0.0);
	void   init(void) { x = y = z = (T)0; n = 0.0;}
};




template <typename T> void Vector<T>::normalize(void)
{
	double nrm = sqrt((double)x*x+y*y+z*z);

	if (nrm>=Zero_Eps) {
		x  = (T)(x/nrm);
		y  = (T)(y/nrm);
		z  = (T)(z/nrm);
		n  = 1.0;
	}
	else {
		init();
	}
}




/**
template <typename T> void Vector<T>::set(T X, T Y, T Z, double N) 

	RxNgɒlZbgD

*/
template <typename T> void Vector<T>::set(T X, T Y, T Z, double N) 
{
	x  = X;
	y  = Y;
	z  = Z;
	n  = N;

	if (n<=0.0) {
		n = sqrt((double)(x*x + y*y + z*z));
	}
}






/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Iy[^

template <typename T> inline Vector<T> operator - (const Vector<T> a)
{ return Vector<T>(-a.x, -a.y, -a.z, a.n); }



template <typename T> inline Vector<T> operator + (const Vector<T> a, const Vector<T> b)
{ return Vector<T>(a.x+b.x, a.y+b.y, a.z+b.z); }



template <typename T> inline Vector<T> operator - (const Vector<T> a, const Vector<T> b)
{ return Vector<T>(a.x-b.x, a.y-b.y, a.z-b.z); }



template <typename T, typename R> inline Vector<T> operator * (const R d, const Vector<T> a)
{ return Vector<T>((T)d*a.x, (T)d*a.y, (T)d*a.z); }



template <typename T, typename R> inline Vector<T> operator * (const Vector<T> a, const R d)
{ return Vector<T>(a.x*(T)d, a.y*(T)d, a.z*(T)d); }



template <typename T, typename R> inline Vector<T> operator / (const Vector<T> a, const R d)
{ return Vector<T>(a.x/(T)d, a.y/(T)d, a.z/(T)d); }



// Cross product  O
template <typename T> inline Vector<T> operator ^ (const Vector<T> a, const Vector<T> b)
{ return Vector<T>(a.y*b.z-a.z*b.y, a.z*b.x-a.x*b.z, a.x*b.y-a.y*b.x); }



// Dot product    
template <typename T> inline T operator * (const Vector<T> a, const Vector<T> b)
{ return (a.x*b.x + a.y*b.y + a.z*b.z); }



template <typename T> inline bool operator == (const Vector<T> v1, const Vector<T> v2)
{ return (v1.x==v2.x && v1.y==v2.y && v1.z==v2.z); }



//
template <typename T> inline Vector<T> MidPoint(const Vector<T> a, const Vector<T> b)
{ return 0.5*(a+b); }



//
// _a  b ̋@ia,b ͈ʒuxNgj
//
template <typename T> inline double VectorDist(const Vector<T> a, const Vector<T> b)
{
	//return (b-a).norm();
	return (b-a).n;
}



template <typename T> inline bool operator < (const Vector<T> v1, const Vector<T> v2)
{
	if (v1.x != v2.x) return v1.x < v2.x;
	if (v1.y != v2.y) return v1.y < v2.y;
	if (v1.z != v2.z) return v1.z < v2.z;
	return false;
}





/////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
template <typename T=double> class Vector2D

	QxNg̒`
	pgbNȖʗp

*/
template <typename T=double> class DllExport Vector2D
{
public:
	T  u;
	T  v;

public:
	Vector2D(const T U=0, const T V=0) : u(U), v(V) {}
};





/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 3Dp`W

/**
template <typename T=int> class DllExport  PCoordinate

	p`̍W̒li[NX

*/
template <typename T=int> class DllExport  PCoordinate
{
public:
	int  dim;
	Vector<T>** point;

public:
	
	PCoordinate(void)  { dim = 0; point = NULL;}
	PCoordinate(int n) { init(n);}

	~PCoordinate(void) {}


	//
	void  init(int n) {
		dim   = 0;
		point = NULL;

		if (n>0) {
			point = (Vector<T>**)malloc(sizeof(Vector<T>*)*n);
			if (point!=NULL) {
				dim = n;
				for (int i=0; i<dim; i++) point[i] = new Vector<T>();
			}
		}
	}


	void  set(int m, T x, T y=0, T z=0, double n=0.0) {
		if (m>=0 && m<dim && point!=NULL) point[m]->set(x, y, z, n); 
	}		
	

	void  clear(void) {
		if (point!=NULL) {
			for (int i=0; i<dim; i++) point[i]->set((T)0);
		}
	}


	void  free(void) {
		if (point!=NULL) {
			for (int i=0; i<dim; i++) delete(point[i]);
			::free(point);
			point = NULL;
		}
		dim = 0;
	}

};






/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// E\

/**
template <typename T=int> class RBound 

	Ë̍\CLASS  RBound ̒`
		xmin: xE̍ŏlD
		xmax: xE̍őlD
		ymin: yE̍ŏlD
		ymax: yE̍őlD
		zmin: zE̍ŏlD
		zmax: zE̍őlD
		tmin: ėpD
		tmax: ėpD
		3Df[^̋Eۑ^D 
*/
template <typename T=int> class DllExport RBound 
{
public:
    T   xmin;
    T   xmax;
    T   ymin;
    T   ymax;
    T   zmin;
    T   zmax;
	T   tmin;
	T   tmax;

public:

	RBound(T XMin=(T)0, T XMax=(T)0, T YMin=(T)0, T YMax=(T)0, T ZMin=(T)0, T ZMax=(T)0, T TMin=(T)0, T TMax=(T)0) {
		set(XMin, XMax, YMin, YMax, ZMin, ZMax, TMin, TMax);
	}

	~RBound() {}


	//
	void  set(T XMin=(T)0, T XMax=(T)0, T YMin=(T)0, T YMax=(T)0, T ZMin=(T)0, T ZMax=(T)0, T TMin=(T)0, T TMax=(T)0){
		xmin = XMin;
		ymin = YMin;
		zmin = ZMin;
		xmax = XMax;
		ymax = YMax;
		zmax = ZMax;
		tmin = TMin;
		tmax = TMax;
	}		

	void init() { xmin = xmax = ymin = ymax = zmin = zmax = tmin = tmax = (T)0;}




	///////////////////////////////////////////
	// g

	// E\ bound L
	void  enlarge(T f) {
		xmin -= f;
		ymin -= f;
		zmin -= f;
		xmax += f;
		ymax += f;
		zmax += f;
	}



	///////////////////////////////////////////
	// Z

	// E\ bound ƗZ
	void  fusion(RBound<T> bound) {
		xmin = Min(xmin, bound.xmin);
		ymin = Min(ymin, bound.ymin);
		zmin = Min(zmin, bound.zmin);
		xmax = Max(xmax, bound.xmax);
		ymax = Max(ymax, bound.ymax);
		zmax = Max(zmax, bound.zmax);
	}


	// xNg vect ƗZ  
	void  fusion(Vector<T> vect){
		xmin = Min(xmin, vect.x);
		ymin = Min(ymin, vect.y);
		zmin = Min(zmin, vect.z);
		xmax = Max(xmax, vect.x);
		ymax = Max(ymax, vect.y);
		zmax = Max(zmax, vect.z);
	}


	// |CgƗZ  
	void  fusion(T x, T y, T z){
		xmin = Min(xmin, x);
		ymin = Min(ymin, y);
		zmin = Min(zmin, z);
		xmax = Max(xmax, x);
		ymax = Max(ymax, y);
		zmax = Max(zmax, z);
	}




	///////////////////////////////////////////
	// ʗ̈

	// E\ bound Ƃ̋ʗ̈  ʗ̈悪Ȃꍇ́Cmin>max ɂȂ
	void  commonarea(RBound<T> bound) {
		xmin = Max(xmin, bound.xmin);
		ymin = Max(ymin, bound.ymin);
		zmin = Max(zmin, bound.zmin);
		xmax = Min(xmax, bound.xmax);
		ymax = Min(ymax, bound.ymax);
		zmax = Min(zmax, bound.zmax);
	}



	///////////////////////////////////////////
	// ؂oꍇ̋E
	void  cutdown(RBound<T> bound) {
		xmin += bound.xmin;
		ymin += bound.ymin;
		zmin += bound.zmin;
		xmax += bound.xmin;
		ymax += bound.ymin;
		zmax += bound.zmin;
	}


	//   
	void  cutdown(Vector<T> vect){
		xmin += vect.x;
		ymin += vect.y;
		zmin += vect.z;
		xmax += vect.x;
		ymax += vect.y;
		zmax += vect.z;
	}

	
	//  
	void  cutdown(T x, T y, T z){
		xmin += x;
		ymin += y;
		zmin += z;
		xmax += x;
		ymax += y;
		zmax += z;
	}



	// xNgʒuxNg̏ꍇC̓_͋EOHD@EOFtrueCEFfalse
	bool  outofBounds(Vector<T> vect) {
		return	vect.x < xmin || vect.x > xmax ||
				vect.y < ymin || vect.y > ymax ||
				vect.z < zmin || vect.z > zmax;
	}


	// ̓_͋EOHD@EOFtrueCEFfalse
	bool  outofBounds(T x, T y, T z) {
		return	x < xmin || x > xmax ||
				y < ymin || y > ymax ||
				z < zmin || z > zmax;
	}

};




/**
template <typename T> inline bool disJunctBounds(RBound<T> b1, RBound<T> b2)
	
	Ëb1b2dȂĂ邩ǂ`FbN
   
	ߒlF 
		dȂĂȂFtrue 
		dȂĂ  Ffalse

*/
template <typename T> inline bool disJunctBounds(RBound<T> b1, RBound<T> b2)
{
	return	(b1.xmin >= b2.xmax) || (b2.xmin >= b1.xmax) || 
			(b1.ymin >= b2.ymax) || (b2.ymin >= b1.ymax) || 
			(b1.zmin >= b2.zmax) || (b2.zmin >= b1.zmax);
}








}		// namespace


#endif 


