// SensorFrame.cpp : t@C
//

#include "stdafx.h"
#include "SensorFrame.h"


using namespace jbxl;
using namespace jbxwl;



// CSensorFrame

IMPLEMENT_DYNCREATE(CSensorFrame, CExFrame)

CSensorFrame::CSensorFrame()
{
	kinectApp = NULL;
}



CSensorFrame::~CSensorFrame()
{
}




BEGIN_MESSAGE_MAP(CSensorFrame, CExFrame)
	ON_UPDATE_COMMAND_UI(ID_CALIB_START, &CSensorFrame::OnStartButtonUpdate)
	ON_UPDATE_COMMAND_UI(ID_CALIB_STOP,  &CSensorFrame::OnStopButtonUpdate)
	ON_COMMAND(ID_CALIB_START, OnCalibrationStart)
	ON_COMMAND(ID_CALIB_STOP,  OnCalibrationStop)
	ON_WM_CREATE()
END_MESSAGE_MAP()




// CSensorFrame bZ[W nh

int  CSensorFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CExFrame::OnCreate(lpCreateStruct) == -1) return -1;

	toolBar = new CExToolBar(this);
	if (!toolBar->CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP 
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC | WS_CLIPCHILDREN) ||
		!toolBar->LoadToolBar(IDR_CALIB_TOOLBAR))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;
	}

	return 0;
}




void  CSensorFrame::OnStartButtonUpdate(CCmdUI* pCmdUI)
{
	if (kinectApp->kinect->m_state==OPENNI_DETECT_STOPPED) {
		pCmdUI->Enable(TRUE);
	}
	else {
		pCmdUI->Enable(FALSE);
	}
}




void  CSensorFrame::OnStopButtonUpdate(CCmdUI* pCmdUI)
{
	if (kinectApp->kinect->m_state==OPENNI_DETECT_EXEC) {
		pCmdUI->Enable(TRUE);
	}
	else {
		pCmdUI->Enable(FALSE);
	}
}




void  CSensorFrame::OnCalibrationStart()
{
	if (kinectApp!=NULL && kinectApp->kinect!=NULL) {
		if (kinectApp->kinect->m_state==OPENNI_DETECT_STOPPED) {
			kinectApp->kinect->m_state = OPENNI_DETECT_STARTING;

			kinectApp->kinect->clearBoneData();
			kinectApp->kinect->clearStartPosData();

			if (!kinectApp->kinect->start_Detection()) {
				CString mesg, noti;
				noti.LoadString(IDS_STR_ERROR);
				mesg.SetString((char*)kinectApp->kinect->m_err_mesg.buf);
				MessageBox(mesg, noti, MB_OK);
			}
		}
	}
}




void  CSensorFrame::OnCalibrationStop()
{
	if (kinectApp!=NULL && kinectApp->kinect!=NULL) {
		if (kinectApp->kinect->m_state==OPENNI_DETECT_EXEC) {
			kinectApp->kinect->m_state = OPENNI_DETECT_STOPPING;

			if (!kinectApp->kinect->stop_Detection()) {	// set OPENNI_DETECT_STOPPED
				CString mesg, noti;
				noti.LoadString(IDS_STR_ERROR);
				mesg.SetString((char*)kinectApp->kinect->m_err_mesg.buf);
				MessageBox(mesg, noti, MB_OK);
			}
		}
		kinectApp->ClearShm();
	}
}




