/** 
 * nslExternalAnimation.h
 *
 *		Copyright (c) 2011, Fumi.Iseki
 * 
 */

#ifndef _NSL_EXTERNAL_ANIMATIONL_H__
#define _NSL_EXTERNAL_ANIMATIONL_H__



#define  SL_MAX_CHANNEL_NUM	6

#define  SL_SHM_SIZE		64
#define  SL_MAX_JOINT_NUM	19

#define  LEN_UUID_PARAM		128
#define  ANIM_UUID_FNAME	"ExternalAnimation.ini"
#define  ZERO_UUID			"00000000-0000-0000-0000-000000000000"




namespace  nsl {





class  ExternalAnimation
{
public:
	LLUUID		uuid;
	int			channel;

	BOOL		isExternal;

	HANDLE		mapHandle[SL_MAX_JOINT_NUM];
	double*		ptrShm[SL_MAX_JOINT_NUM];


public:
	ExternalAnimation()  {}
	ExternalAnimation(LLUUID id) { init(id);}
	~ExternalAnimation() { CloseShm();}

	void			init(LLUUID id);
	void			CreateShm(void);
	void 			CreateJointShm(int n);
	void 			OpenJointShm(int n);
	void			CloseShm(void);


	int				ReadExternalAnimationUUID(std::string uuid);

	LLQuaternion	GetAnimationRotation(std::string joint_name);
	LLVector3		GetAnimationPosition(std::string joint_name);
	LLVector3		GetAnimationScale   (std::string joint_name);

};











/////////////////////////////////////////////////////////////////////////////////////
// Tools

char*	getSecondParam(char* str);
char*	pack_char(char* mesg, char cc);





}		// namespace



#endif		// _NSL_EXTERNAL_ANIMATIONL_H__
