/**
  BREP Cu  modified by Fumi.Iseki

		LGPLD
		http://breplibrary.sourceforge.net/  BRL
*/



#include "common++.h"
#include "tools++.h"
#include "Brep.h"


using namespace jbxl;



int  OctreeNode_DelCount = 0;





/*********************************  BREP_SOLID  *********************************/

/*
	 Solid
*/
BREP_SOLID::BREP_SOLID()
{
	facetno  = 0;
	vertexno = 0;
	counter  = NULL;
	octree   = new OctreeNode((BREP_VERTEX*)NULL, this);
	rbound.set(HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL);
}




/**
	fBXgN^CSolid  Shellȉ̃IuWFNgVertex  OctreeSč폜
*/
BREP_SOLID::~BREP_SOLID()
{
	BREP_SHELL* pbsh;
	BREP_SHELL_RING::iterator ishell = shells.begin();
	while (ishell!=shells.end()) {
		pbsh = *ishell;
		ishell = shells.erase(ishell);	// Shell̐͑Ȃ͂Ȃ̂ŁCcounter̂߂	
		delete pbsh;					// erase̋󏈗 Shellɍs킹
	}
	delete octree;
//	DEBUG_MODE print_messageln("VERTEX = %d", OctreeNode_DelCount);
	OctreeNode_DelCount = 0;
}





/**
	DataCloseCallback()
*/
void  BREP_SOLID::DataCloseCallback()
{
	BREP_SHELL_RING::iterator ishell;
	for (ishell=shells.begin(); ishell!=shells.end(); ishell++) (*ishell)->DataCloseCallback();
	for (ishell=shells.begin(); ishell!=shells.end(); ishell++) rbound.fusion((*ishell)->rbound);

	octree->Iterate(ComputeVertexNormal); 
}




/**	
	SolidɎw肵ShellD
	[copy]
*/
void  BREP_SOLID::ConnectShell(BREP_SHELL* shell)
{
	shell->solid = this;
	shells.push_back(shell);
}



/**
	Solidw肵Shell폜D
*/
void  BREP_SOLID::DisconnectShell(BREP_SHELL* shell)
{
	BREP_SHELL_RING::iterator ishell;
	ishell = std::find(shells.begin(), shells.end(), shell);
	if (ishell!=shells.end()) shells.erase(ishell);

	shell->solid = NULL;
}






/*********************************  BREP_SHELL  *********************************/


BREP_SHELL::BREP_SHELL(BREP_SOLID* pr_solid)
{
	solid = pr_solid;
	rbound.set(HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL);

	if (solid!=NULL) solid->ConnectShell(this);
}




BREP_SHELL::~BREP_SHELL()
{
	CVCounter* counter = NULL;
	if (solid!=NULL) {
		if (solid->counter!=NULL) counter = solid->counter->GetUsableCounter();
		solid->DisconnectShell(this);
	}

	// Faces ̔j
	BREP_FACE*  pbfc;
	BREP_FACE_RING::iterator iface = faces.begin();
	
	int cnt = 0;
	while (iface!=faces.end()) {
		pbfc = *iface;
		iface = faces.erase(iface);
		pbfc->shell = NULL;
		delete(pbfc);
		cnt++;
		
		// JE^
		if (counter!=NULL && cnt%COUNTER_RATE==0) counter->StepIt(); 
	}
//	DEBUG_MODE print_messageln("FACET  = %d", cnt);
}





void  BREP_SHELL::DataCloseCallback()
{
	BREP_FACE_RING::iterator iface;
	for (iface=faces.begin(); iface!=faces.end(); iface++) (*iface)->DataCloseCallback();
	for (iface=faces.begin(); iface!=faces.end(); iface++) rbound.fusion((*iface)->rbound);
}



//
//  [copy]
void BREP_SHELL::ConnectFace(BREP_FACE* face)
{
	faces.push_back(face);
}



//
//  [copy]
void BREP_SHELL::DisconnectFace(BREP_FACE* face)
{
	BREP_FACE_RING::iterator iface;
	iface = std::find(faces.begin(), faces.end(), face);
	if (iface!=faces.end()) faces.erase(iface);

	face->shell = NULL;
}







/*********************************  BREP_FACE  *********************************/


BREP_FACE::BREP_FACE(BREP_SHELL* pr_shell)
{
	shell = pr_shell;
	if (shell!=NULL) shell->ConnectFace(this);

	tolerance = Face_Tolerance;
	rbound.set(HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL);
}




BREP_FACE::~BREP_FACE()
{
	if (shell!=NULL) shell->DisconnectFace(this);

	BREP_CONTOUR*  bpcn;
	BREP_CONTOUR_RING::iterator icon = outer_contours.begin();
	while (icon!=outer_contours.end()) {
		bpcn = *icon;
		icon = outer_contours.erase(icon);
		bpcn->face = NULL;
		delete (bpcn);
	}
}




void  BREP_FACE::DataCloseCallback()
{
	BREP_CONTOUR_RING::iterator icon;
	for (icon=outer_contours.begin(); icon!=outer_contours.end(); icon++) (*icon)->DataCloseCallback();

	ComputePlaneEquation();
}




//
//  [copy]
void BREP_FACE::ConnectContour(BREP_CONTOUR* contour)
{
	if (contour!=NULL) outer_contours.push_back(contour);
}




void BREP_FACE::DisconnectContour(BREP_CONTOUR* contour)
{
	BREP_CONTOUR_RING::iterator icon;
	icon = std::find(outer_contours.begin(), outer_contours.end(), contour);
	if (icon!=outer_contours.end()) outer_contours.erase(icon);

	contour->face = NULL;
}





/**
	ʂ̕@NEP{d = 0   
       (N:@xNgCP:ʂ̓_̈ʒuxNgCd:萔C_畽ʂւ̋x-1j
   [copy]
*/
static BREP_FACE*  this_face;
static double  dmin, dmax, emax;


//
//  [copy]
void  FaceClose(BREP_VERTEX *vertex)
{
	double d = -(this_face->normal * vertex->point);
	if (d < dmin) dmin = d;
	if (d > dmax) dmax = d;

	if (vertex->tolerance>emax) emax = vertex->tolerance;
	this_face->rbound.fusion(vertex->point);
}



//
//  [copy]
void  BREP_FACE::ComputePlaneEquation()
{
	this_face = this;
	normal = outer_contours.front()->normal;

	emax =  0.0;
	dmin =  HUGE_VAL;
	dmax = -HUGE_VAL;

	BREP_CONTOUR_RING::iterator icon;
	for (icon=outer_contours.begin(); icon!=outer_contours.end(); icon++)
		(*icon)->IterateVertices(FaceClose);

	d = (dmin + dmax)/2.;
	tolerance = Max((dmax - dmin)/2., Face_Tolerance);
	tolerance = Max(emax, tolerance);
	double extent = tolerance + emax;

	rbound.xmin -= extent;
	rbound.ymin -= extent;
	rbound.zmin -= extent;
	rbound.xmax += extent;
	rbound.ymax += extent;
	rbound.zmax += extent;
}









/*********************************  BREP_CONTOUR  *********************************/

BREP_CONTOUR::BREP_CONTOUR(BREP_FACE* pr_face)
{
	face = pr_face;
	if (face!=NULL) face->ConnectContour(this);
	
	rbound.set(HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL, HUGE_VAL, -HUGE_VAL);
	wing   = NULL;
//	normal = VECTOR<double>(0.0, 0.0, 0.0);
	dup_edge = 0;
}



//
//  [copy]
BREP_CONTOUR::~BREP_CONTOUR()
{
	if (face!=NULL) face->DisconnectContour(this);
	DestroyWings();
}



void  BREP_CONTOUR::DataCloseCallback()
{
//	if (normal.norm2()==0.0) ComputeNormal();
	ComputeNormal();
}



/** 
	V Wing Contour̃XgɒǉD
	[copy]
*/
void BREP_CONTOUR::ConnectWing(BREP_WING* new_wing)
{
	new_wing->contour = this;

	if (wing==NULL) {	// ŏ Wing
		new_wing->next = new_wing->prev = new_wing;
		wing = new_wing;
	}
	else {				// QԖڈȍ~ Wing
		new_wing->next = wing;
		new_wing->prev = wing->prev;
		new_wing->prev->next = new_wing->next->prev = new_wing;
	}
}




//
//  [copy]
void  BREP_CONTOUR::DisconnectWing(BREP_WING* dis_wing)
{
	if (!wing->next || !wing->prev) {
		print_messageln("DisconnectWing: Wing܂s ContourƐڑ܂܂ɂȂĂ!!");
	}

	if (wing==dis_wing) {
		if (dis_wing->next == dis_wing) {
			wing = 0;
		}
		else {
			wing = dis_wing->next;
		}
	}

	if (dis_wing->next) dis_wing->next->prev = dis_wing->prev;
	if (dis_wing->prev) dis_wing->prev->next = dis_wing->next;

	dis_wing->contour = 0;
	dis_wing->next = dis_wing->prev = 0;
}





/**
@	vertex1X^[gVertexƂCContour,VertexɊ֘At炽 
	WingiKvȂVEdgejD
	쐬Cw肷Vertex͏tĂȂ΃G[ƂȂD
*/
BREP_WING*  BREP_CONTOUR::CreateWing(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2)
{
	// V쐬Wing̃X^[gVertex́COWing̃GhVertexƓłȂ΂ȂȂD
	// ܂ Wing͏悭쐬Ȃ΂ȂȂD
	if (wing!=NULL && BrepEdgeOtherWing(wing->prev)->vertex!=vertex1) {
		DEBUG_MODE print_messageln("CreateWing: Wingǂ쐬ĂȂ!!");
		return 0;
	}

	// vertex1X^[gVertexƂWingDłɋWingꍇɂ͂ԂD
	// vertex1==vertex2 ̏ꍇ NULLԂD
	BREP_WING* wing = BrepCreateWingWithoutContour(vertex1, vertex2);
	if (wing==NULL) return NULL;

	// Edgẽ[v
	// ݂ BrepCreateWingWithoutContour()̎ł͋N肦ȂG[
	if (wing->vertex != vertex1) {
		DEBUG_MODE print_messageln("CreateWing: Edgẽ[v(N肦ȂG[)!!");
		return 0;
	}

	// WingContourɓo^
	ConnectWing(wing); 
	if (BrepEdgeOtherWing(wing)->contour!=NULL) {	// ΉEdge Q̎QƂꂽWingS Edge
		wing->edge->complete = true;
	}

	// WingX^[gVertex̃Oɓo^
	(wing->vertex)->wing_ring.push_back(wing); 

	return wing;
}




/**
	ContourɊ֘Atꂽ WingׂĔjD
	[copy]
*/
void BREP_CONTOUR::DestroyWings()
{
	BREP_WING* first = wing;
	if (first==NULL) return;

	BREP_WING* prev;
	for (BREP_WING* swing=first->prev; swing!=first; swing=prev) {
		prev = swing->prev;
		BrepDestroyWing(swing);
	}

	BrepDestroyWing(first);
}






//
//  [copy]
void  BREP_CONTOUR::IterateWings(void (*func)(BREP_WING*))
{
	BREP_WING* first = wing;
	if (!first) return;

	BREP_WING* next = first;
	do {
		BREP_WING* swing = next;
		next = swing->next;
		func(swing);
	} while(next != first);
}



//
//  [copy]
void  BREP_CONTOUR::IterateVertices(void (*func)(BREP_VERTEX*))
{
	BREP_WING* first = wing;
	if (!first) return;

	BREP_WING* next = first;
	do {
		BREP_WING* swing = next;
		next = swing->next;
		func(swing->vertex);
	} while(next != first);
}






/**
	Newells method ɂ@xNgvZD
*/
void  BREP_CONTOUR::ComputeNormal()
{
	normal = VECTOR<double>(0, 0, 0);

	VECTOR<double> next = wing->vertex->point;
	for (BREP_WING* swing=wing; swing; swing=(swing->next==wing ? NULL:swing->next)) {
		VECTOR<double> cur = next;
		next = swing->next->vertex->point;
		normal.x += (cur.y - next.y) * (cur.z + next.z);
		normal.y += (cur.z - next.z) * (cur.x + next.x);
		normal.z += (cur.x - next.x) * (cur.y + next.y);
	}
	normal.normalize();
}





BREP_CONTOUR* CreateContour(BREP_FACE* face)
{
	BREP_CONTOUR* contour = new BREP_CONTOUR(face);
	return contour;
}













/*********************************  BREP_WING  *********************************/

BREP_WING::BREP_WING(BREP_VERTEX* vx)
{
	vertex  = vx;
	prev    = NULL;
	next    = NULL;
	edge    = NULL;
	contour = NULL;
}











/*********************************  BREP_EDGE  *********************************/


BREP_EDGE::BREP_EDGE(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2)
{
	wing1 = new BREP_WING(vertex1);
	wing2 = new BREP_WING(vertex2);
	wing1->edge = wing2->edge = this;

	center    = (vertex1->point + vertex2->point)/2.;
	edge_ring = NULL;
	complete  = false;
	tolerance = Edge_Tolerance;
}




BREP_EDGE::~BREP_EDGE()
{
	if (wing1->contour || wing2->contour) {
		DEBUG_MODE print_messageln("~BREP_EDGE:  Edge ͂܂ ContourŎgĂ!!");
	}

	delete wing1;
	delete wing2;

	if (edge_ring!=NULL) {
		BREP_EDGE_RING::iterator iedge = std::find(edge_ring->begin(), edge_ring->end(), this);
		if (iedge!=edge_ring->end()) {
			edge_ring->erase(iedge);
		}
		if (edge_ring->size()==1) {
			(*(edge_ring->begin()))->edge_ring = NULL;
			delete(edge_ring);
		}
	}
}




void  BREP_EDGE::DataCloseCallback()
{
	// M.Segal, SIGGRAPH '90 p105
	double e = (wing1->vertex)->tolerance;
	e = Max(e, (wing2->vertex)->tolerance);
	tolerance = Max(e, tolerance);
}








/*********************************  BREP_VERTEX  *********************************/

BREP_VERTEX::BREP_VERTEX()
{
//	normal = VECTOR<double>(0, 0, 0);
//	point  = VECTOR<double>(0, 0, 0);
	tolerance = Abs_Vertex_Tolerance;
//	DEBUG_MODE print_messageln("TOL = %f", tolerance);
}




BREP_VERTEX::~BREP_VERTEX()
{
	if (!wing_ring.empty()) DEBUG_MODE print_messageln("~BREP_VERTEX: Wing̃O܂łȂ!!");
}



//
//  [copy]
void BREP_VERTEX::DisconnectWing(BREP_WING* wing)
{
	BREP_WING_RING::iterator iwing;
	iwing = std::find(wing_ring.begin(), wing_ring.end(), wing);
	if (iwing==wing_ring.end()) {
		DEBUG_MODE print_messageln("DisconnectWing:  Wing VertexƐڑĂ܂!!");
		return;
	}

	wing_ring.erase(iwing);
}





/*
	Vertex̖@xNgvZD
		Vertex̎ Contour̖@xNg̉ZςvZ
	[copy]
*/
void  BREP_VERTEX::ComputeNormal()
{
	normal = VECTOR<double>(0.0, 0.0, 0.0);

	BREP_WING_RING::iterator iwing;
	for (iwing=wing_ring.begin(); iwing!=wing_ring.end(); iwing++) {
		BREP_WING* wing = *iwing;
		normal = normal + (wing->contour->face)->normal;
	}
	normal.normalize();
}





void  BREP_VERTEX::ComputeTolerance()
{
	double max = Xabs(point.x);
	max = Max(max, Xabs(point.y));
	max = Max(max, Xabs(point.z));

	tolerance = Vertex_Tolerance * max;					// 
	tolerance = Max(tolerance, Abs_Vertex_Tolerance);	// 
}




void  BREP_VERTEX::DataCloseCallback() 
{
	ComputeTolerance();
}




void BREP_VERTEX::IterateWings(void (*func)(BREP_WING*)) {
	BREP_WING_RING::iterator iwing;
	for (iwing=wing_ring.begin(); iwing!=wing_ring.end(); iwing++) func(*iwing);
}





/*********************************  OctreeNode  *********************************/

OctreeNode::OctreeNode(BREP_VERTEX* new_vertex, BREP_SOLID* sld/*=NULL*/) {
	solid  = sld;
	vertex = new_vertex;
	for (int i=0; i<8; i++) child[i] = NULL;
}



OctreeNode::~OctreeNode() 
{
	for (int i=0; i<8; i++) {
		if (child[i]) delete child[i];
	}
	delete vertex;
	OctreeNode_DelCount++;

	if (solid!=NULL && OctreeNode_DelCount%COUNTER_RATE==0) {
		if (solid->counter!=NULL) solid->counter->GetUsableCounter()->StepIt();
	}
}



// 
//  Octree Vertex new_vertex̂̂o^Do^ OctreeNodeԂD
//                            ^^^^^^^^
//  ɓʒuVertexo^ς݂̏ꍇ́C OctreeNodeԂD
//  AddWithDuplicates() Ƃ͖߂lႤ̂ŒӂD
//
OctreeNode* OctreeNode::AddWithUnique(BREP_VERTEX* new_vertex) 
{
	OctreeNode* o = NULL;
	OctreeNode* p = this;
	int cmp = -1;

	if (p->vertex==NULL) {	// ԍŏ Vertex
		p->vertex = new_vertex;
		return p;
	}

	while (p!=NULL) {
		cmp = VertexCompare(p->vertex, new_vertex);
		if (cmp==8) {
			return p;  // ɓʒuVertexo^ς
		}
		o = p;
		p = p->child[cmp];
	}

	if (cmp>=0) {
		p = new OctreeNode(new_vertex, solid);
		if (o!=NULL) o->child[cmp] = p;
	}
	return p;
}




//
//  Octree Vertex new_vertex ̂̂o^Ddo^D                           ^^^^^^^^
//  Octreẽgbṽ|C^ԂD
//
OctreeNode* OctreeNode::AddWithDuplicates(BREP_VERTEX* new_vertex) 
{
	OctreeNode* o = NULL;
	OctreeNode* p = this;
	int cmp = -1;

	if (p->vertex==NULL) {	// ԍŏ Vertex
		p->vertex = new_vertex;
		return p;
	}

	while (p!=NULL) {
		cmp = VertexCompare(p->vertex, new_vertex);
		o = p;
		p = p->child[cmp%8];
	}

	if (cmp>=0) {
		p = new OctreeNode(new_vertex, solid);
		if (o!=NULL) o->child[cmp%8] = p;
	}
	return this;
}




//
//  Vertex element Ɠʒuɂ Vertex܂ރm[hԂD
//  [copy]
OctreeNode* OctreeNode::FindSubtree(BREP_VERTEX* element)
{
	OctreeNode* p = this;
	while(p!=NULL){
		int cmp = VertexCompare(p->vertex, element);
		if (cmp==8) return p;
		if (cmp<0)  return 0; 
		p = p->child[cmp];
	}
	return 0;
}


	
//
//  Vertex element Ɠʒuɂ VertexԂD
//  [copy]
BREP_VERTEX* OctreeNode::Find(BREP_VERTEX* element) {
	OctreeNode* p = FindSubtree(element);    // ʒuŒT
	if (p!=NULL) return p->vertex;
	return 0;
}



//
//  [copy]
void OctreeNode::Iterate(void (*func)(BREP_VERTEX*)) {
	for (int i=0; i<8; i++) {
		if (child[i]) child[i]->Iterate(func);
	}
	func(vertex);
}






/*********************************  Other Functions  *********************************/



/**
	Wing̃X^[gVertex̃OɁC Wingo^D
	Wing݂igpĂj߂ɂ́C̃Oɓo^Ă邱ƂƁCContouriցj
	N邱ƂłD
	[copy]
*/
//static void BrepConnectWingToVertex(BREP_WING* wing)
DllExport  void BrepConnectWingToVertex(BREP_WING* wing)
{
	if (wing!=NULL) (wing->vertex)->wing_ring.push_back(wing);
}





/**
	vertex1X^[gVertexƂWingiKvȂEdgej쐬ĕԂD
	Wing쐬ꂽ_ł́CWingContourɂ͊֘AtĂȂD 
*/
DllExport BREP_WING* BrepCreateWingWithoutContour(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2)
{
	BREP_WING *wing;

	// vertex1 - vertex2 ԂɃGbWɓo^Ă邩ǂ`FbND
	BREP_EDGE* edge = BrepFindEdge(vertex1, vertex2);
	if (edge==NULL) { // Edge݂͑ȂD
		edge = CreateEdge(vertex1, vertex2);
		if (edge==NULL) return NULL;	// vertex1==vertex2 Ȃ NULL
		wing = edge->wing1;
	}
	else{ // Edge͊ɑ݂D
		if      (edge->wing1->vertex==vertex1) wing = edge->wing1;
		else if (edge->wing2->vertex==vertex1) wing = edge->wing2;
		else {
			// N肦ȂG[
			DEBUG_MODE print_messageln("BrepCreateWingWithoutContour: N肦ȂG[?@̂PD");
			return NULL;
		}
		
		// Wing ContourŎgĂꍇC WingTD
		if (edge->edge_ring!=NULL && wing->contour!=NULL) {
			BREP_EDGE_RING::iterator iedge=edge->edge_ring->begin();
			while (iedge!=edge->edge_ring->end() && wing->contour!=NULL) {
				if      ((*iedge)->wing1->vertex==vertex1) wing = (*iedge)->wing1;
				else if ((*iedge)->wing2->vertex==vertex1) wing = (*iedge)->wing2;
				else {
					// N肦ȂG[
					DEBUG_MODE print_messageln("BrepCreateWingWithoutContour: N肦ȂG[?@̂QD");
					return NULL;
				}
				iedge++;
			}
		}

		// Wing͊ ContourŎgĂ邩H
		if (wing->contour!=NULL){
			// VEdge蒼
			BREP_EDGE* new_edge = CreateEdge(vertex1, vertex2);
			if (new_edge==NULL) return NULL;

			if (edge->edge_ring==NULL) {
				edge->edge_ring = new BREP_EDGE_RING();
				edge->edge_ring->push_back(edge);
			}
			edge->edge_ring->push_back(new_edge);
			new_edge->edge_ring = edge->edge_ring;
			wing = new_edge->wing1;
		}
	}

	return wing;
}






/**

  [copy]
*/
DllExport void BrepDestroyWing(BREP_WING* wing)
{
	wing->vertex->DisconnectWing(wing);
	wing->contour->DisconnectWing(wing);

	if (!wing->edge->wing1->contour && !wing->edge->wing2->contour) {
		delete wing->edge;
	}
	else {
		wing->edge->complete = false;
	}
}





/**
	vertex1 vertex2ɃGbWŌ΂Ă邩ǂ`FbND
	΂Ă΁CŏɌ EdgeԂD
	     vertex1--Wing1--Edge--Wing2--vertex2  
	[copy]
*/
DllExport BREP_EDGE* BrepFindEdge(BREP_VERTEX* vertex1, BREP_VERTEX* vertex2)
{
	BREP_WING_RING ring;
	BREP_WING_RING::iterator iwing;

	ring = vertex2->wing_ring;
	for (iwing=ring.begin(); iwing!=ring.end(); iwing++){
		BREP_WING* wing = *iwing;
		if (BrepEdgeOtherWing(wing)->vertex==vertex1) return wing->edge;
	}

	ring = vertex1->wing_ring;
	for (iwing=ring.begin(); iwing!=ring.end(); iwing++) {
		BREP_WING* wing = *iwing;
		if (BrepEdgeOtherWing(wing)->vertex==vertex2) return wing->edge;
	}

	return 0;
}





/**
	Vertex vert  octreeɈӓIɓo^Dɓʒu Vertex
	o^Ăꍇ́Cvert͏āCɓo^Ă VertexԂD
	̊֐gp vertgpĂ͂ȂideleteĂ\̂Łj
		gpj@vert = AddVertex2Octree(vert, octree);
**/
DllExport BREP_VERTEX*  AddVertex2Octree(BREP_VERTEX* vert, OctreeNode* octree)
{
	OctreeNode* node;

	node = octree->AddWithUnique(vert);
	if (node==NULL)	{
		//delete vert;
		return NULL;
	}
	
	if (node->vertex==vert) {
		octree->solid->vertexno++;		// VertexVKo^̂ŃJEgD
	}
//	else {
//		delete vert;					// ɓʒuVertexo^ς
//	}
	return node->vertex;
}





/**

  [copy]
*/
DllExport BREP_EDGE* CreateEdge(BREP_VERTEX* v1, BREP_VERTEX* v2)
{
	if (v1==v2) return NULL;

	BREP_EDGE* edge = new BREP_EDGE(v1, v2);
	edge->DataCloseCallback();
	return edge;
}




/**

*/
DllExport void  ComputeVertexNormal(BREP_VERTEX* vert) 
{
	if (vert!=NULL) vert->ComputeNormal();
}




/**
	v2 ɑ΂ v1 ̈ʒuD
		0`7 : Vertex ̈ʒu
		8    : Vertex
*/
DllExport int VertexCompare(BREP_VERTEX* v1, BREP_VERTEX* v2)
{
	double  tolerance = v1->tolerance + v2->tolerance;
	double  dist2 = (v1->point.x-v2->point.x)*(v1->point.x-v2->point.x) +
					(v1->point.y-v2->point.y)*(v1->point.y-v2->point.y) +
					(v1->point.z-v2->point.z)*(v1->point.z-v2->point.z);
	if (dist2<=tolerance*tolerance) return 8;

	int code = 0;
	if (v1->point.x > v2->point.x) code += 1;
	if (v1->point.y > v2->point.y) code += 2;
	if (v1->point.z > v2->point.z) code += 4;
	if (code != 0) return code;   // x1 > x2 || y1 > y2 || z1 > z2

	return 0;
}




//
//  EdgeɊ֘Atꂽ Wing ԂD
//  [copy]
DllExport BREP_WING* BrepEdgeOtherWing(BREP_WING* wing)
{ 
	return (wing==wing->edge->wing1 ? wing->edge->wing2 : wing->edge->wing1);
}




