/* vi: set tabstop=4 nocindent noautoindent: */

/**
Tiny List \Cu		tlist.c
											by Fumi.Iseki 2008 2/1

  wb_
	  #include "tlist.h"
*/




#include  "tlist.h"




/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// List Data
//
//     ÓIɐD 
//

/**
tList_data  init_tListdata(void)
  
	@\: ̃m[hf[^ÓIɍ쐬
		  f[^̂ɎgpD

	߂l: ꂽm[hf[^D
*/
tList_data  init_tListdata(void)
{
	tList_data pp;

	memset(&pp, 0, sizeof(tList_data));
	return pp;
}





/**
tList_data  make_tListdata(int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
  
	@\: f[^w肵ăm[hf[^쐬
		  sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

	: id  -- m[hID
		  lv  -- m[h̃f[^
		  key -- m[h̃L[	(Buffer)	
		  val -- m[h̃f[^ (Buffer)	
		@ptr -- ėpf[^ւ̃|C^		
		  sz  -- *ptr ̃TCY

	߂l: ꂽm[hf[^D
*/
tList_data  make_tListdata(int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	tList_data pp;

	memset(&pp, 0, sizeof(tList_data));

	pp.id  = id;
	pp.lv  = lv;
	pp.sz  = sz;
	pp.key = dup_Buffer(key);	
	pp.val = dup_Buffer(val);

	if (sz>0) {
		pp.ptr = (void*)malloc(sz);
		if (pp.ptr!=NULL) {
			if (ptr!=NULL) memcpy(pp.ptr, ptr, sz);
			else           memset(pp.ptr, 0,   sz);
		}
	}
	
	return pp;
}





/**
tList_data  make_tListdata_bystr(int id, int lv, char* key, char* val, void* ptr, int sz)
  
	@\: f[^w肵ăm[hf[^쐬
		  sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

	: id  -- m[hID
		  lv  -- m[h̃f[^
		  key -- m[h̃L[	 			
		  val -- m[h̃f[^ 			
		@ptr -- ėpf[^ւ̃|C^		
		  sz  -- *ptr ̃TCY

	߂l: ꂽm[hf[^D
*/
tList_data  make_tListdata_bystr(int id, int lv, char* key, char* val, void* ptr, int sz)
{
	tList_data pp;
	
	memset(&pp, 0, sizeof(tList_data));

	pp.id  = id;
	pp.lv  = lv;
	pp.sz  = sz;
	pp.key = make_Buffer_bystr(key);	// key==NULLȂ init_Buffer()
	pp.val = make_Buffer_bystr(val);

	if (sz>0) {
		pp.ptr = (void*)malloc(sz);
		if (pp.ptr!=NULL) {
			if (ptr!=NULL) memcpy(pp.ptr, ptr, sz);
			else           memset(pp.ptr, 0,   sz);
		}
	}

	return pp;
}





/**
void  free_tListdata(tList_data* ldat)
  
	@\: m[hf[^̃obt@NAD
		  f[^g͍폜ȂD

	: ldat -- NAm[hf[^

	߂l: Ȃ
*/
void  free_tListdata(tList_data* ldat)
{
	if (ldat==NULL) return;

	ldat->id = 0;
	ldat->lv = 0;
	ldat->sz = 0;

	free_Buffer(&(ldat->key));	
	free_Buffer(&(ldat->val));
	if (ldat->ptr!=NULL) free(ldat->ptr);
	del_all_tList(&(ldat->lst));

	ldat->key = init_Buffer();
	ldat->val = init_Buffer();
	ldat->ptr = NULL;
	ldat->lst = NULL;

	return;
}





/**
tListdata  dup_tListdata(tList_data ldat)
  
	@\: m[hf[^̕쐬D
		  ldat.sz ɂ͐m ldat.ptr̃TCYݒ肳ĂKvD

	: ldat -- m[hf[^

	߂l: m[hf[^ւ̃|C^D

*/
tList_data  dup_tListdata(tList_data ldat)
{
	tList_data dup;	

	memcpy(&dup, &ldat, sizeof(tList_data));
	dup.key = dup_Buffer(ldat.key);
	dup.val = dup_Buffer(ldat.val);
	if (ldat.ptr!=NULL && ldat.sz>0) {
		dup.ptr = (void*)malloc(ldat.sz);
		if (dup.ptr!=NULL) memcpy(dup.ptr, ldat.ptr, ldat.sz);
	}
	dup.lst = dup_tList(ldat.lst);
	
	return dup;
}








/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tiny List
//

/**
tList*  new_tList_node(void)

	@\: Xgp̋m[h𓮓IɐD

	߂l: ꂽm[hւ̃|C^D
*/
tList*  new_tList_node(void)
{
	tList* pp;

	pp = (tList*)malloc(sizeof(tList));
	if (pp==NULL) return NULL;
	memset(pp, 0, sizeof(tList));
	pp->ldat = init_tListdata();

	return pp;
}





/**
tList   make_tList_node(tList_data ldat)

	@\: Xgpm[hÓIɐD
		  ldat ͂̂܂ܐVϐŎgpDiPɑj

		  ̊֐Őm[h del_*_tList()֐ō폜Ă͂ȂD

	: ldat  -- m[hf[^

	߂l: ꂽm[hD
*/
tList   make_tList_node(tList_data ldat)
{
	tList pp;

	memset(&pp, 0, sizeof(tList));
	pp.ldat = ldat;	

	return pp;
}




/**
tList*  add_tList_node_bydata(tList* pp, tList_data ldat) 

	@\: f[^(ldat)烊Xgpm[ho(new),w肵XǧɒǉD
		  Xg|C^ ppwm[ȟɂo m[h}D
		  ldat ͎w肳ꂽ̂̂܂܎gpD

	: pp   -- ǉꏊ̎Õm[hւ̃|C^D
		  ldat -- ǉm[hf[^D̃f[^̂܂܎gpD
		   
	߂l: ǉm[hւ̃|C^D
*/
tList*  add_tList_node_bydata(tList* pp, tList_data ldat) 
{
	tList* pt;

	pt = new_tList_node();
	pt->ldat = ldat;

	if (pp==NULL) return pt;

	pt->next = pp->next;
	pt->prev = pp;
	pp->next = pt;
	if (pt->next!=NULL) (pt->next)->prev = pt;	

	return pt;
}





/**
tList*  add_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 

	@\: f[^烊Xgpm[ho(new),XgɒǉD
		  Xg|C^ ppwm[ȟɂo m[h}D
		  sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

	: pp  -- ǉꏊ̎Õm[hւ̃|C^D
		  id  -- ǉf[^D
		  lv  -- ǉf[^D
		  key -- ǉf[^D		
		  val -- ǉf[^D		
		@ptr -- ėpf[^ւ̃|C^	
		  sz  -- *ptr ̃TCY
		   
	߂l: ǉm[hւ̃|C^D
*/
tList*  add_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 
{
	tList* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = add_tList_node_bydata(pp, ldat);

	return pt;
}




/**
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

	@\: f[^烊Xgpm[ho(new),XgɒǉD
		  Xg|C^ ppwm[ȟɂo m[h}D
		  sz>0  ptr==NULL ̏ꍇ ptr̗̈mۂC0NAD

	: pp  -- ǉꏊ̎Õm[hւ̃|C^D
		  id  -- ǉf[^D
		  lv  -- ǉf[^D
		  key -- ǉf[^D			
		  val -- ǉf[^D			
		@*ptr -- ėpf[^ւ̃|C^	
		  sz   -- *ptr ̃TCY
		   
	߂l: ǉm[hւ̃|C^D
*/
tList*  add_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tList* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = add_tList_node_bydata(pp, ldat);

	return pt;
}





/**	
tList*  free_tList_node(tList** node) 

	@\: 
		Xgpm[h̃obt@(f[^)̊JD
		*node ɂ NULLD

	: *node  -- Jm[hւ̃|C^D
*/
void   free_tList_node(tList** node)
{
	if (node==NULL || *node==NULL) return;

	free_tListdata(&((*node)->ldat));
	*node = NULL;

	return;
}	





/**	
tList*  del_tList_node(tList* node) 

	@\: Xgp̃m[h폜D
		  Xg|C^ nodewm[h폜,Xg\l߂D

	: node  -- 폜m[hւ̃|C^D

	߂l: 폜m[h̒̃m[hւ̃|C^D
*/
tList*  del_tList_node(tList* node) 
{	
	tList* pp = NULL;

	if (node==NULL) return NULL;

	free_tListdata(&(node->ldat));

	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) {
		node->next->prev = node->prev;
		pp = node->next;
	}
	free(node);

	return pp;
}





/**
tList*  dup_tList_node(tList* node)

	@\Fm[h𕡐 (new)Dm[h̃|C^͕ȂD

*/			 
tList*  dup_tList_node(tList* node)
{
	tList* pp;
	int	sz;

	if (node==NULL) return NULL;

	sz = sizeof(tList);
	pp = (tList*)malloc(sz);
	if (pp==NULL) return NULL;

	memcpy(pp, node, sz);
	pp->ldat = dup_tListdata(node->ldat);
	pp->next = NULL;
	pp->prev = NULL;
	pp->altp = NULL;
	pp->back = NULL;
	pp->esis = NULL;
	pp->ysis = NULL;

	return pp;
}




/**
tList*  move_tList_node(tList* pp, tList* node)

	@\: nodẽ݂Xg؂藣CppֈړD
		  node폜Ȃ del_tList_node(), add_tList_node() s悤Ȃ́D

	: pp    -- ړŐeƂȂm[hւ̃|C^D
		  node  -- ړm[hւ̃|C^D

	߂l: ړm[hm[hւ̃|C^D
*/
tList*  move_tList_node(tList* pp, tList* node)
{
	if (pp==NULL || node==NULL) return NULL;
    
	if (node->prev!=NULL) node->prev->next = node->next;
	if (node->next!=NULL) node->next->prev = node->prev;

	node->prev = pp;
	node->next = pp->next;
	if (pp->next!=NULL) pp->next->prev = node;
	pp->next   = node;
	
	return node;
}





/**
void	set_tList_node_bydata(tList* pp, tList_data ldat)

	@\FXg̃m[hɒlݒ肷D
		  ldat ͎w肳ꂽ̂̂܂܎gpD

	: pp   -- ݒ肷m[hւ̃|C^D
		  ldat -- ݒ肷m[hf[^D̃f[^̂܂܎gpD

*/
void	set_tList_node_bydata(tList* node, tList_data dat)
{
	if (node==NULL) return;

	free_tListdata(&(node->ldat));
	node->ldat = dat;
}





/**
void	set_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)

	@\FXg̃m[hɒlݒ肷Dꂼ̃f[^͕Đݒ肳D
		  key, val NULL̏ꍇ́C̒l̓m[h͐ݒ肳ȂD

	: id  -- m[hID
		  lv  -- m[h̃f[^
		  key -- m[h̃L[				
		  val -- m[h̃f[^ 			
		@ptr -- ėpf[^ւ̃|C^		
		  sz  -- *ptr ̃TCY

*/
void	set_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)
{
	if (pp==NULL) return;

	pp->ldat.id = id;
	pp->ldat.lv = lv;
	pp->ldat.sz = sz;

	if (key!=NULL) {
		free_Buffer(&(pp->ldat.key));
		pp->ldat.key = make_Buffer_bystr(key);
	}
	if (val!=NULL) {
		free_Buffer(&(pp->ldat.val));
		pp->ldat.val = make_Buffer_bystr(val);
	}

	if (sz>0 && ptr!=NULL) {
		if (pp->ldat.ptr!=NULL) free(pp->ldat.ptr);
		pp->ldat.ptr = (void*)malloc(sz);
		if (pp->ldat.ptr!=NULL) memcpy(pp->ldat.ptr, ptr, sz);
	}
}





/**
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

	@\FXg̃m[hɒlݒ肷Dꂼ̃f[^͕Đݒ肳D
		  key.buf, val.buf NULL̏ꍇ́C̒l̓m[hɂ͐ݒ肳ȂD

	: id  -- m[hID
		  lv  -- m[h̃f[^
		  key -- m[h̃L[	(Buffer)	
		  val -- m[h̃f[^ (Buffer)	
		@ptr -- ėpf[^ւ̃|C^		
		  sz  -- *ptr ̃TCY

*/
void	set_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	if (pp==NULL) return;

	pp->ldat.id = id;
	pp->ldat.lv = lv;

	if (pp->ldat.key.buf!=NULL) {
		free_Buffer(&(pp->ldat.key));
		pp->ldat.key = dup_Buffer(key);
	}

	if (pp->ldat.val.buf!=NULL) {
		free_Buffer(&(pp->ldat.val));
		pp->ldat.val = dup_Buffer(val);
	}

	if (sz>0 && ptr!=NULL) {
		if (pp->ldat.ptr!=NULL) free(pp->ldat.ptr);
		pp->ldat.ptr = (void*)malloc(sz);
		if (pp->ldat.ptr!=NULL) memcpy(pp->ldat.ptr, ptr, sz);
	}
}





/**
tList*	update_tList_node(tList* pp, tList* pt)

	@\Fpp pt->keyŌCYm[h΃m[hRs[D΍ŌɃm[hǉ(new)D

	: pp -- Jnm[hւ̃|C^D
		  pt -- ݒ肷m[hւ̃|C^DL[ pt->key

	߂lFݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node(tList* pp, tList* pt)
{
	tList* pm;
	tList_data ldat;

	if (pt==NULL) return pp;
	
	ldat = pp->ldat;
	pm = update_tList_node_byBuffer(pp, ldat.id, ldat.lv, ldat.key, ldat.val, ldat.ptr, ldat.sz);
	
	return pm;
}





/**
tList*	update_tList_node_bydata(tList* pp, char* srch, tList_data ldat)

	@\Fpp srchŌCYm[h΃m[hݒ肷D΍ŌɃm[hǉ(new)D
		  ldat ͎w肳ꂽ̂̂܂܎gpD

	: pp   -- Jnm[hւ̃|C^D
		  srch -- L[
		  ldat -- ǉm[hf[^D̃f[^̂܂܎gpD

	߂lFݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node_bydata(tList* pp, char* srch, tList_data ldat)
{
	tList* pm = NULL;

	if (pp==NULL || srch==NULL) return NULL;

	pm = strncmp_tList(pp, srch, 0, 1);
	if (pm!=NULL) set_tList_node_bydata(pm, ldat);
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_bydata(pm, ldat);
	}
	
	return pm;
}





/**
tList*	update_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)

	@\Fpp keyŌCYm[h΃m[hݒ肷D΍ŌɃm[hǉ(new)D
		  ꂼ̃f[^͕D

	: pp  -- Jnm[hւ̃|C^D
		  id  -- m[hID
		  lv  -- m[h̃f[^
		  key -- m[h̃L[DL[		
		  val -- m[h̃f[^ (Buffer)	
		@ptr -- ėpf[^ւ̃|C^		
		  sz  -- *ptr ̃TCY

	߂lFݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node_bystr(tList* pp, int id, int lv, char* key, char* val, void* ptr, int sz)
{
	tList* pm = NULL;

	if (pp==NULL || key==NULL) return NULL;

	pm = strncmp_tList(pp, key, 0, 1);
	if (pm!=NULL) {
		set_tList_node_bystr(pm, id, lv, NULL, val, ptr, sz);
	}
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_bystr(pm, id, lv, key, val, ptr, sz);
	}
	
	return pm;
}





/**
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)

	@\Fpp key.bufŌCYm[h΃m[hݒ肷D΍ŌɃm[hǉ(new)D
		  ꂼ̃f[^͕D

	: pp  -- Jnm[hւ̃|C^D
		  id  -- m[hID
		  lv  -- m[h̃f[^
		  key -- m[h̃L[   (Buffer)	
		  val -- m[h̃f[^ (Buffer)	
		@ptr -- ėpf[^ւ̃|C^		
		  sz  -- *ptr ̃TCY

	߂lFݒ܂͒ǉm[hւ̃|C^
*/
tList*	update_tList_node_byBuffer(tList* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz)
{
	tList* pm = NULL;

	if (pp==NULL || key.buf==NULL) return NULL;

	pm = strncmp_tList(pp, (char*)key.buf, 0, 1);
	if (pm!=NULL) set_tList_node_byBuffer(pm, id, lv, key, val, ptr, sz);
	else {
		pm = find_tList_end(pp);
		pm = add_tList_node_byBuffer(pm, id, lv, key, val, ptr, sz);
	}
	
	return pm;
}







/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// tiny List
//

/**	
tList*  del_tList(tList** pp) 

	@\: Xgp̎w肵m[hȍ~̃m[h폜D

	: *pp  -- 폜m[hւ̃|C^D

	߂l: 폜m[h(s)̒Õm[hւ̃|C^D
*/
tList*  del_tList(tList** pp) 
{	
	tList* pt;
	tList* pm;
	tList* pw;

	if (pp==NULL || *pp==NULL) return NULL;

	pt = (*pp)->prev;
	if (pt!=NULL) pt->next = NULL;

	pm = *pp;
	while (pm!=NULL) {
		pw = pm;
		pm = pm->next;
   		free_tListdata(&(pw->ldat));
		free(pw);
	}
	*pp = NULL;

	return pt;
}





/**
void  del_all_tList(tList** pp)

	@\: Xg̑Sm[h̍폜D
		  |C^ pp̃m[h܂ރXgŜ폜D
		  pp ͂Xgł΁CǂwĂĂǂD

	: *pp  -- 폜Jnm[hւ̃|C^D

	߂l: ȂD
*/
void  del_all_tList(tList** pp)
{
	tList* pm;
	tList* pv;

	if (pp==NULL || *pp==NULL) return;

	pm = *pp;
	pv = (*pp)->prev;

	do {
		pm = del_tList_node(pm);
	} while (pm!=NULL);

	pm = pv;
	while (pm!=NULL) {
		pv = pm->prev;
		del_tList_node(pm);
		pm = pv;
	}

	*pp = NULL;
}




/**	 
int  del_tList_key(tList* pl, char* key, int no)
		
	@\: plT[`āCnoԖڂ keỹm[h폜D
		
	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ijD啶CʂȂD	
		  no  -- v̒ŉԖڂ̕폜邩w肷D1琔D0̏ꍇ͑Sč폜D
		
	߂l: 폜m[h̐D
*/	  
int  del_tList_key(tList** pl, char* key, int no)
{	   
	int dl = 0;
	int nn = 0;
	if (no<0) no = 0;

	tList* pp = *pl;

	while (pp!=NULL) {
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, 0)) {
			nn++;
			if (no==0 || no==nn) {
				if (pp->prev==NULL) *pl = pp->next;
				pp = del_tList_node(pp);	
				dl++;
				if (no!=0) break;
			}
			else {
				pp = pp->next;
			}
		}
		else {
			pp = pp->next;
		}
	}

	return dl;
}






/**
tList*  dup_tList(tList* pp)

	@\FXg𕡐D

*/			 
tList*  dup_tList(tList* pp)
{
	tList* pt;
	tList* pl;
	tList* tt;

	if (pp==NULL) return NULL;

	pt = pl = dup_tList_node(pp);
	pp = pp->next;

	while(pp!=NULL) {
		tt = dup_tList_node(pp);
		pl = insert_tList(pl, tt);
		pp = pp->next;
	}

	return pt;
}



/**
tList*  add_tList(tList* pp, tList* pt)

	@\FXgpp̍Ō XgptǉD

	pp->1->2->3, pt->4->5 => pp->1->2->pt->4->5 
*/

tList*  add_tList_end(tList* pp, tList* pt)
{
	if (pt==NULL) return pp;
	if (pp==NULL) return pt;

	tList* pe = find_tList_end(pp);
	pe->next = pt;
	pt->prev = pe;

	return pp;
}





/**
tList*  insert_tList(tList* pp, tList* pt)

	@\Fm[hpp̒ pt}D
	
	߂lF}擪̃Xgւ̃AhXD

	pp->1->2->3, pt->4->5 => pp->pt->4->5->1->2 
*/
tList*  insert_tList(tList* pp, tList* pt)
{
	tList* pe;
	
	if (pt==NULL) return pp;
	if (pp==NULL) return pt;

	pe = find_tList_end(pt);
	if (pp->next!=NULL) pp->next->prev = pe;
	pe->next = pp->next;
	pp->next = pt;
	pt->prev = pp;
	
	return pt;
}





/**
void  print_tList(File* fp, tList* pp)

	@\: Xg̕\D
		  |C^ ppȍ~̑SẴm[h̃L[̃obt@WG[o͂ɕ\D

	: fp -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  pp -- \Jnm[hւ̃|C^D

	߂l: ȂD

*/
void  print_tList(FILE* fp, tList* pp)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "[%d] [%d] [%s] [%s]\n", ld.id, ld.lv, ld.key.buf, ld.val.buf);
			//if (pp->next!=NULL) print_tList(pp->next);
			pp = pp->next;
		}
	}
	else {
		fprintf(fp, "(List is NULL)\n");
	}
	return;
}




void  dump_tList(FILE* fp, tList* pp)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp!=NULL) {
			tList_data ld = pp->ldat;
			fprintf(fp, "[%d] [%d] [%s] [%d]\n", ld.id, ld.lv, ld.key.buf, ld.val.vldsz);
			fdump(fp, (unsigned char*)ld.val.buf, ld.val.vldsz);
			pp = pp->next;
		}
	}
	else {
		fprintf(fp, "(List is NULL)\n");
	}
	return;
}





/**
int  count_tList(tList* pp)

	@\FXg ppm[hȍ~̃m[h̐𐔂D

	: pp -- n߂m[hւ̃|C^D

	߂l: m[h̐D
*/
int  count_tList(tList* pp)
{
	int cnt = 0;

	while (pp!=NULL) {
		cnt++;
		pp = pp->next;
	}	
	return cnt;
}






///////////////////////////////////////////////////////////////////////////////////////////
//
// String Compare
//

/**
tList*  strncmp_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D
		  |C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
		  noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					 TLIST_MATCH_COMPLETE   (0): SvD
					 TLIST_MATCH_TLISTKEY  (-1): pl->key.buf ̒ɍ킹D
					 TLIST_MATCH_STRINGKEY (-2): key ̒ɍ킹D
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strncmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncmp((char*)pl->ldat.key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strncasecmp_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D啶𖳎D
		  |C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
		  noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strncasecmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncasecmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strnrvscmp_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D
		  |C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
		  noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strnrvscmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strnrvscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strncaservscmp_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D啶𖳎D
		  |C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
		  noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strncaservscmp_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (ex_strncaservscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strstr_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D
		  |C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂
		  m[h̓CnoԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[D
		  len  -- >=0: key  pl̃L[Ɋ܂܂邩ǂD
				   <0: pl̃L[ KeyɊ܂܂邩ǂD
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strstr_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (len>=0) {
			if (strstr((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstr((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->next;
	}
	return NULL;
}





/**
tList*  strstrcase_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D啶𖳎D
		  |C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂
		  m[h̓CnoԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[D
		  len  -- >=0: key  pl̃L[Ɋ܂܂邩ǂD
				   <0: pl̃L[ KeyɊ܂܂邩ǂD
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strstrcase_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	while (pl!=NULL) {
		if (len>=0) {
			if (strstrcase((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstrcase((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->next;
	}
	return NULL;
}




///////////////////////////////////////////////////////////////////////////////////////////
//
// String Compare Back List
//

/**
tList*  strncmp_back_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D
		  |C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
		  납琔 noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒Ō납琔āCԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strncmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);
	
	while (pl!=NULL) {
		if (ex_strncmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strncasecmp_back_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D啶𖳎D
		  |C^ plȍ~̃m[h,L[̕ keyƑOviIjm[h̓C
		  납琔 noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒Ō납琔āCԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strncasecmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strncasecmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strnrvscmp_back_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D
		  |C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
		  납琔 noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒Ō납琔āCԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strnrvscmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strnrvscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strncaservscmp_back_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D啶𖳎D
		  |C^ plȍ~̃m[h,L[̕ keyƌviIjm[h̓C
		  납琔 noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: pl->key ̒ɍ킹D
					 -2: key ̒ɍ킹D
		  no  -- v̒Ō납琔āCԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strncaservscmp_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (len<=-3) return NULL;
	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (ex_strncaservscmp((char*)(pl->ldat).key.buf, (char*)key, len)) {
			nn++;
			if (no==nn) return pl;
		}
		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strstr_back_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D
		  |C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂
		  m[h̓C납琔 noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[D
		  len  -- >=0: key  pl̃L[Ɋ܂܂邩ǂD
				   <0: pl̃L[ KeyɊ܂܂邩ǂD
		  no  -- v̒Ō납琔āCԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strstr_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (len>=0) {
			if (strstr((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstr((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->prev;
	}
	return NULL;
}





/**
tList*  strstrcase_back_tList(tList* pl, char* key, int len, int no)

	@\: char*^ϐɂm[h̃T[`D啶𖳎D
		  |C^ plȍ~̃m[h,L[̕܂ key̕񂪑̕Ɋ܂܂
		  m[h̓C납琔 noԖڂɂ̂{oD

	: pl   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[D
		  len  -- >=0: key  pl̃L[Ɋ܂܂邩ǂD
				   <0: pl̃L[ KeyɊ܂܂邩ǂD
		  no  -- v̒Ō납琔āCԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tList*  strstrcase_back_tList(tList* pl, char* key, int len, int no)
{
	int nn = 0;

	if (no<=0) no = 1;

	pl = find_tList_end(pl);

	while (pl!=NULL) {
		if (len>=0) {
			if (strstrcase((char*)(pl->ldat).key.buf, (char*)key)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}
		else if (len<0) {
			if (strstrcase((char*)key, (char*)(pl->ldat).key.buf)!=NULL) {
				nn++;
				if (no==nn) return pl;
			}
		}

		pl = pl->prev;
	}
	return NULL;
}







///////////////////////////////////////////////////////////////////////////////////////////

/**
tList*  find_tList_top(tList* pl)

	@\: Xg̍ŏ̃m[hւTD

	: pl -- T[`Jnm[hւ̃|C^D

	߂l: Xg̍ŏ̃m[hւ̃|C^D
*/
tList*  find_tList_top(tList* pl)
{
	if (pl==NULL) return NULL;

	while (pl->prev!=NULL) pl = pl->prev;
	return pl;
}





/**
tList*  find_tList_end(tList* pl)

	@\: Xg̍Ō̃m[hւTD
		  Xg\̍Ō̃m[hT֐Ȃ̂ŁCtTree \ɓKpĂ
		@m[h邱Ƃ͏oȂDtTreeɑ΂Ă find_tTree_end()gƁD

	: pl -- T[`Jnm[hւ̃|C^D

	߂l: Xg̍Ō̃m[hւ̃|C^D
*/
tList*  find_tList_end(tList* pl)
{
	if (pl==NULL) return NULL;

	while (pl->next!=NULL) pl = pl->next;
	return pl;
}




/**
Buffer  search_key_tList(tList* list, char* key, int no) 

	@\FXg̒ noԖڂ keym[h(ldat.key)ToCldat.val̃Rs[ԂD
		  key ̓P[XCZVeBuD

	Fkey  -- wb_ʁD啶CʂȂD

	߂lF
		  vfree
*/
Buffer  search_key_tList(tList* list, char* key, int no) 
{
	tList* pp;
	Buffer buf;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;
	
	pp = strncasecmp_tList(list, key, 0, no);		// Sv
	if (pp!=NULL) {
		buf = dup_Buffer(pp->ldat.val);
	}
	
	return buf;
}





/**
Buffer  search_key_value_tList(tList* list, char* key, char* data, int no) 

	@\FXg̒ noԖڂ keym[hToCdata Ŏn܂m[hlԂD
		  key, data̓P[XCZVeBuD

	Fkey  -- wb_ʁD 啶CʂȂD
	@@@data -- wb_l̍ŏ̕D
*/
Buffer  search_key_value_tList(tList* list, char* key, char* data, int no) 
{
	tList* pp;
	Buffer buf;
	char*  str;
	int	   len;

	buf = init_Buffer();
	if (list==NULL || key==NULL) return buf;

	if (data==NULL) {
		buf = search_key_tList(list, key, no);
		return buf;
	}

	buf = init_Buffer();
	len = strlen(data); 
	
	pp = strncasecmp_tList(list, key, 0, no);
	if (pp!=NULL) {
		str = (char*)pp->ldat.val.buf;
		if (str!=NULL && !strncasecmp(str, data, len)) {
			buf = make_Buffer_bystr(str);
			return buf;
		}
	}

	return buf;
}






/*
int   set_value_tList(tList* list, char* key, int no, char* value, int add_mode)

	@\FXg(lt) noԖڂ keym[h̒l valueݒ肷D
		no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂Đݒ肪sD
		keym[h݂C mode==ON ̏ꍇ́CXg̍ŌɒǉD

	F
		list   -- Ώۂ̃Xg
		key    -- ݒsm[h̃L[D啶CʂȂD
	 	value  -- ݒ肳镶D
		no     -- keyv鉽ڂ̃m[hɑ΂ĐݒsD1琔D
				  0ȉ̏ꍇkeyv邷ׂẴm[hɑ΂ĐݒsD
		add_mod - ̒lON w肵m[hꍇCm[hXg̍ŌɒǉD

	߂lF
		ݒ肳ꂽm[h̐Dw肳ꂽm[h݂Ȃꍇ́iǉꂽꍇj0
		̏ꍇ̓G[D

*/
int   set_value_tList(tList* list, char* key, int no, char* value, int add_mode)
{
	int    cn = 0;
	tList* pm;

	if (list==NULL || key==NULL || value==NULL) return -1;

	if (no>0) {
		pm = strncasecmp_tList(list, key, 0, no);
		if (pm!=NULL) {
			int rep = set_value_tList_node(pm, value);
			if (rep) cn = 1;
		}
	}
	else {		// no<=0
		int nn = 1;
		cn = 0;
		pm = strncasecmp_tList(list, key, 0, nn);
		while (pm!=NULL) {
			int rep = set_value_tList_node(pm, value);
			if (rep) cn++;
			pm = strncasecmp_tList(list, key, 0, ++nn);
		}
	}

	// Not Found
	if (add_mode==ON && cn==0) {
		add_tList_node_str(list, key, value);
	}

	return cn;
}





int   set_value_tList_node(tList* lp, char* value)
{
	if (lp==NULL || value==NULL) return FALSE;
	
	Buffer buf = make_Buffer_bystr(value);
	free_Buffer(&lp->ldat.val);
	lp->ldat.val = buf;

	return TRUE;
}





/**
int	 replace_value_tList(tList* list, char* key, int no, char* srcval, char* value)

	@\FXg(lt) noԖڂ keym[h̒l srcval̕ value ɒuD
		no  0ȉ̏ꍇ́CSĂ keym[h̒lɑ΂ĒusD

	F
		list   -- Ώۂ̃Xg
		key    -- usm[h̃L[D啶CʂȂD
		srcval -- uΏۂ̕DNULLȂw肵ڂ̕ŚD
	 	value  -- usD
		no     -- ڂ̃m[hu邩D1琔D0ȉ̏ꍇkeyvSẴm[hu

	߂lF
		ύXꂽm[h̐Dw肳ꂽm[h݂Ȃ́iǉꂽꍇj0
		̏ꍇ̓G[D

*/
int	 replace_value_tList(tList* list, char* key, int no, char* srcval, char* value)
{
	int	cn = 0;
	tList* pm;

	if (list==NULL || key==NULL || value==NULL) return -1;
	if (srcval==NULL) {
		return set_value_tList(list, key, no, value, OFF);
	}

	if (no>0) {
		pm = strncasecmp_tList(list, key, 0, no);
		if (pm!=NULL) {
			int rep = replace_value_tList_node(pm, srcval, value);
			if (rep) cn = 1;
		}
	}
	else {	  // no<=0
		int nn = 1;
		cn = 0;
		pm = strncasecmp_tList(list, key, 0, nn);
		while (pm!=NULL) {
			int rep = replace_value_tList_node(pm, srcval, value);
			if (rep) cn++;
			pm = strncasecmp_tList(list, key, 0, ++nn);
		}
	}
	
	return cn;
}





int	 replace_value_tList_node(tList* lp, char* srcval, char* value)
{
	if (lp==NULL || value==NULL) return FALSE;
	if (srcval==NULL) {
		return set_value_tList_node(lp, value);
	}

	Buffer buf = replace_sBuffer(lp->ldat.val, srcval, value);
	free_Buffer(&lp->ldat.val);
	lp->ldat.val = buf;
	
	return TRUE;
}
	







tList*	awk_tList(char* str, char cc)
{
	int    nn = 1;
	char*  item;
	tList* lp = NULL;

	if (str==NULL) return NULL;

	item = awk(str, cc, nn);
	while (item!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, item, NULL, NULL, 0);
		free(item);
		item = awk(str, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;
}





tList*	cawk_tList(char* str, char cc)
{
	int    nn = 1;
	char*  item;
	tList* lp = NULL;

	if (str==NULL) return NULL;

	item = cawk(str, cc, nn);
	while (item!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, item, NULL, NULL, 0);
		free(item);
		item = cawk(str, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;

}




tList*	awk_Buffer_tList(Buffer buf, char cc)
{
	int    nn = 1;
	Buffer item;
	tList* lp = NULL;

	if (buf.buf==NULL) return NULL;

	item = awk_Buffer(buf, cc, nn);
	while (item.buf!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, (char*)item.buf, NULL, NULL, 0);
		free_Buffer(&item);
		item = awk_Buffer(buf, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;
}





tList*	cawk_Buffer_tList(Buffer buf, char cc)
{
	int    nn = 1;
	Buffer item;
	tList* lp = NULL;

	if (buf.buf==NULL) return NULL;

	item = cawk_Buffer(buf, cc, nn);
	while (item.buf!=NULL) {
		lp = add_tList_node_bystr(lp, nn, 0, (char*)item.buf, NULL, NULL, 0);
		free_Buffer(&item);
		item = cawk_Buffer(buf, cc, ++nn);
	}

	if (lp!=NULL) lp = find_tList_top(lp);
	return lp;

}





char*  get_str_join_tList(tList* lp, char* deli)
{
	Buffer buf = get_Buffer_join_tList(lp, deli);
	return (char*)buf.buf;
}






Buffer  get_Buffer_join_tList(tList* lp, char* deli)
{
	Buffer buf;
	
	buf = init_Buffer();
	if (lp==NULL) return buf;

	buf = make_Buffer(LBUF);

	if (lp!=NULL && lp->ldat.key.buf!=NULL) {
		cat_s2Buffer((char*)lp->ldat.key.buf, &buf);
		lp = lp->next;

		while (lp!=NULL && lp->ldat.key.buf!=NULL) {
			if (deli!=NULL) cat_s2Buffer(deli, &buf);
			cat_s2Buffer((char*)lp->ldat.key.buf, &buf);
			lp = lp->next;
		}
	}

	return buf;
}









//////////////////////////////////////////////////////////////////////////
// for Configuration File
//

char*  get_strparam_tList(tList* lt, char* key, char* dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf==NULL) buf = make_Buffer_bystr(dflt);
		
	return (char*)buf.buf;
}




int  get_intparam_tList(tList* lt, char* key, int dflt)
{
	Buffer buf;

	buf = search_key_tList(lt, key, 1);
	if (buf.buf!=NULL) {
		int ret = atoi((char*)buf.buf);
		free_Buffer(&buf);
		return ret;
	}
	return dflt;
}









/////////////////////////////////////////////////////////////////////////////
//
// Tiny List File I/O
//

/**
tList*  read_tList_file(char* fname, int mode) 

	@\Ft@CsÂǂݍŃXg̃L[Ɋi[D
		  s̓XgɉȂD

	Ffname -- t@CD 
		  mode  -- 0 ̏ꍇCt@Ĉ܂ܓǂݍށD
			 	   1 ̏ꍇC擪 # ̍s̓XgɉȂD܂Ő󔒂폜C̘̑A󔒂1̋󔒂ɕϊD
				   Ƀ^u͈̋󔒂ƂďD
				   2 ̏ꍇC1ɉāCr # ȍ~

	߂lFi[Xgւ̃|C^D
*/
tList*  read_tList_file(char* fname, int mode) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_tList_fp(fp, mode);
		fclose(fp);
	}
	else {
		DEBUG_MESG("READ_TLIST_FILE: cannot file open [%s]\n", fname);
	}

	return lp;
}






/**
tList*  read_tList_fp(FILE* fp, int mode) 

	@\Ft@C|C^t@CsÂǂݍŃXg̃L[Ɋi[D
		  s̓XgɉȂD

	Ffp   -- t@C|C^D 
		  mode -- 0 ̏ꍇCt@Ĉ܂ܓǂݍށD
				  1 ̏ꍇC擪 # ̍s̓XgɉȂD܂Ő󔒂폜C
				@̘̑A󔒂1̋󔒂ɕϊD
				  ܂C^u͈̋󔒂ƂďD
				  2 ̏ꍇC1ɉāCr # ȍ~

	߂lFi[Xgւ̃|C^D

	oOFfBNgǂ܂ƁC߂ĂȂD

*/
tList*  read_tList_fp(FILE* fp, int mode) 
{
	char	val[LBUF+1];
	char*   str;
	tList*   lp = NULL;
	tList*   lt = NULL;

	if (fp==NULL) return NULL;

	fgets(val, LBUF, fp);
	while (!feof(fp)) {
		if (mode>0) {
			if (mode>1) {
				int i;
				for (i=0; i<(int)strlen(val); i++) {
					if (val[i]=='#') {
						val[i] = '\0';
						break;
					}
					if (i>=LBUF) break;
				}
			}
			str = pack_char(val, ' ');
		}
		else {
			str = (char*)malloc(LBUF+1);
			if (str!=NULL) strncpy(val, str, LBUF);
		}

		if (str!=NULL) {
			if (strlen(str)>0) {	// s̃`FbN
				if (mode==0 || str[0]!='#') {
					lt = add_tList_node_str(lt, str, NULL);
					if (lp==NULL) lp = lt;
				}
			}
			free(str);
		}
		fgets(val, LBUF, fp);
	}
	
	return lp;
}





/**
tList*  read_index_tList_file(char* fname, char deli) 

	@\Ft@CsÂǂݍŁCdeli؂蕶ɂăXg̃L[ƃf[^Ɋi[D
		  s̓XgɉȂD#Ŏn܂s̓XgɉȂ

	Ffname -- t@CD 
		  deli  -- ؂蕶

	߂lFi[Xgւ̃|C^D
*/
tList*  read_index_tList_file(char* fname, char deli) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_index_tList_fp(fp, deli);
		fclose(fp);
	}
	return lp;
}





/**
tList*  read_index_tList_file(char* fname, char deli) 

	@\Ft@CsÂǂݍŁCdeli؂蕶ɂăXg̃L[ƃf[^Ɋi[D
		  s̓XgɉȂD#Ŏn܂s̓XgɉȂ

	Ffp	-- t@C|C^D 
		  deli  -- ؂蕶

	߂lFi[Xgւ̃|C^D
*/
tList*  read_index_tList_fp(FILE* fp, char deli)
{
	Buffer key, val;
	tList* pl;
	tList* pp;
	tList* lt = NULL;

 	pp = pl = read_tList_fp(fp, 1);
	while (pp!=NULL) {
		key = awk_Buffer(pp->ldat.key, deli, 1);
		val = awk_Buffer(pp->ldat.key, deli, 2);
			
		if (lt==NULL) lt = add_tList_node_byBuffer(NULL, 0, 0, key, val, NULL, 0);
		else               add_tList_node_byBuffer(lt,   0, 0, key, val, NULL, 0);
	
		free_Buffer(&key);
		free_Buffer(&val);
		
		pp = pp->next;
	}
	del_all_tList(&pl);

	return lt;
}





/**
tList*  read_Buffer_tList_file(char* fname) 

	@\Ft@C Buffer^ϐQÂǂݍŁCXg̃L[ƃobt@Ɋi[ԂD

	Ffname -- t@CD 

	߂lFi[Xgւ̃|C^D
*/
tList*  read_Buffer_tList_file(char* fname) 
{
	tList* lp = NULL;
	FILE* fp;

	fp = fopen(fname, "rb");
	if (fp!=NULL) {
		lp = read_Buffer_tList_fp(fp);
		fclose(fp);
	}
	return lp;
}






/**
tList*  read_Buffer_tList_fp(FILE* fp) 

	@\Ft@C Buffer^ϐQÂǂݍŁCXg̃L[ƃobt@Ɋi[ԂD

	Ffp   -- t@C|C^D 

	߂lFi[Xgւ̃|C^D

*/
tList*  read_Buffer_tList_fp(FILE* fp) 
{
	int	cc;
	tList*  lp = NULL;
	tList*  lt = NULL;
	Buffer key, val;

	if (fp==NULL) return NULL;

	cc = read_Buffer2_fp(&key, &val, fp);
	while (!feof(fp) && cc) {
		lt = add_tList_node_Buffer(lt, key, val);
		if (lp==NULL) lp = lt;
		free_Buffer(&key);	
		free_Buffer(&val);	
		cc = read_Buffer2_fp(&key, &val, fp);
	}
	
	free_Buffer(&key);	
	free_Buffer(&val);	
	return lp;
}





/**
int  save_Buffer_tList_file(char* fname, tList* lp) 

	@\FXg̃L[ƃobt@ Buffer^ϐt@C֏
		  t@Cɂꍇ́Cǉ݂D

	Ffname -- t@CD 

	߂lFTRUE   ݐD
			FALSE  ݎs
*/
int  save_Buffer_tList_file(char* fname, tList* lp) 
{
	int   ret=FALSE;
	FILE* fp;

	fp = fopen(fname, "ab");
	if (fp!=NULL) {
		ret = save_Buffer_tList_fp(fp, lp);
		fclose(fp);
	}
	return ret;
}






/**
int   save_Buffer_tList_fp(FILE* fp, tList* lp) 

	@\FXg̃L[ƃobt@ Buffer^ϐt@C֏
		  t@Cɂꍇ́Cǉ݂D

	Ffp   -- t@C|C^D 

	߂lFTRUE   ݐD
			FALSE  ݎs

*/
int   save_Buffer_tList_fp(FILE* fp, tList* lp) 
{
	int cc=TRUE;

	if (fp==NULL) return FALSE;

	while (lp!=NULL && cc) {
		cc = save_Buffer2_fp(lp->ldat.key, lp->ldat.val, fp);	
		lp = lp->next;
	}

	if (!cc) return FALSE;
	return TRUE;
}









/////////////////////////////////////////////////////////////////////////////////////////////////////
/**

	Tiny Tree Graph



*/

/////////////////////////////////////////////////////////////////////////////////////////////////////
//
// m[h
//

/**
tTree*  new_tTree_node(void)

	@\: c[p̋m[h𓮓IɐD

	߂l: ꂽm[hւ̃|C^D

	#define new_tTree_node()     new_tList_node()

*/





/**
tTree   make_tTree_node(tList_data ldat)

	@\: c[pm[hÓIɐD

	: ldat  -- m[hf[^

	߂l: ꂽm[hD

	#define make_tTree_node(d)     make_tList_node(d)
*/





/**
tTree*  add_tTree_node(tTree* pp, tTree* node) 

	@\: c[ ppփm[h nodeǉD|C^ ppwm[h̎qm[hƂ nodeî́jǉD
		  node qm[hꍇ́CǉD
		  node om[hĂĂ͖D

	: pp    -- ǉm[h̐eƂȂm[hւ̃|C^D
		  node  -- ǉm[hւ̃|C^Dnode->next ȉc[łǂD
		   
	߂l: ǉm[hւ̃|C^Dsꍇ NULL
*/
tTree*  add_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL) return NULL;
	if (pp==NULL) return node;

	node->prev = pp;
	node->ysis = NULL;
	node->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = node;
	if (pp->next==NULL) pp->next = node;
	pp->back = node;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}





/**
tTree*  add_tTree_node_bydata(tTree* pp, tList_data ldat) 

	@\: f[^ Treem[ho, pp̎qm[hƂĒǉD
		  ldat ͎w肳ꂽ̂̂܂܎gpD

	: pp   -- ǉm[h̐eƂȂm[hւ̃|C^D
		  ldat -- ǉm[hf[^D̃f[^̂܂܎gpD
		   
	߂l: ǉm[hւ̃|C^D
*/
tTree*  add_tTree_node_bydata(tTree* pp, tList_data ldat) 
{
	tTree* pt;

	pt = new_tTree_node();
	pt->ldat  = ldat;
	pt->depth = 1;

	if (pp==NULL) return pt;

	pt->prev = pp;
	pt->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = pt;
	if (pp->next==NULL) pp->next = pt;
	pp->back = pt;

	pt->depth = pp->depth + 1;
	pp->num++;
	
	return pt;
}





/**
tTree*  add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 

	@\: f[^m[ho,XgɒǉD
		  Xg|C^ ppwm[ȟɂo m[h}D

	: pp  -- ǉꏊ̎Õm[hւ̃|C^D
		  id  -- ǉf[^D
		  lv  -- ǉf[^D
		  key -- ǉf[^D		
		  val -- ǉf[^D		
		@ptr -- ėpf[^ւ̃|C^	
		  sz  -- *ptr ̃TCY
		   
	߂l: ǉm[hւ̃|C^D
*/
tTree*  add_tTree_node_byBuffer(tTree* pp, int id, int lv, Buffer key, Buffer val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata(id, lv, key, val, ptr, sz);
	pt   = add_tTree_node_bydata(pp, ldat);

	return pt;
}





/**
tTree*  add_tTree_node_bystr(tTree* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 

	@\: f[^m[ho,XgɒǉD
		  Xg|C^ ppwm[ȟɂo m[h}D

	: pp  -- ǉꏊ̎Õm[hւ̃|C^D
		  id  -- ǉf[^D
		  lv  -- ǉf[^D
		  key -- ǉf[^D		
		  val -- ǉf[^D		
		@ptr -- ėpf[^ւ̃|C^	
		  sz  -- *ptr ̃TCY
		   
	߂l: ǉm[hւ̃|C^D
*/
tTree*  add_tTree_node_bystr(tTree* pp, int id, int lv, char* key, char* val, void* ptr, int sz) 
{
	tTree* pt;
	tList_data ldat;

	ldat = make_tListdata_bystr(id, lv, key, val, ptr, sz);
	pt   = add_tTree_node_bydata(pp, ldat);

	return pt;
}





/**	
tTree*  free_tTree_node(tTree* node) 

	@\: m[h̃obt@(f[^)̊JD

	: node  -- Jm[hւ̃|C^D

	#define free_tTree_node(p)    free_tList_node(p)
*/





/**	
tTree*  del_tTree_node(tTree** node) 

	@\: c[m[h̍폜D폜ꂽm[hqm[hꍇ́C̎qm[h
		@iグi؍\l߂j
		  node ͓IɊmۂꂽϐłȂ΂ȂȂD

	: *node  -- 폜m[hւ̃|C^D

	߂l: 폜m[h̑ɋl߂ꂽqm[hւ̃|C^D
			Ym[hȂi폜m[hqm[hȂjꍇ NULL
*/
tTree*  del_tTree_node(tTree** node) 
{
	tTree* pp = NULL;

	if (node==NULL || *node==NULL) return pp;

	if ((*node)->next!=NULL) {	// 	qm[hꍇ
		tTree* ss;
		(*node)->next->depth--;
		adjust_tTree_depth((*node)->next);

		ss = (*node)->next;
		ss->prev = (*node)->prev;
		while (ss->ysis!=NULL) {
			ss = ss->ysis;
			ss->prev = (*node)->prev;
		} 

		ss->ysis = (*node)->ysis;
		(*node)->next->esis = (*node)->esis;
		if ((*node)->ysis!=NULL) (*node)->ysis->esis = ss;
		if ((*node)->esis!=NULL) (*node)->esis->ysis = (*node)->next;

		if ((*node)->prev!=NULL) {
			if ((*node)->prev->next==(*node)) (*node)->prev->next = (*node)->next;
			if ((*node)->prev->back==(*node)) (*node)->prev->back = ss;
		}
	}

	else {					// qm[hȂꍇ
		if ((*node)->prev!=NULL) {
			if ((*node)->prev->next==(*node)) (*node)->prev->next = (*node)->ysis;
			if ((*node)->prev->back==(*node)) (*node)->prev->back = (*node)->esis;
		}
		if ((*node)->ysis!=NULL) (*node)->ysis->esis = (*node)->esis;
		if ((*node)->esis!=NULL) (*node)->esis->ysis = (*node)->ysis;
	}

	pp = (*node)->prev;
  	free_tListdata(&((*node)->ldat));
	if ((*node)->prev!=NULL) (*node)->prev->num += (*node)->num - 1;

	free(*node);
	*node = NULL;

	return pp;
}




/**	
tTree*  move_tTree_node(tTree* pp, tTree* node) 

	@\: nodẽ݂c[؂藣CppֈړD
		@̃c[ɉāCnodeqm[hꍇ́C̎qm[hiグi؍\l߂j
		  ړɉẮCnode om[hĂĂ͖D
		  node폜Ȃ del_tTree_node(), add_tTree_node() s悤Ȃ́D

	: pp    -- ړŐeƂȂm[hւ̃|C^D
		  node  -- ړm[hւ̃|C^Dnode->next ȉc[łǂD

	߂l: ړm[hm[hւ̃|C^D
*/
tTree*  move_tTree_node(tTree* pp, tTree* node) 
{
	if (node==NULL || pp==NULL) return NULL;

	// m[h̐؂藣
	if (node->next!=NULL) {	// 	qm[hꍇ
		tTree* ss;
		node->next->depth--;
		adjust_tTree_depth(node->next);

		ss = node->next;
		ss->prev = node->prev;
		while (ss->ysis!=NULL) {
			ss = ss->ysis;
			ss->prev = node->prev;
		} 

		ss->ysis = node->ysis;
		node->next->esis = node->esis;
		if (node->ysis!=NULL) node->ysis->esis = ss;
		if (node->esis!=NULL) node->esis->ysis = node->next;

		if (node->prev!=NULL) {
			if (node->prev->next==node) node->prev->next = node->next;
			if (node->prev->back==node) node->prev->back = ss;
		}
	}
	else {					// qm[hȂꍇ
		if (node->prev!=NULL) {
			if (node->prev->next==node) node->prev->next = node->ysis;
			if (node->prev->back==node) node->prev->back = node->esis;
		}
		if (node->ysis!=NULL) node->ysis->esis = node->esis;
		if (node->esis!=NULL) node->esis->ysis = node->ysis;
	}
	if (node->prev!=NULL) node->prev->num += node->num - 1;


	// m[h̍Čiړj
	node->prev = pp;
	node->ysis = NULL;
	node->esis = pp->back;

	if (pp->back!=NULL) pp->back->ysis = node;
	if (pp->next==NULL) pp->next = node;
	pp->back = node;

	node->depth = pp->depth + 1;
	pp->num++;
	
	if (node->next!=NULL) {
		node->next->depth = node->depth + 1;
		adjust_tTree_depth(node->next);
	}

	return node;
}





/**
void  replace_all_tTree_node(tTree* pp, char* key, char* src, char* dst, int len)

	@\Fc[ pp keyL[Csrcm[hlƂĎSẴm[h̃m[hl dst ɏD

	Ftp  -- uΏۂ̃c[
		  key -- T[`L[
		  src -- uΏۂ̃m[hl
		  dst -- ũm[hl
		  len -- 1ȏ: v钷D
					 0: SvD
					-1: c[̃L[l̒ɍ킹D
					-2: T[`L[ key ̒ɍ킹D

	߂lFum[h̐

*/
int  replace_all_tTree_node(tTree* tp, char* key, char* src, char* dst, int len)
{
	int nn = 0;

	do { 
		if (ex_strncmp((char*)(tp->ldat).key.buf, (char*)key, len)) {
			if (ex_strncmp((char*)(tp->ldat.val.buf), (char*)src, len)) {
				free_Buffer(&(tp->ldat.val));
				tp->ldat.val = make_Buffer_bystr(dst);
				nn++;
			}
		}

		if (tp->next!=NULL) nn += replace_all_tTree_node(tp->next, key, src, dst, len);

		tp = tp->ysis;
	} while(tp!=NULL);

	return nn;
}







/////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// c[
//

/**
tTree*  del_tTree(tTree** pp) 

	@\Fw肵m[hȉ̃c[폜D

	F*pp -- 폜c[̐擪m[h

	߂lF폜c[̐em[hւ̃|C^D

*/
tTree*  del_tTree(tTree** pp) 
{
	tTree* pt;

	if (pp==NULL || *pp==NULL) return NULL;

	// qm[h̍폜
	if ((*pp)->next!=NULL) del_sisters_children_tTree(&((*pp)->next));

	// g̍폜
	pt = (*pp)->prev;
	if (pt!=NULL) {
		if (pt->next==*pp) pt->next = (*pp)->ysis;
		if (pt->back==*pp) pt->back = (*pp)->esis;
		pt->num--;
	}
	if ((*pp)->ysis!=NULL) (*pp)->ysis->esis = (*pp)->esis;
	if ((*pp)->esis!=NULL) (*pp)->esis->ysis = (*pp)->ysis;

  	free_tListdata(&((*pp)->ldat));
	free(*pp);
	*pp = NULL;

	return pt;
}





/**
tTree*  del_children_tTree(tTree** pp) 

	@\Fw肵m[h̎qc[폜Dw肵m[h͍폜ȂD

	F*pp -- 폜qc[̐em[h

	߂lF폜c[̐em[hւ̃|C^D*pp ̂܂ܕԂD

*/
tTree*  del_children_tTree(tTree** pp) 
{	
	if (pp==NULL || *pp==NULL) return NULL;

	if ((*pp)->next!=NULL) del_sisters_children_tTree(&((*pp)->next));

	(*pp)->num  = 0;
	(*pp)->next = NULL;
	(*pp)->back = NULL;

	return *pp;
}





/**
tTree*  del_sisters_children_tTree(tTree** pp) 

	@\Fw肵m[h̎oc[Cqc[폜D
		  w肵m[h폜D

	F*pp -- 폜c[̋N_m[h

	߂lF폜c[S̐em[hւ̃|C^D

	jċApDem[hɑ΂鏈͍sȂ̂ŁCʓrĂяoōsƁD

*/
tTree*  del_sisters_children_tTree(tTree** pp) 
{
	tTree* pm;
	tTree* pt;

	if (pp!=NULL || *pp==NULL) return NULL;
	pt = (*pp)->prev;

	pm = *pp;
	while (pm->esis!=NULL) pm = pm->esis;
	while (pm!=NULL) {
		tTree* pw = pm;
		if (pm->next!=NULL) del_sisters_children_tTree(&(pm->next)); 
		pm = pm->ysis;

  		free_tListdata(&(pw->ldat));
		free(pw);
	}

	*pp = NULL;

	return pt;
}





/**
void  del_all_tTree(tTree** pp)

	@\: c[̑Sm[h̍폜D
		  |C^ pp̃m[h܂ރc[Ŝ폜D
		  *pp ̓c[ł΁CǂwĂĂǂD

	: *pp -- 폜Jnm[hւ̃|C^D
		   		 c[ł΁CǂwĂĂǂD

	߂l: ȂD
*/
void  del_all_tTree(tTree** pp)
{
	tTree* pm;

	if (pp==NULL || *pp==NULL) return;

	pm = *pp;
	while (pm->prev!=NULL) pm = pm->prev;
	del_tTree(&pm);

	*pp = NULL;
	return;
}






/**
tTree*  add_tTree(tTree* tp, tTree* tt)

	@\: c[ tp c[ ttǉD
		  add_tTree_node() Ƃ̑́Cadd_tTree()擪(tt)̎om[hc[ tpɒǉ_ɂD

	: tp  -- ǉc[̐eƂȂm[hւ̃|C^D
		  tt  -- ǉc[ւ̃|C^D
		   
	߂l: ǉc[̃m[hւ̃|C^Dsꍇ NULL
*/
tTree*  add_tTree(tTree* tp, tTree* tt)
{
	int	nn;
	tTree* tm;
	tTree* tw;

	if (tt==NULL) return NULL;
	if (tp==NULL) return tt;

	while(tt->esis!=NULL) tt = tt->esis;
	tt->esis = tp->back;
	if (tp->back!=NULL) tp->back->ysis = tt;
	if (tp->next==NULL) tp->next = tt;

	nn = 0;
	tm = tw = tt;
	while (tm!=NULL) {
		nn++;
		tm->prev  = tp;
		tm->depth = tp->depth + 1;

		if (tm->next!=NULL) {
			tm->next->depth = tm->depth + 1;
			adjust_tTree_depth(tm->next);
		}
		tw = tm;
		tm = tm->ysis;
	}

	tp->back = tw;
	tp->num += nn;

	return tt;
}





/**
tTree*  div_tTree(tTree* tp, tTree* tt)

	@\: c[ tp  c[ tt𕪗D

	: tt -- c[ւ̕|CgD
		   
	߂l: c[̌em[hւ̃|C^Dsꍇ NULL
*/
tTree*  div_tTree(tTree* tt)
{
	if (tt==NULL) return NULL;
	if (tt->prev==NULL) return tt;

	if (tt->prev->next==tt) tt->prev->next = tt->ysis;
	if (tt->prev->back==tt) tt->prev->back = tt->esis;

	if (tt->ysis!=NULL) tt->ysis->esis = tt->esis;
	if (tt->esis!=NULL) tt->esis->ysis = tt->ysis;

	tt->depth = 1;
	if (tt->next!=NULL) {
		tt->next->depth = 2;
		adjust_tTree_depth(tt->next);
	}

	tt->prev->num--;
	tt->prev = NULL;

	return tt;
}





/**
tTree*  dup_merge_tTree(tTree* pp, tTree* tp)

	@\Fc[ pp̒Ƀc[ tp𕡐D
		  pp NULL̏ꍇ́Cc[̐[͒Ȃ

	Fpp -- ꂽc[̃gbvƂȂm[h
		  tp -- c[

	߂lFꂽc[ւ̃|C^D
			pp NULLłȂꍇ pp
			pp NULL̏ꍇ́CVc[̃gbvD

*/			 
tTree*  dup_merge_tTree(tTree* pp, tTree* tp)
{
	if (tp==NULL) return pp;

	if (pp!=NULL) {
		while(tp->esis!=NULL) tp = tp->esis;
		while(tp!=NULL) {
			tTree* pt = dup_tList_node(tp);
			pt->next = pt->prev = pt->back = pt->ysis = pt->esis = NULL;
			add_tTree(pp, pt);
			if (tp->next!=NULL) dup_merge_tTree(pt, tp->next);
			tp = tp->ysis;
		}		
	}
	else {
		pp = dup_tList_node(tp);
		pp->next = pp->prev = pp->back = pp->ysis = pp->esis = NULL;
		if (tp->next!=NULL) dup_merge_tTree(pp, tp->next);
	}

	return pp;
}







/**
void  merge_tTree(tTree* tp, tTree* tt)

	@\Fc[ tp Ƀc[ tt DCtt ̓e͉(tpƃm[h`ɂȂ)D
		  tt  tp̈ꕔƓ\(L[l)ꍇC[m[h tt̃m[hŒuD
		  tp ɑ݂Ȃ}͒ǉD
		  c[̐[ tp[ɍČvZD
		  
	Ftp -- tt ̌|Cg
		@tt -- c[

	߂lFtp -- ̃c[D
			tt -- Dv

	----------------------------------------------------------------
	F	tp							tr
			A --> B --> M				A --> B --> X
			  --> C --> M --> X			  --> C --> M
						  --> Y			  --> D
					--> N

		̏ꍇCmerge_tTree(tp, tr) sƈȉ̂悤ɂȂD

			tp
			A --> B --> M 
					--> X (tr)
			  --> C --> M (tr)
					--> N 
			  --> D (tr)

			tt
			A --> B 
			  --> C --> M --> X (tp)
						  --> Y (tp)
*/
void  merge_tTree(tTree* tp, tTree* tt)
{
	tTree* tl;
	tTree* nt;
	tTree* nl;
	int	depth;

	if (tp==NULL || tt==NULL) return;

	depth = tp->depth;
	tl = tp;
	while (tt!=NULL) {
		if ((tt->ldat).key.buf==NULL) return;
		if (tl!=NULL && (tl->ldat).key.buf==NULL) return;
		while (tl!=NULL && strcmp((char*)((tl->ldat).key.buf), (char*)((tt->ldat).key.buf))) tl = tl->ysis;

		nt = tt;
		nl = tl;
		tt = tt->ysis;

		if (tl==NULL) {	
			div_tTree(nt);
			add_tTree(tp->prev, nt);
			tl = nt;
			return;
		}
		else if (nl->next!=NULL && nt->next!=NULL) {
			merge_tTree(nl->next, nt->next);
			tl = tl->ysis;
		}
		else {
			tl = tl->ysis;
			exchange_tTree(nl, nt);
		}
	}

	tp->depth = depth;
	adjust_tTree_depth(tp);

	return;
}





/**
void  exchange_tTree(tTree* tl, tTree* tt)

	@\Fc[ tl c[ ttD

	Ftl -- Ώۂ̃c[
		  tt -- Ώۂ̃c[

	߂lFȂD

*/
void  exchange_tTree(tTree* tl, tTree* tt)
{
	int	dt = tt->depth;
	tTree* pt = tt->prev;
	tTree* yt = tt->ysis;
	tTree* et = tt->esis;


	if (tl->esis!=NULL) tl->esis->ysis = tt;
	if (tl->ysis!=NULL) tl->ysis->esis = tt;
	if (tl->prev!=NULL) {
		if (tl->prev->next==tl) tl->prev->next = tt;
		if (tl->prev->back==tl) tl->prev->back = tt;
	}

	tt->ysis  = tl->ysis;
	tt->esis  = tl->esis;
	tt->prev  = tl->prev;
	tt->depth = tl->depth;
	if (tt->next!=NULL) {
		tt->next->depth = tt->depth + 1;
		adjust_tTree_depth(tt->next);
	}


	if (et!=NULL) et->ysis = tl;
	if (yt!=NULL) yt->esis = tl;
	if (pt!=NULL) {
		if (pt->next==tt) pt->next = tl;
		if (pt->back==tt) pt->back = tl;
	}

	tl->ysis  = yt;
	tl->esis  = et;
	tl->prev  = pt;
	tl->depth = dt;
	if (tl->next!=NULL) {
		tl->next->depth = dt + 1;
		adjust_tTree_depth(tl->next);
	}
}





/**
void   adjust_tTree_depth(tTree* pp)

	@\Fw肵m[h ppɂāC؂̐[𑪂蒼

	Fpp -- ƂȂm[hւ̃|C^

*/
void   adjust_tTree_depth(tTree* pp)
{
	int depth;
	tTree* pt;
	
	if (pp==NULL) return;

	depth = pp->depth;
	pt = pp;
	while (pt->ysis!=NULL) {
		pt = pt->ysis;
		pt->depth = depth;
		if (pt->next!=NULL) {
			pt->next->depth = depth + 1;
			adjust_tTree_depth(pt->next);
		}
	}

	pt = pp;
	while (pt->esis!=NULL) {
		pt = pt->esis;
		pt->depth = depth;
		if (pt->next!=NULL) {
			pt->next->depth = depth + 1;
			adjust_tTree_depth(pt->next);
		}
	}

	if (pp->next!=NULL) {
		pp->next->depth = depth + 1;
		adjust_tTree_depth(pp->next);
	}

	return;
}





/**
void   print_tTree(FILE* fp, tTree* pp, char* space)

	@\: c[̕\D
		  |C^ ppȍ~̑SẴm[h̃L[̃obt@WG[o͂ɕ\D

	: fp    -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  pp	-- \Jnm[hւ̃|C^D
		  space -- o𑵂͂̏邽߂̋󔒁D

	߂l: ȂD

*/
void   print_tTree(FILE* fp, tTree* pp, char* space)
{
	if (fp==NULL) fp = stderr;

	if (pp!=NULL) {
		while(pp->esis!=NULL) pp = pp->esis;
		do { 
			int i;
			tList_data ld = pp->ldat;

			if (pp->depth>1) fprintf(fp, " -> ");
			fprintf(fp, "%d: %d %d %s %s", pp->depth, ld.id, ld.lv, ld.key.buf, ld.val.buf);
			//fprintf(fp, "%d: %d %d %s %s, %04x", pp->depth, ld.id, ld.lv, ld.key.buf, ld.val.buf, pp->altp);

			if (pp->next!=NULL) print_tTree(fp, pp->next, space);
			else fprintf(fp, "\n");

			pp = pp->ysis;
			if (pp!=NULL) {
				for(i=1; i<pp->depth; i++)   fprintf(fp, space);
				for(i=1; i<pp->depth-1; i++) fprintf(fp, "    "); 		// for " -> "
			}
		} while(pp!=NULL);
	}
	else {
		fprintf(fp, "(Tree is NULL)\n");
	}
	fflush(fp);

	return;
}





/**
tTree*  find_tTree_top(tTree* pp)

	@\Fc[̃gbvi[gj

	#define find_tTree_top(p)   find_tList_top(p)
*/





/**
tTree*  find_tTree_end(tTree* pp)

	@\Fc[̍ŏIm[hD

*/
tTree*  find_tTree_end(tTree* pp)
{
	if (pp==NULL) return NULL;

	while(pp->prev!=NULL) pp = pp->prev;	// Top T
	while(pp->back!=NULL) pp = pp->back;

	return pp;
}





/**
int  count_tTree(tTree* pp)

	@\Fc[ ppm[hȍ~̃m[h̐𐔂D

	: pp -- n߂m[hւ̃|C^Dom[hD

	߂l: m[h̐D
*/
int  count_tTree(tTree* pp)
{
	int cnt = 0;

	if (pp==NULL) return 0;
	while(pp->esis!=NULL) pp = pp->esis;

	do { 
		cnt++;
		if (pp->next!=NULL) cnt += count_tTree(pp->next);
		pp = pp->ysis;
	} while(pp!=NULL);

	return cnt;
}








////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Pattern Matching
//

/**
tTree*  strncmp_tTree(tTree* pp, char* key, int len, int no)

	@\: c[m[h̃L[l̃T[`D
		  |C^ ppȍ~̃m[h,L[̕ keyƑOviIjm[h
		   noԖڂɂ̂{oD

	: pp   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ij
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: c[̃L[l̒ɍ킹D
					 -2: T[`L[key ̒ɍ킹D
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tTree*  strncmp_tTree(tTree* pp, char* key, int len, int no)
{
	tTree* pt = NULL;
	int nn = 0;

	if (pp==NULL) return NULL;
	if (len<=-3)  return NULL;
	if (no<=0) no = 1;

	if (ex_strncmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
		nn++;
		if (no==nn) return pp;
	}
	if (pp->next!=NULL) pt = next_strncmp_vertical_tTree(pp->next, key, len, no, &nn);

	return pt;
}





/**
tTree*  strncasecmp_tTree(tTree* pp, char* key, int len, int no)

	@\: c[m[h̃L[l̃T[`D啶𖳎D
		  |C^ ppȍ~̃m[h,L[̕ keyƑOviIjm[h
		   noԖڂɂ̂{oD

	: pp   -- T[`Jnm[hւ̃|C^D
		  key  -- T[`L[ijD啶CʂȂD
		  len  -- 1ȏ: v钷D
				  0: SvD
				 -1: c[̃L[l̒ɍ킹D
				 -2: T[`L[key ̒ɍ킹D
		  no  -- v̒ŉԖڂ̕Ԃw肷D1琔D

	߂l: vm[hւ̃|C^D
			v̂ꍇ NULLD
*/
tTree*  strncasecmp_tTree(tTree* pp, char* key, int len, int no)
{
	tTree* pt = NULL;
	int nn = 0;

	if (pp==NULL) return NULL;
	if (len<=-3)  return NULL;
	if (no<=0) no = 1;

	if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
		nn++;
		if (no==nn) return pp;
	}
	if (pp->next!=NULL) pt = next_strncasecmp_vertical_tTree(pp->next, key, len, no, &nn);

	return pt;
}






/**
tTree*  cmp_sisters_tTree(tTree* tp, tTree* tr)

	@\Fm[htp̎om[h m[htr̎om[hƓp^[iL[lrĂ邩ǂD
		  Ctr->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
		  ܂ tp->ctrl  TREE_ALREADY_FOUND_NODE ̏ꍇ́CɈvȂD
		  m[hp^[ꍇCtr̊em[h altpɂ͑Ή tp̊em[hւ̃|C^i[D

	Ftp -- ׂom[h̒m[h
		  tr -- Tom[hp^[̒m[h

	߂lFtp trƓp^[n܂m[hւ̃|C^D
		  	tr̊em[h altpɂ͑Ή tp̊em[hւ̃|C^i[D
			NULL: tpɓop^[͖D̏ꍇCtraltp̒l͕sƂȂD


	----------------------------------------------------------------
	F	tp						tr
			--> A (1)				--> A 		A, B, X  L[l(ldat.key.buf)
			--> B (2)				--> X
			--> A (3)
			--> X (4)
			--> A (5)
			--> X (6)

		̏ꍇCcmp_sisters_tTree(tp, tr)  (3)ւ̃|C^ԂD܂ tr Am[h
		 altp ɂ (3) ւ̃|C^Ctr Xm[haltpɂ(4)ւ̃|C^i[
		DŏɌp^[̂ݕ]D

*/
tTree*  cmp_sisters_tTree(tTree* tp, tTree* tr)
{
	tTree* ta;
	tTree* tb = NULL;
	tTree* ts;

	ts = tp;
	while (ts!=NULL){
		ta = ts;
		tb = tr;
		while (ta!=NULL && tb!=NULL) {
			if (ta->ctrl==TREE_ALREADY_FOUND_NODE) break;
			if (tb->ctrl!=TREE_NOCMP_NODE && tb->ctrl!=TREE_NOCMP_COPY_NODE) {
				if ((ta->ldat).key.buf!=NULL && (tb->ldat).key.buf!=NULL) {
					if (strcmp((char*)((ta->ldat).key.buf), (char*)((tb->ldat).key.buf))) break;
				}
				else break;
			}
			tb->altp = ta;
			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (tb==NULL) return ts;

		ts = ts->ysis;
	}
	if (tb!=NULL) return NULL;

	return ts;
}






/**
int  check_match_tTree(tTree* tp, tTree* tr)

	@\Fc[ tp c[ trƓp^[(L[l)Ă邩ǂD
		  tp ̃gbv tr ̃gbv̓L[lvĂKvDvĂȂ΁Cp^[͖ƂD
		  Ctr->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D

		  x tp̎}̍Ō̃m[hɑ΂Ă ctrl TREE_ALREADY_FOUND_NODE ݒ肷̂ŁCă`FbN
		@ꍇȂǂ ctrl NAKvD

		  c[p^[ꍇCtr̊em[h altpɂ́CԍŏɌ
		  Ή tp̊em[hւ̃|C^i[D

	Ftp -- Ώۂ̃c[
		  tr -- p^[̃c[

	߂lFTRUE:  tp trƓc[p^[݂D
		  		   tr̊em[h altpɂ́CԍŏɌΉ tp̊em[hւ̃|C^i[D
			FALSE: tpɓc[p^[͖D̏ꍇCtraltp̒l͕sƂȂD

*/
int  check_match_tTree(tTree* tp, tTree* tr)
{
	int  ret;
	tTree* ts;
	tTree* tt;
	tTree* ta;
	tTree* tb;
	tTree* te;


	if (tp==NULL || tr==NULL) return FALSE;

	te = find_tList_end(tr);

	ts = tp;
	while (ts!=NULL) {
		tt = cmp_sisters_tTree(ts, tr);		// ̊KwŃL[lSĈvĂ邩mF
		if (tt==NULL) return FALSE;			// vĂȂ΁CFALSE
		
		ta  = tt;							// ׂc[
		tb  = tr;							// ׂp^[
		ret = TRUE;
		while (tb!=NULL && ret) {
			if (tb->next==NULL) ret = TRUE;
			// ->ta, ->tb->tx: FALSE
			else if (tb->next!=NULL && ta->next==NULL) ret = FALSE;
			// ->ta->xa, ->tb->xb: xaxb`FbN
			else ret = check_match_tTree(ta->next, tb->next);

			ta = ta->ysis;
			tb = tb->ysis;
		}

		if (ret) {
			if (tr==te) tt->ctrl = TREE_ALREADY_FOUND_NODE;
			return TRUE;
		}

		ts = tt->ysis;
	}

	return FALSE;
}






/**
int find_match_tTree(tTree* pp, tTree* pt)

	@\Fc[ pp c[ ptƓp^[̎}TC 
		  p^[̒Tł L[l݂̂rCm[hl͔rȂD
		  Cpt->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
	
		  c[p^[ꍇCtr̊em[h altpɂ́CԍŏɌΉ pp̊em[h
		  ̃|C^i[D

	check_match_tTree() Ƃ̈ႢD
		check_match_tTree() łׂ͔}̊Jnm[hppɌŒ肳D
		find_match_tTree()  ppړȂ猟łD

	Fpp -- Ώۂ̃c[
		  pt -- p^[̃c[

	߂lFTRUE:  pp ptc[p^[݂D
		  		   pt̊em[h altpɂ́CԍŏɌΉ pp̊em[hւ̃|C^i[D
			FALSE: ppɓc[p^[͖D̏ꍇCptaltp̒l͕sƂȂD
*/
int  find_match_tTree(tTree* pp, tTree* pt)
{
	int   ret;
	tTree* pm;

	pm = pp;
	while(pp!=NULL) {
		ret = check_match_tTree(pp, pt);
		if (ret) return TRUE;

		if (pp->next!=NULL) {
			ret = find_match_tTree(pp->next, pt);
			if (ret) {
				clear_tTree_ctrl(pm);
				return TRUE;
			}
		}
		pp = pp->ysis;
	}

	return FALSE;
}







/**
void   clear_tTree_ctrl(tTree* pp)

	@\Fpp ̃c[ ctrl NAD

*/
void   clear_tTree_ctrl(tTree* pp)
{
	while (pp->esis!=NULL) pp = pp->esis;

	while (pp!=NULL) {
		pp->ctrl = TREE_NOCTRL_NODE;
		if (pp->next!=NULL) clear_tTree_ctrl(pp->next);
		pp = pp->ysis;
	}
}







/**
tList*  find_match_tTree_endlist(tTree* pp, tTree* pt)

	@\Fc[ pp c[ ptƓp^[̎}SĒTāC̎}̍Ō̃m[hւ̏XgɂĕԂD
		@Ym[hւ̃|C^ ԂꂽeXgaltp ێĂD 

		  rł L[l݂̂rCm[hl͔rȂD
		  ܂Cpt->ctrl  TREE_NOCMP_NODE ܂ TREE_NOCMP_COPY_NODE ̃m[hׂ͔Ȃ(ɈvƂ)D
	
	Fpp -- Ώۂ̃c[
		  pt -- p^[̃c[

	߂lFYm[hւ̃|C^ێ郊XgD

*/
tList*  find_match_tTree_endlist(tTree* pp, tTree* pt)
{
	tTree* te;
	tList* lp;

	te = find_tTree_end(pt);
	while(pp->esis!=NULL) pp = pp->esis;

	lp = find_match_tTree_endlist_rcsv(pp, pt, te);
	if (lp!=NULL) clear_tTree_ctrl(pp);
	
	return lp;
}





/**
tList*  find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te)

	@\Ffind_match_tTree_endlist() ̕⏕֐

*/
tList*  find_match_tTree_endlist_rcsv(tTree* pp, tTree* pt, tTree* te)
{
	tList* lt = NULL;
	tList* lp = NULL;

	while(pp!=NULL) {
		int ret = check_match_tTree(pp, pt);
		if (ret && te->altp!=NULL) {
			tList* lm = new_tList_node();
			lm->altp = te->altp;
			lt = insert_tList(lt, lm);
			if (lp==NULL) lp = lt;
			te->altp = NULL;
		}
			
		if (pp->next!=NULL) {
			tList* lm = find_match_tTree_endlist_rcsv(pp->next, pt, te);
			if (lm!=NULL) {
				lt = insert_tList(lt, lm);
				if (lp==NULL) lp = lt;
				clear_tTree_ctrl(pp->next);
			}
		}
	
		if (!ret) pp = pp->ysis;	// ꍇ͂xDȂꍇ֎ցD
	}
	
	return lp;
}






/**
void  replace_tTree_node(tTree* pp, tTree* pt)

	@\Fc[ pp c[ ptƓp^[iL[lrj̎}CppɈvp^[̎}΁C
		  ̎}̊em[hɑ΂āCΉ邻ꂼ́ipt->ctrl  TREE_COPY_NODE ܂ TREE_NOCMP_COPY_NODE łj
		  pt̃m[h̑ŒuD
		  p^[̈vijł ldat.keyiL[ljrD

		@u鑮 ldat.id, ldat.lv, ldat.sz, ldat.key, ldat.val, ldat.ptr, ldat.lst
		  uŝ pt->ctrl  TREE_COPY_NODE ܂ TREE_NOCMP_COPY_NODE ̏ꍇ݂̂łD(dv)
		@ldat.val, ldat.ptr, ldat.lst ɂẮCptŒlݒ肳ĂȂ΁CusȂD
	
	Fpp -- uΏۂ̃c[
		  pt -- uc[

	߂lFTRUE : u}Dɒuꂽǂ͕sD
			FALSE: u}ȂD

*/
int replace_tTree_node(tTree* pp, tTree* pt)
{
	int ret;

	if (pp==NULL || pt==NULL) return FALSE;
	while(pp->esis!=NULL) pp = pp->esis;
	
	ret = find_match_tTree(pp, pt);
	if (ret) {
		copy_tTree_byctrl(pt);
		adjust_tTree_depth(pp);
	}

	return ret;
}






/**
void  copy_tTree_byctrl(tTree* pt)

	@\Freplace_tTree_node()̕⏕֐D
		  c[ ptɂāCpt->ctrl  TREE_COPY_NODE ܂ TREE_NOCMP_COPY_NODE ̏ꍇC
		  pt->altp ̃m[h pt̑Rs[D

		  pt->ldat.sz ɂ͐m pt->ldat.ptr̃TCYݒ肳ĂKvD
*/
void  copy_tTree_byctrl(tTree* pt)
{
	while(pt!=NULL) {
		if (pt->altp!=NULL) {
			if (pt->ctrl==TREE_COPY_NODE || pt->ctrl==TREE_NOCMP_COPY_NODE) {
				pt->altp->ldat.id = pt->ldat.id;		
				pt->altp->ldat.lv = pt->ldat.lv;
				pt->altp->ldat.sz = pt->ldat.sz;

				if (pt->ldat.key.buf!=NULL) {
					free_Buffer(&(pt->altp->ldat.key));
					pt->altp->ldat.key = dup_Buffer(pt->ldat.key);
				}
				if (pt->ldat.val.buf!=NULL) {
					free_Buffer(&(pt->altp->ldat.val));
					pt->altp->ldat.val = dup_Buffer(pt->ldat.val);
				}

				if (pt->ldat.ptr!=NULL && pt->ldat.sz>0) {
					if (pt->altp->ldat.ptr!=NULL) free(pt->altp->ldat.ptr);
					pt->altp->ldat.ptr = (void*)malloc(pt->ldat.sz);
					if (pt->altp->ldat.ptr!=NULL) memcpy(pt->altp->ldat.ptr, pt->ldat.ptr, pt->ldat.sz);
				}

				if (pt->ldat.lst!=NULL) {
					del_all_tList(&(pt->altp->ldat.lst));
					pt->altp->ldat.lst = dup_tList(pt->ldat.lst);
				}
			}
		}

		if (pt->next!=NULL) copy_tTree_byctrl(pt->next);
		pt = pt->ysis;
	}

	return;
}






/**
Buffer  get_value_tTree(tTree* pp, tTree* pt)

	@\Fc[ pp c[ ptƓp^[̎}CppɈvp^[
		  }΁C@̎}̍Ō̃m[h̒lԂD

	Fpp -- Ώۂ̃c[
		  pt -- p^[

	߂lFpt̍Ō̃m[hɑΉ pp̃m[h̃m[hl


	----------------------------------------------------------------
	F	tp							tr
			A --> B --> M				C --> M --> Y
			  --> C --> M --> X 			  
						  --> Y(*)		 
					--> N

		̏ꍇCY(*) ̃m[hlԂD
*/
Buffer  get_value_tTree(tTree* pp, tTree* pt)
{
	int fnd;
	Buffer val;

	val = init_Buffer();
	if (pp==NULL || pt==NULL) return val;

	while(pp->esis!=NULL) pp = pp->esis;
	
	fnd = find_match_tTree(pp, pt);
	if (fnd) {
		tTree* tt = find_tTree_end(pt);
		if (tt->altp!=NULL) {
			val = dup_Buffer(tt->altp->ldat.val);
		}
	}

	return val;
}











/////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
tTree*  next_strncmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
tTree*  next_strncmp_horizon_tTree (tTree* pp, char* key, int len, int no, int* nn)
tTree*  next_strncasecmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
tTree*  next_strncasecmp_horizon_tTree (tTree* pp, char* key, int len, int no, int* nn)

	tTree p⏕֐Dhorizon ͋[IȉTiSȉTł͂Ȃj

*/
tTree*  next_strncmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->next!=NULL) {
			tTree* tt = next_strncmp_vertical_tTree(pp->next, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->ysis;
	} while(pp!=NULL);

	return NULL;
}





tTree*  next_strncmp_horizon_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->ysis!=NULL) {
			tTree* tt = next_strncmp_horizon_tTree(pp->ysis, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->next;
	} while(pp!=NULL);

	return NULL;
}





tTree*  next_strncasecmp_vertical_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->next!=NULL) {
			tTree* tt = next_strncasecmp_vertical_tTree(pp->next, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->ysis;
	} while(pp!=NULL);

	return NULL;
}





tTree*  next_strncasecmp_horizon_tTree(tTree* pp, char* key, int len, int no, int* nn)
{
	do { 
		if (ex_strncasecmp((char*)(pp->ldat).key.buf, (char*)key, len)) {
			(*nn)++;
			if (no==*nn) return pp;
		}
		if (pp->ysis!=NULL) {
			tTree* tt = next_strncasecmp_horizon_tTree(pp->ysis, key, len, no, nn);
			if (tt!=NULL) return tt;
		}
		pp = pp->next;
	} while(pp!=NULL);

	return NULL;
}





