/* vim: set tabstop=4 paste nocindent noautoindent ff=unix: */

/**
ėpc[vO  tools.c

						'05 10/10

wb_
	#include "tools.h"
 */


#include "tools.h"



int   DebugMode 	= OFF;
int   KanjiCode 	= EUC;
int	  UnitTestMode 	= OFF;

int   HostEndian 	= UNKNOWN_ENDIAN;


char  LocalIPNum[4] = {0x7f, 0x00, 0x00, 0x01};






///////////////////////////////////////////////////////////////////////////////////////////
// 

#ifndef CPLUSPLUS

int  isNull(void* p)
{
	if (p==NULL) return TRUE;

#ifdef WIN32
	if (p==WIN32_NULL) return TRUE;
#endif

	return FALSE;
}

#endif






///////////////////////////////////////////////////////////////////////////////////////////
// 

/**
int is_little_endian()
int is_big_endian()

	GfBA̓I`FbN

*/
int is_little_endian(void)
{
	unsigned char x[] = {0x01, 0x00};

	if (HostEndian==LITTLE_ENDIAN) return TRUE;

	else if (HostEndian==BIG_ENDIAN) return FALSE;

	else {
		if (*((unsigned short*)x)==1) {
			HostEndian = LITTLE_ENDIAN;
			return TRUE;
		}
		else {
			HostEndian = BIG_ENDIAN;
			return FALSE;
		}
	}
}




int is_big_endian(void)
{
	unsigned char x[] = {0x00, 0x01};

	if (HostEndian==BIG_ENDIAN) return TRUE;

	else if (HostEndian==LITTLE_ENDIAN) return FALSE;

	else {
		if (*((unsigned short*)x)==1) {
			HostEndian = BIG_ENDIAN;
			return TRUE;
		}
		else {
			HostEndian = LITTLE_ENDIAN;
			return FALSE;
		}
	}
}



void  check_endian(void)
{
	if (HostEndian==UNKNOWN_ENDIAN) is_little_endian();
} 



//
//
//
double double_from_little_endian(void* ptr)
{
	double ret = *((double*)ptr);
	
	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==BIG_ENDIAN) reverse_str((uByte*)(&ret), 8);
	return ret;
}



float float_from_little_endian(void* ptr)
{
	float ret = *((float*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==BIG_ENDIAN) reverse_str((uByte*)(&ret), 4);
	return ret;
}



int  int_from_little_endian(void* ptr)
{
	int ret = *((int*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==BIG_ENDIAN) reverse_str((uByte*)(&ret), 4);
	return ret;
}


short short_from_little_endian(void* ptr)
{
	short ret = *((short*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==BIG_ENDIAN) reverse_str((uByte*)(&ret), 2);
	return ret;
}



double double_from_big_endian(void* ptr)
{
	double ret = *((double*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==LITTLE_ENDIAN) reverse_str((uByte*)(&ret), 8);
	return ret;
}



float float_from_big_endian(void* ptr)
{
	float ret = *((float*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==LITTLE_ENDIAN) reverse_str((uByte*)(&ret), 4);
	return ret;
}



int  int_from_big_endian(void* ptr)
{
	int ret = *((int*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==LITTLE_ENDIAN) reverse_str((uByte*)(&ret), 4);
	return ret;
}


short short_from_big_endian(void* ptr)
{
	short ret = *((short*)ptr);

	if (HostEndian==UNKNOWN_ENDIAN) check_endian();
	if (HostEndian==LITTLE_ENDIAN) reverse_str((uByte*)(&ret), 2);
	return ret;
}




///////////////////////////////////////////////////////////////////////////////////////////
// Time

char  _Local_Time[32];

char*  get_local_time(void)
{
    struct tm* pt;
    time_t tm;

    tm = time(NULL);
    pt = localtime(&tm);

	snprintf(_Local_Time, 20, "%04d:%02d:%02d %02d:%02d:%02d", pt->tm_year+1900, pt->tm_mon+1, pt->tm_mday, pt->tm_hour, pt->tm_min, pt->tm_sec);

	return _Local_Time;
}





///////////////////////////////////////////////////////////////////////////////////////////
/**
char*  get_line(char* str, int n)

	@\Fstr̃obt@ nsڂoDsR[h͍폜D
		  n  1琔Dos char^ϐ̃obt@Ɋi[
		  ĕԂD
		  Ԃꂽf[^ free()KvD

	Fstr -- Ώە̎^f[^(܂މs)
		  n   -- s̎wD

	߂lFw肳ꂽ nsڂ̕Ds͊܂܂ȂD
*/
char*  get_line(char* buf, int n)
{
	int i, j, pos, cnt;
	char* ret=NULL;

	if (buf==NULL) return NULL;

	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!=LF && buf[i]!=CR && buf[i]!='\0') i++;
		while (buf[i]==LF || buf[i]==CR) i++;
	}
	if (buf[i]=='\0') return  NULL;

	pos = i;
	while (buf[i]!=LF && buf[i]!=CR && buf[i]!='\0') i++;
	cnt = i - pos;

	if (cnt>=0) {  
		ret = (char*)malloc(cnt+1);
		if (ret==NULL) return NULL;

		for(i=0; i<cnt; i++) ret[i] = buf[pos+i];
		ret[cnt] = '\0';
	}
	return  ret;
}






/**
char*  awk(char* str, char cc, int n)

	@\Fcc؂LƂ, str̃obt@ nԖڂ̍ڂԂD
		  n  1琔D
		  Ԃꂽf[^ free()KvD

	Fstr -- ΏەD
		  cc  -- ؂蕶D
		  n   -- ڂ̎wD

	߂lFw肳ꂽ nԖڂ̍ڂ̕D

*/
char*  awk(char* buf, char cc, int n)
{
	int i, j, pos, cnt;
	char*  item = NULL;

	if (buf==NULL) return NULL;

	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		if (buf[i]==cc) i++;
	}
	if (buf[i]=='\0')  return NULL;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = (char*)malloc(cnt+1);
	if (item==NULL) return NULL;

	for (i=0; i<cnt; i++) item[i] = buf[pos+i];
	item[cnt] = '\0';

	return item;
}





/**
char*  cawk(char* str, char cc, int n)

	@\Fcc؂LƂ, str̃obt@ nԖڂ̍ڂԂD
		  n  1琔DA cc(؂)͈̋؂Ƃ݂ȂD
		  Ԃꂽf[^ free()KvD

	Fstr -- ΏەD
		  cc  -- ؂蕶D
		  n   -- ڂ̎wD

	߂lFw肳ꂽ nԖڂ̍ڂ̕D
*/
char*  cawk(char* buf, char cc, int n)
{
	int i, j, pos, cnt;
	char*  item = NULL;

	if (buf==NULL) return NULL;

	for(i=0,j=0; j<n-1; j++) {
		while (buf[i]!='\0' && buf[i]!=cc) i++;
		while (buf[i]!='\0' && buf[i]==cc) i++;
	}
	if (buf[i]=='\0') return NULL;

	pos = i;
	while (buf[i]!='\0' && buf[i]!=cc) i++;
	cnt = i - pos;

	item = (char*)malloc(cnt+1);
	if (item==NULL) return NULL;

	for (i=0; i<cnt; i++) item[i] = buf[pos+i];
	item[cnt] = '\0';

	return item;
}




/**
void   int_swap(int* p, int* s)

	@\Fint^ϐ p s ̓eւD

	F*p, *s  -- ւ鐮 D

	߂lFȂD
*/
/*
void   int_swap(int* p, int* s)
{
	int swap;

	swap = *p;
	*p   = *s;
	*s   = swap;
}
*/




/**
int  bincmp(unsigned char* b1, unsigned char* b2, int n) 

	@\F oCif[^ s1 s2 nByterD

	߂lF vꍇ 0CvȂꍇ 1 ԂD
			 strncmp()̖߂l̒`Ƃ͎኱قȂ̂Œӂ邱ƁD
*/
int  bincmp(unsigned char* b1, unsigned char* b2, int n) 
{
	int i;

	if (b1==NULL || b2==NULL) return 1;

	for (i=0; i<n; i++) {
		if (b1[i]!=b2[i]) return 1;
	}

	return 0;
}






/**
int  strnrvscmp(const char* s1, const char* s2, int n) 

	@\F  s1 s2납 nrD

	߂lF vꍇ 0CvȂꍇ 1 ԂD
			 strncmp()̖߂l̒`Ƃ͈قȂ̂Œӂ邱ƁD
*/
int  strnrvscmp(const char* s1, const char* s2, int n) 
{
	int j1, j2;
	
	if (s1==NULL || s2==NULL) return 1;

	j1 = (int)strlen(s1) - 1;
	j2 = (int)strlen(s2) - 1;

	while (n>0 && j1>=0 && j2>=0) {
		if (s1[j1--] != s2[j2--]) return 1;
		n--;
	}

	if (n==0) return 0;
	else	  return 1;
}




/**
int  strncaservscmp(const char* s1, const char* s2, int n) 

	@\F  s1 s2납 nrD

	߂lF vꍇ 0CvȂꍇ 1 ԂD
			 strncmp()̖߂l̒`Ƃ͈قȂ̂Œӂ邱ƁD
*/
int  strncaservscmp(const char* s1, const char* s2, int n) 
{
	int j1, j2;
	
	if (s1==NULL || s2==NULL) return 1;

	j1 = (int)strlen(s1) - 1;
	j2 = (int)strlen(s2) - 1;

	while (n>0 && j1>=0 && j2>=0) {
		if (toupper(s1[j1--]) != toupper(s2[j2--])) return 1;
		n--;
	}

	if (n==0) return 0;
	else	  return 1;
}





/**
char*  strstrcase(const char* buf, const char* nd)

	@\F buf̒ɕ nd邩ǂ`FbND啶ʂȂD	
@@@@@啶ʂȂ_΁Cstrstr() ƓD
		  ܂ strcasestr() ƓDW strcasestr()݂ȂꍇɎgpD

*/
char*  strstrcase(const char* buf, const char* nd)
{
	char* pp;
	char* pb;
	char* pn;

	if (buf==NULL || nd==NULL) return NULL;

	pb = (char*)malloc(strlen(buf)+1);
	if (pb==NULL) return NULL;
	memcpy(pb, buf, (int)strlen(buf)+1);

	pn = (char*)malloc(strlen(nd)+1);
	if (pn==NULL) {
		free(pb);
		return NULL;
	}
	memcpy(pn, nd, (int)strlen(nd)+1);

	upper_string(pb);
	upper_string(pn);

	pp = strstr(pb, pn);
	if (pp!=NULL) {
		pp = (pp - pb) + (char*)buf;
	}
	free(pb);
	free(pn);

	return pp;
}





/**
int  ex_strncmp(const char* dat, const char* key, int len) 

	@\: gr

	: dat  -- ׂ镶PD
		  key  -- ׂ镶QD
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: dat ̒ɍ킹D
					 -2: key ̒ɍ킹D
   
	߂l: vꍇ TRUEDvȂꍇ FALSED
*/
int  ex_strncmp(const char* dat, const char* key, int len) 
{
	if (dat==NULL || key==NULL) return FALSE;

	if (len==0) {
		if (!strcmp(dat, key)) return TRUE;
	}
	else if (len>0) {
		if (!strncmp(dat, key, len)) return TRUE;
	}
	else if (len<0) {
		int sz;
		if (len==-1) sz = (int)strlen(dat);
		else		 sz = (int)strlen(key);
		if (!strncmp(dat, key, sz)) return TRUE;
	}
	
	return FALSE;
}




/**
int  ex_strncasecmp(const char* dat, const char* key, int len) 

	@\: grDP[XD

	: dat  -- ׂ镶PD
		  key  -- ׂ镶QD
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: dat ̒ɍ킹D
					 -2: key ̒ɍ킹D
   
	߂l: vꍇ TRUEDvȂꍇ FALSED
*/
int  ex_strncasecmp(const char* dat, const char* key, int len) 
{
	if (dat==NULL || key==NULL) return FALSE;

	if (len==0) {
		if (!strcasecmp(dat, key)) return TRUE;
	}
	else if (len>0) {
		if (!strncasecmp(dat, key, len)) return TRUE;
	}
	else if (len<0) {
		int sz;
		if (len==-1) sz = (int)strlen(dat);
		else		 sz = (int)strlen(key);
		if (!strncasecmp(dat, key, sz)) return TRUE;
	}
	
	return FALSE;
}






/**
int  ex_strnrvscmp(const char* dat, const char* key, int len) 

	@\: gr

	: dat  -- ׂ镶PD
		  key  -- ׂ镶QD
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: dat ̒ɍ킹D
					 -2: key ̒ɍ킹D
   
	߂l: vꍇ TRUEDvȂꍇ FALSED
*/
int  ex_strnrvscmp(const char* dat, const char* key, int len) 
{
	if (dat==NULL || key==NULL) return FALSE;

	if (len==0) {
		if (!strcmp(dat, key)) return TRUE;
	}
	else if (len>0) {
		if (!strnrvscmp(dat, key, len)) return TRUE;
	}
	else if (len<0) {
		int sz;
		if (len==-1) sz = (int)strlen(dat);
		else		 sz = (int)strlen(key);
		if (!strnrvscmp(dat, key, sz)) return TRUE;
	}
	
	return FALSE;
}




/**
int  ex_strncaervscmp(const char* dat, const char* key, int len) 

	@\: grDP[XD

	: dat  -- ׂ镶PD
		  key  -- ׂ镶QD
		  len  -- 1ȏ: v钷D
					  0: SvD
					 -1: dat ̒ɍ킹D
					 -2: key ̒ɍ킹D
   
	߂l: vꍇ TRUEDvȂꍇ FALSED
*/
int  ex_strncaservscmp(const char* dat, const char* key, int len) 
{
	if (dat==NULL || key==NULL) return FALSE;

	if (len==0) {
		if (!strcasecmp(dat, key)) return TRUE;
	}
	else if (len>0) {
		if (!strncaservscmp(dat, key, len)) return TRUE;
	}
	else if (len<0) {
		int sz;
		if (len==-1) sz = (int)strlen(dat);
		else		 sz = (int)strlen(key);
		if (!strncaservscmp(dat, key, sz)) return TRUE;
	}
	
	return FALSE;
}









/**
char*  chomp(char* buf)

	@\Fŏ̉sR[hȍ~𖳎D

	Fbuf -- s𖳌ɂ镶D
 */
char*  chomp(char* buf)
{
	int i, len;
	
	if (buf==NULL) return NULL;

	len = (int)strlen(buf);
	for (i=0; i<len; i++) {
		if (buf[i]==LF || buf[i]==CR) {
			buf[i] = '\0';
			return buf;
		}
	}
	return buf;
}





/**
char*  skip_char(char* pm, const char* check)

	@\Fpm̎w񒆂ŁCcheck[]Ɋi[ꂽ܂
		@|C^XLbvD
		  C" ' ɊYĂD

	Fpm    -- ̐擪|C^
		  check -- XLbv镶i[D

	߂lFcheck[]̒ōŏɌւ̃|C^D
*/
char*  skip_char(char* pm, const char* check)
{
	int  n, sqf=0, dqf=0;

	n = (int)strlen(check);

	while (*pm!='\0') {
		if		(!sqf && *pm=='"')  dqf = 1 - dqf;
		else if (!dqf && *pm=='\'') sqf = 1 - sqf;

		else if (!sqf && !dqf) {
			int i;
			for (i=0; i<n; i++) {
				if (*pm==check[i]) return pm;
			}
		}
		pm++;
	}

	return NULL;
}







/**
char*  pack_head_tail_char(char* mesg, char cc)

	@\F̐擪cc()CIcc()CTAB, CR, LF 폜
		  Ԃꂽf[^ free()KvD

	߂lFϊ̕
*/
char*  pack_head_tail_char(char* mesg, char cc)
{
	int   sz;
	char* ps;
	char* pe;
	char* pp;

	if (mesg==NULL) return NULL;

	ps = mesg;
	while(*ps==cc || *ps==TAB || *ps==LF || *ps==CR) ps++;
	pe = ps;
	while(*pe!='\0') pe++;
	pe--;
	while(*pe==cc || *pe==TAB || *pe==LF || *pe==CR) pe--;

	sz = (int)(pe - ps) + 1;
	pp = (char*)malloc((size_t)(sz + 1));
	memcpy(pp, ps, sz);
	pp[sz] = '\0';

	return pp;		
}







/**
char*  pack_char(char* mesg, char cc)

	@\F񒆋yсC擪cc()CIcc()CCR, LF 폜
		  ^u͋󔒂ɕϊD
		  bZ[W̘A cc  1ɕϊ
		  Ԃꂽf[^ free()KvD

		  CR, LF 폜iĵŒӁD

	߂lFϊ̕
*/
char*  pack_char(char* mesg, char cc)
{
	int i, j;
	int sf = OFF;	// A cc p̃tO
	int ff = ON; 	// 擪 cc 𖳎邽߂̃tO
	char* pp;

	if (mesg==NULL) return NULL;

	pp = (char*)malloc(strlen(mesg)+1);
	if (pp==NULL) return NULL;

	i = j = 0;
	while(mesg[i]!='\0') {
		if (mesg[i]==TAB) mesg[i] = ' ';
		if (mesg[i]!=CR && mesg[i]!=LF) {		// CR LF ǂݔ΂D
			if (mesg[i]==cc) {
				if (sf==OFF) {
					sf = ON;
					if (ff==ON) ff = OFF;
					else  pp[j++] = mesg[i];
				}
			}
			else {
				sf = ff = OFF;
				pp[j++] = mesg[i];
			}
		}
		i++;
	}
	pp[j] = '\0';

	//  cc 폜
	i = (int)strlen(pp) - 1;
	while(i>=0) {
		if (pp[i]==cc) i--; 
		else  break;
	}
	pp[i+1] = '\0';

	return pp;
}





/**
char*  change_esc(char* mesg)

	@\F񒆂 CR, LF  \r, \n ɕϊ
		  Ԃꂽf[^ free()KvD

*/
char*  change_esc(char* mesg)
{
	int i, j;
	char* pp;

	if (mesg==NULL) return NULL;

	pp = (char*)malloc((strlen(mesg)+1)*2);
	if (pp==NULL) return NULL;

	i = j = 0;
	while(mesg[i]!='\0') {
		if (mesg[i]==CR) {
			pp[j++] = '\\';
			pp[j++] = 'r';
		}
		else if (mesg[i]==LF) {
			pp[j++] = '\\';
			pp[j++] = 'n';
		}
		else {
			pp[j++] = mesg[i];
		}
		i++;
	}
	pp[j] = '\0';
	
	return pp;
}







/**
char*  cut_str(char* buf, int ls, int le)

	@\Fbuf[ls] ` buf[le] ؂oăɊi[ĕԂD
		  Ԃꂽf[^ free()KvD

*/
char*  cut_str(char* buf, int ls, int le)
{
	int   i, len;
	char* ret;

	if (buf==NULL) return NULL;

	ls  = Max(ls, 0);
	le  = Min(le, (int)strlen((const char*)buf)); 
	len = le - ls + 1;
	if (len<=0) return NULL;

	ret = (char*)malloc(len+1);
	if (ret==NULL) return NULL;
	memset(ret, 0, len+1);

	for (i=0; i<len; i++) ret[i] = buf[i+ls];

	return ret;
}



				

/**
char*  dup_str(char* buf)

	@\F buf̕oD
		  Ԃꂽf[^ free()KvD

*/
char*  dup_str(char* buf)
{
	int   len;
	char* ret;

	if (buf==NULL) return NULL;

	len = (int)strlen(buf);
	ret = (char*)malloc(len+1);
	if (ret==NULL) return NULL;
	memset(ret, 0, len+1);
	memcpy(ret, buf, len);

	return ret;
}




static char _ToSTR[LDATA];


/**
char*  ltostr(long int n)

	@\Flong int n 𕶎ɂĕԂDfree()Kv͂ȂD

*/
char*  ltostr(long int n)
{
	memset(_ToSTR, 0, LDATA);
	snprintf(_ToSTR, LDATA-1, "%ld", n);
	return _ToSTR;
}



/**
char*  ultostr(unsigned long int n)

	@\Funsigned long int n 𕶎ɂĕԂDfree()Kv͂ȂD

*/
char*  ultostr(unsigned long int n)
{
	memset(_ToSTR, 0, LDATA);
	snprintf(_ToSTR, LDATA-1, "%ld", n);
	return _ToSTR;
}



/**
char*  ftostr(float n)

	@\Ffloat n 𕶎ɂĕԂDfree()Kv͂ȂD

*/
char*  ftostr(float n)
{
	memset(_ToSTR, 0, LDATA);
	snprintf(_ToSTR, LDATA-1, "%f", n);
	return _ToSTR;
}




/**
int hexstr2i(const char* str)

	@\F16i̕𐮐ɕϊD
		  󔒂͖D
		  󔒈ȊO16iłȂoCŕϊ~߂

*/
int hexstr2i(const char* str)
{
	int i, ret = 0;
	if (str==NULL) return ret;

	int len = strlen(str);

	for (i=0; i<len; i++) {
		if (str[i]>=0 && str[i]<=9) {
			ret = ret*16;
			ret += (int)(str[i] - '0');
		}
		else if (str[i]>='A' && str[i]<='F') {
			ret = ret*16;
			ret += (int)(str[i] - 'A') + 10;
		}
		else if (str[i]>='a' && str[i]<='f') {
			ret = ret*16;
			ret += (int)(str[i] - 'a') + 10;
		}
		else if (str[i]!=' ') {
			break;
		}
	}

	return ret;
}







/* ************************************************************************* */

#ifndef WIN32
/**
void  init_rand(void)

	@\F/dev/urandom 痐̌n
@@@@@/dev/urandom ǂ߂Ȃꍇ́CĂяoꂽ̎(b)ɂ
		  ̌nD

 */
void  init_rand(void)
{
	FILE* fp;
	unsigned int seed;

	fp = fopen("/dev/urandom", "rb");
	if (fp==NULL) {
		srand(time(NULL));
		return;
	}
	fread(&seed, sizeof(unsigned int), 1, fp);
	fclose(fp);

	srand(seed);
}

#endif




/**
char*  randstr(int n)

	@\F_ A-Za-z0-9 ܂ł̕ nD
		  Ԃꂽf[^ free()KvD

	Fn -- o͂镶D

	߂lF_ɐꂽ n̕D
*/
char*  randstr(int n)
{
	char   base[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
	char*  pass;
	int	i, sz;

	if (n<=0) return NULL;
	pass = (char*)malloc(n+1);
	if (pass==NULL) return pass;

	sz = (int)strlen(base);
	for (i=0; i<n; i++) pass[i] = base[rand()%sz];
	pass[n] = '\0';

	return pass;
}





/**
unsigned char*  randbit(int n)

	@\F_ n bit̃oCi𐶐D
		  Ԃꂽf[^ free()KvD

	Fn -- o͂ bitD

	߂lF_ɐꂽ n bit̃f[^D
 */
unsigned char*  randbit(int n)
{
	int   i, sz;
	unsigned char* bin;

	sz = (n+7)/8;
	bin = (unsigned char*)malloc(sz);
	if (bin==NULL) return NULL;

	memset(bin, 0, sz);
	for (i=0; i<n; i++) setBit(bin, i, rand()%2);

	return bin;	
}






/* ************************************************************************* */

/**
void  swap_byte(void* p, int s, int c)
	@\FʃoCgƉʃoCgtɂD
		  pw s̃f[^ coCgÂtɂD

	Fp -- f[^ւ̃|C^D
		  s -- f[^̒DoCgPʁD
		  c -- tɂf[^̒DoCgPʁD
*/
void  swap_byte(void* p, int s, int c)
{
	int	i;
	uByte* u = (uByte*)p;
	for (i=0; i<s; i+=c) reverse_str(&u[i], c);
}



	
/**
short  swaps(short p)

	16bit p̏㉺8bitւD
    ntohs(), htons()̑֊֐ for Smopuim SW

*/
short  swaps(short p)
{
	short  r;
    uByte* t;
	uByte* f;
     
	t = (uByte*)&r;
	f = (uByte*)&p;
	t[0] = f[1];
	t[1] = f[0];

	return r;
}




/**
int swapl(int p)

	32bit p8bitÂtɂ
    ntohl(), htonl()̑֊֐ for Smopuim SW

*/
int swapl(int p)
{
	int    r;
    uByte* t;
	uByte* f;
     
	t = (uByte*)&r;
	f = (uByte*)&p;
	t[0] = f[3];
	t[1] = f[2];
	t[2] = f[1];
	t[3] = f[0];

	return r;
}




/**
void  reverse_str(uByte* p, int s)
	@\FoCgtɂD

	Fp -- oCgf[^ւ̃|C^D
		  s -- oCgf[^̒D
*/
void  reverse_str(uByte* p, int s)
{
	int	i;
	uByte  c;
	 
	if (s<=0) s = (int)strlen((const char*)p);

	for (i=0; i<s/2; i++) {
		c		= p[s-1-i];
		p[s-1-i] = p[i];
		p[i]	 = c;
	}
}   






/* ************************************************************************* */

/**
int  file_from_to(char* src, char* dst, char* mode)

	@\Fmodeɏ],t@C src dstɃRs[D

	Fsrc  -- Rs[(\[X)t@C
		  dst  -- Rs[(fBXeBl[V)t@C
		  mode -- Rs[t@C̃I[v[hDfopenɓD"rwa"

	߂lF -1  ƗpȂD
			 -2  \[Xt@C݂ȂD(V{bNN~)
			 -3  \[Xt@C̃I[vs
			 -4  fBXeBl[Vt@C̃I[vs
		 񕉐  Rs[t@C̑傫(oCgP)D
 */
int  file_from_to(char* src, char* dst, char* mode)
{
	long int  sz;
	unsigned char* buf;
	FILE*  fp;

	sz = file_size(src);
	if (sz<0) return -2;
	buf = (unsigned char*)malloc(sz);
	if (buf==NULL) return -1;

	fp = fopen(src, "rb");
		if (fp==NULL) {
		free(buf);
		return -3;
	}
	fread(buf, sz, 1, fp);
	fclose(fp);

	fp = fopen(dst, mode);
	if (fp==NULL) {
		free(buf);
		return -4;
	}
	fwrite(buf, sz, 1, fp);
	fclose(fp);

	free(buf);
	return sz;
}





/**
char* get_file_name(char* str)

	tpXt@Cւ̃|C^oD

*/
char* get_file_name(char* str)
{
	int   sz, len;
	char* fnm;

	if (str==NULL) return NULL;

#ifdef WIN32
	char  cc = '\\';
#else
	char  cc = '/';
#endif

	len = (int)strlen(str);
	sz  = 0;
	while (sz<len && str[len-1-sz]!=cc) sz++;
	fnm = str + len - sz; 

	return fnm;
}

	



/**
unsigned long int   file_size(char* fn)											  

	@\Fʏ̃t@C̑傫ԂDV{bNNȂǂ 0D

	Ft@C

	߂lFt@C̃TCY
 */
unsigned long int   file_size(char* fn)											  
{									  
	struct stat stbuf;											   
																   
	stat(fn, &stbuf);

#ifdef WIN32
	return stbuf.st_size;
#else
	if (S_ISREG(stbuf.st_mode)) return stbuf.st_size;
	else						return 0;
#endif
}





/**
int  file_exist(char* fn)

	@\Fw肵t@C݂ēǂݍ݉\ł΁u^vłȂ΁uUvԂD
		  t@CxI[vĊmF̂ŁCԂ|D
	@@@ǂݍ݉\ȃt@CmF̂ł΁Cfile_size()̕iԂjD

	Ft@C

	߂lFTRUE  t@C݂,ǂ݂݉\D
			FALSE t@C݂Ȃ,܂͓ǂ݂ݕs\D 
 */
int  file_exist(char* fn)
{
	FILE* fp;

	if (fn==NULL) return FALSE;

	if ((fp=fopen(fn,"rb"))==NULL) {
		return FALSE;
	}
	fclose(fp);
	return TRUE;
}





/**
FILE*  file_chmod_open(char* fn, char* fm, mode_t mode)

	@\Fw肵t@C݂ēǂݍ݉\ł΁Cmode ֕ύXC
		  t@C fm[hŃI[vȂāCt@C|C^ԂD
		  ݂Ȃ΁Ct@C쐬đύXČCt@C fm[h
		  ŃI[vȂāCt@C|C^ԂD
		  ̎w@ɂĂ man 2 chmod QƂ邱ƁD

	Ffn	-- t@C
		  fm	-- t@C[hC"r","w","a".....
		  mode  -- Dsee...  man 2 chmod

	߂lFTRUE  D
			FALSE sD 
 */
FILE*  file_chmod_open(char* fn, char* fm, mode_t mode)
{
	FILE* fp;

	if (!file_exist(fn)) {
		if ((fp=fopen(fn,"wb"))==NULL) return NULL;
		fclose(fp);
	}

#ifndef WIN32
	fp = NULL;
	if (chmod(fn, mode)) return fp;
#endif

	fp = fopen(fn, fm);
	return fp;
}




/**
char*  temp_filename(char* dir, int flen)

	@\F/dev/urandom 𗘗pčƗpt@C̃_ȃt@C𓾂D
		  /dev/urandom ǂ߂Ȃꍇ randstr() 𗘗pD
		  Ԃꂽf[^ free()KvD

	Fdir  -- ƃt@CfBNg
		  flen -- t@C̒

	߂lF Ɨpt@C̃tpX
 */
char*  temp_filename(const char* dir, int flen)
{
	FILE* fp;
	int   i, dlen=0;
	char  nostr = '\0';
	char* fname;
	char* fnbin;
	char* fnb64;

	if (dir==NULL) dir = &nostr;
	dlen = (int)strlen(dir);
	if (flen<=0)   flen = 15;

	fname = (char*)malloc(dlen+flen+1);
	if (fname==NULL) return NULL;
	fnbin = (char*)malloc(flen);
	if (fnbin==NULL) {
		free(fname);
		return NULL;
	}

	fnb64 = NULL;
	fp = fopen("/dev/urandom", "rb");

	do {
		if (fp!=NULL) {
			fread(fnbin, flen, 1, fp);
			fnb64 = (char*)encode_base64((unsigned char*)fnbin, flen);
			if (fnb64!=NULL) fnb64[flen] = '\0';
		}
		if (fnb64==NULL) fnb64 = randstr(flen);

		for (i=0; i<flen; i++) {
			if (fnb64[i]=='/') fnb64[i] = 'x';
			if (fnb64[i]=='+') fnb64[i] = 'X';
		}

		memset (fname, 0, dlen+flen+1);
		strncpy(fname, dir, dlen);
		strncat(fname, fnb64, flen);
		free(fnb64);
	} while(file_exist(fname)); 

	if (fp!=NULL) fclose(fp);
	free(fnbin);
	return fname;
}




unsigned char*  read_file(char* fname, unsigned long int* size)
{
	if (size==NULL) return NULL;

	*size = file_size(fname);
	if (*size<=0) return NULL;

	unsigned char* buf = (unsigned char*)malloc(*size);
	if (buf==NULL) return NULL;

	FILE* fp  = fopen(fname, "rb");
	if (fp==NULL) {
		free(buf);
		return NULL;
	}

	fread(buf, *size, 1, fp);
	fclose(fp);

	return buf;
}




long int  write_file(char* fname, unsigned char* buf, unsigned long int size)
{
	if (size==0) return 0;

	FILE* fp  = fopen(fname, "wb");
	if (fp==NULL) return 0;

	fwrite(buf, size, 1, fp);
	fclose(fp);

	return size;
}




/**
char* double_bs(char* str) 

    @\F񒆂 \  \\ ɕςԂ
		  Ԃꂽf[^ free()KvD

    F

    ߂lFϊꂽDsꍇ NULL
 */
char* double_bs(char* str) 
{
	int  i, j;
	int  len, bsn=0;
	char* buf;

	len = (int)strlen(str);
	for (i=0; i<len; i++) if (str[i]=='\\') bsn++;
	buf = (char*)malloc(len+bsn+1);
	if (buf==NULL) return NULL;

	for (i=0,j=0; i<len; i++) {
		buf[j++] = str[i];
		if (str[i]=='\\') buf[j++] = '\\';
	}
	buf[j] = '\0';

	return buf;
}







/**
char*  numbering_name(char* fmt, int n)

	@\FtH[}bg fmtɏ]āCn܂ޕoDv free
		  Ԃꂽf[^ free()KvD
*/
char*  numbering_name(char* fmt, int n)
{
    int    len;
    char   fname[LNAME], *fo;

	memset(fname, 0, LNAME);
	snprintf(fname, LNAME-1, fmt, n);
	len = (int)strlen(fname);

	fo = (char*)malloc(len + 1);
	if (fo==NULL) return NULL;

	memset(fo, 0, len+1);
    strncpy(fo, fname, len);
    return fo;
}






/* ************************************************************************* */

/**
void kanji_convert(unsigned char* mesg)

	@\Fϐ KnjiCodeɏ]ĊR[hϊD

	Fϊ镶 unsigned char*^f[^DeD

	F݂ KanjiCode SJIS̏ꍇ̂ EUC SJISɕϊD
 */
void kanji_convert(unsigned char* mesg)
{
	if (KanjiCode==SJIS) {
		kanji_convert_euc2sjis(mesg);
	}
}




/**
void kanji_convert_euc2sjis(unsigned char* mesg)

	@\FEUCSJISɕϊD

	Fϊ镶 unsigned char*^f[^DeD
*/
void kanji_convert_euc2sjis(unsigned char* mesg)
{
	int i = 0;
	while(mesg[i]!='\0' && mesg[i+1]!='\0'){
		if (mesg[i]>=0xa1 && mesg[i]<=0xfe){ // EUC
			euc2sjis(&mesg[i], &mesg[i+1]);
			i = i + 2;
		} 
		else  i++;
	}
}




/**
void kanji_convert_sjis2euc(unsigned char* mesg)

	@\FSJISEUCɕϊD

	Fϊ镶 unsigned char*^f[^DeD
*/
void kanji_convert_sjis2euc(unsigned char* mesg)
{
	int i = 0;
	while(mesg[i]!='\0' && mesg[i+1]!='\0'){
		// ifϑIȂ̂́CRpCŌxo邽   (GCC) 3.3.2 20031218 
		if ((mesg[i]>=0x81 && mesg[i]<=0x9f) ||
			(mesg[i]>=0xe0 && mesg[i]<=0xfe) || mesg[i]==0xff) { // SJIS
			sjis2euc(&mesg[i], &mesg[i+1]);
			i = i + 2;
		} 
		else  i++;
	}
}



/**
void  euc2sjis(unsigned char *c1, unsigned char *c2)

	@\FR[hϊDEUCSJIS
  
	Fc1 -- ϊ镶̑oCgDeD
		  c2 -- ϊ镶̑oCgDeD
*/
void  euc2sjis(unsigned char *c1, unsigned char *c2)
{
	if (*c1%2==0) *c2 -= 0x02;
	else{
		*c2 -= 0x61;
		if (*c2>0x7e) (*c2)++;
	}

	if (*c1<0xdf) {
		(*c1)++;
		*c1 /= 2;
		*c1 += 0x30;
	}
	else {
		(*c1)++;
		*c1 /= 2;
		*c1 += 0x70;
	}
}





/**
void  sjis2euc(unsigned char *c1, unsigned char *c2)

	@\FR[hϊDSJISEUC
  
	Fc1 -- ϊ镶̑oCgDeD
		  c2 -- ϊ镶̑oCgDeD
*/
void  sjis2euc(unsigned char *c1, unsigned char *c2)
{
	if (*c2<0x9f) {
		if (*c1 < 0xa0) {
			*c1 -= 0x81;
			*c1 *= 2;
			*c1 += 0xa1;
		}
			
		else {
			*c1 -= 0xe0;
			*c1 *= 2;
			*c1 += 0xdf;
		}
		if (*c2>0x7f) (*c2)--;
		*c2 += 0x61;
	}
	else {
		if (*c1<0xa0) {
			*c1 -= 0x81;
			*c1 *= 2;
			*c1 += 0xa2;
		}
		else {
			*c1 -= 0xe0;
			*c1 *= 2;
			*c1 += 0xe0;
		}
		*c2 += 2;
	 }
}






/**
void  upper_string(char* str)

	@\Fstȑ啶ɕϊ
  
	Fstr -- ϊ镶ւ̃|C^DeD

*/
void  upper_string(char* str)
{
	int  i;
	for (i=0; i<(int)strlen((const char*)str); i++) {
		if (str[i]>='a' && str[i]<='z') str[i] += 'A' - 'a';
	}
}







/**
unsigned char*  decode_base64(unsigned char* buf, int* sz)

	@\Fbuf  base64fR[hD
		  ϊ buf̐擪珇sDA-Za-z0-9+/ ȊO͖(ႦΉsR[h)D

		  ̓obt@ 4byte(6bit*4)̏ꍇ, o̓obt@ 3byte
		  (8bit*3)ƂȂD̓obt@̃oCg 4̔{łȂꍇ
		  (sȃf[^), Ȃ̓obt@ɂ '='}Ă
		  ̂Ƃ݂ȂD

		  Ԃꂽf[^ free()KvD

	Fbuf -- base64fR[h镶D
		  sz  -- fR[hꂽf[^̒i[ int ւ̃|C^

	߂lFreturn -- base64fR[hꂽf[^
			*sz -- fR[hꂽf[^̃TCY

	F"QQ" fR[h 'A',0x00 ƂȂD
*/
unsigned char*  decode_base64(unsigned char* buf, int* sz)
{
	int   i, j, cc=0, bas, lt;
	unsigned char* dcd;

	lt = 0;
	while (buf[lt]!='=' && lt<(int)strlen((const char*)buf)) {
		lt++;
		if (lt==(int)strlen((const char*)buf)) break;
	}
	*sz = lt/4*3 + (lt%4)*3/4;
	dcd = (unsigned char*)malloc(*sz);
	if (dcd==NULL) return dcd;
	memset(dcd, 0, *sz);

	for (i=0; i<lt; i++) {
		if	    (buf[i]>='A' && buf[i]<='Z') cc = buf[i] - 'A';
		else if (buf[i]>='a' && buf[i]<='z') cc = buf[i] - 'a' + 26;
		else if (buf[i]>='0' && buf[i]<='9') cc = buf[i] - '0' + 52;
		else if (buf[i]=='+')				 cc = 62;
		else if (buf[i]=='/')				 cc = 63;

		if (cc<64) {
			bas = 32;
			for (j=0; j<6; j++) {
				setBit(dcd, i*6+j, cc/bas);
				cc = cc%bas;
				bas = bas/2;
			}
		}
	}

	return dcd;
}






/**
unsigned char*  encode_base64(unsigned char* buf, int sz)

	@\FoCif[^ buf base64ɃGR[hD

		  ̓obt@ 3byte(8bit*3)̏ꍇ, o̓obt@ 4byte
		  (6bit*4)ƂȂD̓obt@ 6bitEłȂꍇ, 6bitE
		  ܂ 0tꂽƌD
		  o̓obt@ 4byteEłȂꍇ, 4byteE܂ '='t
		  ďo͂D ܂,o̓obt@ł 60bytẻs͍sȂD
		  ʂ n byte ͂ꂽꍇ, base64̏o͂̕ (n+2)/3*4
		  byte ƂȂD

		  Ԃꂽf[^ free()KvD

	Fbuf -- base64ɃGR[hf[^D
		  sz  -- f[^̒D-1ȉ̏ꍇ buf ͕Ƃ݂ȂD

	߂lFreturn -- base64ɃGR[hꂽ

	F'A',0x00,0x01 𕶎(sz=1)Ƃ݂Ȃĕ "QQ==" ƂȂD
		'A',0x00,0x01  3byte𕄍(sz=3) "QQAB" ƂȂD
*/
unsigned char*  encode_base64(unsigned char* buf, int sz)
{
	unsigned char  base[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
	unsigned char  bas;
	int   i, j, len;
	unsigned char*  ecd;
	
	if (buf==NULL) return NULL;
   	if (sz<0) len = (int)strlen((const char*)buf);
	else  	  len = sz;
	if (len==0) return NULL;

	sz  = (len + 2)/3*4;
	ecd = (unsigned char*)malloc(sz+1);
	if (ecd==NULL) return NULL;
	memset(ecd, 0, sz+1);

	for (i=0; i<sz; i++) {
		bas = 0x00;
		if (len*8 > i*6) {
			for (j=0; j<6; j++) {
				if (len*8 > i*6+j) setBit(&bas, j+2, getBit(buf, i*6+j));
				//else			   setBit(&bas, j+2, 0);
			}
			ecd[i] = base[(int)bas];
		}
		else {
			ecd[i] = '=';
		}
	}

	return ecd;
}





/**
unsigned char*  decode_urlenc(unsigned char* buf, int* sz)

	@\Fbuf  URLGR[hfR[hD
		  Ԃꂽf[^ free()KvD

	Fbuf -- fR[h镶D
		  *sz -- fR[hꂽf[^̒i[ϐD

	߂lFreturn -- fR[hꂽf[^
			*sz	-- fR[hꂽf[^̒
*/
unsigned char*  decode_urlenc(unsigned char* buf, int* sz)
{
	int	i, j, len;
	unsigned char*  dec;

	if (buf==NULL) return NULL;
	len = (int)strlen((const char*)buf) + 1;
	dec = (unsigned char*)malloc(len);
	if (dec==NULL) return NULL;
	memset(dec, 0, len);

	i = j = 0;
	while (buf[i]!='\0') {
		if (buf[i]=='%') {
			if (buf[i+1]=='\0') return dec;
			if (buf[i+2]=='\0') return dec;
			dec[j++] = decode_hex(buf[i+1], buf[i+2]);
			i += 2;
		}
		else {
			if (buf[i]=='+') dec[j++] = ' ';
			else			 dec[j++] = buf[i];
		}
		i++;
	}

	*sz = j;
	return dec;
}
				





/**
unsigned char*  encode_urlenc(unsigned char* buf)

	@\FoCif[^ buf URLGR[hD
		  GR[hȂɂĂ͐FXl邪Cő񐔓Iɍl
@@@@@̃vOł͈ȉ̂悤ɂD
		  	GR[hȂ  0-9, A-Z, a-z, -._

		  Ԃꂽf[^ free()KvD

	Fbuf -- GR[hf[^D
		  sz  -- GR[hf[^̒D-1ȉ̏ꍇ buf ͕Ƃ݂ȂD

	߂lFreturn -- GR[hꂽ
*/
unsigned char*  encode_urlenc(unsigned char* buf, int sz)
{
	int	i, j, len;
	unsigned char*  enc;


	if (sz<0) sz = (int)strlen((const char*)buf);
	len = sz*3 + 1;
	enc = (unsigned char*)malloc(len);
	if (enc==NULL) return NULL;
	memset(enc, 0, len);

	for(i=0, j=0; i<sz; i++) {
		if (buf[i]==' ') {										// pXy[X
			enc[j++] = '+';
		}
		else if ((buf[i]>=0x30 && buf[i]<=0x39) ||				// 0-9
				 (buf[i]>=0x41 && buf[i]<=0x5a) ||				// A-Z
				 (buf[i]>=0x61 && buf[i]<=0x7a) ||				// a-z
				  buf[i]=='-' || buf[i]=='.' || buf[i]=='_'){	// - . _
			enc[j++] = buf[i];
		}
		else {
			unsigned char* asc = encode_hex(buf[i]);
			if (asc==NULL) {
				free(enc);
				return NULL;
			}
			enc[j++] = '%';
			enc[j++] = asc[0];
			enc[j++] = asc[1];
			free(asc);
		}
	}

	return enc;
}	






/**
unsigned char*  decode_quoted_printable(unsigned char* buf, int* sz)

	@\Fbuf  quoted printablefR[hD
		  Ԃꂽf[^ free()KvD

	Fbuf -- fR[h镶D
		  *sz -- fR[hꂽf[^̒i[ϐD

	߂lFreturn -- fR[hꂽf[^
			*sz	-- fR[hꂽf[^̒
*/
unsigned char*  decode_quoted_printable(unsigned char* buf, int* sz)
{
	int	i, j, len;
	unsigned char*  dec;

	len = (int)strlen((const char*)buf) + 1;
	dec = (unsigned char*)malloc(len);
	if (dec==NULL) return NULL;
	memset(dec, 0, len);

	i = j = 0;
	while (buf[i]!='\0') {
		if (buf[i]=='=') {
			if (buf[i+1]=='\0') return dec;
			if (buf[i+2]=='\0') return dec;
			dec[j++] = decode_hex(buf[i+1], buf[i+2]);
			i += 2;
		}
		else {
			if (buf[i]=='_') dec[j++] = ' ';			// RFC2047
			else			 dec[j++] = buf[i];
		}
		i++;
	}

	*sz = j;
	return dec;
}
				





/**
unsigned char*  encode_quoted_printable(unsigned char* buf, int sz)

	@\FoCif[^ buf quoted printable ɃGR[hD
		  RFC2047 ɏ]C' '  '_' ɃGR[hD
		  	GR[hȂ '=', '_' ȊO 0x21-0x7e
		  	GR[h镶   '=', '_', 0x00-0x20, 0x7f-0xff

		  Ԃꂽf[^ free()KvD

	Fbuf -- GR[hf[^D
		  sz  -- GR[hf[^̒D-1ȉ̏ꍇ buf ͕Ƃ݂ȂD

	߂lFreturn -- GR[hꂽ
*/
unsigned char*  encode_quoted_printable(unsigned char* buf, int sz)
{
	int	i, j, len;
	unsigned char*  enc;

	if (sz<0) sz = (int)strlen((const char*)buf);
	len = sz*3 + 1;
	enc = (unsigned char*)malloc(len);
	if (enc==NULL) return NULL;
	memset(enc, 0, len);

	for (i=0, j=0; i<sz; i++) {
		if (buf[i]=='=') {		// 0x3d
			enc[j++] = '=';
			enc[j++] = '3';
			enc[j++] = 'D';
		}
		else if (buf[i]=='_') {		// 0x5f
			enc[j++] = '=';
			enc[j++] = '5';
			enc[j++] = 'F';
		}
		else if (buf[i]==' ') {		// 0x20  RFC2047
			enc[j++] = '_';
		}
		else if (buf[i]<=0x1f || buf[i]>=0x7f) {
			unsigned char* asc = encode_hex(buf[i]);
			if (asc==NULL) {
				free(enc);
				return NULL;
			}
			enc[j++] = '=';
			enc[j++] = asc[0];
			enc[j++] = asc[1];
			free(asc);
		}
		else {
			enc[j++] = buf[i];
		}
	}

	return enc;
}	






/**
unsigned char*  encode_hex(unsigned char cc)

	@\FLN^PUiR[h̕ɕϊD
		  Ԃꂽf[^ free()KvD

	FϊLN^D

	߂lFVmۂꂽ 3bytë̗
			[0] -- PUiR[h̏ʂSBitD 0-9,A-F
		  	[1] -- PUiR[h̉ʂSBitD 0-9,A-F
			[2] -- '\0'
			NULL ̏ꍇ̓sD

	Fencode_hex(' ')   "20" ԂD

*/
unsigned char*  encode_hex(unsigned char cc)
{
	unsigned char* ret;
	unsigned char  pp1, pp2;
	unsigned char  base[] = "0123456789ABCDEF";

	ret = (unsigned char*)malloc(3);
	if (ret==NULL) return NULL;

	pp1 = cc >> 4;
	pp2 = cc & 0x0f;

	ret[0] = base[pp1];
	ret[1] = base[pp2];
	ret[2] = '\0';

	return ret;
}




/**
unsigned char  decode_hex(unsigned char pp1, unsigned char pp2)

	@\FPUiR[hLN^ɕϊDO-9,A-FȊOw肳ꂽꍇ0Ƃ݂ȂD

	Fpp1  -- PUiR[h̏ʂSBitD 0-9,A-F
		  pp2  -- PUiR[h̉ʂSBitD 0-9,A-F

	߂lFw肳ꂽASCIIR[h̃LN^

	Fdecode_hex('2', '0')   ' ' ԂD

*/
unsigned char  decode_hex(unsigned char pp1, unsigned char pp2)
{
	unsigned char ret;

	if (pp1>=0x30 && pp1<=0x39) 	 pp1 -= 0x30;	// 0-9
	else if (pp1>=0x41 && pp1<=0x46) pp1 -= 0x37;	// A-F
	else if (pp1>=0x61 && pp1<=0x66) pp1 -= 0x57;	// a-f
	else 							 pp1 =  0x00;

	if (pp2>=0x30 && pp2<=0x39) 	 pp2 -= 0x30;	// 0-9
	else if (pp2>=0x41 && pp2<=0x46) pp2 -= 0x37;	// A-F
	else if (pp2>=0x41 && pp2<=0x46) pp2 -= 0x57;	// a-f
	else 							 pp1 =  0x00;

	ret = (pp1<<4) + pp2;
	return ret;
}





//////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

/**
void  print_message(char* fmt, ...)

	@\Fobt@ÕbZ[Wóistderrj

	Ffmt -- o̓tH[}bgD̑ printf() ɏD
*/
void  print_message(char* fmt, ...)
{
	char*  nfmt;
	int    len;

	va_list  args;
	va_start(args, fmt);

	len  = (int)strlen(fmt);	
	nfmt = (char*)malloc(len + 1);
	if (nfmt==NULL) return;

	strncpy(nfmt, fmt, len);
	nfmt[len] = '\0';

	vfprintf(stderr, nfmt, args); 
	fflush(stderr);
	free(nfmt);

	va_end(args);

	return;
}





/**
void  fprint_message(FILE *fp, char* fmt, ...)

	@\Fobt@ÕbZ[Wóistderrj

	Ffmt -- o̓tH[}bgD̑ printf() ɏD
*/
void  fprint_message(FILE* fp, char* fmt, ...)
{
	char*  nfmt;
	int    len;

	va_list  args;
	va_start(args, fmt);

	len  = (int)strlen(fmt);	
	nfmt = (char*)malloc(len + 1);
	if (nfmt==NULL) return;

	strncpy(nfmt, fmt, len);
	nfmt[len] = '\0';

	vfprintf(fp, nfmt, args); 
	fflush(fp);
	free(nfmt);

	va_end(args);

	return;
}




/**
void  print_escape(char* fmt, char* mesg)

	@\FGXP[v܂ރbZ[W̏óD
	@	@݂ CR, LF ̂ \r, \n ɕϊDsee change_esc()

*/
void  print_escape(char* fmt, char* mesg)
{
	char* pp;

	if (fmt==NULL || mesg==NULL) return;
	
	pp = change_esc(mesg);
	if (pp==NULL) return;

	print_message(fmt, pp);
	free(pp);
}




/**
void  fprint_escape(FILE* fp, char* fmt, char* mesg)

	@\FGXP[v܂ރbZ[W̏óD
	@	@݂ CR, LF ̂ \r, \n ɕϊDsee change_esc()

*/
void  fprint_escape(FILE* fp, char* fmt, char* mesg)
{
	char* pp;

	if (fmt==NULL || mesg==NULL) return;
	
	pp = change_esc(mesg);
	if (pp==NULL) return;

	fprint_message(fp, fmt, pp);
	free(pp);
}




/**
void  fdump(FILE* fp, unsigned char* mesg, int n)

	@\FfobOp 16io
		  mesg noCg16i\Dn<0 ̏ꍇ Ƃ݂ȂD

	Ffp   -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  mesg -- \f[^D
		  n    -- \oCg

*/
void  fdump(FILE* fp, unsigned char* mesg, int n)
{
	int  i, j, mod, len;
	char ascii[16];

	if (fp==NULL) fp = stderr;

	if (mesg==NULL) {
		fprintf(fp, "(Dump Data is NULL)\n");
		return;
	}

    if (n<0) len = (int)strlen((const char*)mesg);
    else     len = n;

    memset(ascii, 0x2e, 16);
    for (i=0, j=0; i<len; i++) {
        fprintf(fp, "%02x ", mesg[i]);
        if (mesg[i]>=0x20 && mesg[i]<=0x7e) ascii[j] = mesg[i];
		j++;
        if (j==16) {
            fprintf(fp, "   ");
            for (j=0; j<16; j++) {
                fprintf(fp, "%c ", ascii[j]);
            }
            fprintf(fp, "\n");
            memset(ascii, 0x2e, 16);
            j = 0;
        }
    }
                
    mod = len%16;
    if (mod>0) {                           
        for (i=0; i<17-mod; i++) fprintf(fp, "   ");
        for (i=0; i<mod; i++)    fprintf(fp, "%c ", ascii[i]);
    }                    
    fprintf(fp, "\n");
}





/**
void  print_16x(FILE* fp, unsigned char* mesg, int n)

	@\FfobOp 16ióD
		  mesg noCg16isC󔒂Ȃŕ\Dn<0 ̏ꍇ Ƃ݂ȂD

	Ffp   -- o͂t@Cւ̃|C^DNULL̏ꍇ stderr
		  mesg -- \f[^D
		  n    -- \oCg

*/
void  print_16x(FILE* fp, unsigned char* mesg, int n)
{
	int  i, len;

	if (fp==NULL) fp = stderr;

    if (n<0) len = (int)strlen((const char*)mesg);
    else     len = n;

    for (i=0; i<len; i++) {
        fprintf(fp, "%02x", mesg[i]);
    }
    fprintf(fp, "\n");
}






/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Ringobt@
//

/**
ringbuffer*  new_ringbuffer()

	@\F̃Oobt@^ϐoD̑ł́C܂obt@͍쐬ȂD
		  Ԃꂽf[^ free()KvD

*/
ringbuffer*  new_ringbuffer()
{
	ringbuffer* rb;
	
	rb = (ringbuffer*)malloc(sizeof(ringbuffer));
	if (rb==NULL) return NULL;
	memset(rb, 0, sizeof(ringbuffer));

	return rb;
}





/**
void   del_ringbuffer(ringbuffer** rb)

	@\Fnew_ringbuffer()ōoOobt@폜D

*/
void   del_ringbuffer(ringbuffer** rb)
{
	if (rb!=NULL && *rb!=NULL) {
		freeNull((*rb)->buf);
		free(*rb);
		*rb = NULL;
	}
}





/**
ringbuffer   init_ringbuffer()

	@\Fꂽ ringbufferϐԂD

*/
ringbuffer   init_ringbuffer()
{
	ringbuffer  rb;

	memset(&rb, 0, sizeof(ringbuffer));
	//rb.bufsz = -1;

	return rb;
}





/**
ringbuffer   make_ringbuffer(int sz)

	@\Fobt@݂郊Oobt@oD
		  obt@ free()KvD

*/
ringbuffer   make_ringbuffer(int sz)
{
	ringbuffer  rb;

	memset(&rb, 0, sizeof(ringbuffer));
	
	if (sz>0) {
		rb.buf = (unsigned char*)malloc(sz);
		if (rb.buf==NULL) return rb;
		rb.bufsz = sz;
	}

	return rb;
}





/**
void   free_ringbuffer(ringbuffer* rb)

	@\FOobt@̃obt@JD

*/
void   free_ringbuffer(ringbuffer* rb)
{
	if (rb!=NULL) {
		freeNull(rb->buf);
		memset(rb, 0, sizeof(ringbuffer));
	}
}






/**
void   clear_ringbuffer(ringbuffer* rb)

	@\FOobt@ rb ̃f[^NAijD

*/
void   clear_ringbuffer(ringbuffer* rb)
{
	if (rb!=NULL) {
		int sz;
		sz = rb->bufsz;
		memset(rb->buf, 0, rb->bufsz);
		memset(rb, 0, sizeof(ringbuffer));
		rb->bufsz = sz;
	}
}




/**
int   put_ringbuffer(ringbuffer* rb, unsigned char* pp, int sz)

	@\FOobt@ rb փf[^ szoCgi[D

	Fsb   bZ[WXg[ւ̃|C^
		  pp   i[f[^ւ̃|C^D
		@sz   i[f[^̃TCYiBytej

	߂lF0ȏF񂾃oCgD
			-1: NULL̃f[^D
			-2: obt@if[^i[j̗̈悪ȂD
			-3: obt@if[^i[j̑傫ȂDf[^putȂD
			rb->state: 0 obt@͐ԁD-1 obt@ُ͈ȏԂɂD
*/
int   put_ringbuffer(ringbuffer* rb, unsigned char* pp, int sz)
{
	if (rb==NULL) return -1;
	rb->state = 0;

	if (pp==NULL)      return -1;
	if (rb->buf==NULL) return -2;
	if (rb->datasz+sz>rb->bufsz) {
		rb->state = -1;
		return -3;
	}

	if (rb->epoint+sz<=rb->bufsz) {
		memcpy(&((rb->buf)[rb->epoint]), pp, sz);
		rb->epoint = rb->epoint + sz;
		if (rb->epoint==rb->bufsz) rb->epoint = 0;
	}
	else {
		memcpy(&(rb->buf[rb->epoint]), pp, rb->bufsz-rb->epoint);
		memcpy(rb->buf, &(pp[rb->bufsz-rb->epoint]), sz-(rb->bufsz-rb->epoint));
		rb->epoint = rb->epoint + sz - rb->bufsz; 
	}

	rb->datasz += sz;
	return sz;
}	






/**
unsigned char*   get_ringbuffer(ringbuffer* rb, int sz)

	@\FOobt@ rb  szoCg̃f[^oD
		  Ԃꂽf[^ free()KvD

	FOobt@ւ̃|C^

	߂lFof[^ւ̃|C^DgI free()KvD
			NULL  f[^擾sDݗLȃf[^TCYsz菬D܂͒PɎsD
			rb->state: 0 obt@͐ԁD-1 obt@ُ͈ȏԂɂD
*/
unsigned char*   get_ringbuffer(ringbuffer* rb, int sz)
{
	unsigned char* pp;

	if (rb==NULL) return NULL;
	rb->state = 0;
	if (rb->buf==NULL) return NULL;
	if (sz>rb->datasz) return NULL;

	pp = (unsigned char*)malloc(sz+1);
	if (pp==NULL) {
		rb->state = -1;
		return NULL;
	}
	memset(pp, 0, sz+1);

	if (rb->spoint+sz<=rb->bufsz) {
		memcpy(pp, &(rb->buf[rb->spoint]), sz);
		rb->spoint = rb->spoint + sz;
		if (rb->spoint==rb->bufsz) rb->spoint = 0;
	}
	else {
		memcpy(pp, &(rb->buf[rb->spoint]), rb->bufsz-rb->spoint);
		memcpy(&(pp[rb->bufsz-rb->spoint]), rb->buf, sz-(rb->bufsz-rb->spoint));
		rb->spoint = rb->spoint + sz - rb->bufsz; 
	}

	rb->datasz -= sz;
	return pp;
}	








///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// bZ[WXg[obt@
//

/**
int   put_mstream(mstream* sb, unsigned char* mesg)

	@\FbZ[WijXg[ sb փbZ[Wïꕔji[D
		@ŁCbZ[WƂ \r\n, \r ܂ \n ŋ؂Ă镶ł̂ƂłD

	Fsb   bZ[WXg[ւ̃|C^
		  mesg i[郁bZ[WC܂͂̈ꕔ

	߂lF0ȏF񂾃oCgiCRLF܂ށj
			-1: NULL̃f[^D
			-2: obt@if[^i[j̗̈悪ȂD
			-3: obt@if[^i[j̑傫ȂD
			sb->state: 0 Xg[͐ԁD-1 Xg[ُ͈ȏԂɂD
*/
int   put_mstream(mstream* sb, unsigned char* mesg)
{
	int  i, n, m, cc, np=0, len;

	if (sb==NULL)   return -1;
	sb->state = 0;
	if (mesg==NULL) return -1;
	if (sb->buf==NULL) return -2;

	len = (int)strlen((const char*)mesg);
	for (i=0, n=0, m=0; i<len; i++) {
		if (mesg[i]==LF || (mesg[i]==CR && mesg[i+1]!=LF)) {
			if (m==0) m = i;
			n++;
		}
	}
	if (sb->datano==0 && n>=1) np = (sb->epoint + m + 1) % sb->bufsz;

	cc = put_ringbuffer(sb, mesg, len);
	if (cc>=0) {
		if (sb->datano==0 && n>=1) sb->npoint = np;
		sb->datano += n;
	}

	if (cc<0) sb->state = -1;
	return cc;
}





/**
unsigned char*  get_mstream(mstream* sb)

	@\FbZ[WijXg[ sb 玟̃bZ[WoD
		  sR[h͍폜D
		@ŁCbZ[WƂ \r\n, \r ܂ \n ŋ؂Ă镶ł̂ƂłD

	FbZ[WXg[ւ̃|C^

	߂lFoXg[f[^ւ̃|C^DgI free()KvD
			NULL  f[^擾sDݗLȃbZ[Wf[^͖D܂͒PɎsD
			sb->state: 0 Xg[͐ԁD-1 Xg[ُ͈ȏԂɂD
*/
unsigned char*  get_mstream(mstream* sb)
{
	int  n, len;
	unsigned char* pp;

	if (sb==NULL) return NULL;
	sb->state = 0;
	if (sb->buf==NULL) return NULL;
	if (sb->datano==0) return NULL;

	len = sb->npoint - sb->spoint;
	if (len==0) return NULL;
	else if (len<0) len += sb->bufsz;

	pp = get_ringbuffer(sb, len);
	if (pp==NULL) {
		sb->state = -1;
		return NULL;
	}
	chomp((char*)pp);

	sb->datano += -1;
	sb->spoint = sb->npoint;

	if (sb->datano>=1) {
		int m;
		n = sb->spoint;
		while (n!=sb->epoint) {
			m = (n + 1) % sb->bufsz;
			if (sb->buf[n]==LF || (sb->buf[n]==CR && sb->buf[m]!=LF)) {
				sb->npoint = m;
				break;
			}
			n = m;
		}
	}

	return pp;
}





/**
unsigned char*  fgets_mstream(unsigned char* mesg, mstream* sb)
 
	@\FbZ[W mesg ̓bZ[WXg[ɈUobt@OC̊֐ɂ
		  sǂݏoDʂԂ鎞Cs̉sR[h͍폜Csɂ͕K \0 D
		  bZ[WXg[̃obt@mۂĂȂꍇ́CŏɌĂяoꂽ_
		@mۂDŮ֐gpāCMf[^obt@OCŌ܂œǂݎɂ
		  KXg[gpĂ̊֐Ăяo΂΂ȂȂDŖꍇ͎Mf[^
		  ͕̐ۏ؂ȂD

	F	mesg	obt@ɈUi[郁bZ[WDNULLłD
			sb	    Xg[obt@iOobt@^̃Xg[obt@j
					obt@mۂĂȂ΁CIɊmۂD

	߂lF return : oւ̃|C^
			 sb->state : <0 bZ[WXg[쒆ُ͈ȏԂɂD
				 		  1 bZ[WXg[ɗLȃf[^ȂDreturn  NULL
*/
unsigned char*  fgets_mstream(unsigned char* mesg, mstream* sb)
{
	int state=0;
	unsigned char* pp;

	if (sb==NULL) return NULL;
	if (sb->buf==NULL) {
		*sb = make_mstream(RECVBUFSZ);
		if (sb->buf==NULL) return NULL;
	}

	if (mesg!=NULL) put_mstream(sb, mesg);
	if (sb->state<0) state = sb->state;

	if (sb->datano==0) {
		sb->state = 1;
		return NULL;
	}
	pp = get_mstream(sb);
	
	if (sb->state>=0 && state<0) sb->state = state;
	return pp;
}





///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 
//

/**
unsigned char*  uuid2guid(unsigned char* p)

	@\FoCi UUID  eLXgGUIDɕϊDv free()

*/
unsigned char*  uuid2guid(unsigned char* p)
{
    unsigned char* guid;

	if (p==NULL) return NULL;

	guid = (unsigned char*)malloc(LGUID);	// 40 = 32+4+1(\0) + 
	if (guid==NULL) return NULL;

    snprintf((char*)guid, 37, "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x",
                    p[0],p[1],p[2],p[3],p[4],p[5],p[6],p[7],p[8],p[9],p[10],p[11],p[12],p[13],p[14],p[15]);

    return guid;
}





/**
unsigned char*  guid2uuid(unsigned char* p)

	@\FeLXgGUID oCiUUID ɕϊDv free()
		͂ GUIĎ`łȂ́Cʂ͕ۏ؂ȂD

*/
unsigned char*  guid2uuid(unsigned char* p)
{
	int   i, j;
    unsigned char* uuid;

	if (p==NULL) return NULL;

	uuid = (unsigned char*)malloc(16);
	if (uuid==NULL) return NULL;

	i = j = 0;
	while (p[i]!='\0' && j<16) {
		if (p[i]!='-' && p[i+1]!='\0') {
			unsigned char hb, lb;

			if      (p[i]>='0' && p[i]<='9')     hb = p[i] - '0';
			else if (p[i]>='a' && p[i]<='f')     hb = p[i] - 'a' + 10;
			else if (p[i]>='A' && p[i]<='F')     hb = p[i] - 'A' + 10;
			else hb = '\0';

			if      (p[i+1]>='0' && p[i+1]<='9') lb = p[i+1] - '0';
			else if (p[i+1]>='a' && p[i+1]<='f') lb = p[i+1] - 'a' + 10;
			else if (p[i+1]>='A' && p[i+1]<='F') lb = p[i+1] - 'A' + 10;
			else lb = '\0';
			
			uuid[j] = (hb<<4) + lb;
			i++;
			j++;
		}
		i++;
	}

    return uuid;
}







///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// VOi
//
#ifndef WIN32

#ifdef SIGCHLD

/**
void  set_sigterm_child(void (*handler)(int))

    @\Fchild vZXȈݒD

*/
void  set_sigterm_child(void (*handler)(int))
{    
	struct sigaction sa;

	if (handler!=NULL) sa.sa_handler = handler;
	else               sa.sa_handler = sigterm_child;

	sa.sa_flags = SA_NOCLDSTOP | SA_RESTART; 
    sigemptyset(&sa.sa_mask);
	sigaddset(&sa.sa_mask, SIGINT);
	sigaddset(&sa.sa_mask, SIGHUP);
	sigaddset(&sa.sa_mask, SIGTERM);
    sigaction(SIGCHLD, &sa, NULL);
}




/**
void  set_sigsegv_handler(void (*handler)(int))

    @\FZOe[VG[̃nhݒD
		   NULLw肵ꍇ́Cnh֐Ƃ trap_segmentation_falt() gpD

*/
void  set_sigsegv_handler(void (*handler)(int))
{
	struct sigaction sa;

	if (handler!=NULL) sa.sa_handler = handler;
	else               sa.sa_handler = trap_segmentation_falt;
	
	sa.sa_flags = 0;
	sigemptyset(&sa.sa_mask);
	sigaction(SIGSEGV, &sa, NULL);
}





void  trap_segmentation_falt(int signal)
{
	print_message("****************************************************************\n");
	print_message("* Segmentation Falt in [%d] !!!!!\n", getpid());
	print_message("****************************************************************\n");

	exit(signal);
}




/**
void  ignore_sigterm_child()

    @\Fchild vZX̏I𖳎D

*/
void  ignore_sigterm_child()
{    
	struct sigaction sa;

	sa.sa_handler = SIG_IGN;
	sa.sa_flags   = 0; 
    sigemptyset(&sa.sa_mask);
    sigaction(SIGCHLD, &sa, NULL);
}




/**
void  sigterm_child(int signal)

    @\Fchild vZXȈ

*/
void  sigterm_child(int signal)
{
    pid_t pid = 0;
    int ret;

	DEBUG_MESG("%d is waiting for children. signal = %d\n", getpid(), signal);

    do {	// `ChvZX̏I҂	
        pid = waitpid(-1, &ret, WNOHANG);
    } while(pid>0);
}


#endif		// SIGCHLD

#endif		// NOT WIN32







///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// for Windows
//

#ifdef WIN32

/* see common.h

void  bzero(char* p, unsigned int n)
{
	for (unsigned int i=0; i<n; i++) *(p++) = 0x00;
}



void  bcopy(char* f, char* t, unsigned int n)
{
	for (unsigned int i=0; i<n; i++) *(t++) = *(f++);
}
*/

#endif   // WIN32
