
#ifndef  __JBXL_CPP_JPEG_TOOl_H_
#define  __JBXL_CPP_JPEG_TOOl_H_


/**
JPEGOtBbNf[^`pwb_  

*/


#include "common++.h"
#include "buffer.h"
#include "xtools.h"
#include "gheader.h"
#include "Gdata.h"

#include "Vector.h"
#include "ClassBox.h"

#include <jpeglib.h>



//
namespace jbxl {



////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////

class JPEGImage 
{
public:
    int    xs;
    int    ys;
    int    col;
	int	   state;

    JSAMPLE*   gp;
    JSAMPARRAY img;

public:
	JPEGImage(void)  { init();}
	~JPEGImage(void) {}

	void   	init(void);										// OtBbNf[^͉Ȃ
	bool   	isNull(void); 									// OtBbNf[^ĂȂH
	void   	clear(void);	 								// SԂfl 0 ɂ
	void   	fill(JSAMPLE v=(JSAMPLE)0);						// SԂfl v ɂ
	void   	free(void);										// OtBbNf[^J

	JSAMPLE& point(int x, int y, int c) { return img[y][x*col + c];}
	void	getm(int x, int y, int c);
	void	set (int x, int y, int c);
};





JPEGImage  	readJPEGFile (char* fname);
JPEGImage  	readJPEGData (FILE* fp);
int  		writeJPEGFile(char* fname, JPEGImage jp, int qulty);
int  		writeJPEGData(FILE* fp,    JPEGImage jp, int qulty);

int			isJPEGHeader(Buffer buf);


CmnHead		JPEGImage2CmnHead(JPEGImage jp);
JPEGImage	CmnHead2JPEGImage(CmnHead hd);

/*
template <typename T>  MSGraph<T> JPEGImage2MSGraph(JPEGImage  jp)
template <typename T>  JPEGImage  MSGraph2JPEGImage(MSGraph<T> vp)
*/







////////////////////////////////////////////////////////////////////////////////////////////

/**
template <typename T>  MSGraph<T> JPEGImage2MSGraph(JPEGImage jp)

	F

	G[Fstate	ERROR_GRAPH_NODATA: f[^
					ERROR_GRAPH_MEMORY: mۃG[ 

*/
template <typename T>  MSGraph<T> JPEGImage2MSGraph(JPEGImage jp)
{
	MSGraph<T> vp;
	int i, j, k, yp, zp;

	vp.init();	// vp.color = GRAPH_COLOR_MONO;
	if (jp.col==3) vp.color = GRAPH_COLOR_RGB;

	if (jp.isNull()) {
		vp.state = ERROR_GRAPH_NODATA;
		return vp;
	}

	vp.set(jp.xs, jp.ys, jp.col);
	if (vp.isNull()) return vp;

	for (k=0; k<jp.col; k++) {
		zp = k*jp.xs*jp.ys;
		for (j=0; j<jp.ys; j++) {
			yp = zp + j*jp.xs;
			for (i=0; i<jp.xs; i++) {
				vp.gp[yp + i] = (T)jp.point(i, j, k);
			}
		}
	}

	return vp;
}






/**
template <typename T>  JPEGImage  MSGraph2JPEGImage(MSGraph<T> vp)

	F

	G[Fstate	ERROR_GRAPH_NODATA: f[^
					ERROR_GRAPH_MEMORY: mۃG[ 

*/
template <typename T>  JPEGImage  MSGraph2JPEGImage(MSGraph<T> vp)
{
	JPEGImage jp;
	int i, j, k, yp, zp;

	jp.init();

	if (vp.isNull()) {
		jp.state = ERROR_GRAPH_NODATA;
		return jp;
	}

	jp.set(vp.xs, vp.ys, vp.zs);
	if (jp.isNull()) return jp;

	for (k=0; k<jp.col; k++) {
		zp = k*jp.xs*jp.ys;
		for (j=0; j<jp.ys; j++) {
			yp = zp + j*jp.xs;
			for (i=0; i<jp.xs; i++) {
				jp.point(i, j, k) = (JSAMPLE)vp.gp[yp + i];
			}
		}
	}

	return jp;
}



}		// namespace



#endif


 
